/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.parts;

import com.kms.katalon.composer.components.impl.control.CTableViewer;
import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.impl.providers.TypeCheckStyleCellTableLabelProvider;
import com.kms.katalon.composer.components.impl.support.TypeCheckedEditingSupport;
import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.components.impl.util.TreeEntityUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.components.util.ColumnViewerUtil;
import com.kms.katalon.composer.parts.CPart;
import com.kms.katalon.composer.testcase.ast.variable.operations.ChangeVariableMaskedOperation;
import com.kms.katalon.composer.testcase.ast.variable.operations.ClearVariableOperation;
import com.kms.katalon.composer.testcase.ast.variable.operations.DeleteVariableOperation;
import com.kms.katalon.composer.testcase.ast.variable.operations.DownVariableOperation;
import com.kms.katalon.composer.testcase.ast.variable.operations.NewVariableOperation;
import com.kms.katalon.composer.testcase.ast.variable.operations.UpVariableOperation;
import com.kms.katalon.composer.testcase.constants.ComposerTestcaseMessageConstants;
import com.kms.katalon.composer.testcase.constants.ImageConstants;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.parser.GroovyWrapperParser;
import com.kms.katalon.composer.testcase.model.InputValueType;
import com.kms.katalon.composer.testcase.parts.TableActionOperator;
import com.kms.katalon.composer.testcase.parts.TestCaseCompositePart;
import com.kms.katalon.composer.testcase.parts.TestCaseDataBindingPart;
import com.kms.katalon.composer.testcase.providers.VariableTableDropTarget;
import com.kms.katalon.composer.testcase.support.VariableDefaultValueEditingSupport;
import com.kms.katalon.composer.testcase.support.VariableDefaultValueTypeEditingSupport;
import com.kms.katalon.composer.testcase.support.VariableDescriptionEditingSupport;
import com.kms.katalon.composer.testcase.support.VariableNameEditingSupport;
import com.kms.katalon.composer.testcase.util.AstValueUtil;
import com.kms.katalon.constants.GlobalMessageConstants;
import com.kms.katalon.controller.LocalVariableController;
import com.kms.katalon.entity.link.VariableLink;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.testdata.DataFileEntity;
import com.kms.katalon.entity.variable.VariableEntity;
import com.kms.katalon.entity.variable.VariableEntityWrapper;
import com.kms.katalon.execution.util.SyntaxUtil;
import com.kms.katalon.groovy.constant.GroovyConstants;
import com.kms.katalon.tracking.service.Trackings;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.ui.MGenericTile;
import org.eclipse.e4.ui.model.application.ui.basic.MCompositePart;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class TestCaseVariablePart
extends CPart
implements TableActionOperator {
    private static final String DEFAULT_VARIABLE_NAME = "variable";
    private static final InputValueType[] defaultInputValueTypes = new InputValueType[]{InputValueType.String, InputValueType.Number, InputValueType.Boolean, InputValueType.Null, InputValueType.GlobalVariable, InputValueType.TestDataValue, InputValueType.TestObject, InputValueType.TestData, InputValueType.Property, InputValueType.List, InputValueType.Map};
    private Composite parent;
    private MPart mpart;
    private CTableViewer tableViewer;
    private TestCaseCompositePart parentTestCaseCompositePart;
    private VariableEntityWrapper variableEntityWrapper;
    @Inject
    private EPartService partService;
    private SashForm sashForm;

    @PostConstruct
    public void init(Composite parent, MPart mpart) {
        MCompositePart compositePart;
        this.parent = parent;
        this.mpart = mpart;
        this.variableEntityWrapper = new VariableEntityWrapper();
        this.variableEntityWrapper.setVariables(new ArrayList());
        if (mpart.getParent().getParent() instanceof MGenericTile && (MGenericTile)mpart.getParent().getParent() instanceof MCompositePart && (compositePart = (MCompositePart)((MGenericTile)mpart.getParent().getParent())).getObject() instanceof TestCaseCompositePart) {
            this.parentTestCaseCompositePart = (TestCaseCompositePart)compositePart.getObject();
        }
        this.initialize(mpart, this.partService);
        this.createComponents();
    }

    @PreDestroy
    public void dispose() {
        super.dispose();
    }

    private void createComponents() {
        this.parent.setLayout((Layout)new GridLayout(1, false));
        this.sashForm = new SashForm(this.parent, 0);
        this.sashForm.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.sashForm.setMaximizedControl(null);
        this.createVariablesGroup();
    }

    private void createVariablesGroup() {
        Composite grpVariables = new Composite((Composite)this.sashForm, 0);
        grpVariables.setLayout((Layout)new GridLayout(1, false));
        grpVariables.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        Composite compositeToolbar = new Composite(grpVariables, 0);
        compositeToolbar.setLayout((Layout)new FillLayout(256));
        compositeToolbar.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        ToolBar toolBar = new ToolBar(compositeToolbar, 0x820000);
        toolBar.setForeground(ColorUtil.getToolBarForegroundColor());
        ToolItem tltmAddVariable = new ToolItem(toolBar, 0);
        tltmAddVariable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TestCaseVariablePart.this.addVariable();
            }
        });
        tltmAddVariable.setText(GlobalMessageConstants.ADD);
        tltmAddVariable.setImage(ImageConstants.IMG_16_ADD);
        final ToolItem tltmRemove = new ToolItem(toolBar, 0);
        tltmRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TestCaseVariablePart.this.removeVariables();
            }
        });
        tltmRemove.setText(GlobalMessageConstants.DELETE);
        tltmRemove.setImage(ImageConstants.IMG_16_REMOVE);
        tltmRemove.setEnabled(false);
        ToolItem tltmClear = new ToolItem(toolBar, 0);
        tltmClear.setText(GlobalMessageConstants.CLEAR);
        tltmClear.setImage(ImageConstants.IMG_16_CLEAR);
        tltmClear.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TestCaseVariablePart.this.clearVariables();
            }
        });
        ToolItem tltmUp = new ToolItem(toolBar, 0);
        tltmUp.setText(ComposerTestcaseMessageConstants.PA_BTN_TIP_MOVE_UP);
        tltmUp.setImage(ImageConstants.IMG_16_MOVE_UP);
        tltmUp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TestCaseVariablePart.this.upVariable();
            }
        });
        ToolItem tltmDown = new ToolItem(toolBar, 0);
        tltmDown.setText(ComposerTestcaseMessageConstants.PA_BTN_TIP_MOVE_DOWN);
        tltmDown.setImage(ImageConstants.IMG_16_MOVE_DOWN);
        tltmDown.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TestCaseVariablePart.this.downVariable();
            }
        });
        Composite compositeTable = new Composite(grpVariables, 0);
        compositeTable.setLayout((Layout)new FillLayout(256));
        compositeTable.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.tableViewer = new CTableViewer(compositeTable, 67586);
        ColumnViewerUtil.setTableActivation((TableViewer)this.tableViewer);
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                tltmRemove.setEnabled(!TestCaseVariablePart.this.tableViewer.getSelection().isEmpty());
            }
        });
        this.tableViewer.addDragSupport(2, new Transfer[]{TextTransfer.getInstance()}, (DragSourceListener)new DragSourceAdapter(){

            public void dragSetData(DragSourceEvent event) {
                StructuredSelection selection = (StructuredSelection)TestCaseVariablePart.this.tableViewer.getSelection();
                VariableEntity variable = (VariableEntity)selection.getFirstElement();
                event.data = String.valueOf(TestCaseVariablePart.this.variableEntityWrapper.getVariables().indexOf(variable));
            }
        });
        this.tableViewer.addDropSupport(2, new Transfer[]{TextTransfer.getInstance()}, (DropTargetListener)new VariableTableDropTarget(this));
        Table table = this.tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(ControlUtils.shouldLineVisble((Display)table.getDisplay()));
        TableViewerColumn tableViewerColumnNo = new TableViewerColumn((TableViewer)this.tableViewer, 0);
        TableColumn tblclmnNo = tableViewerColumnNo.getColumn();
        tblclmnNo.setWidth(70);
        tblclmnNo.setText(GlobalMessageConstants.NO_);
        tableViewerColumnNo.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element != null && element instanceof VariableEntity) {
                    return Integer.toString(TestCaseVariablePart.this.variableEntityWrapper.getVariables().indexOf(element) + 1);
                }
                return "";
            }
        });
        TableViewerColumn tableViewerColumnName = new TableViewerColumn((TableViewer)this.tableViewer, 0);
        tableViewerColumnName.setEditingSupport((EditingSupport)new VariableNameEditingSupport((ColumnViewer)this.tableViewer, this));
        tableViewerColumnName.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element != null && element instanceof VariableEntity) {
                    return ((VariableEntity)element).getName();
                }
                return "";
            }
        });
        TableColumn tblclmnName = tableViewerColumnName.getColumn();
        tblclmnName.setWidth(200);
        tblclmnName.setText(GlobalMessageConstants.NAME);
        TableViewerColumn tableViewerColumnDefaultValueType = new TableViewerColumn((TableViewer)this.tableViewer, 0);
        tableViewerColumnDefaultValueType.setEditingSupport((EditingSupport)new VariableDefaultValueTypeEditingSupport((ColumnViewer)this.tableViewer, this, defaultInputValueTypes));
        TableColumn tblclmnDefaultValueType = tableViewerColumnDefaultValueType.getColumn();
        tblclmnDefaultValueType.setWidth(200);
        tblclmnDefaultValueType.setText(ComposerTestcaseMessageConstants.PA_COL_DEFAULT_VALUE_TYPE);
        tableViewerColumnDefaultValueType.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ExpressionWrapper expression;
                block5: {
                    if (!(element instanceof VariableEntity)) {
                        return "";
                    }
                    expression = GroovyWrapperParser.parseGroovyScriptAndGetFirstExpression(((VariableEntity)element).getDefaultValue());
                    if (expression != null) break block5;
                    return null;
                }
                try {
                    InputValueType valueType = AstValueUtil.getTypeValue(expression);
                    if (valueType != null) {
                        return TreeEntityUtil.getReadableKeywordName((String)valueType.getName());
                    }
                }
                catch (Exception e) {
                    LoggerSingleton.logError((Throwable)e);
                }
                return "";
            }
        });
        TableViewerColumn tableViewerColumnDefaultValue = new TableViewerColumn((TableViewer)this.tableViewer, 0);
        tableViewerColumnDefaultValue.setEditingSupport((EditingSupport)new VariableDefaultValueEditingSupport((ColumnViewer)this.tableViewer, this));
        TableColumn tblclmnDefaultValue = tableViewerColumnDefaultValue.getColumn();
        tblclmnDefaultValue.setWidth(500);
        tblclmnDefaultValue.setText(ComposerTestcaseMessageConstants.PA_COL_DEFAULT_VALUE);
        tableViewerColumnDefaultValue.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (!(element instanceof VariableEntity) || ((VariableEntity)element).getDefaultValue() == null) {
                    return "";
                }
                ExpressionWrapper expression = GroovyWrapperParser.parseGroovyScriptAndGetFirstExpression(((VariableEntity)element).getDefaultValue());
                if (expression == null) {
                    return "";
                }
                return expression.getText();
            }
        });
        TableViewerColumn tableViewerColumnDescription = new TableViewerColumn((TableViewer)this.tableViewer, 0);
        tableViewerColumnDescription.setEditingSupport((EditingSupport)new VariableDescriptionEditingSupport((ColumnViewer)this.tableViewer, this));
        tableViewerColumnDescription.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element != null && element instanceof VariableEntity) {
                    return ((VariableEntity)element).getDescription();
                }
                return "";
            }
        });
        TableColumn tblColumnDescription = tableViewerColumnDescription.getColumn();
        tblColumnDescription.setWidth(400);
        tblColumnDescription.setText(GlobalMessageConstants.DESCRIPTION);
        TableViewerColumn tableViewerColumnLogged = new TableViewerColumn((TableViewer)this.tableViewer, 0);
        tableViewerColumnLogged.setLabelProvider((CellLabelProvider)new TypeCheckStyleCellTableLabelProvider<VariableEntity>(5){

            protected Class<VariableEntity> getElementType() {
                return VariableEntity.class;
            }

            protected Image getImage(VariableEntity element) {
                return element.isMasked() ? ImageConstants.IMG_16_CHECKBOX_CHECKED : ImageConstants.IMG_16_CHECKBOX_UNCHECKED;
            }

            protected String getText(VariableEntity element) {
                return "";
            }
        });
        tableViewerColumnLogged.setEditingSupport((EditingSupport)new TypeCheckedEditingSupport<VariableEntity>((ColumnViewer)this.tableViewer){

            protected Class<VariableEntity> getElementType() {
                return VariableEntity.class;
            }

            protected CellEditor getCellEditorByElement(VariableEntity element) {
                return new CheckboxCellEditor(this.getComposite());
            }

            protected boolean canEditElement(VariableEntity element) {
                return element != null;
            }

            protected Object getElementValue(VariableEntity element) {
                return element.isMasked();
            }

            protected void setElementValue(VariableEntity element, Object value) {
                if (!(value instanceof Boolean)) {
                    return;
                }
                boolean newMasked = (Boolean)value;
                if (element.isMasked() == newMasked) {
                    return;
                }
                TestCaseVariablePart.this.executeOperation((IUndoableOperation)new ChangeVariableMaskedOperation(TestCaseVariablePart.this, element, newMasked));
            }
        });
        TableColumn tblColumnLogged = tableViewerColumnLogged.getColumn();
        tblColumnLogged.setText(ComposerTestcaseMessageConstants.PA_COL_MASKED);
        tblColumnLogged.setToolTipText(ComposerTestcaseMessageConstants.PA_COL_MASKED_TOOLTIP);
        TableColumnLayout tableLayout = new TableColumnLayout();
        tableLayout.setColumnData((Widget)tblclmnNo, (ColumnLayoutData)new ColumnWeightData(0, 40));
        tableLayout.setColumnData((Widget)tblclmnName, (ColumnLayoutData)new ColumnWeightData(20, 50));
        tableLayout.setColumnData((Widget)tblclmnDefaultValueType, (ColumnLayoutData)new ColumnWeightData(10, 100));
        tableLayout.setColumnData((Widget)tblclmnDefaultValue, (ColumnLayoutData)new ColumnWeightData(20, 100));
        tableLayout.setColumnData((Widget)tblColumnDescription, (ColumnLayoutData)new ColumnWeightData(25, 100));
        tableLayout.setColumnData((Widget)tblColumnLogged, (ColumnLayoutData)new ColumnWeightData(0, 80));
        compositeTable.setLayout((Layout)tableLayout);
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
    }

    private void addVariable() {
        VariableEntity newVariable = new VariableEntity();
        newVariable.setName(this.generateNewPropertyName());
        newVariable.setDefaultValue("''");
        this.executeOperation((IUndoableOperation)new NewVariableOperation(this, newVariable));
        Trackings.trackCreatingObject((String)"testCaseVariable", (Object[])new Object[0]);
    }

    private String generateNewPropertyName() {
        String name = DEFAULT_VARIABLE_NAME;
        int index = 0;
        boolean isUnique = false;
        Object newName = name;
        while (!isUnique) {
            isUnique = true;
            for (VariableEntity variable : this.variableEntityWrapper.getVariables()) {
                if (!variable.getName().equals(newName)) continue;
                isUnique = false;
                break;
            }
            if (isUnique) {
                return newName;
            }
            newName = name + "_" + index;
            ++index;
        }
        return newName;
    }

    public void addVariable(VariableEntity[] variablesArray) {
        boolean isAdded = false;
        VariableEntity[] variableEntityArray = variablesArray;
        int n = variablesArray.length;
        int n2 = 0;
        while (n2 < n) {
            VariableEntity addedVariable = variableEntityArray[n2];
            boolean exists = false;
            for (VariableEntity currentVariable : this.variableEntityWrapper.getVariables()) {
                if (!currentVariable.getName().equals(addedVariable.getName())) continue;
                exists = true;
                break;
            }
            if (!exists) {
                this.variableEntityWrapper.getVariables().add(addedVariable);
                VariableLink newVariableLink = new VariableLink(addedVariable.getId());
                this.getDataBindingPart().addVariableLink(newVariableLink);
                isAdded = true;
            }
            ++n2;
        }
        if (isAdded) {
            this.tableViewer.refresh();
            this.getDataBindingPart().refreshVariableBindingTable();
            this.setDirty(true);
        }
    }

    public TestCaseDataBindingPart getDataBindingPart() {
        return this.parentTestCaseCompositePart.getDataBindingPart();
    }

    public void deleteVariables(List<VariableEntity> variableList) {
        if (this.variableEntityWrapper.getVariables().removeAll(variableList)) {
            this.tableViewer.refresh();
            this.getDataBindingPart().refreshVariableBindingTable();
            this.setDirty(true);
        }
    }

    private void removeVariables() {
        this.executeOperation((IUndoableOperation)new DeleteVariableOperation(this));
    }

    private void clearVariables() {
        this.executeOperation((IUndoableOperation)new ClearVariableOperation(this));
    }

    private void upVariable() {
        this.executeOperation((IUndoableOperation)new UpVariableOperation(this));
    }

    private void downVariable() {
        this.executeOperation((IUndoableOperation)new DownVariableOperation(this));
    }

    @Override
    public void setDirty(boolean isDirty) {
        this.mpart.setDirty(isDirty);
        if (this.parentTestCaseCompositePart.getChildTestCasePart().getTreeTableInput() != null) {
            this.parentTestCaseCompositePart.getChildTestCasePart().getTreeTableInput().reloadTestCaseVariables(this.getVariables());
        }
        this.parentTestCaseCompositePart.updateDirty();
    }

    public void loadVariables() {
        TestCaseEntity testCase = this.parentTestCaseCompositePart.getTestCase();
        if (testCase != null && testCase.getVariables() != null) {
            this.variableEntityWrapper.getVariables().clear();
            this.variableEntityWrapper.getVariables().addAll(testCase.getVariables());
            this.tableViewer.setInput((Object)this.variableEntityWrapper.getVariables());
            this.tableViewer.refresh();
        }
    }

    public MPart getMPart() {
        return this.mpart;
    }

    public VariableEntity[] getVariables() {
        if (this.variableEntityWrapper.getVariables() == null) {
            return new VariableEntity[0];
        }
        return this.variableEntityWrapper.getVariables().toArray(new VariableEntity[this.variableEntityWrapper.getVariables().size()]);
    }

    @Override
    public List<VariableEntity> getVariablesList() {
        return this.variableEntityWrapper.getVariables();
    }

    public VariableEntityWrapper getVariableEntityWrapper() {
        return this.variableEntityWrapper;
    }

    @Override
    public TableViewer getTableViewer() {
        return this.tableViewer;
    }

    public boolean validateVariables() {
        StringBuilder errorCollector = new StringBuilder();
        ArrayList<String> names = new ArrayList<String>();
        for (VariableEntity variable : this.variableEntityWrapper.getVariables()) {
            int index = this.variableEntityWrapper.getVariables().indexOf(variable) + 1;
            String variableName = variable.getName();
            String variableDefaultValue = variable.getDefaultValue();
            if (variableDefaultValue == null || variableDefaultValue.isEmpty()) {
                variableDefaultValue = null;
            }
            if (variableName == null || variableName.isEmpty()) {
                errorCollector.append(MessageFormat.format(ComposerTestcaseMessageConstants.PA_ERROR_MSG_VAR_AT_INDEX_CANNOT_BE_NULL_OR_EMPTY, Integer.toString(index)));
            }
            if (!GroovyConstants.isValidVariableName((String)variableName)) {
                errorCollector.append(MessageFormat.format(ComposerTestcaseMessageConstants.PA_ERROR_MSG_INVALID_VAR, variableName));
            }
            if (names.contains(variableName)) {
                errorCollector.append(MessageFormat.format(ComposerTestcaseMessageConstants.PA_ERROR_MSG_DUPLICATE_VAR, variableName));
            } else {
                names.add(variableName);
            }
            try {
                SyntaxUtil.checkVariableSyntax((String)variableName, (String)variableDefaultValue);
            }
            catch (IllegalArgumentException e) {
                errorCollector.append(MessageFormat.format(ComposerTestcaseMessageConstants.PA_ERROR_MSG_INVALID_DEFAULT_VAR_VAL_AT_INDEX, index, e.getMessage()));
            }
        }
        String errorString = errorCollector.toString();
        if (errorString.isEmpty()) {
            return true;
        }
        MultiStatusErrorDialog.showErrorDialog((Throwable)new IllegalArgumentException(errorString), (String)ComposerTestcaseMessageConstants.PA_ERROR_MSG_UNABLE_TO_SAVE_TEST_CASE, (String)ComposerTestcaseMessageConstants.PA_ERROR_REASON_INVALID_TEST_CASE);
        return false;
    }

    @Persist
    private boolean doSave() {
        try {
            this.parentTestCaseCompositePart.save();
            return true;
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            return false;
        }
    }

    public TestCaseCompositePart getParentTestCaseCompositePart() {
        return this.parentTestCaseCompositePart;
    }

    public void createPartControl(Composite parent) {
    }

    public void setFocus() {
    }

    public void setVariablesFromScriptContent(String scriptContent) throws Exception {
        VariableEntityWrapper newVariableEntityWrapper = this.getVariableEntityWrapperFromScriptContent(scriptContent);
        if (newVariableEntityWrapper != null) {
            this.variableEntityWrapper.setVariables(newVariableEntityWrapper.getVariables());
        } else {
            newVariableEntityWrapper = new VariableEntityWrapper();
            newVariableEntityWrapper.setVariables(new ArrayList());
        }
        this.tableViewer.setInput((Object)newVariableEntityWrapper.getVariables());
        this.tableViewer.refresh();
        this.getDataBindingPart().refreshVariableBindingTable();
        this.tableViewer.getTable().redraw();
    }

    public VariableEntityWrapper getVariableEntityWrapperFromScriptContent(String scriptContent) throws Exception {
        VariableEntityWrapper newVariableEntityWrapper = null;
        if (scriptContent != null && scriptContent != "") {
            newVariableEntityWrapper = LocalVariableController.getInstance().toVariableEntityWrapper(scriptContent);
            return newVariableEntityWrapper;
        }
        return newVariableEntityWrapper;
    }

    public void openAddedTestData(DataFileEntity dataFileEntity) {
        this.parentTestCaseCompositePart.openAddedTestData(dataFileEntity);
    }

    @Override
    public TestCaseCompositePart getParent() {
        return this.parentTestCaseCompositePart;
    }
}

