/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.providers;

import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.testcase.ast.treetable.AstStatementTreeTableNode;
import com.kms.katalon.composer.testcase.ast.treetable.AstTreeTableNode;
import com.kms.katalon.composer.testcase.ast.treetable.IAstInputEditableNode;
import com.kms.katalon.composer.testcase.ast.treetable.IAstObjectEditableNode;
import com.kms.katalon.composer.testcase.ast.treetable.IAstOutputEditableNode;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Image;

public class AstTreeLabelProvider
extends StyledCellLabelProvider {
    private static final int CLMN_OBJECT_IDX = 1;
    private static final int CLMN_INPUT_IDX = 2;
    private static final int CLMN_OUTPUT_IDX = 3;
    private static final int CLMN_DESCRIPTION_IDX = 4;
    private int columnIndex;

    private String getText(Object element) {
        if (element == null || !(element instanceof AstTreeTableNode)) {
            return "";
        }
        AstTreeTableNode treeTableNode = (AstTreeTableNode)element;
        switch (this.columnIndex) {
            case 1: {
                if (treeTableNode instanceof IAstObjectEditableNode) {
                    return ((IAstObjectEditableNode)((Object)treeTableNode)).getTestObjectText();
                }
                return "";
            }
            case 2: {
                if (treeTableNode instanceof IAstInputEditableNode) {
                    return ((IAstInputEditableNode)((Object)treeTableNode)).getInputText();
                }
                return "";
            }
            case 3: {
                if (treeTableNode instanceof IAstOutputEditableNode) {
                    return ((IAstOutputEditableNode)((Object)treeTableNode)).getOutputText();
                }
                return "";
            }
            case 4: {
                return this.getDescriptionString(treeTableNode);
            }
        }
        return "";
    }

    private String getDescriptionString(AstTreeTableNode treeTableNode) {
        if (!(treeTableNode instanceof AstStatementTreeTableNode)) {
            return "";
        }
        return StringUtils.defaultString((String)((AstStatementTreeTableNode)treeTableNode).getDescription()).replace("\t", "    ");
    }

    public void update(ViewerCell cell) {
        Object element = cell.getElement();
        if (!(element instanceof AstTreeTableNode)) {
            super.update(cell);
            return;
        }
        this.columnIndex = cell.getColumnIndex();
        String text = this.getText(element);
        cell.setText(text);
        cell.setImage(this.getImage(element));
        if (this.isDisabledStatement(element)) {
            this.handleDisableStatement(cell, text);
        } else {
            this.handleDefaultStatement(cell);
        }
        super.update(cell);
    }

    private Image getImage(Object element) {
        return null;
    }

    private boolean isDisabledStatement(Object element) {
        return element instanceof AstStatementTreeTableNode && ((AstStatementTreeTableNode)element).isDisabled();
    }

    private void handleDisableStatement(ViewerCell cell, String text) {
        if (StringUtils.isEmpty((String)text)) {
            return;
        }
        StyleRange disableText = new StyleRange();
        disableText.start = 0;
        disableText.length = text.length();
        disableText.foreground = ColorUtil.getDisabledTextColor();
        cell.setStyleRanges(new StyleRange[]{disableText});
    }

    private void handleDefaultStatement(ViewerCell cell) {
        cell.setBackground(null);
        cell.setStyleRanges(new StyleRange[0]);
    }

    public String getToolTipText(Object element) {
        if (element == null || !(element instanceof AstTreeTableNode)) {
            return null;
        }
        AstTreeTableNode treeTableNode = (AstTreeTableNode)element;
        switch (this.columnIndex) {
            case 1: {
                if (treeTableNode instanceof IAstObjectEditableNode) {
                    return this.getTooltipReturnValue(((IAstObjectEditableNode)((Object)treeTableNode)).getTestObjectTooltipText());
                }
                return null;
            }
            case 2: {
                if (treeTableNode instanceof IAstInputEditableNode) {
                    return this.getTooltipReturnValue(((IAstInputEditableNode)((Object)treeTableNode)).getInputTooltipText());
                }
                return null;
            }
            case 3: {
                if (treeTableNode instanceof IAstOutputEditableNode) {
                    return this.getTooltipReturnValue(((IAstOutputEditableNode)((Object)treeTableNode)).getOutputTooltipText());
                }
                return null;
            }
            case 4: {
                return this.getTooltipReturnValue(this.getDescriptionString(treeTableNode));
            }
        }
        return null;
    }

    private String getTooltipReturnValue(String tooltip) {
        if (tooltip.isEmpty()) {
            return null;
        }
        return tooltip;
    }
}

