/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.util;

import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.tree.TestCaseTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.testcase.util.AstKeywordsInputUtil;
import com.kms.katalon.controller.KeywordController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.TestCaseController;
import com.kms.katalon.custom.factory.BuiltInMethodNodeFactory;
import com.kms.katalon.custom.keyword.KeywordClass;
import com.kms.katalon.custom.keyword.KeywordMethod;
import com.kms.katalon.entity.integration.IntegratedEntity;
import com.kms.katalon.entity.link.TestCaseTestDataLink;
import com.kms.katalon.entity.link.VariableLink;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.testdata.DataFileEntity;
import com.kms.katalon.entity.variable.VariableEntity;
import com.kms.katalon.groovy.util.GroovyUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class TestCaseEntityUtil {
    private static boolean reloadJavaDoc = false;
    private static Map<String, Map<String, String>> keywordMethodJavaDocMap;

    public static void copyTestCaseProperties(TestCaseEntity src, TestCaseEntity des) {
        TestCaseEntityUtil.copyTestCaseProperties(src, des, true);
    }

    public static void copyTestCaseProperties(TestCaseEntity src, TestCaseEntity des, boolean ignoreMetaInfo) {
        des.setParentFolder(src.getParentFolder());
        des.setProject(src.getProject());
        des.setName(src.getName());
        if (!ignoreMetaInfo) {
            des.setComment(src.getComment());
            des.setTag(src.getTag());
            des.setDescription(src.getDescription());
        }
        des.getDataFileLocations().clear();
        des.getDataFiles().clear();
        for (DataFileEntity dataFile : src.getDataFiles()) {
            des.getDataFiles().add(dataFile);
            des.getDataFileLocations().add(dataFile.getRelativePath());
        }
        des.getVariables().clear();
        for (VariableEntity variable : src.getVariables()) {
            des.getVariables().add(variable);
        }
        des.getTestDataLinks().clear();
        for (TestCaseTestDataLink dataLink : src.getTestDataLinks()) {
            des.getTestDataLinks().add(dataLink);
        }
        des.getVariableLinks().clear();
        for (VariableLink variableLink : src.getVariableLinks()) {
            des.getVariableLinks().add(variableLink);
        }
        des.getIntegratedEntities().clear();
        for (IntegratedEntity integratedEntity : src.getIntegratedEntities()) {
            des.getIntegratedEntities().add(integratedEntity);
        }
    }

    public static List<TestCaseEntity> getTestCasesFromFolderTree(FolderTreeEntity folderTree) {
        ArrayList<TestCaseEntity> lstTestCases = new ArrayList<TestCaseEntity>();
        try {
            Object[] objectArray = folderTree.getChildren();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                if (child instanceof TestCaseTreeEntity) {
                    lstTestCases.add(((TestCaseTreeEntity)child).getObject());
                } else if (child instanceof FolderTreeEntity) {
                    lstTestCases.addAll(TestCaseEntityUtil.getTestCasesFromFolderTree((FolderTreeEntity)child));
                }
                ++n2;
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
        return lstTestCases;
    }

    public static String getBuiltinKeywordJavadocText(String keywordClassName, String keywordName) {
        Map<String, String> javadocsByMethods = TestCaseEntityUtil.getKeywordMethodJavaDocMap().get(keywordClassName);
        if (javadocsByMethods == null) {
            return "";
        }
        return (String)StringUtils.defaultIfBlank((CharSequence)javadocsByMethods.get(keywordName), (CharSequence)"");
    }

    private static Map<String, Map<String, String>> getKeywordMethodJavaDocMap() {
        if (keywordMethodJavaDocMap == null || reloadJavaDoc) {
            TestCaseEntityUtil.initKeywordJavaDocMap();
        }
        return keywordMethodJavaDocMap;
    }

    private static void initKeywordJavaDocMap() {
        keywordMethodJavaDocMap = new HashMap<String, Map<String, String>>();
        reloadJavaDoc = false;
        IProject groovyProject = TestCaseEntityUtil.getGroovyProject();
        if (groovyProject == null) {
            reloadJavaDoc = true;
            return;
        }
        IJavaProject javaProject = JavaCore.create((IProject)groovyProject);
        for (KeywordClass keywordClass : KeywordController.getInstance().getBuiltInKeywordClasses()) {
            HashMap<String, String> allKeywordJavaDocMap = new HashMap<String, String>();
            String keywordClassName = keywordClass.getSimpleName();
            keywordMethodJavaDocMap.put(keywordClassName, allKeywordJavaDocMap);
            try {
                Class<?> keywordType = AstKeywordsInputUtil.loadType(keywordClass.getName(), null);
                if (keywordType == null) continue;
                IType builtinKeywordType = javaProject.findType(keywordType.getName());
                List builtInKeywordMethods = KeywordController.getInstance().getBuiltInKeywords(keywordClassName, true);
                builtInKeywordMethods.add(BuiltInMethodNodeFactory.findCallTestCaseMethod((String)keywordClassName));
                for (KeywordMethod method : builtInKeywordMethods) {
                    IMethod builtInMethod = TestCaseEntityUtil.findBuiltinMethods(builtinKeywordType, method.getName(), javaProject);
                    if (builtInMethod == null) continue;
                    String attachedJavaDoc = builtInMethod.getAttachedJavadoc(null);
                    attachedJavaDoc = attachedJavaDoc == null ? "" : attachedJavaDoc;
                    allKeywordJavaDocMap.put(method.getName(), attachedJavaDoc);
                }
            }
            catch (JavaModelException e) {
                LoggerSingleton.logError((Throwable)e);
            }
        }
    }

    private static IProject getGroovyProject() {
        ProjectEntity projectEntity = ProjectController.getInstance().getCurrentProject();
        if (projectEntity != null) {
            return GroovyUtil.getGroovyProject((ProjectEntity)projectEntity);
        }
        return null;
    }

    private static IMethod findBuiltinMethods(IType type, String methodName, IJavaProject javaProject) throws JavaModelException {
        IMethod[] iMethodArray = type.getMethods();
        int n = iMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod keywordMethod = iMethodArray[n2];
            if (keywordMethod.getElementName().equals(methodName)) {
                return keywordMethod;
            }
            ++n2;
        }
        if (!type.getSuperclassName().equals(Object.class.getName())) {
            return TestCaseEntityUtil.findBuiltinMethods(javaProject.findType(type.getSuperclassName()), methodName, javaProject);
        }
        return null;
    }

    public static List<TestCaseEntity> getTestCaseEntities(List<IFile> scriptFiles) throws Exception {
        ArrayList<TestCaseEntity> testCaseEntities = new ArrayList<TestCaseEntity>();
        if (scriptFiles == null || scriptFiles.isEmpty()) {
            return testCaseEntities;
        }
        for (IFile file : scriptFiles) {
            testCaseEntities.add(TestCaseController.getInstance().getTestCaseByScriptFilePath(file.getRawLocation().toString()));
        }
        return testCaseEntities;
    }
}

