/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.util.groovy;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.ui.CodeStyleConfiguration;
import org.eclipse.text.edits.TextEdit;

public class ImportsManager {
    private final ImportRewrite fImportsRewrite;

    public ImportsManager(CompilationUnit astRoot) {
        astRoot.imports();
        this.fImportsRewrite = CodeStyleConfiguration.createImportRewrite((CompilationUnit)astRoot, (boolean)true);
        if (astRoot.getAST().hasResolvedBindings()) {
            this.fImportsRewrite.setUseContextToFilterImplicitImports(true);
        }
    }

    ICompilationUnit getCompilationUnit() {
        return this.fImportsRewrite.getCompilationUnit();
    }

    public String addImport(String qualifiedTypeName) {
        return this.fImportsRewrite.addImport(qualifiedTypeName);
    }

    public void addAliasImport(String qualifiedTypeName, String aliasName) {
    }

    public String addImport(ITypeBinding typeBinding) {
        return this.fImportsRewrite.addImport(typeBinding);
    }

    public String addStaticImport(String declaringTypeName, String simpleName, boolean isField) {
        return this.fImportsRewrite.addStaticImport(declaringTypeName, simpleName, isField);
    }

    public void create(boolean needsSave, IProgressMonitor monitor) throws CoreException {
        TextEdit edit = this.fImportsRewrite.rewriteImports(monitor);
        JavaModelUtil.applyEdit((ICompilationUnit)this.fImportsRewrite.getCompilationUnit(), (TextEdit)edit, (boolean)needsSave, null);
    }

    public void removeImport(String qualifiedName) {
        this.fImportsRewrite.removeImport(qualifiedName);
    }

    public void removeStaticImport(String qualifiedName) {
        this.fImportsRewrite.removeStaticImport(qualifiedName);
    }
}

