/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.codebrowsing.selection;

import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ArrayExpression;
import org.codehaus.groovy.ast.expr.AttributeExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BitwiseNegationExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ClosureListExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.ElvisOperatorExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.GStringExpression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.MethodPointerExpression;
import org.codehaus.groovy.ast.expr.NotExpression;
import org.codehaus.groovy.ast.expr.PostfixExpression;
import org.codehaus.groovy.ast.expr.PrefixExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.RangeExpression;
import org.codehaus.groovy.ast.expr.SpreadExpression;
import org.codehaus.groovy.ast.expr.SpreadMapExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.TernaryExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.UnaryMinusExpression;
import org.codehaus.groovy.ast.expr.UnaryPlusExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.classgen.BytecodeExpression;
import org.codehaus.groovy.eclipse.codebrowsing.fragments.ASTFragmentFactory;
import org.codehaus.groovy.eclipse.codebrowsing.fragments.ASTFragmentKind;
import org.codehaus.groovy.eclipse.codebrowsing.fragments.FragmentVisitor;
import org.codehaus.groovy.eclipse.codebrowsing.fragments.IASTFragment;
import org.codehaus.groovy.eclipse.codebrowsing.fragments.MethodCallFragment;

public class FindAllOccurrencesVisitor
extends ClassCodeVisitorSupport {
    private IASTFragment toFind;
    private List<IASTFragment> occurrences;
    private ModuleNode module;
    private AnnotatedNode limitTo;
    private ASTFragmentFactory factory;
    private FragmentMatcherVisitor fragmentMatcher;
    private AssociatedExpressionMatcher associatedExpressionMatcher;

    public FindAllOccurrencesVisitor(ModuleNode module) {
        this(module, null);
    }

    public FindAllOccurrencesVisitor(ModuleNode module, AnnotatedNode limitTo) {
        this.limitTo = limitTo;
        this.module = module;
        this.factory = new ASTFragmentFactory();
        this.fragmentMatcher = new FragmentMatcherVisitor();
        this.associatedExpressionMatcher = new AssociatedExpressionMatcher();
    }

    public List<IASTFragment> findOccurrences(IASTFragment fragment) {
        this.toFind = fragment;
        this.occurrences = new ArrayList<IASTFragment>();
        if (this.limitTo == null) {
            List classes = this.module.getClasses();
            for (ClassNode classNode : classes) {
                this.visitClass(classNode);
            }
        } else if (this.limitTo instanceof ClassNode) {
            this.visitClass((ClassNode)this.limitTo);
        } else if (this.limitTo instanceof MethodNode) {
            this.visitMethod((MethodNode)this.limitTo);
        } else if (this.limitTo instanceof FieldNode) {
            this.visitField((FieldNode)this.limitTo);
        } else {
            this.limitTo.visit((GroovyCodeVisitor)this);
        }
        return this.occurrences;
    }

    protected void visitConstructorOrMethod(MethodNode node, boolean isConstructor) {
        if (node.getEnd() == 0 && !node.getName().equals("<clinit>")) {
            return;
        }
        super.visitConstructorOrMethod(node, isConstructor);
    }

    public void visitField(FieldNode node) {
        if (node.getEnd() == 0) {
            return;
        }
        super.visitField(node);
    }

    public void visitProperty(PropertyNode node) {
    }

    public void visitArgumentlistExpression(ArgumentListExpression expression) {
        IASTFragment fragment = this.factory.createFragment((Expression)expression);
        fragment.accept(this.fragmentMatcher);
        if (!this.fragmentMatcher.matchWasFound()) {
            super.visitArgumentlistExpression(expression);
        }
    }

    public void visitArrayExpression(ArrayExpression expression) {
        IASTFragment fragment = this.factory.createFragment((Expression)expression);
        fragment.accept(this.fragmentMatcher);
        if (!this.fragmentMatcher.matchWasFound()) {
            super.visitArrayExpression(expression);
        }
    }

    public void visitAttributeExpression(AttributeExpression expression) {
        IASTFragment fragment = this.factory.createFragment((Expression)expression);
        fragment.accept(this.fragmentMatcher);
        if (!this.fragmentMatcher.matchWasFound()) {
            super.visitAttributeExpression(expression);
        }
    }

    public void visitBinaryExpression(BinaryExpression expression) {
        IASTFragment fragment = this.factory.createFragment((Expression)expression);
        fragment.accept(this.fragmentMatcher);
        this.associatedExpressionMatcher.ignoreNext = false;
        fragment.accept(this.associatedExpressionMatcher);
    }

    public void visitBitwiseNegationExpression(BitwiseNegationExpression expression) {
        IASTFragment fragment = this.factory.createFragment((Expression)expression);
        fragment.accept(this.fragmentMatcher);
        if (!this.fragmentMatcher.matchWasFound()) {
            super.visitBitwiseNegationExpression(expression);
        }
    }

    public void visitBooleanExpression(BooleanExpression expression) {
        IASTFragment fragment = this.factory.createFragment((Expression)expression);
        fragment.accept(this.fragmentMatcher);
        if (!this.fragmentMatcher.matchWasFound()) {
            super.visitBooleanExpression(expression);
        }
    }

    public void visitBytecodeExpression(BytecodeExpression expression) {
        IASTFragment fragment = this.factory.createFragment((Expression)expression);
        fragment.accept(this.fragmentMatcher);
        if (!this.fragmentMatcher.matchWasFound()) {
            super.visitBytecodeExpression(expression);
        }
    }

    public void visitCastExpression(CastExpression expression) {
        IASTFragment fragment = this.factory.createFragment((Expression)expression);
        fragment.accept(this.fragmentMatcher);
        if (!this.fragmentMatcher.matchWasFound()) {
            super.visitCastExpression(expression);
        }
    }

    public void visitClassExpression(ClassExpression expression) {
        IASTFragment fragment = this.factory.createFragment((Expression)expression);
        fragment.accept(this.fragmentMatcher);
        if (!this.fragmentMatcher.matchWasFound()) {
            super.visitClassExpression(expression);
        }
    }

    public void visitClosureExpression(ClosureExpression expression) {
        IASTFragment fragment = this.factory.createFragment((Expression)expression);
        fragment.accept(this.fragmentMatcher);
        if (!this.fragmentMatcher.matchWasFound()) {
            super.visitClosureExpression(expression);
        }
    }

    public void visitClosureListExpression(ClosureListExpression expression) {
        IASTFragment fragment = this.factory.createFragment((Expression)expression);
        fragment.accept(this.fragmentMatcher);
        if (!this.fragmentMatcher.matchWasFound()) {
            super.visitClosureListExpression(expression);
        }
    }

    public void visitConstantExpression(ConstantExpression expression) {
        IASTFragment fragment = this.factory.createFragment((Expression)expression);
        fragment.accept(this.fragmentMatcher);
        if (!this.fragmentMatcher.matchWasFound()) {
            super.visitConstantExpression(expression);
        }
    }

    public void visitConstructorCallExpression(ConstructorCallExpression expression) {
        IASTFragment fragment = this.factory.createFragment((Expression)expression);
        fragment.accept(this.fragmentMatcher);
        if (!this.fragmentMatcher.matchWasFound()) {
            super.visitConstructorCallExpression(expression);
        }
    }

    public void visitDeclarationExpression(DeclarationExpression expression) {
        IASTFragment fragment = this.factory.createFragment((Expression)expression);
        fragment.accept(this.fragmentMatcher);
        if (!this.fragmentMatcher.matchWasFound()) {
            super.visitDeclarationExpression(expression);
        }
    }

    public void visitVariableExpression(VariableExpression expression) {
        IASTFragment fragment = this.factory.createFragment((Expression)expression);
        fragment.accept(this.fragmentMatcher);
        if (!this.fragmentMatcher.matchWasFound()) {
            super.visitVariableExpression(expression);
        }
    }

    public void visitFieldExpression(FieldExpression expression) {
        IASTFragment fragment = this.factory.createFragment((Expression)expression);
        fragment.accept(this.fragmentMatcher);
        if (!this.fragmentMatcher.matchWasFound()) {
            super.visitFieldExpression(expression);
        }
    }

    public void visitGStringExpression(GStringExpression expression) {
        IASTFragment fragment = this.factory.createFragment((Expression)expression);
        fragment.accept(this.fragmentMatcher);
        if (!this.fragmentMatcher.matchWasFound()) {
            super.visitGStringExpression(expression);
        }
    }

    public void visitListExpression(ListExpression expression) {
        IASTFragment fragment = this.factory.createFragment((Expression)expression);
        fragment.accept(this.fragmentMatcher);
        if (!this.fragmentMatcher.matchWasFound()) {
            super.visitListExpression(expression);
        }
    }

    public void visitMapEntryExpression(MapEntryExpression expression) {
        IASTFragment fragment = this.factory.createFragment((Expression)expression);
        fragment.accept(this.fragmentMatcher);
        if (!this.fragmentMatcher.matchWasFound()) {
            super.visitMapEntryExpression(expression);
        }
    }

    public void visitMapExpression(MapExpression expression) {
        IASTFragment fragment = this.factory.createFragment((Expression)expression);
        fragment.accept(this.fragmentMatcher);
        if (!this.fragmentMatcher.matchWasFound()) {
            super.visitMapExpression(expression);
        }
    }

    public void visitMethodCallExpression(MethodCallExpression expression) {
        IASTFragment fragment = this.factory.createFragment((Expression)expression);
        fragment.accept(this.fragmentMatcher);
        this.associatedExpressionMatcher.ignoreNext = true;
        fragment.accept(this.associatedExpressionMatcher);
    }

    public void visitMethodPointerExpression(MethodPointerExpression expression) {
        IASTFragment fragment = this.factory.createFragment((Expression)expression);
        fragment.accept(this.fragmentMatcher);
        this.associatedExpressionMatcher.ignoreNext = true;
        fragment.accept(this.associatedExpressionMatcher);
    }

    public void visitNotExpression(NotExpression expression) {
        IASTFragment fragment = this.factory.createFragment((Expression)expression);
        fragment.accept(this.fragmentMatcher);
        if (!this.fragmentMatcher.matchWasFound()) {
            super.visitNotExpression(expression);
        }
    }

    public void visitPostfixExpression(PostfixExpression expression) {
        IASTFragment fragment = this.factory.createFragment((Expression)expression);
        fragment.accept(this.fragmentMatcher);
        if (!this.fragmentMatcher.matchWasFound()) {
            super.visitPostfixExpression(expression);
        }
    }

    public void visitPrefixExpression(PrefixExpression expression) {
        IASTFragment fragment = this.factory.createFragment((Expression)expression);
        fragment.accept(this.fragmentMatcher);
        if (!this.fragmentMatcher.matchWasFound()) {
            super.visitPrefixExpression(expression);
        }
    }

    public void visitPropertyExpression(PropertyExpression expression) {
        IASTFragment fragment = this.factory.createFragment((Expression)expression);
        fragment.accept(this.fragmentMatcher);
        this.associatedExpressionMatcher.ignoreNext = true;
        fragment.accept(this.associatedExpressionMatcher);
    }

    public void visitRangeExpression(RangeExpression expression) {
        IASTFragment fragment = this.factory.createFragment((Expression)expression);
        fragment.accept(this.fragmentMatcher);
        if (!this.fragmentMatcher.matchWasFound()) {
            super.visitRangeExpression(expression);
        }
    }

    public void visitShortTernaryExpression(ElvisOperatorExpression expression) {
        IASTFragment fragment = this.factory.createFragment((Expression)expression);
        fragment.accept(this.fragmentMatcher);
        if (!this.fragmentMatcher.matchWasFound()) {
            super.visitShortTernaryExpression(expression);
        }
    }

    public void visitSpreadExpression(SpreadExpression expression) {
        IASTFragment fragment = this.factory.createFragment((Expression)expression);
        fragment.accept(this.fragmentMatcher);
        if (!this.fragmentMatcher.matchWasFound()) {
            super.visitSpreadExpression(expression);
        }
    }

    public void visitSpreadMapExpression(SpreadMapExpression expression) {
        IASTFragment fragment = this.factory.createFragment((Expression)expression);
        fragment.accept(this.fragmentMatcher);
        if (!this.fragmentMatcher.matchWasFound()) {
            super.visitSpreadMapExpression(expression);
        }
    }

    public void visitStaticMethodCallExpression(StaticMethodCallExpression expression) {
        IASTFragment fragment = this.factory.createFragment((Expression)expression);
        fragment.accept(this.fragmentMatcher);
        if (!this.fragmentMatcher.matchWasFound()) {
            super.visitStaticMethodCallExpression(expression);
        }
    }

    public void visitTernaryExpression(TernaryExpression expression) {
        IASTFragment fragment = this.factory.createFragment((Expression)expression);
        fragment.accept(this.fragmentMatcher);
        if (!this.fragmentMatcher.matchWasFound()) {
            super.visitTernaryExpression(expression);
        }
    }

    public void visitTupleExpression(TupleExpression expression) {
        IASTFragment fragment = this.factory.createFragment((Expression)expression);
        fragment.accept(this.fragmentMatcher);
        if (!this.fragmentMatcher.matchWasFound()) {
            super.visitTupleExpression(expression);
        }
    }

    public void visitUnaryMinusExpression(UnaryMinusExpression expression) {
        IASTFragment fragment = this.factory.createFragment((Expression)expression);
        fragment.accept(this.fragmentMatcher);
        if (!this.fragmentMatcher.matchWasFound()) {
            super.visitUnaryMinusExpression(expression);
        }
    }

    public void visitUnaryPlusExpression(UnaryPlusExpression expression) {
        IASTFragment fragment = this.factory.createFragment((Expression)expression);
        fragment.accept(this.fragmentMatcher);
        if (!this.fragmentMatcher.matchWasFound()) {
            super.visitUnaryPlusExpression(expression);
        }
    }

    class AssociatedExpressionMatcher
    extends FragmentVisitor {
        boolean ignoreNext;

        AssociatedExpressionMatcher() {
        }

        @Override
        public boolean previsit(IASTFragment fragment) {
            if (!this.ignoreNext) {
                fragment.getAssociatedExpression().visit((GroovyCodeVisitor)FindAllOccurrencesVisitor.this);
            } else {
                this.ignoreNext = false;
            }
            return true;
        }

        @Override
        public boolean visit(MethodCallFragment fragment) {
            fragment.getArguments().visit((GroovyCodeVisitor)FindAllOccurrencesVisitor.this);
            return true;
        }
    }

    class FragmentMatcherVisitor
    extends FragmentVisitor {
        private boolean matchWasFound;

        FragmentMatcherVisitor() {
        }

        @Override
        public boolean previsit(IASTFragment fragment) {
            IASTFragment matched = fragment.findMatchingSubFragment(FindAllOccurrencesVisitor.this.toFind);
            if (matched.kind() != ASTFragmentKind.EMPTY && (FindAllOccurrencesVisitor.this.occurrences.isEmpty() || FindAllOccurrencesVisitor.this.occurrences.get(FindAllOccurrencesVisitor.this.occurrences.size() - 1).getStart() != matched.getStart())) {
                FindAllOccurrencesVisitor.this.occurrences.add(matched);
                this.matchWasFound = true;
            }
            return fragment.kind() == ASTFragmentKind.BINARY;
        }

        boolean matchWasFound() {
            boolean b = this.matchWasFound;
            this.matchWasFound = false;
            return b;
        }
    }
}

