/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.integration.analytics.providers;

import com.kms.katalon.integration.analytics.providers.IBeforeDownloadStarted;
import com.kms.katalon.integration.analytics.providers.IDownloadRequestProgressChanged;
import com.kms.katalon.network.core.services.IDownloadProgress;
import com.kms.katalon.testops.core.model.exception.AnalyticsApiException;
import com.kms.katalon.testops.core.services.ITestOpsController;
import jakarta.inject.Inject;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class ApiRequestDownloader {
    private List<IDownloadRequestProgressChanged> downloadProgressListeners;
    private List<IBeforeDownloadStarted> beforeDownloadStartedListeners;
    private IProgressMonitor monitor;
    private String resourcePath;
    @Inject
    private ITestOpsController testOpsController;

    public ApiRequestDownloader(String resourcePath, IProgressMonitor monitor) {
        this.resourcePath = resourcePath;
        this.monitor = monitor;
    }

    public void subcribeDownloadProgressChanged(IDownloadRequestProgressChanged listener) {
        if (this.downloadProgressListeners == null) {
            this.downloadProgressListeners = new LinkedList<IDownloadRequestProgressChanged>();
        }
        this.downloadProgressListeners.add(listener);
    }

    public void subcribeBeforeDownloadStarted(IBeforeDownloadStarted listener) {
        if (this.beforeDownloadStartedListeners == null) {
            this.beforeDownloadStartedListeners = new LinkedList<IBeforeDownloadStarted>();
        }
        this.beforeDownloadStartedListeners.add(listener);
    }

    public File download(Long executionId) throws AnalyticsApiException {
        return this.testOpsController.downloadReport(executionId, new IDownloadProgress(){
            long totalBytes = 0L;

            public void start(long totalBytes) {
                this.totalBytes = totalBytes;
                ApiRequestDownloader.this.notifyBeforeDownloadListeners(totalBytes);
            }

            public void update(long bytesRead) {
                ApiRequestDownloader.this.notifyProgressListeners(this.totalBytes, bytesRead);
            }

            public void finish() {
            }
        });
    }

    private void notifyProgressListeners(long total, long downloaded) {
        if (this.downloadProgressListeners != null) {
            this.downloadProgressListeners.parallelStream().forEach(l3 -> l3.notifyProgressChanged(total, downloaded));
        }
    }

    private void notifyBeforeDownloadListeners(long contentLength) {
        if (this.beforeDownloadStartedListeners != null) {
            this.beforeDownloadStartedListeners.parallelStream().forEach(l2 -> l2.notifyDownloadInfo(contentLength));
        }
    }
}

