/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.integration.analytics.util;

import com.kms.katalon.core.util.internal.ZipUtil;
import com.kms.katalon.execution.entity.ReportFolder;
import com.kms.katalon.integration.analytics.util.FileUtils;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.testops.core.model.ExecutionReportScanResult;
import com.kms.katalon.util.ExecutorUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import java.util.zip.ZipOutputStream;
import org.apache.commons.lang3.StringUtils;

public class ExecutionReportScanner {
    private static final Pattern HAR_FILE_PATTERN = Pattern.compile("([^\\s]+(\\.(?i)(har))$)");
    private static final Pattern OTHER_FILE_PATTERN = Pattern.compile("(.*(?i)(?<!\\.|\\.zip|\\.har)$)");

    public ExecutionReportScanResult lazyScan(ReportFolder mainReportFolder) {
        return this.lazyScan(mainReportFolder, true);
    }

    public ExecutionReportScanResult lazyScan(ReportFolder mainReportFolder, boolean compressHarFiles) {
        List<ScanResultPair> results = mainReportFolder.getReportFolders().parallelStream().map(reportFolder -> {
            ArrayList<ExecutionReportScanResult.NormalReportArtifact> localPaths = new ArrayList<ExecutionReportScanResult.NormalReportArtifact>();
            ArrayList<ExecutionReportScanResult.FutureReportArtifact> localFuturePaths = new ArrayList<ExecutionReportScanResult.FutureReportArtifact>();
            this.resolveReportFolder((String)reportFolder, file -> {
                boolean bl = localPaths.add(new ExecutionReportScanResult.NormalReportArtifact(file));
            }, futureFile -> {
                boolean bl = localFuturePaths.add(new ExecutionReportScanResult.FutureReportArtifact(futureFile));
            }, compressHarFiles, false);
            LogUtil.logInfo((String)MessageFormat.format("Scan report folder: \"{0}\": found {1} normal files and {2} future files", reportFolder, localPaths.size(), localFuturePaths.size()));
            return new ScanResultPair(localPaths, localFuturePaths);
        }).toList();
        ArrayList<ExecutionReportScanResult.NormalReportArtifact> allPaths = new ArrayList<ExecutionReportScanResult.NormalReportArtifact>();
        ArrayList<ExecutionReportScanResult.FutureReportArtifact> allFuturePaths = new ArrayList<ExecutionReportScanResult.FutureReportArtifact>();
        for (ScanResultPair pair : results) {
            allPaths.addAll(pair.normalArtifacts);
            allFuturePaths.addAll(pair.futureArtifacts);
        }
        LogUtil.logInfo((String)MessageFormat.format("Scan report result: found total {0} normal files and {1} future files", allPaths.size(), allFuturePaths.size()));
        return new ExecutionReportScanResult(allPaths, allFuturePaths);
    }

    public List<Path> scan(ReportFolder mainReportFolder) {
        return this.scan(mainReportFolder, true, true);
    }

    public List<Path> scan(ReportFolder mainReportFolder, boolean compressHarFiles) {
        return this.scan(mainReportFolder, compressHarFiles, true);
    }

    public List<Path> scan(ReportFolder mainReportFolder, boolean compressHarFiles, boolean waitForCompression) {
        List<List> results = mainReportFolder.getReportFolders().parallelStream().map(reportFolder -> {
            ArrayList localPaths = new ArrayList();
            this.resolveReportFolder((String)reportFolder, file -> {
                boolean bl = localPaths.add(file);
            }, null, compressHarFiles, waitForCompression);
            LogUtil.logInfo((String)MessageFormat.format("Scan report folder: \"{0}\": found {1} files", reportFolder, localPaths.size()));
            return localPaths;
        }).toList();
        ArrayList<Path> allPaths = new ArrayList<Path>();
        for (List localPaths : results) {
            allPaths.addAll(localPaths);
        }
        LogUtil.logInfo((String)MessageFormat.format("Scan report result: found total {0} files", allPaths.size()));
        return allPaths;
    }

    private void resolveReportFolder(String reportFolder, FileResolver onFile, FutureFileResolver onFutureFile, boolean compressHarFiles, boolean waitForCompression) {
        block8: {
            AtomicReference<Object> harFilesCompressingPool = new AtomicReference<Object>(null);
            AtomicReference<Object> zip = new AtomicReference<Object>(null);
            AtomicBoolean harZipFileIncluded = new AtomicBoolean(false);
            ArrayList rawFuturePaths = new ArrayList();
            try {
                try {
                    this.scanReportFolder(reportFolder, fileI -> {
                        String fileName = fileI.toFile().getName();
                        if (HAR_FILE_PATTERN.matcher(fileName).matches()) {
                            if (!compressHarFiles) {
                                return;
                            }
                            if (!harZipFileIncluded.get()) {
                                harZipFileIncluded.set(true);
                                try {
                                    Path zipFilePath = FileUtils.createTemporaryFile(StringUtils.appendIfMissing((String)reportFolder, (CharSequence)File.separator, (CharSequence[])new CharSequence[0]) + "katalon-analytics-tmp", "hars-", ".zip");
                                    zip.set(ZipUtil.createZip((Path)zipFilePath));
                                    harFilesCompressingPool.set(Executors.newSingleThreadExecutor());
                                    rawFuturePaths.add(zipFilePath);
                                }
                                catch (IOException error) {
                                    LogUtil.logError((Throwable)error, (String)"Cannot create HAR compression file");
                                }
                            }
                            ((ExecutorService)harFilesCompressingPool.get()).submit(() -> this.resolveHarFile(fileI, (ZipOutputStream)zip.get()));
                        } else if (OTHER_FILE_PATTERN.matcher(fileName).matches()) {
                            onFile.resolve(fileI);
                        }
                    });
                }
                catch (IOException error) {
                    LogUtil.logError((Throwable)error, (String)MessageFormat.format("Cannot resolve report folder: \"{0}\"", reportFolder));
                    if (!compressHarFiles) {
                        return;
                    }
                    ExecutorService futurePool = Executors.newSingleThreadExecutor();
                    rawFuturePaths.forEach(rawFuturePath -> {
                        Future<Path> futureZipFile = futurePool.submit(() -> {
                            ExecutorUtils.awaitWithGracefulShutdown((ExecutorService)((ExecutorService)harFilesCompressingPool.get()));
                            ZipUtil.closeZip((ZipOutputStream)((ZipOutputStream)zip.get()));
                            return rawFuturePath;
                        });
                        if (waitForCompression) {
                            try {
                                futureZipFile.get();
                            }
                            catch (InterruptedException | ExecutionException exception) {}
                        }
                        if (onFutureFile != null) {
                            onFutureFile.resolve(futureZipFile);
                        } else {
                            onFile.resolve((Path)rawFuturePath);
                        }
                    });
                    futurePool.shutdown();
                    break block8;
                }
            }
            catch (Throwable throwable) {
                if (!compressHarFiles) {
                    return;
                }
                ExecutorService futurePool = Executors.newSingleThreadExecutor();
                rawFuturePaths.forEach(rawFuturePath -> {
                    Future<Path> futureZipFile = futurePool.submit(() -> {
                        ExecutorUtils.awaitWithGracefulShutdown((ExecutorService)((ExecutorService)harFilesCompressingPool.get()));
                        ZipUtil.closeZip((ZipOutputStream)((ZipOutputStream)zip.get()));
                        return rawFuturePath;
                    });
                    if (waitForCompression) {
                        try {
                            futureZipFile.get();
                        }
                        catch (InterruptedException | ExecutionException exception) {}
                    }
                    if (onFutureFile != null) {
                        onFutureFile.resolve(futureZipFile);
                    } else {
                        onFile.resolve((Path)rawFuturePath);
                    }
                });
                futurePool.shutdown();
                throw throwable;
            }
            if (!compressHarFiles) {
                return;
            }
            ExecutorService futurePool = Executors.newSingleThreadExecutor();
            rawFuturePaths.forEach(rawFuturePath -> {
                Future<Path> futureZipFile = futurePool.submit(() -> {
                    ExecutorUtils.awaitWithGracefulShutdown((ExecutorService)((ExecutorService)harFilesCompressingPool.get()));
                    ZipUtil.closeZip((ZipOutputStream)((ZipOutputStream)zip.get()));
                    return rawFuturePath;
                });
                if (waitForCompression) {
                    try {
                        futureZipFile.get();
                    }
                    catch (InterruptedException | ExecutionException exception) {}
                }
                if (onFutureFile != null) {
                    onFutureFile.resolve(futureZipFile);
                } else {
                    onFile.resolve((Path)rawFuturePath);
                }
            });
            futurePool.shutdown();
        }
    }

    private void resolveHarFile(Path harFile, ZipOutputStream zip) {
        try {
            ZipUtil.appendFile((ZipOutputStream)zip, (Path)harFile);
        }
        catch (IOException error) {
            LogUtil.logError((Throwable)error, (String)MessageFormat.format("Cannot compress HAR file: \"{0}\"", harFile.toFile().getAbsolutePath()));
        }
    }

    private void scanReportFolder(String reportFolder, final FileResolver fileResolver) throws IOException {
        Files.walkFileTree(FileUtils.createPath(reportFolder), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path visitedFile, BasicFileAttributes attrs) throws IOException {
                fileResolver.resolve(visitedFile);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static interface FileResolver {
        public void resolve(Path var1);
    }

    public static interface FutureFileResolver {
        public void resolve(Future<Path> var1);
    }

    private static class ScanResultPair {
        final List<ExecutionReportScanResult.NormalReportArtifact> normalArtifacts;
        final List<ExecutionReportScanResult.FutureReportArtifact> futureArtifacts;

        ScanResultPair(List<ExecutionReportScanResult.NormalReportArtifact> normalArtifacts, List<ExecutionReportScanResult.FutureReportArtifact> futureArtifacts) {
            this.normalArtifacts = normalArtifacts;
            this.futureArtifacts = futureArtifacts;
        }
    }
}

