/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.session.core.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Instant;
import java.util.Base64;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KatOneJwtToken {
    private static final Logger logger = LoggerFactory.getLogger(KatOneJwtToken.class);
    private String azp;
    private Long exp;
    private Long iat;
    private String iss;
    private String typ;
    private String email;
    @JsonProperty(value="account_uuid")
    private String accountUuid;

    public static KatOneJwtToken parseToken(String token) {
        if (StringUtils.isEmpty((CharSequence)token)) {
            return null;
        }
        String[] chunk = token.split("\\.");
        Base64.Decoder decoder = Base64.getUrlDecoder();
        String payload = new String(decoder.decode(chunk[1]));
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            return (KatOneJwtToken)mapper.readValue(payload, KatOneJwtToken.class);
        }
        catch (JsonProcessingException e) {
            logger.error("Failed to parse token!", (Throwable)e);
            return null;
        }
    }

    public String getAzp() {
        return this.azp;
    }

    public Long getExp() {
        return this.exp;
    }

    public Long getIat() {
        return this.iat;
    }

    public String getIss() {
        return this.iss;
    }

    public String getEmail() {
        return this.email;
    }

    public String getTyp() {
        return this.typ;
    }

    public String getAccountUuid() {
        return this.accountUuid;
    }

    public void setAccountUuid(String accountUuid) {
        this.accountUuid = accountUuid;
    }

    public boolean isExpired() {
        return this.exp <= Instant.now().getEpochSecond();
    }

    public boolean isExpiringSoon(int minutesBefore) {
        long futureTime = Instant.now().getEpochSecond() + (long)(minutesBefore * 60);
        return this.exp <= futureTime;
    }
}

