/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.activation.plugin.models;

import com.kms.katalon.activation.plugin.models.KStoreBasicCredentials;
import com.kms.katalon.activation.plugin.models.KStoreCredentials;

public class KStoreClientExceptionWithInfo
extends Exception {
    private static final long serialVersionUID = -154534255301013098L;
    private KStoreCredentials credential;
    private String endpoint = "uninitialized";

    public KStoreClientExceptionWithInfo(String message, KStoreCredentials credential, String endpoint) {
        super(message);
        this.credential = credential;
        this.endpoint = endpoint;
    }

    public KStoreClientExceptionWithInfo(String message, KStoreCredentials credential, String endpoint, Throwable cause) {
        super(message, cause);
        this.credential = credential;
        this.endpoint = endpoint;
    }

    private String getCredential() {
        if (this.credential == null) {
            return "";
        }
        if (this.credential instanceof KStoreBasicCredentials) {
            return ((KStoreBasicCredentials)this.credential).getUsername();
        }
        return "";
    }

    private String getEndpoint() {
        return this.endpoint;
    }

    public String getInfoMessage() {
        String credential = this.getCredential();
        String endpoint = this.getEndpoint();
        if (credential.equals("")) {
            return "Invalid API key, please re-check your credential";
        }
        return "credential: " + credential + ", endpoint: " + endpoint;
    }
}

