/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.selenium.filter;

import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.remote.http.Filter;
import org.openqa.selenium.remote.http.HttpHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeleniumBasicAuthorizationFilter
implements Filter {
    private static Logger logger = LoggerFactory.getLogger(SeleniumBasicAuthorizationFilter.class);
    private URL url;

    public SeleniumBasicAuthorizationFilter(URL url) {
        this.url = url;
    }

    public HttpHandler apply(HttpHandler next) {
        return req -> {
            try {
                String basicAuthToken = this.getBasicAuthToken(req.getUri());
                if (StringUtils.isNotBlank((CharSequence)basicAuthToken)) {
                    req.addHeader("Authorization", "Basic " + basicAuthToken);
                }
            }
            catch (Exception e) {
                logger.warn("Exception while apply AppiumAuthorizationFilter", (Throwable)e);
            }
            return next.execute(req);
        };
    }

    private String getBasicAuthToken(String urlStr) throws MalformedURLException {
        String info = this.url.getUserInfo();
        if (StringUtils.isBlank((CharSequence)info)) {
            return null;
        }
        return Base64.getEncoder().encodeToString(info.getBytes(StandardCharsets.UTF_8));
    }
}

