/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.selenium.filter;

import java.io.IOException;
import java.io.InputStream;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.DecompressingEntity;
import org.apache.http.client.entity.DeflateInputStreamFactory;
import org.apache.http.client.entity.GZIPInputStreamFactory;
import org.apache.http.client.entity.InputStreamFactory;
import org.apache.http.config.Lookup;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.util.EntityUtils;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.Filter;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpResponse;

public class SeleniumResponseContentEncodingDecompressionFilter
implements Filter {
    private static String CONTENT_ENCODING_HEADER_NAME = "Content-Encoding";
    private static String CONTENT_LENGTH_HEADER_NAME = "Content-Length";
    private static String CONTENT_MD5_HEADER_NAME = "Content-MD5";
    private static String GZIP_ENCODING = "gzip";
    private static String DEFLATE_ENCODING = "deflate";
    private final Lookup<InputStreamFactory> decoderRegistry;

    public SeleniumResponseContentEncodingDecompressionFilter() {
        this(null);
    }

    public SeleniumResponseContentEncodingDecompressionFilter(Lookup<InputStreamFactory> decoderRegistry) {
        this.decoderRegistry = decoderRegistry != null ? decoderRegistry : RegistryBuilder.create().register(GZIP_ENCODING, (Object)GZIPInputStreamFactory.getInstance()).register(DEFLATE_ENCODING, (Object)DeflateInputStreamFactory.getInstance()).build();
    }

    public HttpHandler apply(HttpHandler next) {
        return request -> {
            HttpResponse response;
            block13: {
                long contentLength;
                response = next.execute(request);
                String encoding = response.getHeader(CONTENT_ENCODING_HEADER_NAME);
                long l = contentLength = response.getHeader(CONTENT_LENGTH_HEADER_NAME) != null ? Long.parseLong(response.getHeader(CONTENT_LENGTH_HEADER_NAME)) : -1L;
                if (encoding != null && contentLength != 0L) {
                    try {
                        Throwable throwable = null;
                        Object var8_9 = null;
                        try (InputStream compressedStream = (InputStream)response.getContent().get();){
                            InputStreamEntity inputStreamEntity = new InputStreamEntity(compressedStream);
                            InputStreamFactory decoderFactory = (InputStreamFactory)this.decoderRegistry.lookup(encoding.toLowerCase());
                            if (decoderFactory != null) {
                                DecompressingEntity decompressingEntity = new DecompressingEntity((HttpEntity)inputStreamEntity, decoderFactory);
                                byte[] decompressedBytes = EntityUtils.toByteArray((HttpEntity)decompressingEntity);
                                response.setContent(Contents.bytes((byte[])decompressedBytes));
                                response.removeHeader(CONTENT_ENCODING_HEADER_NAME);
                                response.removeHeader(CONTENT_LENGTH_HEADER_NAME);
                                response.removeHeader(CONTENT_MD5_HEADER_NAME);
                                break block13;
                            }
                            throw new IOException("Unsupported Content-Encoding: " + encoding);
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Failed to decompress response", e);
                    }
                }
            }
            return response;
        };
    }
}

