/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.common.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.Platform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessUtil {
    private static final Logger logger = LoggerFactory.getLogger(ProcessUtil.class);

    public static void terminateProcess(Process p) {
        ProcessHandle processHandle = p.toHandle();
        if (processHandle.compareTo(ProcessHandle.current()) != 0) {
            if (processHandle.supportsNormalTermination()) {
                processHandle.destroy();
                try {
                    processHandle.onExit().get(2000L, TimeUnit.MILLISECONDS);
                    return;
                }
                catch (InterruptedException | ExecutionException | TimeoutException ex) {
                    logger.info(MessageFormat.format("The process with PID {0} wasn't terminated, error: {1}", processHandle.pid(), ex.getMessage()));
                }
            }
            if (processHandle.isAlive()) {
                processHandle.destroyForcibly();
            }
        }
    }

    public static void killProcessOnWindows(String processName) throws InterruptedException, IOException {
        ProcessUtil.killProcessOnWindows(processName, null, null);
    }

    public static void killProcessOnWindows(String processName, File logFile, File errorLogFile) throws InterruptedException, IOException {
        ProcessBuilder pb = new ProcessBuilder("taskkill", "/f", "/im", processName, "/t");
        if (logFile != null) {
            FileWriter writer = new FileWriter(logFile, true);
            writer.write(String.format("\r\nTerminating process \"%s\"\r\n", processName));
            writer.close();
            pb.redirectOutput(ProcessBuilder.Redirect.appendTo(logFile));
        }
        if (errorLogFile != null) {
            pb.redirectError(ProcessBuilder.Redirect.appendTo(errorLogFile));
        }
        pb.start().waitFor();
    }

    public static void killProcessOnUnix(String processName) throws InterruptedException, IOException {
        ProcessUtil.killProcessOnUnix(processName, null, null);
    }

    public static void killProcessOnUnix(String processName, File logFile, File errorLogFile) throws InterruptedException, IOException {
        ProcessBuilder pb = new ProcessBuilder("killall", processName);
        if (logFile != null) {
            FileWriter writer = new FileWriter(logFile, true);
            writer.write(String.format("\r\nTerminating process \"%s\"\r\n", processName));
            writer.close();
            pb.redirectOutput(ProcessBuilder.Redirect.appendTo(logFile));
        }
        if (errorLogFile != null) {
            pb.redirectError(ProcessBuilder.Redirect.appendTo(errorLogFile));
        }
        pb.start().waitFor();
    }

    public static List<String> readSync(Process process) throws InterruptedException, IOException {
        return ProcessUtil.read(process, true);
    }

    public static List<String> read(Process process) throws InterruptedException, IOException {
        return ProcessUtil.read(process, false);
    }

    public static List<String> read(Process process, boolean waitForProcessEnd) throws InterruptedException, IOException {
        ArrayList<String> output = new ArrayList<String>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    output.add(line);
                }
                if (waitForProcessEnd) {
                    process.waitFor();
                }
            }
            catch (IOException iOException) {
                reader.close();
            }
        }
        return output;
    }

    public static boolean includes(List<String> result, String signal) {
        return result.stream().anyMatch(line -> StringUtils.contains((CharSequence)line, (CharSequence)signal));
    }

    public static boolean isKRE() {
        return Platform.getProduct() != null && Platform.getProduct().getId().equals("com.kms.katalon.console.product");
    }
}

