/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.mobile.objectspy.components;

import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.impl.dialogs.CustomProgressMonitorDialog;
import com.kms.katalon.composer.components.impl.dialogs.ProgressMonitorDialogWithThread;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.mobile.objectspy.actions.MobileAction;
import com.kms.katalon.composer.mobile.objectspy.actions.MobileActionMapping;
import com.kms.katalon.composer.mobile.objectspy.constant.ComposerMobileObjectspyMessageConstants;
import com.kms.katalon.composer.mobile.objectspy.dialog.AppiumMonitorDialog;
import com.kms.katalon.composer.mobile.objectspy.dialog.MobileAppDialog;
import com.kms.katalon.composer.mobile.objectspy.interfaces.IMobileInspectorController;
import com.kms.katalon.composer.mobile.objectspy.interfaces.ITestCloudApplicationSelectorComposite;
import com.kms.katalon.composer.mobile.objectspy.interfaces.ITestCloudDeviceSelectorComposite;
import com.kms.katalon.composer.mobile.objectspy.interfaces.MobileAppComposite;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ConstantExpressionWrapper;
import com.kms.katalon.composer.testops.service.AnalyticsSettingStore;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.mobile.driver.MobileDriverType;
import com.kms.katalon.execution.webui.configuration.RemoteWebRunConfiguration;
import com.kms.katalon.testcloud.configuration.TestCloudRunConfiguration;
import com.kms.katalon.testcloud.core.event.TestCloudDevicePlatformSelectedEvent;
import com.kms.katalon.testcloud.core.event.TestCloudUploadApplicationLinkSelected;
import com.kms.katalon.testcloud.core.model.TestCloudApplication;
import com.kms.katalon.testcloud.core.model.TestCloudEntity;
import com.kms.katalon.testcloud.core.model.TestCloudExecutionMode;
import com.kms.katalon.testcloud.core.model.TestCloudExecutionSessionResponse;
import com.kms.katalon.testcloud.core.model.TestCloudMobileDevice;
import com.kms.katalon.testcloud.core.model.TestCloudMobilePlatformName;
import com.kms.katalon.testcloud.core.model.TestCloudSessionType;
import com.kms.katalon.testcloud.core.model.exception.TestCloudException;
import com.kms.katalon.testcloud.core.service.ITestCloudController;
import com.kms.katalon.tracking.model.MobileDeviceOption;
import jakarta.inject.Inject;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;

@Creatable
public class TestCloudConfigurationsComposite
implements MobileAppComposite {
    @Inject
    private ITestCloudController controller;
    @Inject
    private ITestCloudDeviceSelectorComposite testcloudDeviceSelectorComposite;
    @Inject
    private ITestCloudApplicationSelectorComposite testcloudApplicationSelectorComposite;
    private TestCloudRunConfiguration runConfiguration;
    private Composite testCloudComposite;
    @Inject
    private IEventBroker eventBroker;

    @Override
    public Composite render(Composite parent, int type, MobileAppDialog parentDialog) {
        this.testCloudComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.testCloudComposite.setLayout((Layout)layout);
        this.testcloudDeviceSelectorComposite.render(this.testCloudComposite, type);
        this.testcloudApplicationSelectorComposite.render(this.testCloudComposite, type);
        return this.testCloudComposite;
    }

    @Inject
    @Optional
    private void subscribeUploadApplicationLinkSelected(@UIEventTopic(value="ON_UPLOAD_APPLICATION_LINK_SELECTED") TestCloudUploadApplicationLinkSelected event) {
        AnalyticsSettingStore analyticsSettingStore = AnalyticsSettingStore.getStore((String)ProjectController.getInstance().getCurrentProject().getFolderLocation());
        String team = String.valueOf(analyticsSettingStore.getTeam().getId());
        String project = String.valueOf(analyticsSettingStore.getProject().getId());
        String url = MessageFormat.format(event.getUrl(), team, project);
        Program.launch((String)url);
    }

    @Inject
    @Optional
    private void subscribeApplicationRefreshButtonSelected(@UIEventTopic(value="ON_APPLICATION_REFRESH_BUTTON_PRESSED") Map data) {
        try {
            if (this.testCloudComposite != null && !this.testCloudComposite.isDisposed()) {
                this.fetchApplications();
            }
        }
        catch (InterruptedException | InvocationTargetException e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    @Inject
    @Optional
    private void subscribeApplicationRefreshButtonSelected(@UIEventTopic(value="ON_TESTCLOUD_DEVICE_PLATFORM_SELECTED") TestCloudDevicePlatformSelectedEvent event) {
        this.testcloudApplicationSelectorComposite.setTestCloudDevicePlatform(event.getSelectedPlatform());
        this.eventBroker.send("TESTCLOUD/REFRESH_START_BUTTON_STATE", null);
    }

    @Override
    public boolean validateSetting() {
        return true;
    }

    @Override
    public MobileDriverType getSelectedDriverType() {
        TestCloudMobileDevice testCloudDevice = this.testcloudDeviceSelectorComposite.getSelectionDevice();
        if (testCloudDevice != null) {
            return testCloudDevice.getPlatformName().equals((Object)TestCloudMobilePlatformName.ANDROID) ? MobileDriverType.ANDROID_DRIVER : MobileDriverType.IOS_DRIVER;
        }
        return MobileDriverType.ANDROID_DRIVER;
    }

    @Override
    public boolean startApp(final IMobileInspectorController inspectorController, AppiumMonitorDialog progressDialog) throws InvocationTargetException, InterruptedException {
        TestCloudMobileDevice device = this.testcloudDeviceSelectorComposite.getSelectionDevice();
        final TestCloudApplication application = this.testcloudApplicationSelectorComposite.getSelectionApplication();
        try {
            this.runConfiguration = (TestCloudRunConfiguration)this.controller.buildRunConfiguration((TestCloudEntity)device, TestCloudSessionType.MOBILE_NATIVE, TestCloudExecutionMode.INSTANT);
        }
        catch (TestCloudException e) {
            LoggerSingleton.logError((Throwable)e);
            return false;
        }
        final CustomProgressMonitorDialog customProgress = new CustomProgressMonitorDialog(Display.getDefault().getActiveShell()){

            public void cancelPressed() {
                EventBrokerSingleton.getInstance().getEventBroker().send("TESTCLOUD/CANCEL_START_TESTCLOUD_RECORD_SPY", null);
                this.finishedRun();
                this.getProgressMonitor().done();
                super.cancelPressed();
            }
        };
        customProgress.setIsDisplayIcon(false);
        IRunnableWithProgress processToRun = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask(ComposerMobileObjectspyMessageConstants.DIA_LBL_STATUS_APP_STARTING, -1);
                monitor.subTask(ComposerMobileObjectspyMessageConstants.MSG_LOOKING_FOR_AVAILABLE_DEVICE);
                customProgress.runAndWait((Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        inspectorController.startMobileAppOnCloudDevices((RemoteWebRunConfiguration)(this).TestCloudConfigurationsComposite.this.runConfiguration, application.getId());
                        return null;
                    }
                });
                if (monitor.isCanceled()) {
                    throw new InterruptedException(ComposerMobileObjectspyMessageConstants.DIA_ERROR_MSG_OPERATION_CANCELED);
                }
                monitor.done();
            }
        };
        customProgress.run(true, true, processToRun);
        return true;
    }

    @Override
    public void setInput() throws InvocationTargetException, InterruptedException {
        this.fetchDevices();
        this.fetchApplications();
    }

    @Override
    public String getAppFile() {
        return this.testcloudApplicationSelectorComposite.getSelectionApplication().getId();
    }

    @Override
    public String getAppName() {
        String name = this.testcloudApplicationSelectorComposite.getSelectionApplication().getName();
        return FilenameUtils.getName((String)name);
    }

    @Override
    public MobileActionMapping buildStartAppActionMapping() {
        MobileActionMapping startAppAction = new MobileActionMapping(MobileAction.StartApplication, null);
        String appValue = this.getAppFile();
        startAppAction.getData()[0].setValue(new ConstantExpressionWrapper((Object)appValue));
        return startAppAction;
    }

    @Override
    public boolean isAbleToStart() {
        return this.testcloudDeviceSelectorComposite.getSelectionDevice() != null && this.testcloudApplicationSelectorComposite.getSelectionApplication() != null;
    }

    @Override
    public void loadDevices() throws InvocationTargetException, InterruptedException {
        this.fetchDevices();
        this.fetchApplications();
    }

    private void onUpdatedDevices(List<TestCloudMobileDevice> devices) {
        this.testcloudDeviceSelectorComposite.setTestCloudDevices(devices);
    }

    private void onUpdatedApplications(List<TestCloudApplication> applications) {
        TestCloudMobileDevice device = this.testcloudDeviceSelectorComposite.getSelectionDevice();
        if (device != null) {
            this.testcloudApplicationSelectorComposite.setTestCloudApplications(applications, device.getPlatformName());
        } else {
            this.testcloudApplicationSelectorComposite.setTestCloudApplications(applications, null);
        }
    }

    private void fetchDevices() throws InvocationTargetException, InterruptedException {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask(ComposerMobileObjectspyMessageConstants.DIA_JOB_TASK_LOADING_DEVICES, -1);
                List testCloudDeviceList = null;
                try {
                    testCloudDeviceList = TestCloudConfigurationsComposite.this.controller.requestTestCloudDevice();
                }
                catch (TestCloudException e) {
                    LoggerSingleton.logError((Throwable)e);
                }
                if (monitor.isCanceled()) {
                    throw new InterruptedException(ComposerMobileObjectspyMessageConstants.DIA_ERROR_MSG_OPERATION_CANCELED);
                }
                final List deviceList = testCloudDeviceList;
                UISynchronizeService.syncExec((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        TestCloudConfigurationsComposite.this.onUpdatedDevices(deviceList);
                    }
                });
                monitor.done();
            }
        };
        new ProgressMonitorDialogWithThread(Display.getDefault().getActiveShell()).run(true, true, runnable);
    }

    private void fetchApplications() throws InvocationTargetException, InterruptedException {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask(ComposerMobileObjectspyMessageConstants.DIA_JOB_TASK_LOADING_APPLICATIONS, -1);
                List testCloudApplicationList = null;
                try {
                    testCloudApplicationList = TestCloudConfigurationsComposite.this.controller.requestTestCloudApplication();
                }
                catch (TestCloudException e) {
                    LoggerSingleton.logError((Throwable)e);
                }
                if (monitor.isCanceled()) {
                    throw new InterruptedException(ComposerMobileObjectspyMessageConstants.DIA_ERROR_MSG_OPERATION_CANCELED);
                }
                final List applicationList = testCloudApplicationList;
                UISynchronizeService.syncExec((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        TestCloudConfigurationsComposite.this.onUpdatedApplications(applicationList);
                    }
                });
                monitor.done();
            }
        };
        new ProgressMonitorDialogWithThread(Display.getDefault().getActiveShell()).run(true, true, runnable);
    }

    @Override
    public String getDialogConfigurationsLabel() {
        return ComposerMobileObjectspyMessageConstants.DIA_LBL_TESTCLOUD_CONFIGURATIONS;
    }

    @Override
    public MobileDeviceOption getMobileDeviceOption() {
        return MobileDeviceOption.TESTCLOUD_DEVICE;
    }

    public TestCloudMobileDevice getSelectedDevice() {
        return this.testcloudDeviceSelectorComposite.getSelectionDevice();
    }

    public TestCloudExecutionSessionResponse getExecutionSession(String executionSessionId) {
        try {
            return this.controller.getExecutionSession(executionSessionId);
        }
        catch (TestCloudException e) {
            LoggerSingleton.logError((Throwable)e);
            return null;
        }
    }
}

