/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.mobile.objectspy.util;

import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.tree.WebElementTreeEntity;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.mobile.objectspy.dialog.AddElementToObjectRepositoryDialogV2;
import com.kms.katalon.composer.mobile.objectspy.element.CapturedMobileElementConverterV2;
import com.kms.katalon.composer.mobile.objectspy.element.MobileElement;
import com.kms.katalon.composer.mobile.objectspy.element.impl.CapturedMobileElement;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ObjectRepositoryController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.repository.MobileElementEntity;
import com.kms.katalon.entity.repository.WebElementEntity;
import com.kms.katalon.entity.repository.WebElementPropertyEntity;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class MobileElementHelper {
    private List<String> ignoredProperties = Arrays.asList("x", "y", "width", "height", "bounds", "enabled");

    public int calculateHashValue(Object elementObj) {
        HashCodeBuilder hashCodeBuilder;
        block4: {
            block3: {
                if (elementObj == null) {
                    return -1;
                }
                hashCodeBuilder = new HashCodeBuilder();
                if (!(elementObj instanceof MobileElement)) break block3;
                MobileElement mElement = (MobileElement)elementObj;
                HashMap<String, String> attributes = new HashMap<String, String>();
                attributes.putAll(mElement.getAttributes());
                Map sortedAttributes = attributes.entrySet().stream().sorted(Map.Entry.comparingByKey()).collect(LinkedHashMap::new, (map, entry) -> {
                    String string = map.put((String)entry.getKey(), (String)entry.getValue());
                }, HashMap::putAll);
                for (Map.Entry attribute : sortedAttributes.entrySet()) {
                    String key = (String)attribute.getKey();
                    String val = (String)attribute.getValue();
                    if (this.ignoredProperties.contains(key) || !StringUtils.isNotBlank((String)val)) continue;
                    hashCodeBuilder.append((Object)val);
                }
                break block4;
            }
            if (!(elementObj instanceof MobileElementEntity)) break block4;
            MobileElementEntity entity = (MobileElementEntity)elementObj;
            ArrayList<WebElementPropertyEntity> entityProperties = new ArrayList<WebElementPropertyEntity>();
            entityProperties.addAll(entity.getWebElementProperties());
            entityProperties.sort(Comparator.comparing(WebElementPropertyEntity::getName));
            for (WebElementPropertyEntity webElementPropertyEntity : entityProperties) {
                String propertyName = webElementPropertyEntity.getName();
                String propertyValue = webElementPropertyEntity.getValue();
                if (this.ignoredProperties.contains(propertyName) || !StringUtils.isNotBlank((String)propertyValue)) continue;
                hashCodeBuilder.append((Object)propertyValue);
            }
        }
        return hashCodeBuilder.toHashCode();
    }

    public void addConflictedMobileElement(CapturedMobileElement mobileElement, AddElementToObjectRepositoryDialogV2.AddToObjectRepositoryDialogResult dialogResult, List<ITreeEntity> newTreeEntities) throws Exception {
        FolderTreeEntity selectedParentFolder = dialogResult.getSelectedParentFolder();
        AddElementToObjectRepositoryDialogV2.ConflictOptions selectedConflictOption = dialogResult.getSelectedConflictOption();
        List<MobileElementEntity> allConflictedElementEntites = dialogResult.getAllConflictedElementEntities();
        CapturedMobileElement newMobileElement = (CapturedMobileElement)mobileElement.clone();
        String folderPath = ProjectController.getInstance().getCurrentProject().getFolderLocation() + File.separator + selectedParentFolder.getObject().getRelativePath();
        FolderEntity conflictedFolderEntity = FolderController.getInstance().getFolder(folderPath);
        if (mobileElement.isConflicted()) {
            String oldElementAbsolutePath = folderPath + File.separator + StringUtils.trim((String)newMobileElement.getName()) + MobileElementEntity.getWebElementFileExtension();
            MobileElementEntity objectAtDestinationFolder = (MobileElementEntity)ObjectRepositoryController.getInstance().getWebElement(oldElementAbsolutePath);
            MobileElementEntity oldMobileElementEntity = objectAtDestinationFolder == null ? allConflictedElementEntites.stream().filter(entity -> {
                int newElementAHash = this.calculateHashValue(newMobileElement);
                int entityAHash = this.calculateHashValue(entity);
                return this.isTheSameHashValue(newElementAHash, entityAHash);
            }).findFirst().get() : objectAtDestinationFolder;
            CapturedMobileElementConverterV2 converter = new CapturedMobileElementConverterV2();
            switch (selectedConflictOption) {
                case CREATE_NEW_OBJECT: {
                    newMobileElement.setName(ObjectRepositoryController.getInstance().getAvailableWebElementName(conflictedFolderEntity, StringUtils.trim((String)newMobileElement.getName())));
                    MobileElementEntity importedMobileElement = converter.convert(newMobileElement, conflictedFolderEntity);
                    ObjectRepositoryController.getInstance().updateTestObject((WebElementEntity)importedMobileElement);
                    mobileElement.setScriptId(importedMobileElement.getIdForDisplay());
                    newTreeEntities.add((ITreeEntity)new WebElementTreeEntity((WebElementEntity)importedMobileElement, (ITreeEntity)selectedParentFolder));
                    break;
                }
                case REPLACE_EXISTING_OBJECT: {
                    oldMobileElementEntity.setWebElementProperties(converter.convertProperties(newMobileElement.getAttributes()));
                    oldMobileElementEntity.setLocator(newMobileElement.getLocator());
                    oldMobileElementEntity.setLocatorStrategy(newMobileElement.getLocatorStrategy());
                    oldMobileElementEntity.setName(newMobileElement.getName());
                    ObjectRepositoryController.getInstance().updateTestObject((WebElementEntity)oldMobileElementEntity);
                    mobileElement.setScriptId(oldMobileElementEntity.getIdForDisplay());
                    newTreeEntities.add((ITreeEntity)new WebElementTreeEntity((WebElementEntity)oldMobileElementEntity, (ITreeEntity)selectedParentFolder));
                    break;
                }
                case MERGE_CHANGE_TO_EXISTING_OBJECT: {
                    List mergedProperties = oldMobileElementEntity.getWebElementProperties();
                    int numOldWebElementProperties = oldMobileElementEntity.getWebElementProperties().size();
                    List<WebElementPropertyEntity> newProperties = converter.convertProperties(newMobileElement.getAttributes());
                    for (WebElementPropertyEntity newMobileElementProperty : newProperties) {
                        boolean newPropertyUsed = false;
                        int i = 0;
                        while (i < numOldWebElementProperties) {
                            if (newMobileElementProperty.getName().equals(((WebElementPropertyEntity)mergedProperties.get(i)).getName())) {
                                mergedProperties.set(i, newMobileElementProperty);
                                newPropertyUsed = true;
                                break;
                            }
                            ++i;
                        }
                        if (newPropertyUsed) continue;
                        mergedProperties.add(newMobileElementProperty);
                    }
                    oldMobileElementEntity.setWebElementProperties(mergedProperties);
                    oldMobileElementEntity.setLocator(newMobileElement.getLocator());
                    oldMobileElementEntity.setLocatorStrategy(newMobileElement.getLocatorStrategy());
                    ObjectRepositoryController.getInstance().updateTestObject((WebElementEntity)oldMobileElementEntity);
                    mobileElement.setScriptId(oldMobileElementEntity.getIdForDisplay());
                    newTreeEntities.add((ITreeEntity)new WebElementTreeEntity((WebElementEntity)oldMobileElementEntity, (ITreeEntity)selectedParentFolder));
                    break;
                }
            }
        }
    }

    public boolean isTheSameHashValue(int objHash, int targetHash) {
        if (objHash == -1 || targetHash == -1) {
            return false;
        }
        return objHash == targetHash;
    }
}

