/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.ai.component;

import com.kms.katalon.composer.ai.generation.dialogs.TestArtifactGenerationDialog;
import com.kms.katalon.composer.ai.provider.TestCaseAIGenerationLabelProvider;
import com.kms.katalon.composer.ai.provider.WebServiceAIGenerationContentProvider;
import com.kms.katalon.composer.components.impl.dialogs.TreeEntitySelectionNoFilterDialog;
import com.kms.katalon.composer.components.impl.providers.IEntityLabelProvider;
import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.tree.WebElementTreeEntity;
import com.kms.katalon.composer.components.impl.util.TreeEntityUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.components.util.ComponentUtil;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.repository.WebServiceRequestEntity;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.SystemUtils;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;

public class TestArtifactEndpointSelectionComponent
extends TreeEntitySelectionNoFilterDialog {
    private final int BUTTON_WIDTH = SystemUtils.IS_OS_WINDOWS ? 100 : 150;
    @Inject
    IEventBroker eventBroker;
    private List<Object> checkedItems;
    private ContainerCheckedTreeViewer endpointsTree;
    private Composite view;
    private Button btnGenerateTest;
    private Composite resultLineComposite;
    private StyledText resultLabel;
    private TestArtifactGenerationDialog dialog;

    @Inject
    public TestArtifactEndpointSelectionComponent() {
        super(Display.getCurrent().getActiveShell(), (IEntityLabelProvider)new TestCaseAIGenerationLabelProvider(){

            @Override
            protected String getText(ITreeEntity element) {
                return " " + super.getText(element);
            }
        }, (ITreeContentProvider)new WebServiceAIGenerationContentProvider());
        this.setAllowMultiple(false);
        this.setDoubleClickSelects(false);
        this.setMessage("Select endpoints to generate test cases:");
    }

    public void setDialog(TestArtifactGenerationDialog dialog) {
        this.dialog = dialog;
    }

    protected void computeResult() {
        ContainerCheckedTreeViewer treeViewer = (ContainerCheckedTreeViewer)this.getTreeViewer();
        List<Object> grayedItems = Arrays.asList(treeViewer.getGrayedElements());
        this.checkedItems.removeAll(grayedItems);
        this.setResult(this.checkedItems);
    }

    public void createSelectEndpointArea(Composite parent) {
        this.view = parent;
        Composite result = (Composite)ComponentBuilder.gridContainer((Composite)this.view).marginLeft(10).marginRight(10).fillHorizontal().build();
        this.createResultLine(result);
        super.createDialogArea((Composite)ComponentBuilder.fromGrid((Composite)this.view).fill().build());
        this.createButtons(this.view);
    }

    public TreeViewer createTreeViewer(Composite parent) {
        this.endpointsTree = (ContainerCheckedTreeViewer)super.createTreeViewer(parent);
        try {
            this.endpointsTree.getTree().addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    if (event.detail == 32) {
                        TreeItem item = (TreeItem)event.item;
                        TestArtifactEndpointSelectionComponent.this.endpointsTree.getTree().setSelection(item);
                        TestArtifactEndpointSelectionComponent.this.onStageChangedTreeItem(item, item.getChecked());
                        TestArtifactEndpointSelectionComponent.this.updateParentItems(item);
                        TestArtifactEndpointSelectionComponent.this.endpointsTree.refresh();
                    }
                }
            });
            this.endpointsTree.expandAll();
            this.endpointsTree.setCheckedElements(this.endpointsTree.getExpandedElements());
            this.checkedItems = new ArrayList<Object>(Arrays.asList(this.endpointsTree.getCheckedElements()).stream().filter(e -> e instanceof WebElementTreeEntity).toList());
        }
        catch (Exception e2) {
            LoggerSingleton.logError((Throwable)e2);
        }
        return this.endpointsTree;
    }

    protected TreeViewer doCreateTreeViewer(Composite parent, int style) {
        return new ContainerCheckedTreeViewer(new Tree(parent, 0x20 | style));
    }

    private void onStageChangedTreeItem(TreeItem item, boolean isChecked) {
        Object element = item.getData();
        if (element instanceof WebElementTreeEntity) {
            if (isChecked) {
                if (!this.checkedItems.contains(element)) {
                    this.checkedItems.add(element);
                }
            } else {
                this.checkedItems.remove(element);
            }
            if (this.checkedItems == null || this.checkedItems.isEmpty()) {
                this.btnGenerateTest.setEnabled(false);
            } else {
                this.btnGenerateTest.setEnabled(true);
            }
            return;
        }
        if (element instanceof FolderTreeEntity) {
            FolderTreeEntity folderElement = (FolderTreeEntity)element;
            try {
                TreeItem[] children;
                this.checkedItems.remove(element);
                TreeItem[] treeItemArray = children = item.getItems();
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem child = treeItemArray[n2];
                    this.onStageChangedTreeItem(child, isChecked);
                    ++n2;
                }
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e);
            }
        }
    }

    private void createButtons(Composite parent) {
        Composite cpButtons = (Composite)ComponentBuilder.gridContainer((Composite)parent, (int)2).background(ColorUtil.GRAY_COLOR).fillHorizontal().marginTop(10).marginBottom(20).marginRight(10).build();
        Composite cfr_ignored_0 = (Composite)ComponentBuilder.gridContainer((Composite)cpButtons, (int)2).fillHorizontal().bottom().left().build();
        Composite rightButtons = (Composite)ComponentBuilder.gridContainer((Composite)cpButtons, (int)2).fillHorizontal().bottom().right().build();
        ComponentBuilder.button((Composite)rightButtons).text("Cancel").width(ComponentUtil.applyZoom((int)this.BUTTON_WIDTH)).onClick(event -> this.dialog.cancelEndpointSelection()).build();
        this.btnGenerateTest = (Button)ComponentBuilder.button((Composite)rightButtons).text("Generate tests").width(ComponentUtil.applyZoom((int)this.BUTTON_WIDTH)).onClick(event -> this.dialog.generateTests()).defaultButton().build();
        this.dialog.getShell().setDefaultButton(this.btnGenerateTest);
    }

    private void createResultLine(Composite parent) {
        this.resultLineComposite = (Composite)ComponentBuilder.gridContainer((Composite)parent, (int)2).margin(5).fillHorizontal().background(ColorUtil.themeColor((Color)ColorUtil.getColor((String)"#E7F2EF"), (Color)ColorUtil.getColor((String)"#557F79"))).backgroundMode(2).build();
        ComponentBuilder.image((Composite)this.resultLineComposite, (String)(ColorUtil.isDarkTheme() ? "genai/complete_dark.png" : "genai/complete_light.png")).autoSize(24, 24).top().build();
        this.resultLabel = (StyledText)ComponentBuilder.styledText((Composite)this.resultLineComposite, (int)8).text("Imported Open API specification successfully.").verticalIndent(2).build();
        this.resultLabel.setEditable(false);
        this.resultLabel.setCaret(null);
        this.resultLabel.setWordWrap(true);
    }

    public void setAvailableEndpoints(List<WebServiceRequestEntity> entities) {
        this.setInput(this.convertListRequestToTreeView(entities));
    }

    public List<WebServiceRequestEntity> getSelectedEndpoints() {
        return this.convertObjectToWebServiceRequestEntity(this.checkedItems);
    }

    public void hide() {
        ComponentUtil.hide((Control)this.view);
    }

    public void show() {
        ComponentUtil.show((Control)this.view);
    }

    private ITreeEntity[] convertListRequestToTreeView(List<WebServiceRequestEntity> entities) {
        FolderTreeEntity folderTreeEntity = TreeEntityUtil.getFolderTreeEntity((FolderEntity)entities.get(0).getParentFolder());
        ArrayList<FolderTreeEntity> treeEntities = new ArrayList<FolderTreeEntity>();
        for (WebServiceRequestEntity entity : entities) {
            FolderTreeEntity parentTree = folderTreeEntity;
            if (entity.getParentFolder() == null || treeEntities.contains(parentTree = new FolderTreeEntity(entity.getParentFolder(), (ITreeEntity)folderTreeEntity))) continue;
            treeEntities.add(parentTree);
        }
        return treeEntities.toArray(new ITreeEntity[0]);
    }

    private List<WebServiceRequestEntity> convertObjectToWebServiceRequestEntity(List<Object> objects) {
        ArrayList<WebServiceRequestEntity> webService = new ArrayList<WebServiceRequestEntity>();
        for (Object entity : objects) {
            if (entity instanceof WebElementTreeEntity) {
                WebElementTreeEntity webTree = (WebElementTreeEntity)entity;
                try {
                    Object object = webTree.getObject();
                    if (object instanceof WebServiceRequestEntity) {
                        WebServiceRequestEntity ws = (WebServiceRequestEntity)object;
                        webService.add(ws);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (!(entity instanceof WebServiceRequestEntity)) continue;
            WebServiceRequestEntity ws = (WebServiceRequestEntity)entity;
            webService.add(ws);
        }
        return webService;
    }
}

