/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.ai.component;

import com.kms.katalon.ai.core.model.apigen.TestArtifactGenerationEndpoint;
import com.kms.katalon.ai.core.model.apigen.TestArtifactGenerationTestCase;
import com.kms.katalon.ai.core.services.IStudioAssistController;
import com.kms.katalon.composer.ai.generation.dialogs.TestArtifactGenerationDialog;
import com.kms.katalon.composer.ai.provider.TestCaseAIGenerationContentProvider;
import com.kms.katalon.composer.ai.provider.TestCaseAIGenerationLabelProvider;
import com.kms.katalon.composer.components.dialogs.CWizardDialog;
import com.kms.katalon.composer.components.dialogs.TestGenerationCancellationDialog;
import com.kms.katalon.composer.components.impl.dialogs.TreeEntitySelectionNoFilterDialog;
import com.kms.katalon.composer.components.impl.providers.IEntityLabelProvider;
import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.tree.TestCaseTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.components.util.ComponentUtil;
import com.kms.katalon.composer.components.wizard.RenameWizard;
import com.kms.katalon.composer.resources.image.ImageManager;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.setting.IStudioAssistAiAutoTagSetting;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.repository.WebServiceRequestEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.util.Util;
import com.kms.katalon.util.NameUtil;
import jakarta.inject.Inject;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;

public class TestArtifactTestCaseSelectionComponent
extends TreeEntitySelectionNoFilterDialog {
    private final int BUTTON_WIDTH = SystemUtils.IS_OS_WINDOWS ? 100 : 150;
    private List<Object> checkedItems;
    private ContainerCheckedTreeViewer endpointsTree;
    private Composite view;
    private Composite resultLineComposite;
    private StyledText resultLabel;
    private Canvas resultLineImage;
    private List<TestArtifactGenerationEndpoint> endpoints;
    private Map<String, WebServiceRequestEntity> availableEntities;
    private List<Object> renamedItems;
    private Button btnAdd;
    private static DateFormat dateFormat = new SimpleDateFormat("yyMMdd");
    private TestArtifactGenerationDialog dialog;
    private FolderEntity aiGeneratedFolder;
    @Inject
    private IStudioAssistController controller;

    public TestArtifactTestCaseSelectionComponent() {
        super(Display.getCurrent().getActiveShell(), (IEntityLabelProvider)new TestCaseAIGenerationLabelProvider(){

            @Override
            protected String getText(ITreeEntity element) {
                return " " + super.getText(element);
            }
        }, (ITreeContentProvider)new TestCaseAIGenerationContentProvider());
        this.setAllowMultiple(false);
        this.setDoubleClickSelects(false);
        this.aiGeneratedFolder = this.createAIGenFolder();
        this.setMessage(MessageFormat.format("Select test cases to add to folder {0} and review:", this.aiGeneratedFolder.getName()));
        this.renamedItems = new ArrayList<Object>();
    }

    public void setDialog(TestArtifactGenerationDialog dialog) {
        this.dialog = dialog;
    }

    protected void computeResult() {
        ContainerCheckedTreeViewer treeViewer = (ContainerCheckedTreeViewer)this.getTreeViewer();
        List<Object> grayedItems = Arrays.asList(treeViewer.getGrayedElements());
        this.checkedItems.removeAll(grayedItems);
        this.setResult(this.checkedItems);
    }

    public void createSelectTestCaseArea(Composite parent) {
        this.view = parent;
        Composite result = (Composite)ComponentBuilder.gridContainer((Composite)this.view).marginLeft(10).marginRight(10).fillHorizontal().build();
        this.createResultLine(result);
        super.createDialogArea((Composite)ComponentBuilder.fromGrid((Composite)this.view).fill().build());
        this.createButtons(this.view);
    }

    public TreeViewer createTreeViewer(Composite parent) {
        this.endpointsTree = (ContainerCheckedTreeViewer)super.createTreeViewer(parent);
        try {
            this.endpointsTree.getTree().addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    if (event.detail == 32) {
                        TreeItem item = (TreeItem)event.item;
                        TestArtifactTestCaseSelectionComponent.this.endpointsTree.getTree().setSelection(item);
                        TestArtifactTestCaseSelectionComponent.this.onStageChangedTreeItem(item, item.getChecked());
                        TestArtifactTestCaseSelectionComponent.this.updateParentItems(item);
                        TestArtifactTestCaseSelectionComponent.this.endpointsTree.refresh();
                    }
                }
            });
            this.endpointsTree.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    TreeSelection selection = (TreeSelection)event.getSelection();
                    Object element = selection.getFirstElement();
                    if (element instanceof TestCaseTreeEntity) {
                        TestCaseTreeEntity treeEntity = (TestCaseTreeEntity)element;
                        try {
                            TestCaseEntity entity = treeEntity.getObject();
                            List existingNames = entity.getParentFolder().getChildrenEntities().stream().map(FileEntity::getLocation).collect(Collectors.toList());
                            RenameWizard renameWizard = new RenameWizard((ITreeEntity)treeEntity, existingNames);
                            CWizardDialog wizardDialog = new CWizardDialog(TestArtifactTestCaseSelectionComponent.this.getShell(), (IWizard)renameWizard);
                            if (wizardDialog.open() == 0) {
                                String oldName = entity.getName();
                                String newNameValue = renameWizard.getNewNameValue();
                                if (!StringUtils.equals((CharSequence)newNameValue, (CharSequence)oldName)) {
                                    entity.setName(newNameValue);
                                }
                                TestArtifactTestCaseSelectionComponent.this.getLabelProvider().resetData();
                                TestArtifactTestCaseSelectionComponent.this.endpointsTree.update((Object)treeEntity, null);
                                TestArtifactTestCaseSelectionComponent.this.endpointsTree.refresh();
                                if (!TestArtifactTestCaseSelectionComponent.this.resultLineComposite.isDisposed() || TestArtifactTestCaseSelectionComponent.this.resultLineComposite.isVisible()) {
                                    TestArtifactTestCaseSelectionComponent.this.handleResultLine();
                                }
                                TestArtifactTestCaseSelectionComponent.this.btnAdd.setEnabled(true);
                                for (Object checkedItem : TestArtifactTestCaseSelectionComponent.this.checkedItems) {
                                    TestCaseTreeEntity file;
                                    if (!(checkedItem instanceof TestCaseTreeEntity) || NameUtil.isValidName((String)(file = (TestCaseTreeEntity)checkedItem).getText(), (boolean)false) && TestArtifactTestCaseSelectionComponent.this.isValidNameLength(file)) continue;
                                    TestArtifactTestCaseSelectionComponent.this.btnAdd.setEnabled(false);
                                }
                                TestArtifactTestCaseSelectionComponent.this.renamedItems.add(element);
                            }
                        }
                        catch (Exception e) {
                            LoggerSingleton.logError((Throwable)e);
                        }
                    }
                }
            });
            this.endpointsTree.expandAll();
            this.endpointsTree.setCheckedElements(this.endpointsTree.getExpandedElements());
            this.checkedItems = new ArrayList<Object>(Arrays.asList(this.endpointsTree.getCheckedElements()).stream().filter(e -> e instanceof TestCaseTreeEntity).toList());
        }
        catch (Exception e2) {
            LoggerSingleton.logError((Throwable)e2);
        }
        return this.endpointsTree;
    }

    private void onStageChangedTreeItem(TreeItem item, boolean isChecked) {
        block12: {
            try {
                Object element = item.getData();
                if (element instanceof TestCaseTreeEntity) {
                    TestCaseTreeEntity tcEntity = (TestCaseTreeEntity)element;
                    if (isChecked) {
                        if (!this.checkedItems.contains(element)) {
                            this.checkedItems.add(element);
                        }
                    } else {
                        this.checkedItems.remove(element);
                    }
                    if (this.checkedItems == null || this.checkedItems.isEmpty()) {
                        this.btnAdd.setEnabled(false);
                        return;
                    }
                    this.btnAdd.setEnabled(true);
                    for (Object checkedItem : this.checkedItems) {
                        TestCaseTreeEntity file;
                        if (!(checkedItem instanceof TestCaseTreeEntity) || NameUtil.isValidName((String)(file = (TestCaseTreeEntity)checkedItem).getText(), (boolean)false) && this.isValidNameLength(file)) continue;
                        this.btnAdd.setEnabled(false);
                    }
                    return;
                }
                if (!(element instanceof FolderTreeEntity)) break block12;
                FolderTreeEntity folderElement = (FolderTreeEntity)element;
                try {
                    TreeItem[] children;
                    this.checkedItems.remove(element);
                    TreeItem[] treeItemArray = children = item.getItems();
                    int n = children.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TreeItem child = treeItemArray[n2];
                        this.onStageChangedTreeItem(child, isChecked);
                        ++n2;
                    }
                    for (Object checkedItem : this.checkedItems) {
                        TestCaseTreeEntity file;
                        if (!(checkedItem instanceof TestCaseTreeEntity) || this.isValidNameLength(file = (TestCaseTreeEntity)checkedItem)) continue;
                        this.btnAdd.setEnabled(false);
                        break;
                    }
                }
                catch (Exception e) {
                    LoggerSingleton.logError((Throwable)e);
                }
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e);
            }
        }
    }

    protected TreeViewer doCreateTreeViewer(Composite parent, int style) {
        return new ContainerCheckedTreeViewer(new Tree(parent, 0x20 | style));
    }

    private TestCaseAIGenerationLabelProvider getLabelProvider() {
        return (TestCaseAIGenerationLabelProvider)this.endpointsTree.getLabelProvider();
    }

    private void createButtons(Composite parent) {
        Composite cpButtons = (Composite)ComponentBuilder.gridContainer((Composite)parent, (int)2).background(ColorUtil.GRAY_COLOR).fillHorizontal().marginTop(10).marginBottom(20).marginRight(10).marginLeft(10).build();
        Composite cfr_ignored_0 = (Composite)ComponentBuilder.gridContainer((Composite)cpButtons, (int)2).fillHorizontal().bottom().left().build();
        Composite rightButtons = (Composite)ComponentBuilder.gridContainer((Composite)cpButtons, (int)2).fillHorizontal().bottom().right().build();
        ComponentBuilder.button((Composite)rightButtons).text("Cancel").width(ComponentUtil.applyZoom((int)this.BUTTON_WIDTH)).onClick(event -> {
            int result = this.confirmClosing();
            if (result == 1) {
                this.dialog.cancelTestCaseSelection();
            }
        }).build();
        this.btnAdd = (Button)ComponentBuilder.button((Composite)rightButtons).text("Add").width(ComponentUtil.applyZoom((int)this.BUTTON_WIDTH)).onClick(event -> this.dialog.saveTestCases()).defaultButton().build();
        this.dialog.getShell().setDefaultButton(this.btnAdd);
    }

    private void createResultLine(Composite parent) {
        this.resultLineComposite = (Composite)ComponentBuilder.gridContainer((Composite)parent, (int)2).margin(5).fillHorizontal().background(ColorUtil.themeColor((Color)ColorUtil.WARNING_BACKGROUND_LIGHT_COLOR, (Color)ColorUtil.getColor((String)"#817542"))).backgroundMode(2).build();
        this.resultLineImage = (Canvas)ComponentBuilder.image((Composite)this.resultLineComposite, (String)"dialog/warning_20.png").autoSize(24, 24).top().build();
        this.resultLabel = (StyledText)ComponentBuilder.styledText((Composite)this.resultLineComposite, (int)8).text("Successfully generated {0} test cases using AI").fillHorizontal().verticalIndent(2).bottom().build();
    }

    private void updateTree(List<TestArtifactGenerationEndpoint> endpoints) {
        this.getLabelProvider().resetData();
        this.endpointsTree.setInput((Object)this.generateInput(endpoints));
        this.endpointsTree.expandAll();
        this.endpointsTree.setAllChecked(true);
        this.handleResultLine();
        this.endpointsTree.refresh();
        this.checkedItems = new ArrayList<Object>(Arrays.asList(this.endpointsTree.getCheckedElements()).stream().filter(e -> e instanceof TestCaseTreeEntity).toList());
    }

    private void handleResultLine() {
        int size = this.getLabelProvider().getLongNameSet().size();
        if (size > 0) {
            this.resultLineComposite.setBackground(ColorUtil.themeColor((Color)ColorUtil.WARNING_BACKGROUND_LIGHT_COLOR, (Color)ColorUtil.getColor((String)"#817542")));
            this.resultLineImage.setBackgroundImage(ImageManager.getImage((String)"dialog/warning_20.png"));
            String msg = MessageFormat.format("Test cases successfully generated. {0} test case names exceed maximum length or have invalid format. \n Double-click to rename highlighted test cases.", size);
            this.resultLabel.setText(msg);
            this.resultLabel.setBackground(ColorUtil.themeColor((Color)ColorUtil.WARNING_BACKGROUND_LIGHT_COLOR, (Color)ColorUtil.getColor((String)"#817542")));
            ComponentUtil.setVerticalIndent((Control)this.resultLabel, (int)0);
        } else {
            this.resultLineComposite.setBackground(ColorUtil.themeColor((Color)ColorUtil.getColor((String)"#E7F2EF"), (Color)ColorUtil.getColor((String)"#557F79")));
            this.resultLineImage.setBackgroundImage(ImageManager.getImage((String)(ColorUtil.isDarkTheme() ? "genai/complete_dark.png" : "genai/complete_light.png")));
            this.resultLabel.setText(MessageFormat.format("Successfully generated {0} test cases using AI", this.numberOfGeneratedTestCase()));
            this.resultLabel.setBackground(ColorUtil.themeColor((Color)ColorUtil.getColor((String)"#E7F2EF"), (Color)ColorUtil.getColor((String)"#557F79")));
            ComponentUtil.setVerticalIndent((Control)this.resultLabel, (int)2);
        }
    }

    private int numberOfGeneratedTestCase() {
        int total = 0;
        for (TestArtifactGenerationEndpoint ep : this.endpoints) {
            total += ep.getTestCases().size();
        }
        return total;
    }

    private ITreeEntity[] generateInput(List<TestArtifactGenerationEndpoint> endpoints) {
        boolean isEnable = true;
        ArrayList<FolderTreeEntity> treeEntities = new ArrayList<FolderTreeEntity>();
        IStudioAssistAiAutoTagSetting aiAutoTaggingSetting = this.controller.getStudioAssistAiAutoTagSetting();
        boolean apiGenerationEnabled = aiAutoTaggingSetting.isApiTestCaseGeneration();
        String customTag = aiAutoTaggingSetting.getApiTestCustomTag();
        try {
            for (TestArtifactGenerationEndpoint ep : endpoints) {
                String folderName = ep.getMethod() + " " + ep.getPath();
                WebServiceRequestEntity entity = this.availableEntities.get(folderName);
                FolderEntity testCaseFolder = this.getParentFolder(this.aiGeneratedFolder, ep.getId());
                testCaseFolder.setName(entity.getName());
                testCaseFolder.setFolderType(FolderEntity.FolderType.GENAI);
                ArrayList<TestCaseEntity> tcEntityList = new ArrayList<TestCaseEntity>();
                for (TestArtifactGenerationTestCase tc : ep.getTestCases()) {
                    TestCaseEntity testCaseEntity = new TestCaseEntity();
                    testCaseEntity.setName(FilenameUtils.getBaseName((String)tc.getName()));
                    testCaseEntity.setTestCaseGuid(Util.generateGuid());
                    if (apiGenerationEnabled) {
                        boolean apiGenerationDefaultTag = aiAutoTaggingSetting.isApiTestCaseDefaultTag();
                        String tag = apiGenerationDefaultTag ? "API_Test_Generation" : customTag;
                        testCaseEntity.updateTagForTestCase(tag);
                    }
                    testCaseEntity.setProject(this.aiGeneratedFolder.getProject());
                    testCaseEntity.setParentFolder(testCaseFolder);
                    testCaseEntity.setScriptContents(tc.getScript().getBytes());
                    tcEntityList.add(testCaseEntity);
                    if (NameUtil.isValidName((String)testCaseEntity.getName(), (boolean)false) && testCaseEntity.getLocation().length() < 255) continue;
                    isEnable = false;
                }
                testCaseFolder.setChildrenEntities(tcEntityList);
                FolderTreeEntity testCaseFolderTreeEntity = new FolderTreeEntity(testCaseFolder, null);
                treeEntities.add(testCaseFolderTreeEntity);
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
        this.btnAdd.setEnabled(isEnable);
        return (ITreeEntity[])treeEntities.toArray(ITreeEntity[]::new);
    }

    private FolderEntity getParentFolder(FolderEntity parentFolder, String endpointName) {
        for (FileEntity folder : parentFolder.getChildrenEntities()) {
            if (!folder.getName().equals(endpointName)) continue;
            return (FolderEntity)folder;
        }
        return parentFolder;
    }

    private List<TestCaseEntity> convertObjectToTestCaseEntity(List<Object> objects) {
        ArrayList<TestCaseEntity> testCases = new ArrayList<TestCaseEntity>();
        for (Object entity : objects) {
            if (entity instanceof TestCaseTreeEntity) {
                TestCaseTreeEntity webTree = (TestCaseTreeEntity)entity;
                try {
                    TestCaseEntity object = webTree.getObject();
                    if (object instanceof TestCaseEntity) {
                        TestCaseEntity ws = object;
                        ws.getParentFolder().setChildrenEntities(new ArrayList());
                        testCases.add(ws);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (!(entity instanceof TestCaseEntity)) continue;
            TestCaseEntity ws = (TestCaseEntity)entity;
            ws.getParentFolder().setChildrenEntities(new ArrayList());
            testCases.add(ws);
        }
        return testCases;
    }

    private FolderEntity createAIGenFolder() {
        try {
            ProjectEntity currentProj = ProjectController.getInstance().getCurrentProject();
            FolderEntity testCaseRootFolder = FolderController.getInstance().getTestCaseRoot(currentProj);
            String name = MessageFormat.format("AI-Generated - {0}", dateFormat.format(new Date()));
            FolderEntity AIGenFolder = new FolderEntity();
            AIGenFolder.setParentFolder(testCaseRootFolder);
            AIGenFolder.setDescription("folder");
            AIGenFolder.setFolderType(testCaseRootFolder.getFolderType());
            AIGenFolder.setProject(testCaseRootFolder.getProject());
            AIGenFolder.setName(FolderController.getInstance().getAvailableFolderName(testCaseRootFolder, name));
            AIGenFolder.setTag("API_Test_Generation");
            return AIGenFolder;
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            return null;
        }
    }

    private void createSubAIGenFolderBasedOnEndpoint() {
        try {
            ArrayList<FolderEntity> childrenFolders = new ArrayList<FolderEntity>();
            for (TestArtifactGenerationEndpoint endpoint : this.endpoints) {
                FolderEntity folder = new FolderEntity();
                folder.setName(endpoint.getId());
                folder.setParentFolder(this.aiGeneratedFolder);
                folder.setDescription("folder");
                folder.setFolderType(this.aiGeneratedFolder.getFolderType());
                folder.setProject(this.aiGeneratedFolder.getProject());
                folder.setTag("API_Test_Generation");
                childrenFolders.add(folder);
            }
            this.aiGeneratedFolder.setChildrenEntities(childrenFolders);
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private boolean isValidNameLength(TestCaseTreeEntity tcTreeEntity) {
        try {
            TestCaseEntity entity = tcTreeEntity.getObject();
            System.out.println(entity.getLocation());
            return StringUtils.length((CharSequence)entity.getLocation()) < 255;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void setAvailableEndpoints(List<TestArtifactGenerationEndpoint> endpoints, List<WebServiceRequestEntity> entities) {
        this.endpoints = endpoints;
        this.availableEntities = new HashMap<String, WebServiceRequestEntity>();
        entities.forEach(e -> {
            String id = MessageFormat.format("{0} {1}", e.getRestRequestMethod(), e.getPath());
            this.availableEntities.put(id, (WebServiceRequestEntity)e);
        });
        this.createSubAIGenFolderBasedOnEndpoint();
        this.updateTree(endpoints);
    }

    public List<TestCaseEntity> getSelectedTestCases() {
        return this.convertObjectToTestCaseEntity(this.checkedItems);
    }

    public List<Object> getRenamedSelectTestCases() {
        return this.renamedItems;
    }

    public FolderEntity getAIGeneratedFolder() {
        return this.aiGeneratedFolder;
    }

    public void hide() {
        ComponentUtil.hide((Control)this.view);
    }

    public void show() {
        ComponentUtil.show((Control)this.view);
    }

    public void dispose() {
        this.view.dispose();
    }

    public int confirmClosing() {
        return new TestGenerationCancellationDialog("All currently generated test cases will be lost. Are you sure you want to cancel?", "Resume process").open();
    }
}

