/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.ai.studioassist.dialog;

import com.kms.katalon.composer.components.impl.overlay.OverlayShell;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class ImagePreviewOverlayShell
extends OverlayShell {
    private static final int PADDING = 4;
    private static final int CLOSE_BUTTON_SIZE = 40;
    private static final int CLOSE_BUTTON_OFFSET = 40;
    private static final int CONTENT_MAX_WIDTH = 800;
    private static final int CONTENT_MAX_HEIGHT = 600;
    private Composite contentComposite;
    private Composite closeButtonContainer;
    private Canvas closeButton;
    private Canvas imageCanvas;
    private Image previewImage;
    private Color backgroundColor;
    private Color closeButtonBgColor;
    private Color closeButtonHoverColor;
    private Color textColor;
    private Listener escapeKeyFilter;

    public ImagePreviewOverlayShell(Control target) {
        this(target, 0);
    }

    public ImagePreviewOverlayShell(Display display) {
        this(ImagePreviewOverlayShell.getActiveShellOrDefault(display), 0);
    }

    public ImagePreviewOverlayShell(Control target, int style) {
        super(target, style);
        this.initializeColors();
        this.createContents();
        this.setAlpha(245);
    }

    private static Control getActiveShellOrDefault(Display display) {
        Shell activeShell = display.getActiveShell();
        if (activeShell != null && !activeShell.isDisposed()) {
            return activeShell;
        }
        Shell[] shells = display.getShells();
        if (shells != null) {
            Shell[] shellArray = shells;
            int n = shells.length;
            int n2 = 0;
            while (n2 < n) {
                Shell shell = shellArray[n2];
                if (!shell.isDisposed() && shell.isVisible()) {
                    return shell;
                }
                ++n2;
            }
        }
        throw new IllegalStateException("No active shell available for overlay");
    }

    private void initializeColors() {
        Display display = this.getDisplay();
        this.backgroundColor = new Color((Device)display, 255, 255, 255);
        this.closeButtonBgColor = new Color((Device)display, 255, 255, 255, 0);
        this.closeButtonHoverColor = new Color((Device)display, 255, 255, 255, 0);
        this.textColor = new Color((Device)display, 0, 0, 0);
    }

    private void createContents() {
        this.setBackground(new Color((Device)this.getDisplay(), 0, 0, 0, 180));
        this.contentComposite = new Composite((Composite)this, 0);
        this.contentComposite.setBackground(this.backgroundColor);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 4;
        layout.marginHeight = 4;
        layout.verticalSpacing = 15;
        this.contentComposite.setLayout((Layout)layout);
        this.imageCanvas = new Canvas(this.contentComposite, 2048);
        this.imageCanvas.setBackground(this.backgroundColor);
        GridData imageData = new GridData(0x1000000, 0x1000000, true, true);
        this.imageCanvas.setLayoutData((Object)imageData);
        this.imageCanvas.addPaintListener(e -> {
            if (this.previewImage != null && !this.previewImage.isDisposed()) {
                Rectangle bounds = this.imageCanvas.getBounds();
                Rectangle imageBounds = this.previewImage.getBounds();
                double scaleX = (double)bounds.width / (double)imageBounds.width;
                double scaleY = (double)bounds.height / (double)imageBounds.height;
                double scale = Math.min(scaleX, scaleY);
                int scaledWidth = (int)((double)imageBounds.width * scale);
                int scaledHeight = (int)((double)imageBounds.height * scale);
                int x = (bounds.width - scaledWidth) / 2;
                int y = (bounds.height - scaledHeight) / 2;
                e.gc.drawImage(this.previewImage, 0, 0, imageBounds.width, imageBounds.height, x, y, scaledWidth, scaledHeight);
            }
        });
        this.createCloseButton();
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                Rectangle closeBounds;
                Point point = new Point(e.x, e.y);
                Rectangle contentBounds = ImagePreviewOverlayShell.this.contentComposite.getBounds();
                Rectangle rectangle = closeBounds = ImagePreviewOverlayShell.this.closeButtonContainer != null ? ImagePreviewOverlayShell.this.closeButtonContainer.getBounds() : new Rectangle(0, 0, 0, 0);
                if (!contentBounds.contains(point) && !closeBounds.contains(point)) {
                    ImagePreviewOverlayShell.this.close();
                }
            }
        });
    }

    private void createCloseButton() {
        this.closeButtonContainer = new Composite((Composite)this, 262144);
        this.closeButton = new Canvas(this.closeButtonContainer, 262144);
        this.closeButton.setBounds(0, 0, 40, 40);
        this.closeButton.addPaintListener(e -> {
            GC gc = e.gc;
            gc.setAntialias(1);
            gc.setForeground(new Color((Device)this.getDisplay(), 255, 255, 255));
            gc.setBackground(this.getDisplay().getSystemColor(262144));
            gc.setLineWidth(3);
            int padding = 12;
            gc.drawLine(padding, padding, 40 - padding, 40 - padding);
            gc.drawLine(40 - padding, padding, padding, 40 - padding);
        });
        this.closeButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                ImagePreviewOverlayShell.this.close();
            }
        });
        this.closeButton.setCursor(this.getDisplay().getSystemCursor(21));
    }

    public void setPreviewContent(Image image) {
        this.previewImage = image;
        if (this.imageCanvas != null && !this.imageCanvas.isDisposed() && image != null) {
            Rectangle imageBounds = image.getBounds();
            int width = Math.min(imageBounds.width, 800);
            int height = Math.min(imageBounds.height, 600);
            GridData imageData = (GridData)this.imageCanvas.getLayoutData();
            imageData.widthHint = width;
            imageData.heightHint = height;
        }
        if (this.contentComposite != null && !this.contentComposite.isDisposed()) {
            this.contentComposite.layout(true, true);
        }
    }

    protected void reposition() {
        super.reposition();
        if (this.contentComposite != null && !this.contentComposite.isDisposed()) {
            Rectangle bounds = this.getBounds();
            Point preferredSize = this.contentComposite.computeSize(-1, -1);
            int x = (bounds.width - preferredSize.x) / 2;
            int y = (bounds.height - preferredSize.y) / 2;
            this.contentComposite.setBounds(x, y, preferredSize.x, preferredSize.y);
            if (this.closeButtonContainer != null && !this.closeButtonContainer.isDisposed()) {
                int closeX = x + preferredSize.x - 40 + 40;
                int closeY = y - 20;
                this.closeButtonContainer.setBounds(closeX, closeY, 40, 40);
                this.closeButtonContainer.moveAbove((Control)this.contentComposite);
            }
        }
    }

    public void dispose() {
        if (this.escapeKeyFilter != null && !this.getDisplay().isDisposed()) {
            this.getDisplay().removeFilter(1, this.escapeKeyFilter);
            this.escapeKeyFilter = null;
        }
        if (this.backgroundColor != null && !this.backgroundColor.isDisposed()) {
            this.backgroundColor.dispose();
        }
        if (this.closeButtonBgColor != null && !this.closeButtonBgColor.isDisposed()) {
            this.closeButtonBgColor.dispose();
        }
        if (this.closeButtonHoverColor != null && !this.closeButtonHoverColor.isDisposed()) {
            this.closeButtonHoverColor.dispose();
        }
        if (this.textColor != null && !this.textColor.isDisposed()) {
            this.textColor.dispose();
        }
        if (this.previewImage != null && !this.previewImage.isDisposed()) {
            this.previewImage.dispose();
        }
        super.dispose();
    }

    public void open() {
        super.open();
        this.reposition();
        this.escapeKeyFilter = event -> {
            if (event.keyCode == 27 && this.isShowing()) {
                this.close();
                event.doit = false;
            }
        };
        this.getDisplay().addFilter(1, this.escapeKeyFilter);
    }
}

