/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.ai.studioassist.preference;

import com.kms.katalon.ai.core.model.config.GeminiConfig;
import com.kms.katalon.ai.core.model.config.LlmConfigType;
import com.kms.katalon.ai.core.model.config.StudioAssistConfig;
import com.kms.katalon.ai.core.model.exception.StudioAssistLoadingConfigException;
import com.kms.katalon.ai.core.model.exception.StudioAssistSavingConfigException;
import com.kms.katalon.composer.ai.studioassist.preference.StudioAssistConfigComponent;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.session.core.model.AiConfigPolicy;
import com.kms.katalon.session.core.model.ManagedGeminiConfig;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class ManagedGeminiPage
extends StudioAssistConfigComponent {
    private Text geminiModel;
    private Text geminiMaxToken;
    private final String BASE_URL = "Base URL";
    private final String API_KEY = "API key";
    private final String MODEL = "Model";
    private final String MAX_TOKEN = "Max completion token";

    public ManagedGeminiPage(Composite parent, AiConfigPolicy aiConfigPolicy) {
        super(parent, aiConfigPolicy);
    }

    @Override
    protected Composite createContent(Composite parent) {
        Composite container = (Composite)ComponentBuilder.gridContainer((Composite)parent, (int)2, (int)0).build();
        ComponentBuilder.label((Composite)container).text("Gemini").bold().build();
        ComponentBuilder.label((Composite)container).text("- managed by your organization").build();
        Composite component = (Composite)ComponentBuilder.group((Composite)parent).gridLayout(2).fillHorizontal().build();
        ComponentBuilder.label((Composite)component).text("Base URL*").build();
        ComponentBuilder.text((Composite)component).text(((ManagedGeminiConfig)this.aiConfigPolicy.getManagedGeminiAiConfig().get()).getBaseUrl()).disable().build();
        ComponentBuilder.label((Composite)component).text("API key*").build();
        ComponentBuilder.text((Composite)component).text(((ManagedGeminiConfig)this.aiConfigPolicy.getManagedGeminiAiConfig().get()).getApiKey()).maskPassword().disable().build();
        ComponentBuilder.label((Composite)component).text("Model*").build();
        this.geminiModel = (Text)ComponentBuilder.text((Composite)component).fill().onChange(event -> {
            boolean bl = this.validateNotBlank("Model", this.geminiModel.getText(), true);
        }).build();
        ComponentBuilder.label((Composite)component).text("Max completion token*").build();
        this.geminiMaxToken = (Text)ComponentBuilder.text((Composite)component).fill().onChange(event -> this.validateMaxToken("Max completion token", this.geminiMaxToken.getText(), true)).build();
        return component;
    }

    @Override
    protected void onSwitchOption(LlmConfigType type) {
    }

    @Override
    protected void loadConfig() throws StudioAssistLoadingConfigException {
        try {
            StudioAssistConfig config = this.controller.getConfig();
            boolean usingGemini = config instanceof GeminiConfig;
            if (usingGemini) {
                GeminiConfig geminiConfig = (GeminiConfig)config;
                this.geminiModel.setText(geminiConfig.getModel());
                this.geminiMaxToken.setText(Integer.toString(geminiConfig.getMaxToken()));
            } else {
                this.geminiModel.setText("gemini-2.5-flash");
                this.geminiMaxToken.setText(Integer.toString(16000));
            }
            this.displayContent(usingGemini);
        }
        catch (StudioAssistLoadingConfigException e) {
            LoggerSingleton.logError((String)"Failed to load config in ManagedGeminiAiPage");
            LoggerSingleton.logError((Throwable)e);
        }
    }

    @Override
    public void saveConfig() throws StudioAssistSavingConfigException {
        try {
            GeminiConfig geminiConfig = new GeminiConfig();
            geminiConfig.setModel(this.geminiModel.getText().trim());
            geminiConfig.setMaxToken(Integer.valueOf(this.geminiMaxToken.getText().trim()).intValue());
            this.controller.saveConfig((StudioAssistConfig)geminiConfig);
        }
        catch (StudioAssistSavingConfigException e) {
            LoggerSingleton.logError((String)"Failed to save config in ManagedGeminiAiPage");
            LoggerSingleton.logError((Throwable)e);
        }
    }

    @Override
    public void resetConfig() {
        this.geminiModel.setText("gemini-2.5-flash");
        this.geminiMaxToken.setText(Integer.toString(16000));
    }

    @Override
    protected void initValidationList() {
        this.validationList.put("Max completion token", false);
        this.validationList.put("Model", false);
    }
}

