/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.ai.studioassist.preference;

import com.kms.katalon.ai.core.model.config.LlmConfigType;
import com.kms.katalon.ai.core.model.config.OpenAiCompatibleConfig;
import com.kms.katalon.ai.core.model.config.StudioAssistConfig;
import com.kms.katalon.ai.core.model.exception.StudioAssistLoadingConfigException;
import com.kms.katalon.ai.core.model.exception.StudioAssistSavingConfigException;
import com.kms.katalon.composer.ai.studioassist.preference.StudioAssistConfigComponent;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.session.core.model.AiConfigPolicy;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class OpenAiCompatibleConfigComponent
extends StudioAssistConfigComponent {
    private Text openAiCompatibleBaseUrl;
    private Text openAiCompatibleApiKeyHeaderName;
    private Text openAiCompatibleApiKey;
    private Text openAiCompatibleModel;
    private Text openAiCompatibleMaxToken;
    private final String BASE_URL = "Base URL";
    private final String API_KEY = "API key";
    private final String API_KEY_HEADER_NAME = "API key header name";
    private final String MODEL = "Model";
    private final String MAX_TOKEN = "Max completion token";

    public OpenAiCompatibleConfigComponent(Composite parent, AiConfigPolicy aiConfigPolicy) {
        super(parent, aiConfigPolicy);
    }

    @Override
    protected Composite createContent(Composite parent) {
        Composite outerComponent = (Composite)ComponentBuilder.gridContainer((Composite)parent, (int)1, (int)0).fillHorizontal().build();
        Composite component = (Composite)ComponentBuilder.group((Composite)outerComponent).gridLayout(2).fillHorizontal().build();
        ComponentBuilder.label((Composite)component).text("Base URL*").build();
        this.openAiCompatibleBaseUrl = (Text)ComponentBuilder.text((Composite)component).fill().onChange(event -> {
            boolean bl = this.validateNotBlank("Base URL", this.openAiCompatibleBaseUrl.getText(), true);
        }).build();
        ComponentBuilder.label((Composite)component).text("API key").build();
        this.openAiCompatibleApiKey = (Text)ComponentBuilder.text((Composite)component).maskPassword().fill().build();
        ComponentBuilder.label((Composite)component).text("API key header name").build();
        this.openAiCompatibleApiKeyHeaderName = (Text)ComponentBuilder.text((Composite)component).placeholder("Authorization").fill().build();
        ComponentBuilder.label((Composite)component).text("Model").build();
        this.openAiCompatibleModel = (Text)ComponentBuilder.text((Composite)component).placeholder("gpt-4.1-mini").fill().build();
        ComponentBuilder.label((Composite)component).text("Max completion token*").build();
        this.openAiCompatibleMaxToken = (Text)ComponentBuilder.text((Composite)component).fill().onChange(event -> this.validateMaxToken("Max completion token", this.openAiCompatibleMaxToken.getText(), true)).build();
        this.content = outerComponent;
        return outerComponent;
    }

    @Override
    protected void onSwitchOption(LlmConfigType type) {
        boolean hasChosenOpenAiCompatible = type == LlmConfigType.OPENAI_COMPATIBLE;
        this.displayContent(hasChosenOpenAiCompatible);
        if (hasChosenOpenAiCompatible) {
            this.resetMessage(hasChosenOpenAiCompatible);
        }
    }

    @Override
    protected void loadConfig() throws StudioAssistLoadingConfigException {
        StudioAssistConfig config = this.controller.getConfig();
        boolean usingOpenAiCompatible = config instanceof OpenAiCompatibleConfig;
        if (usingOpenAiCompatible) {
            OpenAiCompatibleConfig openAiCompatibleConfig = (OpenAiCompatibleConfig)config;
            this.openAiCompatibleBaseUrl.setText(openAiCompatibleConfig.getBaseUrl());
            this.openAiCompatibleApiKey.setText(openAiCompatibleConfig.getApiKey());
            this.openAiCompatibleApiKeyHeaderName.setText(openAiCompatibleConfig.getApiKeyHeaderName());
            String model = (String)StringUtils.defaultIfBlank((CharSequence)openAiCompatibleConfig.getModelName(), (CharSequence)"gpt-4.1-mini");
            this.openAiCompatibleModel.setText(model);
            this.openAiCompatibleMaxToken.setText(Long.toString(openAiCompatibleConfig.getMaxToken()));
        } else {
            this.openAiCompatibleApiKeyHeaderName.setText("Authorization");
            this.openAiCompatibleModel.setText("gpt-4.1-mini");
            this.openAiCompatibleMaxToken.setText(Integer.toString(16000));
        }
        this.displayContent(usingOpenAiCompatible);
    }

    @Override
    public void saveConfig() throws StudioAssistSavingConfigException {
        OpenAiCompatibleConfig openAiCompatibleConfig = new OpenAiCompatibleConfig();
        openAiCompatibleConfig.setBaseUrl(this.openAiCompatibleBaseUrl.getText());
        openAiCompatibleConfig.setApiKey(this.openAiCompatibleApiKey.getText());
        openAiCompatibleConfig.setApiKeyHeaderName(this.openAiCompatibleApiKeyHeaderName.getText());
        openAiCompatibleConfig.setModelName(this.openAiCompatibleModel.getText());
        openAiCompatibleConfig.setMaxToken(Integer.valueOf(this.openAiCompatibleMaxToken.getText()).intValue());
        this.controller.saveConfig((StudioAssistConfig)openAiCompatibleConfig);
    }

    @Override
    public void resetConfig() {
        this.openAiCompatibleBaseUrl.setText("");
        this.openAiCompatibleApiKey.setText("");
        this.openAiCompatibleApiKeyHeaderName.setText("Authorization");
        this.openAiCompatibleModel.setText("gpt-4.1-mini");
        this.openAiCompatibleMaxToken.setText(String.valueOf(16000));
        this.displayContent(false);
    }

    @Override
    protected void initValidationList() {
        this.validationList.put("Base URL", false);
        this.validationList.put("Max completion token", false);
    }
}

