/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.ai.studioassist.preference;

import com.kms.katalon.ai.core.model.exception.StudioAssistLoadingConfigException;
import com.kms.katalon.ai.core.model.exception.StudioAssistSavingConfigException;
import com.kms.katalon.ai.core.services.IStudioAssistController;
import com.kms.katalon.composer.ai.constants.ComposerStudioAssistConstants;
import com.kms.katalon.composer.ai.studioassist.preference.AdminManagedAiAutoTagComponent;
import com.kms.katalon.composer.ai.studioassist.preference.AiAutoTagComponent;
import com.kms.katalon.composer.ai.studioassist.preference.AutoTagDisabledComponent;
import com.kms.katalon.composer.ai.studioassist.preference.ManagedAzureOpenAiPage;
import com.kms.katalon.composer.ai.studioassist.preference.ManagedGeminiPage;
import com.kms.katalon.composer.ai.studioassist.preference.ManagedOpenAiCompatiblePage;
import com.kms.katalon.composer.ai.studioassist.preference.ManagedOpenAiPage;
import com.kms.katalon.composer.ai.studioassist.preference.StudioAssistConfigComponent;
import com.kms.katalon.composer.ai.studioassist.preference.UserManagedAiAutoTagComponent;
import com.kms.katalon.composer.ai.studioassist.preference.UserSettingPage;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.components.util.DialogUtil;
import com.kms.katalon.constants.GlobalMessageConstants;
import com.kms.katalon.preferences.internal.PreferenceStoreManager;
import com.kms.katalon.preferences.internal.ScopedPreferenceStore;
import com.kms.katalon.session.core.model.AiAutoTagPolicyType;
import com.kms.katalon.session.core.model.AiAutoTagSetting;
import com.kms.katalon.session.core.model.AiConfigPolicy;
import com.kms.katalon.session.core.model.AiConfigPolicyType;
import com.kms.katalon.session.core.model.ProductFeature;
import com.kms.katalon.session.core.services.IFeatureController;
import com.kms.katalon.session.core.services.IProductFeatureDialog;
import com.kms.katalon.session.core.services.ISessionController;
import jakarta.inject.Inject;
import java.io.IOException;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class StudioAssistPreferencePage
extends PreferencePage {
    @Inject
    protected IStudioAssistController controller;
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private IEclipseContext context;
    @Inject
    private IFeatureController featureController;
    @Inject
    private IProductFeatureDialog productFeatureDialog;
    @Inject
    private ISessionController sessionController;
    private Composite parentComponent;
    private StudioAssistConfigComponent configComponent;
    private ScopedPreferenceStore scopedPreferenceStore = PreferenceStoreManager.getPreferenceStore((String)"com.kms.katalon.ai");
    private Button projectContextObjectIdsButton;
    private Button projectContextCustomKeywordsButton;
    private Listener compositeResizeListener;
    private Button followUpQuestionButton;
    private AiAutoTagComponent autoTaggingComponent;

    protected Control createContents(Composite parent) {
        this.parentComponent = (Composite)ComponentBuilder.gridContainer((Composite)parent).fill().build();
        if (!this.featureController.canUse(ProductFeature.STUDIOASSIST_EXECUTE_PROMPT)) {
            this.setValid(true);
            return parent;
        }
        AiConfigPolicy aiConfigPolicy = this.sessionController.getAiConfigPolicy();
        AiConfigPolicyType aiConfigPolicyType = aiConfigPolicy.getAiConfigPolicyType();
        String lable = aiConfigPolicyType == AiConfigPolicyType.USER_MANAGED_SETTINGS || aiConfigPolicyType == AiConfigPolicyType.AI_DISABLED ? "Select StudioAssist configuration" : "AI service configuration";
        ComponentBuilder.label((Composite)this.parentComponent).text(lable).marginBottom(0).build();
        switch (aiConfigPolicyType) {
            case ADMINISTRATION_MANAGED_AZURE_OPENAI: {
                this.configComponent = new ManagedAzureOpenAiPage(this.parentComponent, aiConfigPolicy);
                break;
            }
            case ADMINISTRATION_MANAGED_OPENAI: {
                this.configComponent = new ManagedOpenAiPage(this.parentComponent, aiConfigPolicy);
                break;
            }
            case ADMINISTRATION_MANAGED_GEMINI: {
                this.configComponent = new ManagedGeminiPage(this.parentComponent, aiConfigPolicy);
                break;
            }
            case ADMINISTRATION_MANAGED_OPENAI_COMPATIBLE: {
                this.configComponent = new ManagedOpenAiCompatiblePage(this.parentComponent, aiConfigPolicy);
                break;
            }
            default: {
                this.configComponent = new UserSettingPage(this.parentComponent, aiConfigPolicy);
            }
        }
        try {
            ContextInjectionFactory.inject((Object)this.configComponent, (IEclipseContext)this.context);
            this.configComponent.setMainPreferencePage(this);
            this.configComponent.loadConfig();
        }
        catch (StudioAssistLoadingConfigException e) {
            LoggerSingleton.logError((String)"An error has occurred while loading the StudioAssist configuration.");
            LoggerSingleton.logError((Throwable)e);
            this.showErrorDialog(ComposerStudioAssistConstants.ERROR_CANNOT_LOAD_CONFIG);
        }
        this.createSeparator(null);
        this.studioAssistTagSetting();
        this.createSeparator(null);
        this.projectContextSection(this.parentComponent);
        this.createSeparator(null);
        this.followUpQuestionSection(this.parentComponent);
        this.setValid(true);
        ScrolledComposite scrolledComposite = DialogUtil.findScrolledComposite((Control)this.parentComponent);
        this.compositeResizeListener = DialogUtil.autoUpdateScrolledCompositeListener((ScrolledComposite)scrolledComposite);
        this.parentComponent.addListener(11, this.compositeResizeListener);
        return parent;
    }

    private void createSeparator(Composite composite) {
        Composite separatorContainer = composite != null ? composite : this.parentComponent;
        Label separator = new Label(separatorContainer, 258);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.verticalIndent = 10;
        separator.setLayoutData((Object)gridData);
    }

    private void studioAssistTagSetting() {
        ComponentBuilder.label((Composite)this.parentComponent).text("Append tags for test cases used AI capabilities").bold().marginTop(5).build();
        AiAutoTagPolicyType aiAutoTaggingPolicyType = Optional.ofNullable(this.sessionController.getAdministrationManagedKsSetting().getAiAutoTagging()).map(setting -> setting.getType()).orElse(AiAutoTagPolicyType.USER_MANAGED_AI_AUTO_TAG);
        AiAutoTagSetting aiAutoTaggingSetting = this.sessionController.getAdministrationManagedKsSetting().getAiAutoTagging();
        switch (aiAutoTaggingPolicyType) {
            case ADMIN_MANAGED_AI_AUTO_TAG: {
                this.autoTaggingComponent = new AdminManagedAiAutoTagComponent(this.parentComponent, aiAutoTaggingSetting, this.controller);
                break;
            }
            case USER_MANAGED_AI_AUTO_TAG: {
                this.autoTaggingComponent = new UserManagedAiAutoTagComponent(this.parentComponent, aiAutoTaggingSetting, this.controller);
                break;
            }
            default: {
                this.autoTaggingComponent = new AutoTagDisabledComponent(this.parentComponent, aiAutoTaggingSetting, this.controller);
            }
        }
        this.autoTaggingComponent.setMainPreferencePage(this);
    }

    private void projectContextSection(Composite parent) {
        Composite container = (Composite)ComponentBuilder.gridContainer((Composite)parent, (int)2).build();
        ComponentBuilder.label((Composite)container).text("Auto-include project context information").marginTop(5).build();
        ComponentBuilder.label((Composite)container).image("help_16.png").onClick(e -> {
            try {
                Program.launch((String)"https://docs.katalon.com/katalon-studio/get-started/workspace-settings/katalon-studio-preferences/studioassist-preferences#ariaid-title1");
            }
            catch (Exception ex) {
                LoggerSingleton.logError((Throwable)ex);
                MessageDialog.openWarning((Shell)this.getShell(), (String)GlobalMessageConstants.ERROR, (String)ex.getMessage());
            }
        }).build();
        this.projectContextObjectIdsButton = (Button)ComponentBuilder.checkBox((Composite)container).text("Object repository").colSpan(2).build();
        boolean projectContextObjectIds = this.getCheckboxValue("studioassist.projectContext.objectRepository", true);
        this.projectContextObjectIdsButton.setSelection(projectContextObjectIds);
        this.projectContextCustomKeywordsButton = (Button)ComponentBuilder.checkBox((Composite)container).text("Custom keywords").colSpan(2).build();
        boolean projectContextCustomKeywords = this.getCheckboxValue("studioassist.projectContext.customKeywords", true);
        this.projectContextCustomKeywordsButton.setSelection(projectContextCustomKeywords);
    }

    private void followUpQuestionSection(Composite parent) {
        this.followUpQuestionButton = (Button)ComponentBuilder.checkBox((Composite)parent).text("Auto-suggest follow-up questions in the chat").marginTop(5).build();
        boolean followUpQuestionEnabled = this.getCheckboxValue("studioassist.follow_up_question.enabled", true);
        this.followUpQuestionButton.setSelection(followUpQuestionEnabled);
    }

    private boolean getCheckboxValue(String propertyName, boolean defaultValue) {
        String rawValue = this.scopedPreferenceStore.getString(propertyName);
        if (StringUtils.isBlank((CharSequence)rawValue)) {
            return defaultValue;
        }
        return Boolean.valueOf(rawValue);
    }

    protected void performDefaults() {
        if (!this.featureController.canUse(ProductFeature.STUDIOASSIST_EXECUTE_PROMPT)) {
            this.productFeatureDialog.showNotAvailableFeature(ProductFeature.STUDIOASSIST_EXECUTE_PROMPT);
            return;
        }
        super.performDefaults();
        this.configComponent.resetConfig();
        this.autoTaggingComponent.resetConfig();
        this.setErrorMessage(null);
    }

    protected void performApply() {
        if (this.parentComponent == null || this.parentComponent.isDisposed() || this.configComponent == null) {
            return;
        }
        try {
            this.configComponent.saveConfig();
            this.autoTaggingComponent.saveConfig();
            this.scopedPreferenceStore.setValue(this.getDialogFontName(), this.isValid());
            this.scopedPreferenceStore.setValue("studioassist.projectContext.customKeywords", String.valueOf(this.projectContextCustomKeywordsButton.getSelection()));
            this.scopedPreferenceStore.setValue("studioassist.projectContext.objectRepository", String.valueOf(this.projectContextObjectIdsButton.getSelection()));
            this.scopedPreferenceStore.setValue("studioassist.follow_up_question.enabled", String.valueOf(this.followUpQuestionButton.getSelection()));
            this.scopedPreferenceStore.save();
        }
        catch (StudioAssistSavingConfigException | IOException e) {
            LoggerSingleton.logError((Throwable)e);
            this.showErrorDialog(ComposerStudioAssistConstants.ERROR_CANNOT_SAVE_CONFIG);
        }
        this.eventBroker.post("ON_SA_SETTING_CHANGE", null);
    }

    public boolean performOk() {
        this.performApply();
        return super.performOk();
    }

    private void showErrorDialog(String errorMessage) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        MessageDialog.openError((Shell)window.getShell(), (String)ComposerStudioAssistConstants.ERROR, (String)errorMessage);
    }

    public void dispose() {
        if (this.compositeResizeListener != null) {
            this.parentComponent.removeListener(11, this.compositeResizeListener);
            this.compositeResizeListener = null;
        }
        super.dispose();
    }
}

