/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.ai.util;

import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.tree.SystemFileTreeEntity;
import com.kms.katalon.composer.components.impl.tree.TestSuiteCollectionTreeEntity;
import com.kms.katalon.composer.components.impl.tree.WebElementTreeEntity;
import com.kms.katalon.composer.components.impl.tree.WindowsElementTreeEntity;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.entity.file.SystemFileEntity;
import com.kms.katalon.entity.repository.WebServiceRequestEntity;
import org.slf4j.Logger;

public class AttachmentUtil {
    private static final String ERROR_WHILE_FILTERING_ENTITIES = "Something went wrong while filtering entities for ProjectFileSelectionDialog.";

    public static boolean isSupportedAttachmentAsTreeEntity(ITreeEntity entity, Logger logger) {
        if (entity instanceof FolderTreeEntity) {
            FolderTreeEntity folderTreeEntity = (FolderTreeEntity)entity;
            try {
                return AttachmentUtil.isFolderHasSupportedFiles(folderTreeEntity, logger);
            }
            catch (Exception e) {
                logger.warn(ERROR_WHILE_FILTERING_ENTITIES, (Throwable)e);
            }
        }
        try {
            return AttachmentUtil.isSupportedFile(entity);
        }
        catch (Exception e) {
            logger.warn(ERROR_WHILE_FILTERING_ENTITIES, (Throwable)e);
            return false;
        }
    }

    private static boolean isFolderHasSupportedFiles(FolderTreeEntity folderTreeEntity, Logger logger) throws Exception {
        Object[] objectArray = folderTreeEntity.getChildren();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            FolderTreeEntity childFolder;
            Object childObject = objectArray[n2];
            if (childObject instanceof FolderTreeEntity && AttachmentUtil.isFolderHasSupportedFiles(childFolder = (FolderTreeEntity)childObject, logger)) {
                return true;
            }
            try {
                ITreeEntity entity;
                if (childObject instanceof ITreeEntity && AttachmentUtil.isSupportedFile(entity = (ITreeEntity)childObject)) {
                    return true;
                }
            }
            catch (Exception e) {
                logger.warn(ERROR_WHILE_FILTERING_ENTITIES, (Throwable)e);
            }
            ++n2;
        }
        return false;
    }

    private static boolean isSupportedFile(ITreeEntity entity) throws Exception {
        if (entity instanceof TestSuiteCollectionTreeEntity) {
            return false;
        }
        if (entity instanceof SystemFileTreeEntity) {
            SystemFileTreeEntity systemFileObject = (SystemFileTreeEntity)entity;
            SystemFileEntity systemFile = systemFileObject.getObject();
            return systemFile.getName().toLowerCase().endsWith(".feature");
        }
        if (entity instanceof WindowsElementTreeEntity) {
            return false;
        }
        if (entity instanceof WebElementTreeEntity) {
            WebElementTreeEntity testObject = (WebElementTreeEntity)entity;
            return testObject.getObject() instanceof WebServiceRequestEntity;
        }
        return true;
    }
}

