/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.entity.testcase;

import com.kms.katalon.core.setting.IStudioAssistAiAutoTagSetting;
import com.kms.katalon.core.setting.service.AiAutoTagSettingRegistry;
import com.kms.katalon.entity.file.IntegratedFileEntity;
import com.kms.katalon.entity.integration.IntegratedEntity;
import com.kms.katalon.entity.link.TestCaseTestDataLink;
import com.kms.katalon.entity.link.VariableLink;
import com.kms.katalon.entity.testcase.RecordOption;
import com.kms.katalon.entity.testdata.DataFileEntity;
import com.kms.katalon.entity.util.Util;
import com.kms.katalon.entity.variable.VariableEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang3.StringUtils;

@XmlRootElement
public class TestCaseEntity
extends IntegratedFileEntity {
    private static final long serialVersionUID = 1L;
    private static final String GEN_AI_TEST_CASE_TAG = "API_Test_Generation";
    private static final String TAG_SEPARATOR = ",";
    private String comment = "";
    private String origin;
    @XmlTransient
    private List<DataFileEntity> dataFiles;
    private List<String> dataFileLocations;
    private List<VariableEntity> variables;
    private String testCaseGuid;
    private byte[] scriptContents;
    private List<VariableLink> variableLinks;
    private List<TestCaseTestDataLink> testDataLinks;
    private RecordOption recordOption = RecordOption.OTHER;

    public TestCaseEntity() {
        this.variables = new ArrayList<VariableEntity>();
        this.dataFiles = new ArrayList<DataFileEntity>();
        this.dataFileLocations = new ArrayList<String>();
        this.variableLinks = new ArrayList<VariableLink>();
        this.testDataLinks = new ArrayList<TestCaseTestDataLink>();
    }

    @XmlElement
    public RecordOption getRecordOption() {
        return this.recordOption;
    }

    public void setRecordOption(RecordOption recordOption) {
        this.recordOption = recordOption;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getTestCaseGuid() {
        return this.testCaseGuid;
    }

    public void setTestCaseGuid(String testCaseGuid) {
        this.testCaseGuid = testCaseGuid;
    }

    @Override
    public TestCaseEntity clone() {
        TestCaseEntity newTestCase = new TestCaseEntity();
        newTestCase.setParentFolder(this.getParentFolder());
        newTestCase.setProject(this.getProject());
        newTestCase.setName(this.getName());
        newTestCase.setComment(this.getComment());
        newTestCase.setTag(this.getTag());
        newTestCase.setDescription(this.getDescription());
        newTestCase.getDataFileLocations().clear();
        newTestCase.getDataFiles().clear();
        for (DataFileEntity dataFile : this.getDataFiles()) {
            newTestCase.getDataFiles().add(dataFile);
            newTestCase.getDataFileLocations().add(dataFile.getRelativePath());
        }
        newTestCase.getVariables().clear();
        HashMap<String, String> variablesIdCollection = new HashMap<String, String>();
        for (VariableEntity variable : this.getVariables()) {
            VariableEntity variableClone = variable.clone();
            newTestCase.getVariables().add(variableClone);
            variablesIdCollection.put(variable.getId(), variableClone.getId());
        }
        newTestCase.getIntegratedEntities().clear();
        for (IntegratedEntity integratedEntity : this.getIntegratedEntities()) {
            newTestCase.getIntegratedEntities().add(integratedEntity);
        }
        newTestCase.setScriptContents(this.getScriptContents());
        newTestCase.setTestCaseGuid(Util.generateGuid());
        newTestCase.getVariableLinks().clear();
        for (VariableLink variableLink : this.getVariableLinks()) {
            VariableLink variableLinkClone = variableLink.clone();
            String oldVariableId = variableLink.getVariableId();
            if (variablesIdCollection.containsKey(oldVariableId)) {
                variableLinkClone.setVariableId((String)variablesIdCollection.get(oldVariableId));
            }
            newTestCase.getVariableLinks().add(variableLinkClone);
        }
        newTestCase.getTestDataLinks().clear();
        for (TestCaseTestDataLink testDataLink : this.getTestDataLinks()) {
            newTestCase.getTestDataLinks().add(testDataLink.clone());
        }
        newTestCase.setRecordOption(this.getRecordOption());
        newTestCase.setOrigin(this.getOrigin());
        return newTestCase;
    }

    public List<String> getDataFileLocations() {
        return this.dataFileLocations;
    }

    public void setDataFileLocations(List<String> dataFileLocations) {
        this.dataFileLocations = dataFileLocations;
    }

    @Override
    public String getFileExtension() {
        return TestCaseEntity.getTestCaseFileExtension();
    }

    public static String getTestCaseFileExtension() {
        return ".tc";
    }

    public List<DataFileEntity> getDataFiles() {
        return this.dataFiles;
    }

    public void setDataFiles(List<DataFileEntity> dataFiles) {
        this.dataFiles = dataFiles;
    }

    public byte[] getScriptContents() {
        return this.scriptContents;
    }

    public void setScriptContents(byte[] scriptContents) {
        this.scriptContents = scriptContents;
    }

    public List<VariableEntity> getVariables() {
        return this.variables;
    }

    public void setVariables(List<VariableEntity> variables) {
        this.variables = variables;
    }

    public void addVariables(List<VariableEntity> variablesToAdd) {
        this.variables.addAll(variablesToAdd);
    }

    public List<VariableLink> getVariableLinks() {
        return this.variableLinks;
    }

    public void setVariableLinks(List<VariableLink> variableLinks) {
        this.variableLinks = variableLinks;
    }

    public List<TestCaseTestDataLink> getTestDataLinks() {
        return this.testDataLinks;
    }

    public void setTestDataLinks(List<TestCaseTestDataLink> testDataLinks) {
        this.testDataLinks = testDataLinks;
    }

    public List<VariableLink> convertVariableEntityToVariableLink() {
        ArrayList<VariableLink> list = new ArrayList<VariableLink>();
        for (VariableEntity var : this.variables) {
            list.add(new VariableLink(var.getId()));
        }
        return list;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.testCaseGuid);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof TestCaseEntity)) {
            return false;
        }
        TestCaseEntity other = (TestCaseEntity)obj;
        return Objects.equals(this.testCaseGuid, other.testCaseGuid);
    }

    @Deprecated
    public boolean isAPITestGenerationTestCase() {
        return GEN_AI_TEST_CASE_TAG.equals(this.getTag());
    }

    public boolean isKatalonAITestCase() {
        String tagString = this.getTag();
        if (StringUtils.isEmpty((CharSequence)tagString)) {
            return false;
        }
        IStudioAssistAiAutoTagSetting aiAutoTaggingSetting = AiAutoTagSettingRegistry.getAiAutoTaggingSetting();
        List aiTags = aiAutoTaggingSetting.getAiAutoTags();
        String[] stringArray = tagString.split(TAG_SEPARATOR);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String tag = stringArray[n2];
            if (aiTags.contains(tag.trim())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void updateTagForTestCase(String newTag) {
        if (StringUtils.isEmpty((CharSequence)newTag)) {
            return;
        }
        String currentTag = this.getTag();
        if (StringUtils.isEmpty((CharSequence)currentTag)) {
            this.setTag(newTag);
            return;
        }
        String[] stringArray = currentTag.split(TAG_SEPARATOR);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String tag = stringArray[n2];
            if (tag.trim().equals(newTag)) {
                return;
            }
            ++n2;
        }
        this.setTag(currentTag + TAG_SEPARATOR + newTag);
    }

    @XmlElement
    public String getOrigin() {
        return this.origin;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }
}

