/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.entity.testobject.events;

import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.repository.WebElementEntity;

public class TestObjectUpdatedEvent {
    private final String originalPk;
    private final FileEntity webElementEntity;
    private final TriggeredBy triggeredBy;

    public TestObjectUpdatedEvent(String originalPk, FileEntity webElementEntity, TriggeredBy triggeredBy) {
        this.originalPk = originalPk;
        this.webElementEntity = webElementEntity;
        this.triggeredBy = triggeredBy;
    }

    public String getOriginalPk() {
        return this.originalPk;
    }

    public WebElementEntity getWebElementEntity() {
        return (WebElementEntity)this.webElementEntity;
    }

    public TriggeredBy getTriggeredBy() {
        return this.triggeredBy;
    }

    public boolean shouldTriggerReferenceUpdate() {
        return this.triggeredBy == TriggeredBy.RENAME_TEST_OBJECT || this.triggeredBy == TriggeredBy.MOVE_TEST_OBJECT || this.triggeredBy == TriggeredBy.RENAME_FOLDER;
    }

    public boolean isContentOnlyChange() {
        return this.triggeredBy == TriggeredBy.CONTENT_MODIFICATION || this.triggeredBy == TriggeredBy.AUTO_HEALING || this.triggeredBy == TriggeredBy.RECORDING_SESSION || this.triggeredBy == TriggeredBy.OBJECT_SPY_SESSION;
    }

    public boolean isDeleteCleanup() {
        return this.triggeredBy == TriggeredBy.DELETE_REFERENCE_CLEANUP;
    }

    public static enum TriggeredBy {
        RENAME_TEST_OBJECT,
        MOVE_TEST_OBJECT,
        RENAME_FOLDER,
        CONTENT_MODIFICATION,
        DELETE_REFERENCE_CLEANUP,
        AUTO_HEALING,
        RECORDING_SESSION,
        OBJECT_SPY_SESSION,
        OTHERS;

    }
}

