/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.controller;

import com.katalon.network.oauth.core.model.AuthorizationRequest;
import com.kms.katalon.ai.core.context.IAgentSessionContext;
import com.kms.katalon.ai.core.model.agent.AgentConversation;
import com.kms.katalon.ai.core.model.agent.AgentMessage;
import com.kms.katalon.ai.core.model.agent.AgentSession;
import com.kms.katalon.ai.core.model.agent.AgentSetting;
import com.kms.katalon.ai.core.model.agent.McpClient;
import com.kms.katalon.ai.core.model.agent.ToolCallApproval;
import com.kms.katalon.ai.core.model.agent.ToolCallMessage;
import com.kms.katalon.ai.core.model.agent.config.McpServerDefinition;
import com.kms.katalon.ai.core.model.agent.config.McpServerSetting;
import com.kms.katalon.ai.core.model.agent.config.McpSetting;
import com.kms.katalon.ai.core.model.chat.ChatQuestionMessage;
import com.kms.katalon.ai.core.model.chat.ResponseMessage;
import com.kms.katalon.ai.core.model.chat.StudioAssistChatPair;
import com.kms.katalon.ai.core.model.exception.StudioAssistBaseException;
import com.kms.katalon.ai.core.services.IAgentManager;
import com.kms.katalon.ai.services.AgentPreferences;
import com.kms.katalon.util.collections.Pair;
import jakarta.inject.Inject;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Creatable
public class AgentSessionContext
implements IAgentSessionContext {
    private static final Logger logger = LoggerFactory.getLogger(AgentSessionContext.class);
    private static final int MAX_DURATION_WAITING_FOR_ANSWER = 120;
    @Inject
    private IAgentManager agentManager;
    @Inject
    private AgentPreferences agentPreferences;
    @Inject
    private IEventBroker eventBroker;
    private AgentSession session;
    private final EventHandler onMcpClientAddedHandler = this::onMcpClientAdded;

    public void initializeSession() {
        McpSetting setting = this.agentManager.getMcpSetting();
        this.session = new AgentSession();
        logger.info("Created new conversation for Agent mode with ID: " + this.getCurrentConversationId());
        AgentSetting agentSettings = this.agentPreferences.loadAgentSetting();
        List disabledServers = agentSettings.getDisabledServers();
        List servers = setting.getServers();
        if (servers.isEmpty()) {
            logger.info("No MCP servers configured");
            return;
        }
        for (McpServerDefinition server : servers) {
            McpClient client = new McpClient(server.getName());
            client.setBuiltin(server.isBuiltin());
            this.session.addMcpClient(client);
        }
        for (McpServerDefinition server : servers) {
            if (disabledServers.contains(server.getName())) continue;
            this.agentManager.connectServer(this.session, server);
        }
        this.eventBroker.subscribe("ON_MCP_CLIENT_ADDED", this.onMcpClientAddedHandler);
    }

    public void disposeSession() {
        this.eventBroker.unsubscribe(this.onMcpClientAddedHandler);
        for (McpClient client : this.session.getMcpClients()) {
            this.agentManager.closeClient(client);
        }
    }

    public void addServer(McpServerDefinition server) {
        this.agentManager.addServer(this.session, server);
    }

    public void disableServer(String server) {
        this.agentManager.disableServer(this.session, server);
    }

    public void enableServer(String server) {
        this.agentManager.enableServer(this.session, server);
    }

    public void removeServer(String server) {
        this.agentManager.removeServer(this.session, server);
    }

    public AuthorizationRequest requestServerAuthorization(String server) {
        return this.agentManager.requestServerAuthorization(this.session, server);
    }

    public void authorizeClient(String state, String authorizationCode) {
        this.agentManager.authorizeServer(this.session, state, authorizationCode);
    }

    public McpClient refreshClient(String server) {
        McpClient client = this.session.getMcpClient(server);
        this.agentManager.refreshClient(this.session, client);
        return client;
    }

    public void excludeTools(String server, List<String> tools) {
    }

    public CompletableFuture<Void> sendMessage(ChatQuestionMessage question) {
        return ((CompletableFuture)this.agentManager.sendMessage(this.session, question).thenCompose(this::processAgentResponseMessage)).thenApply(response -> null);
    }

    public CompletableFuture<Void> retryMessage(ChatQuestionMessage question) {
        return ((CompletableFuture)this.agentManager.retryMessage(this.session, question).thenCompose(this::processAgentResponseMessage)).thenApply(response -> null);
    }

    public void approveToolCall(AgentMessage agentMessage, ToolCallApproval approval) {
        this.agentManager.approveToolCall(this.session, agentMessage, approval);
    }

    public void denyToolCall(AgentMessage agentMessage) {
        this.agentManager.denyToolCall(this.session, agentMessage);
    }

    public void acknowledgeMaxedToolCall(AgentMessage agentMessage) {
        this.agentManager.acknowledgeMaxedToolCall(this.session, agentMessage);
    }

    public void rejectMaxedToolCall(AgentMessage agentMessage) {
        this.agentManager.rejectMaxedToolCall(this.session, agentMessage);
    }

    public void stopGeneration(AgentMessage agentMessage) {
        this.agentManager.stopGeneration(this.session, agentMessage);
    }

    public void clearConversation() {
        this.agentManager.clearConversation(this.session);
    }

    public String getCurrentConversationId() {
        return this.session.getConversation().getConversationId();
    }

    public void getFollowUpQuestions(String conversationId, String questionId) throws StudioAssistBaseException {
        this.agentManager.getFollowUpQuestions(this.session, conversationId, questionId);
    }

    public void resetApprovedTools(List<McpServerSetting> mcpServerSettings) {
        this.agentManager.resetApprovedTools(mcpServerSettings);
    }

    public List<McpClient> getMcpClients() {
        return this.session.getMcpClients();
    }

    public AgentMessage findAgentMessageById(String messageId) {
        if (this.session == null || this.session.getConversation() == null) {
            return null;
        }
        return this.session.getConversation().getMessages().stream().filter(item -> item instanceof StudioAssistChatPair).map(item -> (StudioAssistChatPair)item).map(StudioAssistChatPair::getResponse).filter(response -> response instanceof AgentMessage).map(response -> (AgentMessage)response).filter(agentMessage -> messageId.equals(agentMessage.getMessageId())).findFirst().orElse(null);
    }

    public void selectTool(String server, String tool) {
        this.agentManager.selectTool(server, tool);
    }

    public void deselectTool(String server, String tool) {
        this.agentManager.deselectTool(server, tool);
    }

    public void selectAllTools(String server) {
        this.agentManager.selectAllTools(this.session.getMcpClient(server));
    }

    public void deselectAllTools(String server) {
        this.agentManager.deselectAllTools(this.session.getMcpClient(server));
    }

    private CompletableFuture<ResponseMessage> processAgentResponseMessage(Pair<AgentMessage, ResponseMessage> messages) {
        if (messages == null) {
            return CompletableFuture.completedFuture(null);
        }
        return this.agentManager.processAgentResponseMessage(this.session, messages).thenCompose(newResponse -> {
            if (newResponse == null) {
                return CompletableFuture.completedFuture(null);
            }
            return this.processAgentResponseMessage((Pair<AgentMessage, ResponseMessage>)Pair.of((Object)((AgentMessage)messages.getLeft()), (Object)newResponse));
        });
    }

    public McpSetting getMcpSetting() {
        return this.agentManager.getMcpSetting();
    }

    public AgentSetting getAgentSetting() {
        return this.agentManager.getAgentSetting();
    }

    public AgentConversation getConversation() {
        return this.session.getConversation();
    }

    public List<ToolCallMessage> getAvailableTools() {
        return this.agentManager.getAvailableTools(this.session);
    }

    /*
     * WARNING - void declaration
     */
    private void onMcpClientAdded(Event event) {
        void server;
        Object data = event.getProperty("org.eclipse.e4.data");
        if (!(data instanceof McpServerDefinition)) {
            return;
        }
        McpServerDefinition mcpServerDefinition = (McpServerDefinition)data;
        this.agentManager.connectServer(this.session, (McpServerDefinition)server);
    }
}

