/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.controller;

import com.kms.katalon.ai.core.context.IChatSessionContext;
import com.kms.katalon.ai.core.model.chat.ChatQuestionMessage;
import com.kms.katalon.ai.core.model.chat.ChatResponseMessage;
import com.kms.katalon.ai.core.model.chat.ChatSession;
import com.kms.katalon.ai.core.model.chat.ResponseMessage;
import com.kms.katalon.ai.core.model.chat.StudioAssistChatPair;
import com.kms.katalon.ai.core.model.chat.StudioAssistConversation;
import com.kms.katalon.ai.core.model.presentation.ProjectContext;
import com.kms.katalon.ai.core.services.IChatManager;
import jakarta.inject.Inject;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Creatable
public class ChatSessionContext
implements IChatSessionContext {
    private static final Logger logger = LoggerFactory.getLogger(ChatSessionContext.class);
    @Inject
    private IChatManager chatManager;
    private ChatSession session;

    public void initializeSession() {
        this.session = new ChatSession();
        logger.info("Created new conversation for Chat mode with ID: {}", (Object)this.getCurrentConversationId());
    }

    public CompletableFuture<Void> sendMessage(ChatQuestionMessage message) {
        return ((CompletableFuture)this.chatManager.sendMessage(this.session, message).thenCompose(this::processChatResponseMessage)).thenApply(response -> null);
    }

    public CompletableFuture<Void> retryMessage(ChatQuestionMessage message) {
        return ((CompletableFuture)this.chatManager.retryMessage(this.session, message).thenCompose(this::processChatResponseMessage)).thenApply(response -> null);
    }

    public void stopGeneration(ChatResponseMessage answerMessage) {
        this.chatManager.stopGeneration(this.session, answerMessage);
    }

    public void clearConversation() {
        this.chatManager.clearConversation(this.session);
    }

    public StudioAssistConversation getConversation() {
        return this.session.getConversation();
    }

    public CompletableFuture<Void> getFollowUpQuestions(String conversationId, String questionMessageId) {
        return this.chatManager.getFollowUpQuestions(this.session, conversationId, questionMessageId).thenApply(response -> null);
    }

    public ChatResponseMessage findAnswerMessageById(String messageId) {
        if (this.session == null || this.session.getConversation() == null) {
            return null;
        }
        return this.session.getConversation().getMessages().stream().filter(StudioAssistChatPair.class::isInstance).map(StudioAssistChatPair.class::cast).map(StudioAssistChatPair::getResponse).filter(ChatResponseMessage.class::isInstance).map(ChatResponseMessage.class::cast).filter(chatMessage -> messageId.equals(chatMessage.getMessageId())).findFirst().orElse(null);
    }

    public ChatSession getSession() {
        return this.session;
    }

    public List<ProjectContext> getProjectContexts() {
        return this.session.getProjectContexts();
    }

    private String getCurrentConversationId() {
        return this.session.getConversation().getConversationId();
    }

    private CompletableFuture<ResponseMessage> processChatResponseMessage(ResponseMessage response) {
        if (response == null) {
            return CompletableFuture.completedFuture(null);
        }
        return this.chatManager.processChatResponseMessage(this.session, response).thenCompose(newResponse -> {
            if (newResponse == null) {
                return CompletableFuture.completedFuture(null);
            }
            return this.processChatResponseMessage((ResponseMessage)newResponse);
        });
    }
}

