/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.controller;

import com.kms.katalon.ai.controller.StudioAssistChatController;
import com.kms.katalon.ai.core.context.IConversationSessionContext;
import com.kms.katalon.ai.core.model.chat.AttachmentSource;
import com.kms.katalon.ai.core.model.chat.ChatMode;
import com.kms.katalon.ai.core.model.chat.ConversationSession;
import com.kms.katalon.ai.core.model.chat.StudioAssistChatStatus;
import com.kms.katalon.ai.core.model.config.LlmConfigType;
import com.kms.katalon.ai.core.model.config.StudioAssistConfig;
import com.kms.katalon.ai.core.model.exception.StudioAssistLoadingConfigException;
import com.kms.katalon.ai.core.model.preference.StudioAssistUserPreference;
import com.kms.katalon.ai.core.repository.IStudioAssistUserPreferenceRepository;
import com.kms.katalon.ai.core.services.IStudioAssistController;
import com.kms.katalon.controller.ProjectController;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConversationSessionContext
implements IConversationSessionContext,
EventHandler {
    private static final Logger logger = LoggerFactory.getLogger(ConversationSessionContext.class);
    private volatile ConversationSession currentSession;
    @Inject
    private IStudioAssistController studioAssistController;
    @Inject
    private StudioAssistChatController studioAssistChatController;
    @Inject
    private IStudioAssistUserPreferenceRepository studioAssistUserPreferenceRepository;
    @Inject
    private IEventBroker eventBroker;

    @PostConstruct
    public void postConstruct() {
        this.eventBroker.subscribe("ON_SA_SETTING_CHANGE", (EventHandler)this);
        this.eventBroker.subscribe("PROJECT/OPENED", (EventHandler)this);
        this.eventBroker.subscribe("PROJECT/CLOSED", (EventHandler)this);
    }

    @PreDestroy
    public void preDestroy() {
        this.eventBroker.unsubscribe((EventHandler)this);
    }

    public void handleEvent(Event event) {
        switch (event.getTopic()) {
            case "ON_SA_SETTING_CHANGE": {
                this.studioAssistSettingUpdated();
                break;
            }
            case "PROJECT/OPENED": {
                this.projectOpened();
                break;
            }
            case "PROJECT/CLOSED": {
                this.projectClosed();
                break;
            }
        }
    }

    public void initSession() {
        ConversationSession chatSession = new ConversationSession();
        StudioAssistUserPreference userPreference = this.studioAssistUserPreferenceRepository.getUserPreference();
        ChatMode currentChatMode = Objects.isNull(userPreference.getCurrentChatMode()) ? ChatMode.ASK : ChatMode.valueOf((String)userPreference.getCurrentChatMode().toString());
        chatSession.setChatMode(currentChatMode);
        boolean hasProjectOpened = Objects.nonNull(ProjectController.getInstance().getCurrentProject());
        ArrayList<AttachmentSource> attachmentSources = new ArrayList<AttachmentSource>();
        attachmentSources.add(AttachmentSource.EXTERNAL);
        if (hasProjectOpened) {
            attachmentSources.add(AttachmentSource.PROJECT);
        }
        chatSession.setAttachmentSources(attachmentSources);
        chatSession.setStatus(StudioAssistChatStatus.LOADING);
        chatSession.setUserPreference(userPreference);
        try {
            chatSession.setLlmConfigType(Optional.ofNullable(this.studioAssistController.getConfig()).map(StudioAssistConfig::getType).orElse(LlmConfigType.NONE));
        }
        catch (StudioAssistLoadingConfigException e) {
            logger.error("Unable to load Studio Assist Config Type", (Throwable)e);
        }
        this.currentSession = chatSession;
        this.handleConversationSessionUpdated(chatSession);
    }

    public ConversationSession getCurrentSession() {
        return this.currentSession;
    }

    public void changeChatMode(ChatMode chatMode) {
        if (this.currentSession.getChatMode() != chatMode) {
            this.currentSession.setChatMode(chatMode);
            StudioAssistUserPreference userPreference = this.studioAssistUserPreferenceRepository.getUserPreference();
            userPreference.setCurrentChatMode(chatMode);
            if (chatMode.equals((Object)ChatMode.AGENT) && !userPreference.isIntroducedAgentMode()) {
                userPreference.setIntroducedAgentMode(true);
            }
            this.studioAssistUserPreferenceRepository.saveUserPreference(userPreference);
            this.handleConversationSessionUpdated(this.currentSession);
            this.handleProjectContextUpdated();
        }
    }

    public void studioAssistChatViewOpened() {
        StudioAssistChatStatus availability = this.studioAssistChatController.validateFunctionAvailability();
        this.currentSession.setStatus(availability);
        this.handleConversationSessionUpdated(this.currentSession);
    }

    public StudioAssistUserPreference getUserPreference() {
        return this.studioAssistUserPreferenceRepository.getUserPreference();
    }

    private void studioAssistSettingUpdated() {
        try {
            this.currentSession.setLlmConfigType(Optional.ofNullable(this.studioAssistController.getConfig()).map(StudioAssistConfig::getType).orElse(LlmConfigType.NONE));
            this.handleConversationSessionUpdated(this.currentSession);
            this.handleProjectContextUpdated();
        }
        catch (StudioAssistLoadingConfigException e) {
            logger.error("Unable to load Studio Assist Config Type", (Throwable)e);
        }
        ((CompletableFuture)CompletableFuture.supplyAsync(() -> this.studioAssistChatController.validateFunctionAvailability()).thenAccept(availability -> {
            this.currentSession.setStatus(availability);
            this.handleConversationSessionUpdated(this.currentSession);
        })).exceptionally(ex -> {
            logger.error("Error validating function availability", ex);
            return null;
        });
    }

    private void projectOpened() {
        List attachmentSources = this.currentSession.getAttachmentSources();
        attachmentSources.add(AttachmentSource.PROJECT);
        this.currentSession.setAttachmentSources(attachmentSources);
        this.handleConversationSessionUpdated(this.currentSession);
        this.handleProjectContextUpdated();
    }

    private void projectClosed() {
        List attachmentSources = this.currentSession.getAttachmentSources();
        attachmentSources.remove(AttachmentSource.PROJECT);
        this.currentSession.setAttachmentSources(attachmentSources);
        this.handleConversationSessionUpdated(this.currentSession);
        this.handleProjectContextUpdated();
    }

    private void handleConversationSessionUpdated(ConversationSession conversationSession) {
        this.eventBroker.post("ON_STUDIO_ASSIST_CONVERSATION_SESSION_UPDATED", (Object)conversationSession);
    }

    private void handleProjectContextUpdated() {
        this.eventBroker.post("ON_STUDIO_ASSIST_PROJECT_CONTEXT_UPDATED", null);
    }
}

