/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.controller;

import com.kms.katalon.ai.core.constant.LLMModelDefaultPrompt;
import com.kms.katalon.ai.core.constant.StudioAssistAttachmentSource;
import com.kms.katalon.ai.core.constant.StudioAssistAttachmentStatus;
import com.kms.katalon.ai.core.constant.StudioAssistFileType;
import com.kms.katalon.ai.core.constant.StudioAssistTrackingContextTypeEnum;
import com.kms.katalon.ai.core.constant.StudioAssistTrackingKeyEnum;
import com.kms.katalon.ai.core.controller.IStudioAssistReferenceContextController;
import com.kms.katalon.ai.core.model.chat.ChatMode;
import com.kms.katalon.ai.core.model.chat.StudioAssistChatAttachment;
import com.kms.katalon.ai.core.model.chat.StudioAssistChatPair;
import com.kms.katalon.ai.core.model.chat.StudioAssistChatReferenceContextMessage;
import com.kms.katalon.ai.core.model.chat.StudioAssistConversation;
import com.kms.katalon.ai.core.model.chat.StudioAssistUploadedFileHistory;
import com.kms.katalon.ai.core.model.exception.StudioAssistAttachmentValidationException;
import com.kms.katalon.ai.core.model.exception.StudioAssistBaseException;
import com.kms.katalon.ai.core.model.exception.StudioAssistException;
import com.kms.katalon.ai.core.model.exception.StudioAssistLoadAttachmentException;
import com.kms.katalon.ai.core.model.prompt.PromptType;
import com.kms.katalon.ai.core.services.IStudioAssistReferenceContextService;
import com.kms.katalon.ai.core.services.IStudioAssistTrackingService;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.setting.StudioAssistSetting;
import com.kms.katalon.entity.project.ProjectEntity;
import jakarta.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StudioAssistReferenceContextController
implements IStudioAssistReferenceContextController {
    private final Logger logger = LoggerFactory.getLogger(StudioAssistReferenceContextController.class);
    private HashMap<String, StudioAssistChatAttachment> cachedClientAIAttachments = new HashMap();
    @Inject
    private IStudioAssistReferenceContextService refContextService;
    @Inject
    private IStudioAssistTrackingService studioAssistTrackingService;

    public List<StudioAssistChatReferenceContextMessage> getContext(String conversationId, String questionId, PromptType promptType, ChatMode chatMode) throws StudioAssistException {
        try {
            List<StudioAssistChatReferenceContextMessage> projectContext = this.getProjectContext(conversationId, questionId, promptType, chatMode);
            return projectContext;
        }
        catch (Exception e) {
            throw new StudioAssistException(e.getMessage());
        }
    }

    private List<StudioAssistChatReferenceContextMessage> getProjectContext(String conversationId, String questionId, PromptType promptType, ChatMode chatMode) throws Exception {
        long startTime;
        if (chatMode == ChatMode.AGENT) {
            return null;
        }
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        if (Objects.isNull(project)) {
            return null;
        }
        String currentProjectId = project.getId();
        ArrayList<StudioAssistChatReferenceContextMessage> result = new ArrayList<StudioAssistChatReferenceContextMessage>();
        if (StudioAssistSetting.isProjectContextObjectRepositoriesEnabled()) {
            startTime = System.currentTimeMillis();
            StudioAssistChatReferenceContextMessage objectRepositoryContext = this.refContextService.getObjectRepository(project, conversationId);
            if (objectRepositoryContext != null) {
                result.add(objectRepositoryContext);
                this.trackUsingObjectRepository(currentProjectId, conversationId, questionId, chatMode);
            }
            this.logger.info("Total time to get Object Repositories context (ms): " + (System.currentTimeMillis() - startTime));
        }
        if (StudioAssistSetting.isProjectContextCustomKeywordsEnabled()) {
            startTime = System.currentTimeMillis();
            StudioAssistChatReferenceContextMessage customKeywordContext = this.refContextService.getCustomKeywordsFromCurrentProject(project, conversationId);
            if (customKeywordContext != null) {
                result.add(customKeywordContext);
                this.trackUsingCustomKeyword(currentProjectId, conversationId, questionId, chatMode);
            }
            this.logger.info("Total time to get Custom keywords context (ms): " + (System.currentTimeMillis() - startTime));
        }
        return result;
    }

    private void trackUsingObjectRepository(String projectId, String conversationId, String questionId, ChatMode chatMode) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        byte[] digest = messageDigest.digest(projectId.getBytes());
        String hashProjectId = Base64.getEncoder().encodeToString(digest);
        ArrayList<String> trackingData = new ArrayList<String>();
        trackingData.add(StudioAssistTrackingKeyEnum.CONVERSATION_ID.getValue());
        trackingData.add(conversationId);
        trackingData.add(StudioAssistTrackingKeyEnum.QUESTION_ID.getValue());
        trackingData.add(questionId);
        trackingData.add(StudioAssistTrackingKeyEnum.CONTEXT_TYPE.getValue());
        trackingData.add(StudioAssistTrackingContextTypeEnum.OBJECT_REPOSITORY.getValue());
        trackingData.add(StudioAssistTrackingKeyEnum.CONTEXT_ID.getValue());
        trackingData.add(hashProjectId);
        trackingData.add(StudioAssistTrackingKeyEnum.CHAT_MODE.getValue());
        trackingData.add(chatMode.name().toLowerCase());
        this.studioAssistTrackingService.trackStudioAssistChat(trackingData);
    }

    private void trackUsingCustomKeyword(String projectId, String conversationId, String questionId, ChatMode chatMode) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        byte[] digest = messageDigest.digest(projectId.getBytes());
        String hashProjectId = Base64.getEncoder().encodeToString(digest);
        ArrayList<String> trackingData = new ArrayList<String>();
        trackingData.add(StudioAssistTrackingKeyEnum.CONVERSATION_ID.getValue());
        trackingData.add(conversationId);
        trackingData.add(StudioAssistTrackingKeyEnum.QUESTION_ID.getValue());
        trackingData.add(questionId);
        trackingData.add(StudioAssistTrackingKeyEnum.CONTEXT_TYPE.getValue());
        trackingData.add(StudioAssistTrackingContextTypeEnum.CUSTOM_KEYWORD.getValue());
        trackingData.add(StudioAssistTrackingKeyEnum.CONTEXT_ID.getValue());
        trackingData.add(hashProjectId);
        trackingData.add(StudioAssistTrackingKeyEnum.CHAT_MODE.getValue());
        trackingData.add(chatMode.name().toLowerCase());
        this.studioAssistTrackingService.trackStudioAssistChat(trackingData);
    }

    public void clear() {
        this.cachedClientAIAttachments.clear();
    }

    private Date getDateModified(StudioAssistChatAttachment attachment) throws Exception {
        File file = new File(attachment.getFilePath());
        return new Date(file.lastModified());
    }

    public StudioAssistChatAttachment loadAttachmentContent(StudioAssistChatAttachment attachment) throws StudioAssistLoadAttachmentException {
        this.setAttachmentDateModified(attachment);
        StudioAssistChatAttachment cachedAttachment = this.cachedClientAIAttachments.get(attachment.getFilePath());
        if (this.isCachedAttachmentValid(cachedAttachment, attachment)) {
            return this.updateAndReturnCachedAttachment(cachedAttachment, attachment);
        }
        return this.loadFreshAttachment(attachment);
    }

    private void setAttachmentDateModified(StudioAssistChatAttachment attachment) throws StudioAssistLoadAttachmentException {
        try {
            attachment.setDateModified(this.getDateModified(attachment));
        }
        catch (Exception exception) {
            throw new StudioAssistLoadAttachmentException("Error while getting date modified from attachment. " + exception.getMessage());
        }
    }

    private boolean isCachedAttachmentValid(StudioAssistChatAttachment cachedAttachment, StudioAssistChatAttachment attachment) throws StudioAssistLoadAttachmentException {
        if (cachedAttachment == null || attachment.getDateModified() == null) {
            return false;
        }
        return cachedAttachment.getDateModified() != null && cachedAttachment.getDateModified().equals(attachment.getDateModified());
    }

    private StudioAssistChatAttachment updateAndReturnCachedAttachment(StudioAssistChatAttachment cachedAttachment, StudioAssistChatAttachment attachment) {
        cachedAttachment.setFileSource(attachment.getFileSource());
        if (attachment.getStatus() != null) {
            cachedAttachment.setStatus(attachment.getStatus());
        }
        return cachedAttachment;
    }

    private StudioAssistChatAttachment loadFreshAttachment(StudioAssistChatAttachment attachment) throws StudioAssistLoadAttachmentException {
        try {
            StudioAssistAttachmentStatus originalStatus = attachment.getStatus();
            StudioAssistChatAttachment fulfillAttachment = this.refContextService.fulfillAttachmentContent(attachment);
            if (fulfillAttachment != null) {
                this.prepareFulfilledAttachment(fulfillAttachment, originalStatus);
                this.cachedClientAIAttachments.put(fulfillAttachment.getFilePath(), fulfillAttachment);
            }
            return fulfillAttachment;
        }
        catch (IOException ioException) {
            throw new StudioAssistLoadAttachmentException("Error while getting file content from function fulfillAttachmentContent. " + ioException.getMessage());
        }
    }

    private void prepareFulfilledAttachment(StudioAssistChatAttachment fulfillAttachment, StudioAssistAttachmentStatus originalStatus) {
        if (originalStatus != null && fulfillAttachment.getStatus() == null) {
            fulfillAttachment.setStatus(originalStatus);
        }
        if (StringUtils.isBlank((CharSequence)fulfillAttachment.getFileClientId())) {
            fulfillAttachment.setFileClientId(UUID.randomUUID().toString());
        }
    }

    public void updateFileIdIntoCache(Map<String, StudioAssistUploadedFileHistory> uploadedFileMap) {
        if (uploadedFileMap == null || uploadedFileMap.isEmpty()) {
            return;
        }
        Map cacheByFileClientId = this.cachedClientAIAttachments.values().stream().collect(Collectors.toMap(StudioAssistChatAttachment::getFileClientId, Function.identity()));
        for (String fileClientId : uploadedFileMap.keySet()) {
            if (!cacheByFileClientId.containsKey(fileClientId)) continue;
            StudioAssistChatAttachment attachment = (StudioAssistChatAttachment)cacheByFileClientId.get(fileClientId);
            attachment.setFileId(uploadedFileMap.get(fileClientId).getFileId());
        }
    }

    public StudioAssistAttachmentStatus validateAttachment(String attachmentFilePath, StudioAssistFileType attachmentFileType) throws StudioAssistBaseException {
        try {
            return this.refContextService.validateAttachment(attachmentFilePath, attachmentFileType);
        }
        catch (Exception e) {
            throw new StudioAssistAttachmentValidationException((Throwable)e);
        }
    }

    public void loadAndAddReferenceContexts(StudioAssistConversation conversation, String conversationId, String questionId, PromptType promptType, ChatMode chatMode) throws StudioAssistBaseException {
        try {
            List<StudioAssistChatReferenceContextMessage> contexts = this.getContext(conversationId, questionId, promptType, chatMode);
            if (contexts == null || contexts.isEmpty()) {
                return;
            }
            List<StudioAssistChatReferenceContextMessage> newContexts = this.filterExistingContexts(conversation, contexts);
            if (newContexts.isEmpty()) {
                return;
            }
            conversation.getMessages().stream().filter(item -> item instanceof StudioAssistChatPair).map(item -> (StudioAssistChatPair)item).filter(pair -> pair.getRequest() != null && questionId.equals(pair.getRequest().getMessageId())).findFirst().ifPresent(firstChatPair -> firstChatPair.setReferenceContexts(newContexts));
        }
        catch (Exception e) {
            this.logger.error("Failed to load and add reference contexts", (Throwable)e);
            throw e;
        }
    }

    private List<StudioAssistChatReferenceContextMessage> filterExistingContexts(StudioAssistConversation conversation, List<StudioAssistChatReferenceContextMessage> newContexts) {
        List existingContexts = conversation.getMessages().stream().filter(item -> item instanceof StudioAssistChatPair).map(item -> (StudioAssistChatPair)item).filter(pair -> pair.getReferenceContexts() != null).flatMap(pair -> pair.getReferenceContexts().stream()).toList();
        boolean hasObjectRepository = existingContexts.stream().anyMatch(ctx -> ctx.getContent() != null && ctx.getContent().startsWith(LLMModelDefaultPrompt.PROJECT_CONTEXT_OBJECT_REPOSITORY_TEMPLATE));
        boolean hasCustomKeywords = existingContexts.stream().anyMatch(ctx -> ctx.getContent() != null && ctx.getContent().startsWith(LLMModelDefaultPrompt.PROJECT_CONTEXT_CUSTOM_KEYWORDS_TEMPLATE));
        return newContexts.stream().filter(newCtx -> {
            String content = newCtx.getContent();
            if (content == null) {
                return true;
            }
            if (hasObjectRepository && content.startsWith(LLMModelDefaultPrompt.PROJECT_CONTEXT_OBJECT_REPOSITORY_TEMPLATE)) {
                this.logger.debug("Skipping Object Repository context - already exists in conversation");
                return false;
            }
            if (hasCustomKeywords && content.startsWith(LLMModelDefaultPrompt.PROJECT_CONTEXT_CUSTOM_KEYWORDS_TEMPLATE)) {
                this.logger.debug("Skipping Custom Keyword context - already exists in conversation");
                return false;
            }
            return true;
        }).collect(Collectors.toList());
    }

    public void addAttachments(List<StudioAssistChatAttachment> attachments) {
        if (attachments == null || attachments.isEmpty()) {
            this.getCurrentAttachments();
            return;
        }
        for (StudioAssistChatAttachment attachment : attachments) {
            String filePath = attachment.getFilePath();
            String fileClientId = attachment.getFileClientId();
            if (StringUtils.isBlank((CharSequence)fileClientId)) {
                fileClientId = UUID.randomUUID().toString();
                attachment.setFileClientId(fileClientId);
            }
            if (!this.cachedClientAIAttachments.containsKey(filePath)) {
                this.cachedClientAIAttachments.put(filePath, attachment);
                continue;
            }
            StudioAssistChatAttachment existing = this.cachedClientAIAttachments.get(filePath);
            if (existing.getFileSource() == attachment.getFileSource()) continue;
            existing.setFileSource(attachment.getFileSource());
        }
        this.getCurrentAttachments();
    }

    public List<StudioAssistChatAttachment> getCurrentAttachments() {
        return new ArrayList<StudioAssistChatAttachment>(this.cachedClientAIAttachments.values());
    }

    public void clearAttachments() {
        this.logger.info("Clearing {} attachments from cache", (Object)this.cachedClientAIAttachments.size());
        this.cachedClientAIAttachments.clear();
    }

    public void removeAttachment(String filePath) {
        if (StringUtils.isBlank((CharSequence)filePath)) {
            this.getCurrentAttachments();
            return;
        }
        if (this.cachedClientAIAttachments.get(filePath) != null) {
            this.cachedClientAIAttachments.remove(filePath);
        } else {
            this.logger.info("Attachment not found for removal (fileClientId: {})", (Object)filePath);
        }
        this.getCurrentAttachments();
    }

    /*
     * WARNING - void declaration
     */
    public void setFocusingFile(StudioAssistChatAttachment focusingFile) {
        this.logger.info("setFocusingFile called with: {}", focusingFile != null ? focusingFile.getFilePath() + " (status: " + String.valueOf(focusingFile.getStatus()) + ", fileClientId: " + focusingFile.getFileClientId() + ")" : "null");
        ArrayList<String> focusingFilePaths = new ArrayList<String>();
        for (Map.Entry<String, StudioAssistChatAttachment> entry : this.cachedClientAIAttachments.entrySet()) {
            StudioAssistChatAttachment attachment = entry.getValue();
            if (attachment.getFileSource() != StudioAssistAttachmentSource.FOCUSING_FILE) continue;
            focusingFilePaths.add(entry.getKey());
            this.logger.info("Found existing focusing file to remove: {} (fileClientId: {}, type: {})", new Object[]{attachment.getFilePath(), attachment.getFileClientId(), attachment.getClass().getSimpleName()});
        }
        for (String string : focusingFilePaths) {
            this.cachedClientAIAttachments.remove(string);
            this.logger.info("Removed previous focusing file at path: {}", (Object)string);
        }
        if (focusingFile != null) {
            void var3_9;
            String string = focusingFile.getFileClientId();
            if (StringUtils.isBlank((CharSequence)string)) {
                String string2 = UUID.randomUUID().toString();
                focusingFile.setFileClientId(string2);
                this.logger.info("Generated new fileClientId: {}", (Object)string2);
            }
            this.cachedClientAIAttachments.put(focusingFile.getFilePath(), focusingFile);
            this.logger.info("Set new focusing file: {} (fileClientId: {}, status: {})", new Object[]{focusingFile.getFilePath(), var3_9, focusingFile.getStatus()});
        } else {
            this.logger.info("Cleared focusing file (none set)");
        }
        this.logger.info("After setFocusingFile, cache contains {} attachments", (Object)this.cachedClientAIAttachments.size());
        for (Map.Entry<String, Object> entry : this.cachedClientAIAttachments.entrySet()) {
            this.logger.info("  - {} (type: {}, fileSource: {}, status: {}, fileClientId: {})", new Object[]{((StudioAssistChatAttachment)entry.getValue()).getFilePath(), ((StudioAssistChatAttachment)entry.getValue()).getClass().getSimpleName(), ((StudioAssistChatAttachment)entry.getValue()).getFileSource(), ((StudioAssistChatAttachment)entry.getValue()).getStatus(), ((StudioAssistChatAttachment)entry.getValue()).getFileClientId()});
        }
        this.getCurrentAttachments();
    }
}

