/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.mcp.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.kms.katalon.ai.mcp.server.OAuthCallbackHandler;
import com.kms.katalon.ai.mcp.tools.BddTools;
import com.kms.katalon.ai.mcp.tools.CustomKeywordTools;
import com.kms.katalon.ai.mcp.tools.ProjectContextTools;
import com.kms.katalon.ai.mcp.tools.TestCaseTools;
import com.kms.katalon.ai.mcp.tools.TestDataTools;
import com.kms.katalon.ai.mcp.tools.TestObjectTools;
import com.kms.katalon.ai.mcp.tools.TestSuiteTools;
import io.modelcontextprotocol.server.McpServer;
import io.modelcontextprotocol.server.McpSyncServer;
import io.modelcontextprotocol.server.transport.HttpServletStreamableServerTransportProvider;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.spec.McpStreamableServerTransportProvider;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.servlet.Servlet;
import java.text.MessageFormat;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.ee10.servlet.ServletHolder;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Creatable
@Singleton
public class McpServerManager {
    private static final Logger logger = LoggerFactory.getLogger(McpServerManager.class);
    private static final String DEFAULT_HOST = "127.0.0.1";
    private static final int DEFAULT_PORT = 33699;
    private static final String THREAD_POOL_NAME = "katalon-mcp-server";
    private static final int THREAD_POOL_SIZE = 10;
    private static final String MCP_SERVER_NAME = "mcp-jetty-server";
    private static final String MCP_SERVER_VERSION = "1.0.0";
    private static final String MCP_SERVER_PORT_VARIABLE = "KATALON_STUDIO_MCP_SERVER_PORT";
    private Server jettyServer;
    private McpSyncServer mcpServer;
    private int port;
    private String host;
    private final AtomicBoolean isRunning = new AtomicBoolean(false);
    @Inject
    private IEclipseContext eclipseContext;
    private ProjectContextTools projectContextTools;
    private TestCaseTools testCaseTools;
    private CustomKeywordTools customKeywordTools;
    private TestDataTools testDataTools;
    private TestSuiteTools testSuiteTools;
    private BddTools bddTools;
    private TestObjectTools testObjectTools;

    public CompletableFuture<Void> start() {
        if (this.isRunning.get()) {
            logger.info("Katalon Studio MCP server is already started");
            return CompletableFuture.completedFuture(null);
        }
        this.projectContextTools = (ProjectContextTools)ContextInjectionFactory.make(ProjectContextTools.class, (IEclipseContext)this.eclipseContext);
        this.testCaseTools = (TestCaseTools)ContextInjectionFactory.make(TestCaseTools.class, (IEclipseContext)this.eclipseContext);
        this.customKeywordTools = (CustomKeywordTools)ContextInjectionFactory.make(CustomKeywordTools.class, (IEclipseContext)this.eclipseContext);
        this.testDataTools = (TestDataTools)ContextInjectionFactory.make(TestDataTools.class, (IEclipseContext)this.eclipseContext);
        this.testSuiteTools = (TestSuiteTools)ContextInjectionFactory.make(TestSuiteTools.class, (IEclipseContext)this.eclipseContext);
        this.bddTools = (BddTools)ContextInjectionFactory.make(BddTools.class, (IEclipseContext)this.eclipseContext);
        this.testObjectTools = (TestObjectTools)ContextInjectionFactory.make(TestObjectTools.class, (IEclipseContext)this.eclipseContext);
        return this.startServerAsync();
    }

    private CompletableFuture<Void> startServerAsync() {
        return CompletableFuture.runAsync(() -> {
            try {
                QueuedThreadPool threadPool = new QueuedThreadPool(10);
                threadPool.setName(THREAD_POOL_NAME);
                this.host = DEFAULT_HOST;
                this.port = 33699;
                String portVariable = System.getenv(MCP_SERVER_PORT_VARIABLE);
                if (StringUtils.isNotBlank((CharSequence)portVariable)) {
                    try {
                        this.port = Integer.parseInt(portVariable);
                    }
                    catch (NumberFormatException numberFormatException) {
                        logger.warn("Invalid value for environment variable {}: {}. Katalon Studio MCP server will fallback to use default port.", (Object)MCP_SERVER_PORT_VARIABLE, (Object)portVariable);
                    }
                }
                this.jettyServer = new Server((ThreadPool)threadPool);
                ServerConnector connector = new ServerConnector(this.jettyServer);
                connector.setHost(this.host);
                connector.setPort(this.port);
                this.jettyServer.addConnector((Connector)connector);
                HttpServletStreamableServerTransportProvider transportProvider = HttpServletStreamableServerTransportProvider.builder().objectMapper(new ObjectMapper()).mcpEndpoint("/stream").build();
                this.mcpServer = McpServer.sync((McpStreamableServerTransportProvider)transportProvider).serverInfo(MCP_SERVER_NAME, MCP_SERVER_VERSION).capabilities(McpSchema.ServerCapabilities.builder().resources(Boolean.valueOf(false), Boolean.valueOf(false)).tools(Boolean.valueOf(true)).prompts(Boolean.valueOf(true)).build()).build();
                this.mcpServer.addTool(this.projectContextTools.getCustomKeywordsListTool());
                this.mcpServer.addTool(this.projectContextTools.getTestObjectsListTool());
                this.mcpServer.addTool(this.testCaseTools.getTestCaseListTool());
                this.mcpServer.addTool(this.testCaseTools.getTestCaseScriptTool());
                this.mcpServer.addTool(this.testCaseTools.updateTestCaseScriptTool());
                this.mcpServer.addTool(this.testCaseTools.createNewTestCaseTool());
                this.mcpServer.addTool(this.testCaseTools.updateTestCaseTool());
                this.mcpServer.addTool(this.customKeywordTools.createCustomKeywordTool());
                this.mcpServer.addTool(this.customKeywordTools.updateCustomKeywordTool());
                this.mcpServer.addTool(this.customKeywordTools.getCustomKeywordTool());
                this.mcpServer.addTool(this.testDataTools.getTestDataListTool());
                this.mcpServer.addTool(this.testDataTools.createInternalTestDataTool());
                this.mcpServer.addTool(this.testSuiteTools.getTestSuiteTool());
                this.mcpServer.addTool(this.testSuiteTools.createTestSuiteTool());
                this.mcpServer.addTool(this.testSuiteTools.updateTestSuiteTool());
                this.mcpServer.addTool(this.testSuiteTools.createTestSuiteCollectionTool());
                this.mcpServer.addTool(this.testSuiteTools.updateTestSuiteCollectionTool());
                this.mcpServer.addTool(this.testSuiteTools.createDynamicTestSuiteTool());
                this.mcpServer.addTool(this.testSuiteTools.updateDynamicTestSuiteTool());
                this.mcpServer.addTool(this.bddTools.createBddFeatureFileTool());
                this.mcpServer.addTool(this.bddTools.updateBddFeatureFileTool());
                this.mcpServer.addTool(this.testObjectTools.getTestObjectTool());
                this.mcpServer.addTool(this.testObjectTools.createWebTestObjectTool());
                this.mcpServer.addTool(this.testObjectTools.createMobileTestObjectTool());
                this.mcpServer.addTool(this.testObjectTools.createWindowsTestObjectTool());
                this.mcpServer.addTool(this.testObjectTools.createRestWebServiceTestObjectTool());
                this.mcpServer.addTool(this.testObjectTools.createSoapWebServiceTestObjectTool());
                this.mcpServer.addTool(this.testObjectTools.updateWebTestObjectTool());
                this.mcpServer.addTool(this.testObjectTools.updateMobileTestObjectTool());
                this.mcpServer.addTool(this.testObjectTools.updateWindowsTestObjectTool());
                this.mcpServer.addTool(this.testObjectTools.updateRestWebServiceTestObjectTool());
                this.mcpServer.addTool(this.testObjectTools.updateSoapWebServiceTestObjectTool());
                ContextHandlerCollection contextCollection = new ContextHandlerCollection(new ContextHandler[0]);
                ServletContextHandler mcpContextHandler = new ServletContextHandler(1);
                mcpContextHandler.setContextPath("/mcp");
                mcpContextHandler.addServlet(new ServletHolder((Servlet)transportProvider), "/*");
                contextCollection.addHandler((Handler)mcpContextHandler);
                OAuthCallbackHandler oauthCallbackHandler = (OAuthCallbackHandler)((Object)((Object)ContextInjectionFactory.make(OAuthCallbackHandler.class, (IEclipseContext)this.eclipseContext)));
                contextCollection.addHandler((Handler)new ContextHandler((Handler)oauthCallbackHandler, "/oauth2/callback"));
                this.jettyServer.setHandler((Handler)contextCollection);
                this.jettyServer.start();
                this.isRunning.set(true);
                logger.info(MessageFormat.format("Katalon Studio MCP server has been started. Streamable HTTP endpoint: {0}", this.getStreamableEndpointUrl()));
            }
            catch (Exception e) {
                logger.error("Failed to start Katalon Studio MCP server", (Throwable)e);
            }
        });
    }

    public void stop() {
        if (!this.isRunning.get()) {
            return;
        }
        logger.info("Stopping Katalon Studio MCP server...");
        try {
            if (this.mcpServer != null) {
                this.mcpServer.close();
            }
            if (this.jettyServer != null) {
                this.jettyServer.stop();
                this.jettyServer.destroy();
            }
            this.isRunning.set(false);
            logger.info("Katalon Studio MCP server stopped successfully");
        }
        catch (Exception e) {
            logger.error("Error while stopping Katalon Studio MCP server", (Throwable)e);
        }
    }

    public boolean isRunning() {
        return this.isRunning.get() && this.jettyServer != null && this.jettyServer.isRunning();
    }

    public String getStreamableEndpointUrl() {
        return MessageFormat.format("http://{0}:{1,number,#}/mcp/stream", this.host, this.port);
    }

    public String getOAuthCallbackUrl() {
        return MessageFormat.format("http://{0}:{1,number,#}/oauth2/callback", this.host, this.port);
    }
}

