/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.mcp.tools;

import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.KeywordController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.repository.WebElementEntity;
import com.kms.katalon.entity.repository.WindowsElementEntity;
import io.modelcontextprotocol.server.McpServerFeatures;
import io.modelcontextprotocol.spec.McpSchema;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.ast.MethodNode;

public class ProjectContextTools {
    public McpServerFeatures.SyncToolSpecification getCustomKeywordsListTool() {
        McpSchema.Tool tool = new McpSchema.Tool("getCustomKeywords", "Get Custom Keywords List", "Retrieves a list of all custom keywords available in the current Katalon Studio project", this.createEmptyInputSchema(), this.createCustomKeywordsOutputSchema(), null, null);
        return McpServerFeatures.SyncToolSpecification.builder().tool(tool).callHandler((exchange, request) -> this.getCustomKeywordsListToolCallHandler()).build();
    }

    public McpServerFeatures.SyncToolSpecification getTestObjectsListTool() {
        McpSchema.Tool tool = new McpSchema.Tool("getTestObjects", "Get Test Objects List", "Retrieves a list of all test objects IDs from the current Katalon Studio project", this.createEmptyInputSchema(), this.createTestObjectsOutputSchema(), null, null);
        return McpServerFeatures.SyncToolSpecification.builder().tool(tool).callHandler((exchange, request) -> this.getTestObjectsListToolCallHandler()).build();
    }

    private McpSchema.CallToolResult getCustomKeywordsListToolCallHandler() {
        boolean isError = false;
        Object resultContent = "";
        List<Object> customKeywords = new ArrayList();
        try {
            customKeywords = this.getCustomKeywordsList();
            resultContent = JsonUtil.toJson(customKeywords);
        }
        catch (Exception e) {
            isError = true;
            resultContent = "Error retrieving custom keywords: " + e.getMessage();
        }
        Map structuredContent = Map.of("results", customKeywords);
        return new McpSchema.CallToolResult(List.of(new McpSchema.TextContent(null, (String)resultContent, null)), Boolean.valueOf(isError), structuredContent, null);
    }

    private McpSchema.CallToolResult getTestObjectsListToolCallHandler() {
        boolean isError = false;
        Object resultContent = "";
        List<Object> testObjectIDs = new ArrayList();
        try {
            testObjectIDs = this.getTestObjectsList();
            resultContent = JsonUtil.toJson(testObjectIDs);
        }
        catch (Exception e) {
            isError = true;
            resultContent = "Error retrieving test objects: " + e.getMessage();
        }
        Map structuredContent = Map.of("results", testObjectIDs);
        return new McpSchema.CallToolResult(List.of(new McpSchema.TextContent(null, (String)resultContent, null)), Boolean.valueOf(isError), structuredContent, null);
    }

    private List<String> getCustomKeywordsList() throws Exception {
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        if (project == null) {
            throw new Exception("No project is currently opened.");
        }
        ArrayList<String> keywordList = new ArrayList<String>();
        List customKeywords = KeywordController.getInstance().getCustomKeywords(project);
        if (customKeywords == null || customKeywords.isEmpty()) {
            return keywordList;
        }
        for (MethodNode keyword : customKeywords) {
            keywordList.add(keyword.getTypeDescriptor());
        }
        return keywordList;
    }

    private List<String> getTestObjectsList() throws Exception {
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        if (project == null) {
            throw new Exception("No project is currently opened.");
        }
        ArrayList<String> testObjectIDList = new ArrayList<String>();
        FolderEntity folder = FolderController.getInstance().getObjectRepositoryRoot(project);
        List descendantEntities = FolderController.getInstance().getAllDescentdantEntities(folder);
        if (descendantEntities == null || descendantEntities.isEmpty()) {
            return testObjectIDList;
        }
        for (Object each : descendantEntities) {
            if (!(each instanceof WebElementEntity) && !(each instanceof WindowsElementEntity)) continue;
            FileEntity entity = (FileEntity)each;
            testObjectIDList.add(entity.getIdForDisplay());
        }
        return testObjectIDList;
    }

    private McpSchema.JsonSchema createEmptyInputSchema() {
        return new McpSchema.JsonSchema("object", Map.of(), List.of(), null, null, null);
    }

    private Map<String, Object> createCustomKeywordsOutputSchema() {
        return Map.of("type", "object", "properties", Map.of("results", Map.of("type", "array", "items", Map.of("type", "string", "description", "Custom keyword descriptor with full method signature"), "description", "List of custom keywords available in the project")), "required", List.of("results"));
    }

    private Map<String, Object> createTestObjectsOutputSchema() {
        return Map.of("type", "object", "properties", Map.of("results", Map.of("type", "array", "items", Map.of("type", "string", "description", "Test object ID"), "description", "List of test object IDs available in the project")), "required", List.of("results"));
    }
}

