/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.mcp.tools.schema;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class TestDataSchema {
    public final String testDataId;
    public final String testDataName;
    public final String description;
    public final String location;

    protected TestDataSchema(String testDataId, String testDataName, String description, String location) {
        this.testDataId = testDataId;
        this.testDataName = testDataName;
        this.description = description;
        this.location = location;
    }

    public abstract String getDriver();

    public abstract Map<String, Object> toSchemaProperties();

    public abstract List<String> getRequiredFields();

    protected Map<String, Object> getBaseProperties() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("testDataId", this.createProperty("string", "Test data entity ID for display (e.g., 'Data Files/LoginData')"));
        properties.put("testDataName", this.createProperty("string", "Test data name"));
        properties.put("description", this.createProperty("string", "Test data description"));
        properties.put("location", this.createProperty("string", "Full file path location"));
        return properties;
    }

    protected Map<String, Object> createProperty(String type, String description) {
        HashMap<String, Object> property = new HashMap<String, Object>();
        property.put("type", type);
        property.put("description", description);
        return property;
    }

    protected Map<String, Object> createConstProperty(String value, String description) {
        HashMap<String, Object> property = new HashMap<String, Object>();
        property.put("const", value);
        property.put("description", description);
        return property;
    }

    protected Map<String, Object> createArrayProperty(String itemType, String description) {
        HashMap<String, Object> property = new HashMap<String, Object>();
        property.put("type", "array");
        property.put("description", description);
        HashMap<String, String> items = new HashMap<String, String>();
        items.put("type", itemType);
        property.put("items", items);
        return property;
    }

    public Map<String, Object> toDataMap() {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("testDataId", this.testDataId);
        dataMap.put("testDataName", this.testDataName);
        dataMap.put("description", this.description);
        dataMap.put("location", this.location);
        dataMap.put("driver", this.getDriver());
        return dataMap;
    }
}

