/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.mcp.tools.schema;

import com.kms.katalon.ai.mcp.enums.TestObjectType;
import com.kms.katalon.ai.mcp.jsonschema.builder.ObjectSchemaBuilder;
import com.kms.katalon.ai.mcp.jsonschema.builder.SchemaBuilder;
import com.kms.katalon.core.enums.mobile.LocatorStrategy;
import com.kms.katalon.core.testobject.SelectorMethod;
import com.kms.katalon.entity.repository.WebElementPropertyEntity;
import com.kms.katalon.entity.repository.WebServiceRequestEntity;
import io.modelcontextprotocol.spec.McpSchema;

public class TestObjectInputSchema {
    public static McpSchema.JsonSchema createSchemaForGetTestObjectTool() {
        return SchemaBuilder.object().property("testObjectId", SchemaBuilder.string("The ID of the test object to retrieve details (e.g., 'Object Repository/Page_Login/btn_Submit')")).required("testObjectId").buildAsMcpJsonSchema();
    }

    public static McpSchema.JsonSchema createSchemaForCreateOrUpdateTestObjectTool(boolean isUpdate, TestObjectType testObjectType, String webServiceRequestType) {
        ObjectSchemaBuilder schemaBuilder = SchemaBuilder.object().property("description", SchemaBuilder.string("The description of the test object (optional)"));
        if (isUpdate) {
            schemaBuilder.property("testObjectId", SchemaBuilder.string("The ID of the test object to update (e.g., 'Object Repository/Page_Login/btn_Submit')"));
            schemaBuilder.required("testObjectId");
        } else {
            schemaBuilder.property("testObjectName", SchemaBuilder.string("The name of the test object to create (e.g., 'btn_Submit'). Test Object Name must start with English letters or numbers, and can mix up with space or any of the following characters: ( ) . , _ -"));
            schemaBuilder.property("folderPath", SchemaBuilder.string("The folder path where the test object will be created (e.g., 'Object Repository/Page_Login' or 'Page_Login'). If not provided, creates in root."));
            schemaBuilder.required("testObjectName");
        }
        switch (testObjectType) {
            case WEB: {
                TestObjectInputSchema.toWebTestObjectSchema(schemaBuilder);
                break;
            }
            case MOBILE: {
                TestObjectInputSchema.toMobileTestObjectSchema(schemaBuilder);
                break;
            }
            case WINDOWS: {
                TestObjectInputSchema.toWindowsTestObjectSchema(schemaBuilder);
                break;
            }
            case WEB_SERVICE: {
                if ("REST".equalsIgnoreCase(webServiceRequestType)) {
                    TestObjectInputSchema.toRestWebServiceTestObjectSchema(schemaBuilder);
                    break;
                }
                if (!"SOAP".equalsIgnoreCase(webServiceRequestType)) break;
                TestObjectInputSchema.toSoapWebServiceTestObjectSchema(schemaBuilder);
            }
        }
        return schemaBuilder.buildAsMcpJsonSchema();
    }

    private static ObjectSchemaBuilder toWebTestObjectSchema(ObjectSchemaBuilder schemaBuilder) {
        return schemaBuilder.property("locatorStrategy", SchemaBuilder.string("The locator strategy for Web Test Object.").enumValues(SelectorMethod.XPATH.toString(), SelectorMethod.CSS.toString(), SelectorMethod.BASIC.getName().toUpperCase(), SelectorMethod.IMAGE.toString(), SelectorMethod.SMART_LOCATOR.toString())).property("locatorValue", SchemaBuilder.string("The locator value is only used for the XPATH, CSS, SMART_LOCATOR locator strategy (e.g., '//button[@id=\"submit\"]' for XPATH, '#submit' for CSS)")).property("imagePath", SchemaBuilder.string("The image path is only used for the IMAGE locator strategy (optional)")).property("useRelativeImagePath", SchemaBuilder.bool("Whether to use relative image path, only used for the IMAGE locator strategy (optional)")).property("elementObjectProperties", SchemaBuilder.array("List of web element object properties, only used for ATTRIBUTES locator strategy.").items(TestObjectInputSchema.createWebElementPropertySchema())).required("locatorStrategy");
    }

    private static ObjectSchemaBuilder toMobileTestObjectSchema(ObjectSchemaBuilder schemaBuilder) {
        return schemaBuilder.property("locatorStrategy", SchemaBuilder.string("The locator strategy for Mobile Test Object").enumValues(LocatorStrategy.ATTRIBUTES.toString(), LocatorStrategy.ACCESSIBILITY.toString(), LocatorStrategy.CLASS_NAME.toString(), LocatorStrategy.ID.toString(), LocatorStrategy.NAME.toString(), LocatorStrategy.XPATH.toString(), LocatorStrategy.IMAGE.toString(), LocatorStrategy.ANDROID_VIEWTAG.toString(), LocatorStrategy.ANDROID_UI_AUTOMATOR.toString(), LocatorStrategy.IOS_PREDICATE_STRING.toString(), LocatorStrategy.IOS_CLASS_CHAIN.toString(), LocatorStrategy.CUSTOM.toString())).property("locatorValue", SchemaBuilder.string("The locator value (e.g., 'com.example:id/button' for ID, '//android.widget.Button' for XPATH)")).required("locatorStrategy", "locatorValue");
    }

    private static ObjectSchemaBuilder toWindowsTestObjectSchema(ObjectSchemaBuilder schemaBuilder) {
        return schemaBuilder.property("locatorStrategy", SchemaBuilder.string("The locator strategy for Windows Test Object").enumValues(com.kms.katalon.core.enums.windows.LocatorStrategy.ACCESSIBILITY_ID.toString(), com.kms.katalon.core.enums.windows.LocatorStrategy.CLASS_NAME.toString(), com.kms.katalon.core.enums.windows.LocatorStrategy.NAME.toString(), com.kms.katalon.core.enums.windows.LocatorStrategy.TAG_NAME.toString(), com.kms.katalon.core.enums.windows.LocatorStrategy.XPATH.toString())).property("locatorValue", SchemaBuilder.string("The locator value (e.g., 'UsernameTextBox' for ACCESSIBILITY_ID, '//Edit[@Name=\"Username\"]' for XPATH")).required("locatorStrategy", "locatorValue");
    }

    private static ObjectSchemaBuilder toRestWebServiceTestObjectSchema(ObjectSchemaBuilder schemaBuilder) {
        return schemaBuilder.property("verificationScript", SchemaBuilder.string("The verification script to validate response (optional)")).property("restUrl", SchemaBuilder.string("The REST API URL")).property("restRequestMethod", SchemaBuilder.string("The HTTP request method for REST service").enumValues(WebServiceRequestEntity.REST_REQUEST_METHODS));
    }

    private static ObjectSchemaBuilder toSoapWebServiceTestObjectSchema(ObjectSchemaBuilder schemaBuilder) {
        return schemaBuilder.property("verificationScript", SchemaBuilder.string("The verification script to validate response (optional)")).property("soapRequestMethod", SchemaBuilder.string("The HTTP request method for SOAP service").enumValues(WebServiceRequestEntity.SOAP_REQUEST_METHODS)).property("soapServiceEndpoint", SchemaBuilder.string("The SOAP service endpoint URL")).property("soapServiceFunction", SchemaBuilder.string("The SOAP service function/operation name")).property("wsdlAddress", SchemaBuilder.string("The WSDL address (optional)")).property("soapBody", SchemaBuilder.string("The SOAP request body content (optional)"));
    }

    private static ObjectSchemaBuilder createWebElementPropertySchema() {
        return SchemaBuilder.object().property("name", SchemaBuilder.string("The property name (e.g., 'id', 'class', 'tag')")).property("value", SchemaBuilder.string("The property value")).property("matchCondition", SchemaBuilder.string("The match condition for the property").enumValues(WebElementPropertyEntity.MATCH_CONDITION.EQUAL.toString(), WebElementPropertyEntity.MATCH_CONDITION.NOT_EQUAL.toString(), WebElementPropertyEntity.MATCH_CONDITION.CONTAINS.toString(), WebElementPropertyEntity.MATCH_CONDITION.NOT_CONTAIN.toString(), WebElementPropertyEntity.MATCH_CONDITION.STARTS_WITH.toString(), WebElementPropertyEntity.MATCH_CONDITION.ENDS_WITH.toString(), WebElementPropertyEntity.MATCH_CONDITION.MATCH_REGEX.toString(), WebElementPropertyEntity.MATCH_CONDITION.NOT_MATCH_REGEX.toString())).required("name", "value", "matchCondition");
    }
}

