/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.preferences;

import com.kms.katalon.ai.core.model.config.GeminiConfig;
import com.kms.katalon.ai.core.model.config.StudioAssistConfig;
import com.kms.katalon.ai.core.model.exception.StudioAssistLoadingConfigException;
import com.kms.katalon.ai.core.model.exception.StudioAssistSavingConfigException;
import com.kms.katalon.ai.preferences.StudioAssistPreferenceStore;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.session.core.model.ManagedGeminiConfig;
import com.kms.katalon.session.core.services.ISessionController;
import jakarta.inject.Inject;
import org.apache.commons.lang3.StringUtils;

public class ManagedGeminiPreferenceStore
extends StudioAssistPreferenceStore {
    @Inject
    private ISessionController sessionController;
    public static String ADMIN_GEMINI_MAX_TOKEN = "admin_gemini_max_token";
    public static String ADMIN_GEMINI_MODEL_NAME = "admin_gemini_model_name";

    @Override
    public StudioAssistConfig getConfig() throws StudioAssistLoadingConfigException {
        try {
            String encodedModelName;
            String modelName;
            ManagedGeminiConfig adminGeminiConfig = (ManagedGeminiConfig)this.sessionController.getAiConfigPolicy().getManagedGeminiAiConfig().orElseThrow(() -> new IllegalStateException("ManagedGeminiConfig is not available"));
            String baseUrl = adminGeminiConfig.getBaseUrl();
            String apiKey = adminGeminiConfig.getApiKey();
            int maxToken = this.store.getInt(ADMIN_GEMINI_MAX_TOKEN);
            if (maxToken < 1) {
                maxToken = 16000;
            }
            if (StringUtils.isBlank((CharSequence)(modelName = this.decode(encodedModelName = this.store.getString(ADMIN_GEMINI_MODEL_NAME))))) {
                modelName = "gemini-2.5-flash";
            }
            return new GeminiConfig(baseUrl, apiKey, modelName, maxToken);
        }
        catch (Exception e) {
            LoggerSingleton.logError((String)"Failed to get config in ManagedGeminiPreference, error: ");
            LoggerSingleton.logError((Throwable)e);
            throw new StudioAssistLoadingConfigException((Throwable)e);
        }
    }

    @Override
    public void saveConfig(StudioAssistConfig credential) throws StudioAssistSavingConfigException {
        try {
            this.store.setValue(ADMIN_GEMINI_MAX_TOKEN, ((GeminiConfig)credential).getMaxToken());
            this.store.setValue(ADMIN_GEMINI_MODEL_NAME, this.encode(((GeminiConfig)credential).getModel()));
            this.store.save();
        }
        catch (Exception e) {
            LoggerSingleton.logError((String)"Failed to save config in ManagedGeminiPreference, error: ");
            LoggerSingleton.logError((Throwable)e);
            throw new StudioAssistSavingConfigException((Throwable)e);
        }
    }
}

