/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.preferences;

import com.kms.katalon.ai.core.model.config.OpenAiCompatibleConfig;
import com.kms.katalon.ai.core.model.config.StudioAssistConfig;
import com.kms.katalon.ai.core.model.exception.StudioAssistLoadingConfigException;
import com.kms.katalon.ai.core.model.exception.StudioAssistSavingConfigException;
import com.kms.katalon.ai.preferences.StudioAssistPreferenceStore;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.session.core.model.ManagedOpenAiCompatibleConfig;
import com.kms.katalon.session.core.services.ISessionController;
import jakarta.inject.Inject;
import org.apache.commons.lang3.StringUtils;

public class ManagedOpenAiCompatiblePreferenceStore
extends StudioAssistPreferenceStore {
    @Inject
    private ISessionController sessionController;
    public static final String ADMIN_OPENAI_COMPATIBLE_MODEL_NAME = "admin_openai_compatible_model_name";
    public static final String ADMIN_OPENAI_COMPATIBLE_MAX_TOKEN = "admin_openai_compatible_max_token";

    @Override
    public StudioAssistConfig getConfig() throws StudioAssistLoadingConfigException {
        try {
            String encodedModelName;
            String modelName;
            ManagedOpenAiCompatibleConfig adminOpenAiConfig = (ManagedOpenAiCompatibleConfig)this.sessionController.getAiConfigPolicy().getManagedOpenAiCompatible().orElseThrow(() -> new IllegalStateException("ManagedOpenAiCompatibleConfig is not available"));
            String baseUrl = (String)StringUtils.defaultIfBlank((CharSequence)adminOpenAiConfig.getBaseUrl(), (CharSequence)"");
            String apiKey = (String)StringUtils.defaultIfBlank((CharSequence)adminOpenAiConfig.getApiKey(), (CharSequence)"");
            String apiKeyHeader = (String)StringUtils.defaultIfBlank((CharSequence)adminOpenAiConfig.getApiKeyHeaderName(), (CharSequence)"");
            int maxToken = this.store.getInt(ADMIN_OPENAI_COMPATIBLE_MAX_TOKEN);
            if (maxToken < 1) {
                maxToken = 16000;
            }
            if (StringUtils.isBlank((CharSequence)(modelName = this.decode(encodedModelName = this.store.getString(ADMIN_OPENAI_COMPATIBLE_MODEL_NAME))))) {
                modelName = "gpt-4.1-mini";
            }
            return new OpenAiCompatibleConfig(baseUrl, apiKey, apiKeyHeader, modelName, maxToken);
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e, (String)"Failed to get config in ManagedOpenAiCompatiblePreference");
            throw new StudioAssistLoadingConfigException((Throwable)e);
        }
    }

    @Override
    public void saveConfig(StudioAssistConfig credential) throws StudioAssistSavingConfigException {
        try {
            this.store.setValue(ADMIN_OPENAI_COMPATIBLE_MAX_TOKEN, ((OpenAiCompatibleConfig)credential).getMaxToken());
            this.store.setValue(ADMIN_OPENAI_COMPATIBLE_MODEL_NAME, this.encode(((OpenAiCompatibleConfig)credential).getModelName()));
            this.store.save();
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e, (String)"Failed to save config in ManagedOpenAiCompatiblePreference");
            throw new StudioAssistSavingConfigException((Throwable)e);
        }
    }
}

