/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.preferences;

import com.kms.katalon.ai.core.model.config.LlmConfigType;
import com.kms.katalon.ai.core.model.config.OpenAIConfig;
import com.kms.katalon.ai.core.model.config.StudioAssistConfig;
import com.kms.katalon.ai.core.model.exception.StudioAssistLoadingConfigException;
import com.kms.katalon.ai.core.model.exception.StudioAssistSavingConfigException;
import com.kms.katalon.ai.preferences.AzureOpenAIPreferenceStore;
import com.kms.katalon.ai.preferences.StudioAssistPreferenceStore;
import java.io.IOException;
import java.security.GeneralSecurityException;

public class OpenAIPreferenceStore
extends StudioAssistPreferenceStore {
    public static String OPENAI_SECRET_KEY = "openai_secret_key";
    public static String OPENAI_MAX_TOKEN = "openai_max_token";
    public static String OPENAI_MODEL_NAME = "openai_model_name";
    public static String OPENAI_ORGANIZATION_ID = "openai_organization_id";

    @Override
    public StudioAssistConfig getConfig() throws StudioAssistLoadingConfigException {
        try {
            String encodedSecretKey = this.store.getString(OPENAI_SECRET_KEY);
            String secretKey = this.decode(encodedSecretKey);
            int maxToken = this.store.getInt(OPENAI_MAX_TOKEN);
            if (maxToken <= 0) {
                maxToken = 16000;
            }
            String encodedOrganizationId = this.store.getString(OPENAI_ORGANIZATION_ID);
            String organizationId = this.decode(encodedOrganizationId);
            String modelName = this.store.getString(OPENAI_MODEL_NAME);
            if (modelName == null || modelName.isBlank()) {
                modelName = OpenAIConfig.DEFAULT_MODEL;
            }
            return new OpenAIConfig(secretKey, maxToken, organizationId, modelName);
        }
        catch (IOException | GeneralSecurityException e) {
            throw new StudioAssistLoadingConfigException((Throwable)e);
        }
    }

    @Override
    public void saveConfig(StudioAssistConfig credential) throws StudioAssistSavingConfigException {
        this.store.setValue(STUDIO_ASSIST_CONFIG_TYPE, LlmConfigType.OPENAI.toString());
        this.store.setValue(AzureOpenAIPreferenceStore.AZURE_API_BASE_URL, "");
        this.store.setValue(AzureOpenAIPreferenceStore.AZURE_API_DEPLOYMENT_NAME, "");
        this.store.setValue(AzureOpenAIPreferenceStore.AZURE_API_API_KEY, "");
        this.store.setValue(AzureOpenAIPreferenceStore.AZURE_API_MAX_TOKEN, 0L);
        try {
            String secretKey = ((OpenAIConfig)credential).getSecretKey();
            this.store.setValue(OPENAI_SECRET_KEY, this.encode(secretKey));
            this.store.setValue(OPENAI_MAX_TOKEN, ((OpenAIConfig)credential).getMaxToken());
            String organizationId = ((OpenAIConfig)credential).getOrganizationId();
            this.store.setValue(OPENAI_ORGANIZATION_ID, this.encode(organizationId));
            this.store.setValue(OPENAI_MODEL_NAME, ((OpenAIConfig)credential).getModelName());
            this.store.save();
        }
        catch (IOException | GeneralSecurityException e) {
            throw new StudioAssistSavingConfigException((Throwable)e);
        }
    }
}

