/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.preferences;

import com.kms.katalon.ai.core.model.config.LlmConfigType;
import com.kms.katalon.ai.core.model.config.OpenAiCompatibleConfig;
import com.kms.katalon.ai.core.model.config.StudioAssistConfig;
import com.kms.katalon.ai.core.model.exception.StudioAssistLoadingConfigException;
import com.kms.katalon.ai.core.model.exception.StudioAssistSavingConfigException;
import com.kms.katalon.ai.preferences.StudioAssistPreferenceStore;
import java.io.IOException;
import java.security.GeneralSecurityException;
import org.apache.commons.lang3.StringUtils;

public class OpenAiCompatiblePreferenceStore
extends StudioAssistPreferenceStore {
    public static final String OPENAI_COMPATIBLE_BASE_URL = "openai_compatible_base_url";
    public static final String OPENAI_COMPATIBLE_API_KEY = "openai_compatible_api_key";
    public static final String OPENAI_COMPATIBLE_API_KEY_HEADER_NAME = "openai_compatible_api_key_header_name";
    public static final String OPENAI_COMPATIBLE_MODEL_NAME = "openai_compatible_model_name";
    public static final String OPENAI_COMPATIBLE_MAX_TOKEN = "openai_compatible_max_token";

    @Override
    public StudioAssistConfig getConfig() throws StudioAssistLoadingConfigException {
        try {
            String encodedBaseUrl = this.store.getString(OPENAI_COMPATIBLE_BASE_URL);
            String baseUrl = this.decode(encodedBaseUrl);
            String encodedApiKey = this.store.getString(OPENAI_COMPATIBLE_API_KEY);
            String apiKey = this.decode(encodedApiKey);
            String encodedApiHeaderName = this.store.getString(OPENAI_COMPATIBLE_API_KEY_HEADER_NAME);
            String apiHeaderName = (String)StringUtils.defaultIfBlank((CharSequence)this.decode(encodedApiHeaderName), (CharSequence)"Authorization");
            String encodedModelName = this.store.getString(OPENAI_COMPATIBLE_MODEL_NAME);
            String modelName = (String)StringUtils.defaultIfBlank((CharSequence)this.decode(encodedModelName), (CharSequence)"gpt-4.1-mini");
            int maxToken = this.store.getInt(OPENAI_COMPATIBLE_MAX_TOKEN);
            if (maxToken <= 0) {
                maxToken = 16000;
            }
            return new OpenAiCompatibleConfig(baseUrl, apiKey, apiHeaderName, modelName, maxToken);
        }
        catch (IOException | GeneralSecurityException e) {
            throw new StudioAssistLoadingConfigException((Throwable)e);
        }
    }

    @Override
    public void saveConfig(StudioAssistConfig credential) throws StudioAssistSavingConfigException {
        this.store.setValue(STUDIO_ASSIST_CONFIG_TYPE, LlmConfigType.OPENAI_COMPATIBLE.toString());
        try {
            OpenAiCompatibleConfig openAiCompatibleConfig = (OpenAiCompatibleConfig)credential;
            String baseUrl = openAiCompatibleConfig.getBaseUrl();
            this.store.setValue(OPENAI_COMPATIBLE_BASE_URL, this.encode(baseUrl));
            String apiKey = openAiCompatibleConfig.getApiKey();
            this.store.setValue(OPENAI_COMPATIBLE_API_KEY, this.encode(apiKey));
            String apiKeyHeaderName = openAiCompatibleConfig.getApiKeyHeaderName();
            this.store.setValue(OPENAI_COMPATIBLE_API_KEY_HEADER_NAME, this.encode(apiKeyHeaderName));
            String modelName = openAiCompatibleConfig.getModelName();
            this.store.setValue(OPENAI_COMPATIBLE_MODEL_NAME, this.encode(modelName));
            this.store.setValue(OPENAI_COMPATIBLE_MAX_TOKEN, openAiCompatibleConfig.getMaxToken());
            this.store.save();
        }
        catch (IOException | GeneralSecurityException e) {
            throw new StudioAssistSavingConfigException((Throwable)e);
        }
    }
}

