/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.preferences;

import com.kms.katalon.ai.core.model.config.AiAutoTagConfig;
import com.kms.katalon.ai.core.model.config.AwsBedrockConfig;
import com.kms.katalon.ai.core.model.config.AzureOpenAIConfig;
import com.kms.katalon.ai.core.model.config.GeminiConfig;
import com.kms.katalon.ai.core.model.config.LlmConfigType;
import com.kms.katalon.ai.core.model.config.NoneConfig;
import com.kms.katalon.ai.core.model.config.OpenAIConfig;
import com.kms.katalon.ai.core.model.config.OpenAiCompatibleConfig;
import com.kms.katalon.ai.core.model.config.StudioAssistConfig;
import com.kms.katalon.ai.core.model.exception.StudioAssistLoadingConfigException;
import com.kms.katalon.ai.core.model.exception.StudioAssistSavingConfigException;
import com.kms.katalon.ai.core.model.exception.StudioAssistUnavailableException;
import com.kms.katalon.ai.core.model.prompt.PromptType;
import com.kms.katalon.ai.core.preferences.IStudioAssistPreferences;
import com.kms.katalon.ai.preferences.AwsBedrockPreferenceStore;
import com.kms.katalon.ai.preferences.AzureOpenAIPreferenceStore;
import com.kms.katalon.ai.preferences.GeminiPreferenceStore;
import com.kms.katalon.ai.preferences.GenAIPreferenceStore;
import com.kms.katalon.ai.preferences.LegacyOpenAIPreferenceStore;
import com.kms.katalon.ai.preferences.ManagedAzureOpenAiPreferenceStore;
import com.kms.katalon.ai.preferences.ManagedGeminiPreferenceStore;
import com.kms.katalon.ai.preferences.ManagedOpenAiCompatiblePreferenceStore;
import com.kms.katalon.ai.preferences.ManagedOpenAiPreferenceStore;
import com.kms.katalon.ai.preferences.NonePreferenceStore;
import com.kms.katalon.ai.preferences.OpenAIPreferenceStore;
import com.kms.katalon.ai.preferences.OpenAiCompatiblePreferenceStore;
import com.kms.katalon.ai.preferences.StudioAssistConsolePreferenceStore;
import com.kms.katalon.ai.preferences.StudioAssistPreferenceStore;
import com.kms.katalon.ai.preferences.UserManagedAiAutoTagSetting;
import com.kms.katalon.core.model.RunningMode;
import com.kms.katalon.core.util.ApplicationRunningMode;
import com.kms.katalon.session.core.model.AiAutoTagPolicyType;
import com.kms.katalon.session.core.model.AiConfigPolicyType;
import com.kms.katalon.session.core.services.ISessionController;
import jakarta.inject.Inject;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class StudioAssistPreferences
implements IStudioAssistPreferences {
    @Inject
    private IEclipseContext eclipseContext;
    @Inject
    private ISessionController sessionController;

    public StudioAssistConfig getConfig() throws StudioAssistLoadingConfigException {
        if (ApplicationRunningMode.get() == RunningMode.CONSOLE) {
            return this.makePreferenceStore(StudioAssistConsolePreferenceStore.class).getConfig();
        }
        AiConfigPolicyType aiConfigPolicyType = this.sessionController.getAiConfigPolicy().getAiConfigPolicyType();
        StudioAssistPreferenceStore store = null;
        block0 : switch (aiConfigPolicyType) {
            case ADMINISTRATION_MANAGED_AZURE_OPENAI: {
                store = this.makePreferenceStore(ManagedAzureOpenAiPreferenceStore.class);
                break;
            }
            case ADMINISTRATION_MANAGED_OPENAI: {
                store = this.makePreferenceStore(ManagedOpenAiPreferenceStore.class);
                break;
            }
            case ADMINISTRATION_MANAGED_GEMINI: {
                store = this.makePreferenceStore(ManagedGeminiPreferenceStore.class);
                break;
            }
            case ADMINISTRATION_MANAGED_OPENAI_COMPATIBLE: {
                store = this.makePreferenceStore(ManagedOpenAiCompatiblePreferenceStore.class);
                break;
            }
            default: {
                LlmConfigType configType = StudioAssistPreferenceStore.getSavedConfigType();
                switch (configType) {
                    case OPENAI: {
                        store = this.makePreferenceStore(OpenAIPreferenceStore.class);
                        break block0;
                    }
                    case AZURE_OPENAI: {
                        store = this.makePreferenceStore(AzureOpenAIPreferenceStore.class);
                        break block0;
                    }
                    case GEN_AI: {
                        store = this.makePreferenceStore(GenAIPreferenceStore.class);
                        break block0;
                    }
                    case GEMINI: {
                        store = this.makePreferenceStore(GeminiPreferenceStore.class);
                        break block0;
                    }
                    case OPENAI_COMPATIBLE: {
                        store = this.makePreferenceStore(OpenAiCompatiblePreferenceStore.class);
                        break block0;
                    }
                    case AWS_BEDROCK: {
                        store = this.makePreferenceStore(AwsBedrockPreferenceStore.class);
                        break block0;
                    }
                    case NONE: {
                        store = this.makePreferenceStore(NonePreferenceStore.class);
                        break block0;
                    }
                }
                store = this.makePreferenceStore(LegacyOpenAIPreferenceStore.class);
            }
        }
        return store.getConfig();
    }

    public void saveConfig(StudioAssistConfig config) throws StudioAssistSavingConfigException {
        AiConfigPolicyType aiConfigPolicyType = this.sessionController.getAiConfigPolicy().getAiConfigPolicyType();
        StudioAssistPreferenceStore store = null;
        switch (aiConfigPolicyType) {
            case ADMINISTRATION_MANAGED_AZURE_OPENAI: {
                store = this.makePreferenceStore(ManagedAzureOpenAiPreferenceStore.class);
                break;
            }
            case ADMINISTRATION_MANAGED_OPENAI: {
                store = this.makePreferenceStore(ManagedOpenAiPreferenceStore.class);
                break;
            }
            case ADMINISTRATION_MANAGED_GEMINI: {
                store = this.makePreferenceStore(ManagedGeminiPreferenceStore.class);
                break;
            }
            case ADMINISTRATION_MANAGED_OPENAI_COMPATIBLE: {
                store = this.makePreferenceStore(ManagedOpenAiCompatiblePreferenceStore.class);
                break;
            }
            default: {
                store = config instanceof OpenAIConfig ? this.makePreferenceStore(OpenAIPreferenceStore.class) : (config instanceof AzureOpenAIConfig ? this.makePreferenceStore(AzureOpenAIPreferenceStore.class) : (config instanceof GeminiConfig ? this.makePreferenceStore(GeminiPreferenceStore.class) : (config instanceof OpenAiCompatibleConfig ? this.makePreferenceStore(OpenAiCompatiblePreferenceStore.class) : (config instanceof AwsBedrockConfig ? this.makePreferenceStore(AwsBedrockPreferenceStore.class) : (config instanceof NoneConfig ? this.makePreferenceStore(NonePreferenceStore.class) : this.makePreferenceStore(GenAIPreferenceStore.class))))));
            }
        }
        ((StudioAssistPreferenceStore)store).saveConfig(config);
    }

    public String getSavedCustomPrompt(PromptType promptType) throws StudioAssistUnavailableException {
        return this.getStore().getCustomPrompt(promptType);
    }

    public void setCustomPromptContentTemplate(PromptType promptType, String promptContent) throws StudioAssistSavingConfigException {
        this.getStore().saveCustomPrompt(promptType, promptContent);
    }

    private StudioAssistPreferenceStore getStore() {
        if (ApplicationRunningMode.get() == RunningMode.CONSOLE) {
            return this.makePreferenceStore(StudioAssistConsolePreferenceStore.class);
        }
        AiConfigPolicyType aiConfigPolicyType = this.sessionController.getAiConfigPolicy() == null ? null : this.sessionController.getAiConfigPolicy().getAiConfigPolicyType();
        switch (aiConfigPolicyType) {
            case ADMINISTRATION_MANAGED_AZURE_OPENAI: {
                return this.makePreferenceStore(ManagedAzureOpenAiPreferenceStore.class);
            }
            case ADMINISTRATION_MANAGED_OPENAI: {
                return this.makePreferenceStore(ManagedOpenAiPreferenceStore.class);
            }
            case ADMINISTRATION_MANAGED_GEMINI: {
                return this.makePreferenceStore(ManagedGeminiPreferenceStore.class);
            }
            case ADMINISTRATION_MANAGED_OPENAI_COMPATIBLE: {
                return this.makePreferenceStore(ManagedOpenAiCompatiblePreferenceStore.class);
            }
        }
        LlmConfigType configType = StudioAssistPreferenceStore.getSavedConfigType();
        switch (configType) {
            case OPENAI: {
                return this.makePreferenceStore(OpenAIPreferenceStore.class);
            }
            case AZURE_OPENAI: {
                return this.makePreferenceStore(AzureOpenAIPreferenceStore.class);
            }
            case GEN_AI: {
                return this.makePreferenceStore(GenAIPreferenceStore.class);
            }
            case OPENAI_COMPATIBLE: {
                return this.makePreferenceStore(OpenAiCompatiblePreferenceStore.class);
            }
            case AWS_BEDROCK: {
                return this.makePreferenceStore(AwsBedrockPreferenceStore.class);
            }
            case NONE: {
                return this.makePreferenceStore(NonePreferenceStore.class);
            }
        }
        return this.makePreferenceStore(LegacyOpenAIPreferenceStore.class);
    }

    public void saveStudioAssistAiAutoTagSetting(AiAutoTagConfig aiAutoTagSetting) throws StudioAssistSavingConfigException {
        AiAutoTagPolicyType taggingPolicyType = this.sessionController.getAdministrationManagedKsSetting().getAiAutoTagging().getType();
        if (taggingPolicyType != AiAutoTagPolicyType.USER_MANAGED_AI_AUTO_TAG) {
            return;
        }
        UserManagedAiAutoTagSetting userSetting = new UserManagedAiAutoTagSetting();
        userSetting.saveConfig(aiAutoTagSetting);
    }

    private <T extends StudioAssistPreferenceStore> T makePreferenceStore(Class<T> storeClass) {
        return (T)((StudioAssistPreferenceStore)ContextInjectionFactory.make(storeClass, (IEclipseContext)this.eclipseContext));
    }
}

