/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.presentation;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.katalon.composer.core.webview.browserfunction.BrowserFunctionUtil;
import com.katalon.network.oauth.core.model.AuthorizationRequest;
import com.kms.katalon.ai.core.IStudioAssistChatListener;
import com.kms.katalon.ai.core.constant.StudioAssistAttachmentSource;
import com.kms.katalon.ai.core.constant.StudioAssistAttachmentStatus;
import com.kms.katalon.ai.core.constant.StudioAssistFileType;
import com.kms.katalon.ai.core.constant.StudioAssistTrackingKeyEnum;
import com.kms.katalon.ai.core.constant.StudioAssistTrackingValueEnum;
import com.kms.katalon.ai.core.context.IAgentSessionContext;
import com.kms.katalon.ai.core.context.IChatSessionContext;
import com.kms.katalon.ai.core.context.IConversationSessionContext;
import com.kms.katalon.ai.core.controller.IAgentController;
import com.kms.katalon.ai.core.controller.IChatController;
import com.kms.katalon.ai.core.controller.IStudioAssistChatController;
import com.kms.katalon.ai.core.controller.IStudioAssistReferenceContextController;
import com.kms.katalon.ai.core.dto.StudioAssistAgentSettingTrackingRequest;
import com.kms.katalon.ai.core.dto.StudioAssistChatRateConversationRequest;
import com.kms.katalon.ai.core.dto.StudioAssistSettingRequest;
import com.kms.katalon.ai.core.dto.StudioAssistToolCallRequest;
import com.kms.katalon.ai.core.event.tracking.AttachmentUsageTrackingEvent;
import com.kms.katalon.ai.core.event.tracking.ChatActionTrackingEvent;
import com.kms.katalon.ai.core.event.tracking.ChatAnswerTrackingEvent;
import com.kms.katalon.ai.core.event.tracking.ChatCloseTrackingEvent;
import com.kms.katalon.ai.core.event.tracking.ChatFileAttachmentTrackingEvent;
import com.kms.katalon.ai.core.event.tracking.ChatOpenTrackingEvent;
import com.kms.katalon.ai.core.event.tracking.ConversationRatingTrackingEvent;
import com.kms.katalon.ai.core.model.agent.AgentConversation;
import com.kms.katalon.ai.core.model.agent.AgentMessage;
import com.kms.katalon.ai.core.model.agent.AgentSetting;
import com.kms.katalon.ai.core.model.agent.McpClient;
import com.kms.katalon.ai.core.model.agent.config.McpHttpServerDefinition;
import com.kms.katalon.ai.core.model.agent.config.McpServerDefinition;
import com.kms.katalon.ai.core.model.agent.config.McpSetting;
import com.kms.katalon.ai.core.model.agent.config.McpSseServerDefinition;
import com.kms.katalon.ai.core.model.agent.event.AgentMessageUpdatedEvent;
import com.kms.katalon.ai.core.model.agent.event.McpClientAuthorizedEvent;
import com.kms.katalon.ai.core.model.agent.event.McpClientUpdatedEvent;
import com.kms.katalon.ai.core.model.chat.AttachmentSource;
import com.kms.katalon.ai.core.model.chat.ChatMode;
import com.kms.katalon.ai.core.model.chat.ChatQuestionMessage;
import com.kms.katalon.ai.core.model.chat.ChatResponseMessage;
import com.kms.katalon.ai.core.model.chat.ConversationSession;
import com.kms.katalon.ai.core.model.chat.FocusingFileAttachment;
import com.kms.katalon.ai.core.model.chat.ResponseMessage;
import com.kms.katalon.ai.core.model.chat.ResponseMessageStatus;
import com.kms.katalon.ai.core.model.chat.StudioAssistChatAttachment;
import com.kms.katalon.ai.core.model.chat.StudioAssistChatPair;
import com.kms.katalon.ai.core.model.chat.StudioAssistChatStatus;
import com.kms.katalon.ai.core.model.chat.StudioAssistConversation;
import com.kms.katalon.ai.core.model.exception.StudioAssistBaseException;
import com.kms.katalon.ai.core.presentation.IStudioAssistChatNavigator;
import com.kms.katalon.ai.core.presentation.IStudioAssistChatView;
import com.kms.katalon.ai.core.presentation.dto.ChatAttachmentDTO;
import com.kms.katalon.ai.core.presentation.dto.ChatAttachmentUploadDTO;
import com.kms.katalon.ai.core.presentation.dto.ChatQuestionMessageDTO;
import com.kms.katalon.ai.core.presentation.dto.MaxedToolCallActionDTO;
import com.kms.katalon.ai.core.presentation.dto.ProcessingStatusDTO;
import com.kms.katalon.ai.core.presentation.dto.RateConversationDTO;
import com.kms.katalon.ai.core.presentation.dto.ToolCallActionDTO;
import com.kms.katalon.ai.core.services.IAgentPreferences;
import com.kms.katalon.ai.core.util.AttachmentUtil;
import com.kms.katalon.ai.presentation.StudioAssistChatView;
import com.kms.katalon.ai.services.AttachmentManager;
import com.kms.katalon.ai.util.TreeEntityFilePathExtractor;
import com.kms.katalon.ai.util.TreeEntityFileTypeResolver;
import com.kms.katalon.application.utils.ApplicationInfo;
import com.kms.katalon.composer.ai.constants.ComposerStudioAssistConstants;
import com.kms.katalon.composer.ai.studioassist.dialog.ImagePreviewOverlayShell;
import com.kms.katalon.composer.ai.studioassist.dialog.McpServerAddingDialog;
import com.kms.katalon.composer.ai.studioassist.dialog.McpToolApprovalResetDialog;
import com.kms.katalon.composer.ai.studioassist.dialog.ProjectFileSelectionDialog;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.components.util.ComponentUtil;
import com.kms.katalon.composer.constant.StudioAssistChatOpenOperationEnum;
import com.kms.katalon.constants.GlobalStringConstants;
import com.kms.katalon.core.setting.StudioAssistSetting;
import com.kms.katalon.session.core.model.Account;
import com.kms.katalon.session.core.model.Session;
import com.kms.katalon.session.core.services.ISessionController;
import com.kms.katalon.webserver.WebViewController;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import java.io.File;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.ProgressAdapter;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Creatable
public class StudioAssistChatNavigator
implements IStudioAssistChatNavigator,
EventHandler {
    private static final Logger logger = LoggerFactory.getLogger(StudioAssistChatNavigator.class);
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private IAgentController agentController;
    @Inject
    IChatController chatController;
    @Inject
    private IConversationSessionContext conversationSessionContext;
    @Inject
    private IStudioAssistChatController studioAssistChatController;
    @Inject
    protected IStudioAssistReferenceContextController referenceContextController;
    @Inject
    private IAgentPreferences agentPreferences;
    @Inject
    private ISessionController sessionController;
    @Inject
    private AttachmentManager attachmentManager;
    protected IAgentSessionContext agentSessionContext;
    protected IChatSessionContext chatSessionContext;
    private final AtomicReference<Browser> mainBrowser = new AtomicReference();
    private IStudioAssistChatView studioAssistChatView;

    @PostConstruct
    public void postConstruct() {
        this.agentSessionContext = this.agentController.createSession();
        this.chatSessionContext = this.chatController.createSession();
        this.eventBroker.subscribe("ON_STUDIO_ASSIST_CONVERSATION_SESSION_UPDATED", (EventHandler)this);
        this.eventBroker.subscribe("PROJECT/OPENED", (EventHandler)this);
        this.eventBroker.subscribe("PROJECT/CLOSED", (EventHandler)this);
        this.eventBroker.subscribe("ON_CHAT_MESSAGE_UPDATED", (EventHandler)this);
        this.eventBroker.subscribe("STUDIOASSIST_AGENT_MESSAGE_UPDATED", (EventHandler)this);
        this.eventBroker.subscribe("ON_FOCUSING_FILE_UPDATED", (EventHandler)this);
        this.eventBroker.subscribe("ON_STUDIO_ASSIST_PROJECT_CONTEXT_UPDATED", (EventHandler)this);
        this.eventBroker.subscribe("ON_TRACKING_OPEN_CHAT_WINDOW", (EventHandler)this);
    }

    @PreDestroy
    public void preDestroy() {
        this.eventBroker.unsubscribe((EventHandler)this);
        this.studioAssistChatView = null;
    }

    public void handleEvent(Event event) {
        switch (event.getTopic()) {
            case "ON_STUDIO_ASSIST_CONVERSATION_SESSION_UPDATED": {
                this.handleConversationSessionUpdated(event);
                break;
            }
            case "ON_CHAT_MESSAGE_UPDATED": {
                this.handleChatMessageUpdated(event);
                break;
            }
            case "STUDIOASSIST_AGENT_MESSAGE_UPDATED": {
                this.handleAgentMessageUpdated(event);
                break;
            }
            case "ON_FOCUSING_FILE_UPDATED": {
                this.handleUpdateAttachments();
                break;
            }
            case "ON_STUDIO_ASSIST_PROJECT_CONTEXT_UPDATED": {
                this.handleProjectContextUpdated();
                break;
            }
            case "ON_TRACKING_OPEN_CHAT_WINDOW": {
                this.onTrackingOpenChatWindow(event);
            }
        }
    }

    public void init(Browser browser) {
        boolean isSessionInitialized;
        this.mainBrowser.set(browser);
        this.registerStudioAssistChatView(browser);
        ConversationSession currentSession = this.conversationSessionContext.getCurrentSession();
        boolean bl = isSessionInitialized = currentSession != null && currentSession.getStatus() != null && currentSession.getStatus() != StudioAssistChatStatus.UNAVAILABLE;
        if (isSessionInitialized) {
            this.restoreSession(currentSession, browser);
        } else {
            CompletableFuture.runAsync(() -> this.conversationSessionContext.initSession()).exceptionally(throwable -> {
                ConversationSession errorSession = new ConversationSession();
                errorSession.setStatus(StudioAssistChatStatus.UNAVAILABLE);
                errorSession.setChatMode(ChatMode.ASK);
                BrowserFunctionUtil.execute((Browser)browser, (String)"studioAssistChatView.openStudioAssistChatView", (Object[])new Object[]{errorSession});
                return null;
            });
        }
    }

    public void close() {
        ChatMode chatMode;
        StudioAssistConversation conversation;
        ConversationSession session = this.conversationSessionContext.getCurrentSession();
        if (session != null && session.getChatMode() != null && (conversation = this.getConversationByChatMode(chatMode = session.getChatMode())) != null) {
            ChatCloseTrackingEvent event = ChatCloseTrackingEvent.builder().conversation(conversation).chatMode(chatMode.getName()).build();
            this.eventBroker.send("STUDIOASSIST_TRACK_CHAT_CLOSE", (Object)event);
        }
        this.chatSessionContext.clearConversation();
        this.agentSessionContext.clearConversation();
        this.agentSessionContext.disposeSession();
        BrowserFunctionUtil.execute((Browser)this.mainBrowser.get(), (String)"studioAssistChatView.closeStudioAssistChatView", (Object[])new Object[0]);
    }

    private void restoreSession(ConversationSession session, Browser browser) {
        List attachments;
        BrowserFunctionUtil.execute((Browser)browser, (String)"studioAssistChatView.openStudioAssistChatView", (Object[])new Object[]{session});
        ChatMode chatMode = session.getChatMode();
        StudioAssistConversation conversation = this.getConversationByChatMode(chatMode);
        if (conversation != null) {
            BrowserFunctionUtil.execute((Browser)browser, (String)"studioAssistChatView.updateConversation", (Object[])new Object[]{conversation});
        }
        if (!(attachments = this.referenceContextController.getCurrentAttachments()).isEmpty()) {
            this.handleUpdateAttachments();
        }
    }

    private void handleConversationSessionUpdated(Event event) {
        Object data = event.getProperty("org.eclipse.e4.data");
        if (data instanceof ConversationSession) {
            ConversationSession session = (ConversationSession)data;
            BrowserFunctionUtil.execute((Browser)this.mainBrowser.get(), (String)"studioAssistChatView.updateStudioAssistConversationSession", (Object[])new Object[]{session});
        }
    }

    private void handleProjectContextUpdated() {
        ChatMode chatMode = this.conversationSessionContext.getCurrentSession().getChatMode();
        if (chatMode.equals((Object)ChatMode.ASK)) {
            BrowserFunctionUtil.execute((Browser)this.mainBrowser.get(), (String)"studioAssistChatView.updateProjectContext", (Object[])new Object[]{this.chatSessionContext.getProjectContexts()});
        } else if (chatMode.equals((Object)ChatMode.AGENT)) {
            BrowserFunctionUtil.execute((Browser)this.mainBrowser.get(), (String)"studioAssistChatView.updateProjectContext", (Object[])new Object[]{List.of()});
        }
    }

    private void handleProjectClosed() {
        ChatMode chatMode = this.conversationSessionContext.getCurrentSession().getChatMode();
        if (chatMode.equals((Object)ChatMode.ASK)) {
            BrowserFunctionUtil.execute((Browser)this.mainBrowser.get(), (String)"studioAssistChatView.updateProjectContext", (Object[])new Object[]{this.chatSessionContext.getProjectContexts()});
        } else if (chatMode.equals((Object)ChatMode.AGENT)) {
            BrowserFunctionUtil.execute((Browser)this.mainBrowser.get(), (String)"studioAssistChatView.updateProjectContext", (Object[])new Object[]{List.of()});
        }
    }

    private void registerStudioAssistChatView(final Browser browser) {
        this.studioAssistChatView = new StudioAssistChatView();
        this.studioAssistChatView.init(browser);
        this.studioAssistChatView.addListener(new IStudioAssistChatListener(){

            public void onStudioAssistChatViewOpened() {
                ChatMode chatMode = StudioAssistChatNavigator.this.conversationSessionContext.getCurrentSession().getChatMode();
                if (chatMode.equals((Object)ChatMode.ASK)) {
                    BrowserFunctionUtil.execute((Browser)browser, (String)"studioAssistChatView.updateProjectContext", (Object[])new Object[]{StudioAssistChatNavigator.this.chatSessionContext.getProjectContexts()});
                }
                CompletableFuture.runAsync(() -> StudioAssistChatNavigator.this.conversationSessionContext.studioAssistChatViewOpened()).exceptionally(throwable -> {
                    ConversationSession errorSession = new ConversationSession();
                    errorSession.setStatus(StudioAssistChatStatus.UNAVAILABLE);
                    errorSession.setChatMode(ChatMode.ASK);
                    BrowserFunctionUtil.execute((Browser)browser, (String)"studioAssistChatView.updateStudioAssistConversationSession", (Object[])new Object[]{errorSession});
                    return null;
                });
            }

            public void onAskQuestion(ChatQuestionMessageDTO questionMessage) {
                List<StudioAssistChatAttachment> attachments = StudioAssistChatNavigator.this.loadAttachmentContents(questionMessage.getAttachments());
                ChatMode chatMode = StudioAssistChatNavigator.this.conversationSessionContext.getCurrentSession().getChatMode();
                String conversationId = StudioAssistChatNavigator.this.getConversationIdByChatMode(chatMode);
                ChatQuestionMessage question = new ChatQuestionMessage(questionMessage.getMessageId(), questionMessage.getContent(), attachments);
                StudioAssistChatNavigator.this.handleSendMessage(question, false);
                StudioAssistChatNavigator.this.trackStudioAssistAction(StudioAssistTrackingValueEnum.SEND_QUESTION.getValue(), question.getMessageId());
                if (!attachments.isEmpty()) {
                    StudioAssistChatNavigator.this.eventBroker.post("STUDIOASSIST_TRACK_ATTACHMENT_USAGE", (Object)AttachmentUsageTrackingEvent.create((String)conversationId, (String)question.getMessageId(), attachments, (String)chatMode.getName()));
                }
            }

            public void onRetryMessage(ChatQuestionMessageDTO questionMessage) {
                List<StudioAssistChatAttachment> attachments = StudioAssistChatNavigator.this.loadAttachmentContents(questionMessage.getAttachments());
                ChatQuestionMessage question = new ChatQuestionMessage(questionMessage.getMessageId(), questionMessage.getContent(), attachments);
                StudioAssistChatNavigator.this.handleSendMessage(question, true);
                ChatMode chatMode = StudioAssistChatNavigator.this.conversationSessionContext.getCurrentSession().getChatMode();
                StudioAssistChatNavigator.this.trackStudioAssistAction(StudioAssistTrackingValueEnum.RETRY.getValue(), question.getMessageId());
                if (!attachments.isEmpty()) {
                    StudioAssistChatNavigator.this.eventBroker.post("STUDIOASSIST_TRACK_ATTACHMENT_USAGE", (Object)AttachmentUsageTrackingEvent.create((String)StudioAssistChatNavigator.this.getConversationIdByChatMode(chatMode), (String)questionMessage.getMessageId(), attachments, (String)chatMode.getName()));
                }
            }

            public void onOpenStudioAssistSetting() {
                StudioAssistChatNavigator.this.trackStudioAssistAction(StudioAssistTrackingValueEnum.OPEN_SETTINGS.getValue());
                StudioAssistChatNavigator.this.eventBroker.post("KATALON/PREFERENCES", (Object)"com.kms.katalon.composer.preferences.GeneralPreferencePage/com.kms.katalon.composer.ai");
            }

            public void onChatModeChange(ChatMode chatMode) {
                StudioAssistChatNavigator.this.conversationSessionContext.changeChatMode(chatMode);
                BrowserFunctionUtil.execute((Browser)browser, (String)"studioAssistChatView.updateConversation", (Object[])new Object[]{StudioAssistChatNavigator.this.getConversationByChatMode(chatMode)});
                StudioAssistChatNavigator.this.trackStudioAssistAction(String.format(StudioAssistTrackingValueEnum.SWITCH_MODE.getValue(), chatMode.getName().toLowerCase()));
            }

            public void onClearConversation() {
                StudioAssistChatNavigator.this.referenceContextController.clear();
                ChatMode chatMode = StudioAssistChatNavigator.this.conversationSessionContext.getCurrentSession().getChatMode();
                if (chatMode.equals((Object)ChatMode.AGENT)) {
                    StudioAssistChatNavigator.this.agentSessionContext.clearConversation();
                } else {
                    StudioAssistChatNavigator.this.chatSessionContext.clearConversation();
                }
                BrowserFunctionUtil.execute((Browser)browser, (String)"studioAssistChatView.updateConversation", (Object[])new Object[]{StudioAssistChatNavigator.this.getConversationByChatMode(chatMode)});
                StudioAssistChatNavigator.this.trackStudioAssistAction(StudioAssistTrackingValueEnum.CLEAR_CONVERSATION.getValue());
            }

            public void onRateAnswer(RateConversationDTO rate) {
                ChatMode chatMode = StudioAssistChatNavigator.this.conversationSessionContext.getCurrentSession().getChatMode();
                StudioAssistConversation conversation = StudioAssistChatNavigator.this.getConversationByChatMode(chatMode);
                if (conversation != null) {
                    StudioAssistChatPair chatPair = conversation.getValidChatItems().stream().filter(item -> item instanceof StudioAssistChatPair).map(item -> (StudioAssistChatPair)item).filter(item -> rate.getMessageId().equals(item.getRequest().getMessageId())).findFirst().orElse(null);
                    if (chatPair != null && chatPair.getResponse() != null) {
                        ResponseMessage answer = chatPair.getResponse();
                        if (answer instanceof ChatResponseMessage) {
                            ((ChatResponseMessage)answer).setRated(true);
                        } else if (answer instanceof AgentMessage) {
                            ((AgentMessage)answer).setRated(true);
                        }
                        chatPair.setResponse(answer);
                        BrowserFunctionUtil.execute((Browser)browser, (String)"studioAssistChatView.updateConversation", (Object[])new Object[]{conversation});
                    }
                    String conversationId = StudioAssistChatNavigator.this.getConversationIdByChatMode(chatMode);
                    StudioAssistChatRateConversationRequest conversationRateRequest = new StudioAssistChatRateConversationRequest();
                    conversationRateRequest.setLatestQuestionId(rate.getMessageId());
                    conversationRateRequest.setThumb(rate.isHelpful());
                    conversationRateRequest.setConversationId(conversationId);
                    StudioAssistChatNavigator.this.eventBroker.post("STUDIOASSIST_TRACK_CONVERSATION_RATING", (Object)ConversationRatingTrackingEvent.create((StudioAssistChatRateConversationRequest)conversationRateRequest, (StudioAssistConversation)conversation, (ChatMode)chatMode));
                }
            }

            public void approveToolCall(ToolCallActionDTO toolCallAction) {
                if (StudioAssistChatNavigator.this.conversationSessionContext.getCurrentSession().getChatMode().equals((Object)ChatMode.ASK)) {
                    return;
                }
                AgentMessage agentMessage = StudioAssistChatNavigator.this.agentSessionContext.findAgentMessageById(toolCallAction.getMessageId());
                StudioAssistChatNavigator.this.agentSessionContext.approveToolCall(agentMessage, toolCallAction.getApproval());
            }

            public void denyToolCall(ToolCallActionDTO toolCallAction) {
                if (StudioAssistChatNavigator.this.conversationSessionContext.getCurrentSession().getChatMode().equals((Object)ChatMode.ASK)) {
                    return;
                }
                AgentMessage agentMessage = StudioAssistChatNavigator.this.agentSessionContext.findAgentMessageById(toolCallAction.getMessageId());
                StudioAssistChatNavigator.this.agentSessionContext.denyToolCall(agentMessage);
            }

            public void acknowledgeMaxedToolCall(MaxedToolCallActionDTO maxedToolCallAction) {
                if (StudioAssistChatNavigator.this.conversationSessionContext.getCurrentSession().getChatMode().equals((Object)ChatMode.ASK)) {
                    return;
                }
                AgentMessage agentMessage = StudioAssistChatNavigator.this.agentSessionContext.findAgentMessageById(maxedToolCallAction.getMessageId());
                StudioAssistChatNavigator.this.agentSessionContext.acknowledgeMaxedToolCall(agentMessage);
            }

            public void rejectMaxedToolCall(MaxedToolCallActionDTO maxedToolCallAction) {
                if (StudioAssistChatNavigator.this.conversationSessionContext.getCurrentSession().getChatMode().equals((Object)ChatMode.ASK)) {
                    return;
                }
                AgentMessage agentMessage = StudioAssistChatNavigator.this.agentSessionContext.findAgentMessageById(maxedToolCallAction.getMessageId());
                StudioAssistChatNavigator.this.agentSessionContext.rejectMaxedToolCall(agentMessage);
            }

            public void stopGeneration(String messageId) {
                ChatMode chatMode = StudioAssistChatNavigator.this.conversationSessionContext.getCurrentSession().getChatMode();
                if (chatMode.equals((Object)ChatMode.AGENT)) {
                    AgentMessage agentMessage = StudioAssistChatNavigator.this.agentSessionContext.findAgentMessageById(messageId);
                    StudioAssistChatNavigator.this.agentSessionContext.stopGeneration(agentMessage);
                } else {
                    ChatResponseMessage chatMessage = StudioAssistChatNavigator.this.chatSessionContext.findAnswerMessageById(messageId);
                    if (chatMessage == null) {
                        chatMessage = new ChatResponseMessage(messageId);
                    }
                    StudioAssistChatNavigator.this.chatSessionContext.stopGeneration(chatMessage);
                }
                StudioAssistChatNavigator.this.trackStudioAssistAction(StudioAssistTrackingValueEnum.STOP_GENERATING.getValue(), messageId);
            }

            public void onUploadAttachments(ChatAttachmentUploadDTO attachment) {
                List<StudioAssistChatAttachment> newAttachments = switch (attachment.getAttachmentSource()) {
                    case AttachmentSource.PROJECT -> StudioAssistChatNavigator.this.handleUploadAttachmentsFromProject();
                    case AttachmentSource.EXTERNAL -> StudioAssistChatNavigator.this.handleUploadAttachmentsFromExternal();
                    default -> throw new IncompatibleClassChangeError();
                };
                StudioAssistChatNavigator.this.referenceContextController.addAttachments(newAttachments);
                StudioAssistChatNavigator.this.handleUpdateAttachments();
                StudioAssistChatNavigator.this.trackStudioAssistAction(StudioAssistTrackingValueEnum.UPLOAD_ATTACHMENT.getValue());
            }

            public void onRemoveAttachment(String filePath) {
                StudioAssistChatNavigator.this.referenceContextController.removeAttachment(filePath);
                StudioAssistChatNavigator.this.handleUpdateAttachments();
                StudioAssistChatNavigator.this.trackStudioAssistAction(StudioAssistTrackingValueEnum.REMOVE_ATTACHMENT.getValue());
            }

            public void onNavigateBackToChat() {
                try {
                    final Browser browser2 = StudioAssistChatNavigator.this.mainBrowser.get();
                    if (browser2 == null || browser2.isDisposed()) {
                        return;
                    }
                    browser2.addProgressListener((ProgressListener)new ProgressAdapter(){

                        public void completed(ProgressEvent event) {
                            browser2.removeProgressListener((ProgressListener)this);
                            Display.getDefault().asyncExec(() -> StudioAssistChatNavigator.this.init(browser2));
                        }
                    });
                    URIBuilder uriBuilder = WebViewController.getInstance().buildURIBuilder("StudioAssistChat.html");
                    String url = uriBuilder.toString();
                    browser2.setUrl(url);
                }
                catch (Exception e) {
                    logger.error("Exception while navigating back to StudioAssist chat", (Throwable)e);
                }
            }

            public void onClickFollowUpQuestion(ChatQuestionMessageDTO questionMessageDTO) {
                ChatQuestionMessage question = new ChatQuestionMessage(questionMessageDTO.getMessageId(), questionMessageDTO.getContent(), List.of());
                StudioAssistChatNavigator.this.handleSendMessage(question, false);
                StudioAssistChatNavigator.this.trackStudioAssistAction(StudioAssistTrackingValueEnum.CLICK_FOLLOW_UP.getValue());
            }

            public void onCopyMessage(String messageId) {
                StudioAssistChatNavigator.this.trackStudioAssistAction(StudioAssistTrackingValueEnum.COPY_ANSWER.getValue());
            }

            public void onCopyCodeBlock(String messageId) {
                StudioAssistChatNavigator.this.trackStudioAssistAction(StudioAssistTrackingValueEnum.COPY_CODE.getValue());
            }

            public void onRequestAiAccess() {
                try {
                    String myServerUrl = ApplicationInfo.getMyServerUrl();
                    Session session = StudioAssistChatNavigator.this.sessionController.getSession();
                    Account account = session.getAccount();
                    String accountId = String.valueOf(account.getId());
                    String url = "%s/enable-ai-settings?accountId=%s".formatted(myServerUrl, accountId);
                    ComponentUtil.triggerLink((String)url);
                    StudioAssistChatNavigator.this.trackStudioAssistAction(StudioAssistTrackingValueEnum.REQUEST_ACCESS.getValue());
                }
                catch (Exception e) {
                    logger.error("Exception while handle ON_CHAT_REQUEST_AI_ACCESS event", (Throwable)e);
                }
            }

            public void onReloadChatView() {
                StudioAssistChatNavigator.this.init(browser);
            }

            public void onPasteAttachmentFromClipboard() {
                List<StudioAssistChatAttachment> attachments = StudioAssistChatNavigator.this.attachmentManager.createImageAttachmentsFromClipboard(AttachmentUtil::checkAttachmentStatus);
                if (attachments.isEmpty()) {
                    return;
                }
                StudioAssistChatNavigator.this.referenceContextController.addAttachments(attachments);
                StudioAssistChatNavigator.this.handleUpdateAttachments();
            }

            public void onPreviewAttachment(String filePath) {
                File file = new File(filePath);
                if (file.exists()) {
                    Image image = new Image((Device)Display.getCurrent(), filePath);
                    ImagePreviewOverlayShell overlay = new ImagePreviewOverlayShell(Display.getCurrent());
                    overlay.setPreviewContent(image);
                    overlay.open();
                } else {
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Preview Attachment", (String)"The file does not exist or has been moved.");
                }
            }

            public void onClickFileAttachment() {
                StudioAssistChatNavigator.this.eventBroker.post("STUDIOASSIST_FILE_ATTACHMENT", (Object)ChatFileAttachmentTrackingEvent.builder().chatMode(StudioAssistChatNavigator.this.conversationSessionContext.getCurrentSession().getChatMode()).build());
            }
        });
    }

    private List<StudioAssistChatAttachment> handleUploadAttachmentsFromProject() {
        this.eventBroker.post("STUDIOASSIST_FILE_ATTACHMENT", (Object)ChatFileAttachmentTrackingEvent.builder().chatMode(this.conversationSessionContext.getCurrentSession().getChatMode()).attachmentSource(AttachmentSource.PROJECT).build());
        try {
            ProjectFileSelectionDialog dialog = new ProjectFileSelectionDialog(Display.getCurrent().getActiveShell());
            dialog.open();
            ArrayList<StudioAssistChatAttachment> attachments = new ArrayList<StudioAssistChatAttachment>();
            if (dialog.getReturnCode() == 0) {
                List selectedEntities = dialog.getSelectedItems();
                for (ITreeEntity entity : selectedEntities) {
                    String filePath = TreeEntityFilePathExtractor.extractFilePath(entity);
                    StudioAssistFileType fileType = TreeEntityFileTypeResolver.resolveFileType(entity.getClass().getSimpleName(), filePath);
                    StudioAssistChatAttachment attachment = this.attachmentManager.createProjectFileAttachment(filePath, fileType, (arg_0, arg_1) -> ((IStudioAssistReferenceContextController)this.referenceContextController).validateAttachment(arg_0, arg_1));
                    if (attachment == null) continue;
                    attachments.add(attachment);
                }
                return attachments;
            }
        }
        catch (Exception e) {
            logger.error("Error uploading attachments from project", (Throwable)e);
        }
        return Collections.emptyList();
    }

    private List<StudioAssistChatAttachment> handleUploadAttachmentsFromExternal() {
        this.eventBroker.post("STUDIOASSIST_FILE_ATTACHMENT", (Object)ChatFileAttachmentTrackingEvent.builder().chatMode(this.conversationSessionContext.getCurrentSession().getChatMode()).attachmentSource(AttachmentSource.EXTERNAL).build());
        FileDialog dialog = new FileDialog(Display.getCurrent().getActiveShell(), 2);
        dialog.open();
        if (dialog.getFileNames() == null) {
            return Collections.emptyList();
        }
        ArrayList<String> filePaths = new ArrayList<String>();
        Path currentPath = Path.of(dialog.getFilterPath(), new String[0]);
        String[] stringArray = dialog.getFileNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName;
            String filePath = fileName = stringArray[n2];
            if (!new File(fileName).exists()) {
                Path pathToFile = currentPath.resolve(fileName);
                filePath = pathToFile.toString();
            }
            filePaths.add(filePath);
            ++n2;
        }
        return this.attachmentManager.createExternalFileAttachments(filePaths, AttachmentUtil::checkAttachmentStatus);
    }

    private void handleSendMessage(ChatQuestionMessage question, boolean isRetry) {
        ChatMode chatMode = this.conversationSessionContext.getCurrentSession().getChatMode();
        String conversationId = this.getConversationIdByChatMode(chatMode);
        CompletableFuture.supplyAsync(() -> {
            this.handleUpdateProcessingStatus(conversationId, question);
            return null;
        }).thenRun(() -> {
            CompletableFuture future;
            if (chatMode.equals((Object)ChatMode.AGENT)) {
                future = isRetry ? this.agentSessionContext.retryMessage(question) : this.agentSessionContext.sendMessage(question);
                AgentConversation conversation = this.agentSessionContext.getConversation();
                BrowserFunctionUtil.execute((Browser)this.mainBrowser.get(), (String)"studioAssistChatView.updateConversation", (Object[])new Object[]{conversation});
            } else {
                future = isRetry ? this.chatSessionContext.retryMessage(question) : this.chatSessionContext.sendMessage(question);
                StudioAssistConversation conversation = this.chatSessionContext.getConversation();
                BrowserFunctionUtil.execute((Browser)this.mainBrowser.get(), (String)"studioAssistChatView.updateConversation", (Object[])new Object[]{conversation});
            }
            future.thenRun(this::cleanUpAttachments);
        });
    }

    private void cleanUpAttachments() {
        try {
            List currentAttachments = this.referenceContextController.getCurrentAttachments();
            StudioAssistChatAttachment focusingFile = currentAttachments.stream().filter(a -> a.getFileSource() == StudioAssistAttachmentSource.FOCUSING_FILE).findFirst().orElse(null);
            this.referenceContextController.clearAttachments();
            if (focusingFile != null && new File(focusingFile.getFilePath()).exists()) {
                this.referenceContextController.setFocusingFile(focusingFile);
            }
            this.handleUpdateAttachments();
        }
        catch (Exception e) {
            logger.error("Error clearing attachments after send", (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Inject
    @Optional
    private void checkFocusingFile(@UIEventTopic(value="EXPLORER/SET_SELECTED_ITEM") Object object) {
        if (!(object instanceof ITreeEntity)) {
            this.referenceContextController.setFocusingFile(null);
            this.handleUpdateAttachments();
            return;
        }
        ITreeEntity iTreeEntity = (ITreeEntity)object;
        try {
            void treeEntity;
            String filePath = TreeEntityFilePathExtractor.extractFilePath((ITreeEntity)treeEntity);
            FocusingFileAttachment focusingFile = this.attachmentManager.createFocusingFileAttachment(filePath, TreeEntityFileTypeResolver.resolveFileType(treeEntity.getClass().getSimpleName(), filePath));
            if (focusingFile != null) {
                StudioAssistChatAttachment loadedAttachment = this.referenceContextController.loadAttachmentContent((StudioAssistChatAttachment)focusingFile);
                if (loadedAttachment != null) {
                    this.referenceContextController.setFocusingFile(loadedAttachment);
                    this.handleUpdateAttachments();
                }
            } else {
                this.referenceContextController.setFocusingFile(null);
                this.handleUpdateAttachments();
            }
        }
        catch (Exception e) {
            logger.error("Error handling focusing file update", (Throwable)e);
            this.referenceContextController.setFocusingFile(null);
            this.handleUpdateAttachments();
        }
    }

    private void handleUpdateAttachments() {
        Browser browser = this.mainBrowser.get();
        if (browser == null || browser.isDisposed()) {
            return;
        }
        try {
            List currentAttachments = this.referenceContextController.getCurrentAttachments();
            List<ChatAttachmentDTO> attachmentDTOs = currentAttachments.stream().map(ChatAttachmentDTO::from).toList();
            BrowserFunctionUtil.execute((Browser)browser, (String)"studioAssistChatView.uploadChatAttachments", (Object[])new Object[]{attachmentDTOs});
        }
        catch (Exception e) {
            logger.error("Error broadcasting attachments to webview", (Throwable)e);
        }
    }

    private void handleUpdateProcessingStatus(String conversationId, ChatQuestionMessage question) {
        boolean shouldAnalyzeFile;
        this.updateProcessingStatus(ProcessingStatusDTO.Status.SYNC_CONTEXT, conversationId, question.getMessageId());
        ChatMode chatMode = this.conversationSessionContext.getCurrentSession().getChatMode();
        boolean bl = shouldAnalyzeFile = chatMode == ChatMode.ASK && !this.chatSessionContext.getProjectContexts().isEmpty() || !question.getAttachments().isEmpty();
        if (shouldAnalyzeFile) {
            this.updateProcessingStatus(ProcessingStatusDTO.Status.ANALYZE_FILE, conversationId, question.getMessageId());
        }
        this.updateProcessingStatus(ProcessingStatusDTO.Status.GENERATE_RESPONSE, conversationId, question.getMessageId());
    }

    private void generateFollowUpQuestions(ChatMode chatMode, String conversationId, String questionMessageId) {
        if (!StudioAssistSetting.isFollowUpQuestionEnabled()) {
            return;
        }
        if (chatMode.equals((Object)ChatMode.AGENT)) {
            try {
                this.agentSessionContext.getFollowUpQuestions(conversationId, questionMessageId);
            }
            catch (StudioAssistBaseException e) {
                logger.error("agentSessionContext.getFollowUpQuestions(conversationId, questionMessageId);", (Throwable)e);
            }
        } else {
            this.chatSessionContext.getFollowUpQuestions(conversationId, questionMessageId).exceptionally(throwable -> {
                logger.error("Error generating follow-up questions", throwable);
                return null;
            });
        }
    }

    private void updateProcessingStatus(ProcessingStatusDTO.Status status, String conversationId, String questionMessageId) {
        ProcessingStatusDTO dto = new ProcessingStatusDTO(status, conversationId, questionMessageId);
        BrowserFunctionUtil.execute((Browser)this.mainBrowser.get(), (String)"studioAssistChatView.updateProcessingStatus", (Object[])new Object[]{dto});
    }

    private void handleChatMessageUpdated(Event event) {
        Object data = event.getProperty("org.eclipse.e4.data");
        if (data instanceof ResponseMessage) {
            ResponseMessage answerMessage = (ResponseMessage)data;
            StudioAssistConversation conversation = this.chatSessionContext.getConversation();
            if (answerMessage instanceof ChatResponseMessage) {
                ChatResponseMessage chatMessage = (ChatResponseMessage)answerMessage;
                if (chatMessage.getStatus().equals((Object)ResponseMessageStatus.COMPLETED)) {
                    this.generateFollowUpQuestions(ChatMode.ASK, conversation.getConversationId(), answerMessage.getMessageId());
                }
                this.eventBroker.post("STUDIOASSIST_TRACK_CHAT_ANSWER", (Object)ChatAnswerTrackingEvent.builder().responseMessage((ResponseMessage)chatMessage).conversationId(conversation.getConversationId()).build());
            }
            this.updateProcessingStatus(ProcessingStatusDTO.Status.COMPLETED, conversation.getConversationId(), answerMessage.getMessageId());
            BrowserFunctionUtil.execute((Browser)this.mainBrowser.get(), (String)"studioAssistChatView.updateConversation", (Object[])new Object[]{conversation});
        }
    }

    private void handleAgentMessageUpdated(Event event) {
        Object data = event.getProperty("org.eclipse.e4.data");
        if (data instanceof AgentMessageUpdatedEvent) {
            AgentMessageUpdatedEvent agentEvent = (AgentMessageUpdatedEvent)data;
            AgentMessage agentMessage = agentEvent.getMessage();
            AgentConversation conversation = this.agentSessionContext.getConversation();
            if (agentMessage.isFinished()) {
                this.updateProcessingStatus(ProcessingStatusDTO.Status.COMPLETED, conversation.getConversationId(), agentMessage.getMessageId());
                this.generateFollowUpQuestions(ChatMode.AGENT, conversation.getConversationId(), agentMessage.getMessageId());
                this.eventBroker.post("STUDIOASSIST_TRACK_CHAT_ANSWER", (Object)ChatAnswerTrackingEvent.builder().responseMessage((ResponseMessage)agentMessage).conversationId(conversation.getConversationId()).build());
            }
            BrowserFunctionUtil.execute((Browser)this.mainBrowser.get(), (String)"studioAssistChatView.updateConversation", (Object[])new Object[]{conversation});
        }
    }

    private List<StudioAssistChatAttachment> loadAttachmentContents(List<ChatAttachmentDTO> attachmentDTOs) {
        if (attachmentDTOs == null || attachmentDTOs.isEmpty()) {
            return List.of();
        }
        ArrayList<StudioAssistChatAttachment> loadedAttachments = new ArrayList<StudioAssistChatAttachment>();
        for (ChatAttachmentDTO dto : attachmentDTOs) {
            try {
                StudioAssistChatAttachment attachment = new StudioAssistChatAttachment(StudioAssistFileType.valueOf((String)dto.fileType()), dto.filePath(), StudioAssistAttachmentStatus.valueOf((String)dto.status()), StudioAssistAttachmentSource.valueOf((String)dto.fileSource()));
                StudioAssistChatAttachment loadedAttachment = this.referenceContextController.loadAttachmentContent(attachment);
                if (loadedAttachment == null) continue;
                loadedAttachments.add(loadedAttachment);
            }
            catch (Exception e) {
                logger.warn("Error loading attachment {}: {}", (Object)dto.filePath(), (Object)e.getMessage());
            }
        }
        return loadedAttachments;
    }

    private StudioAssistConversation getConversationByChatMode(ChatMode chatMode) {
        if (chatMode.equals((Object)ChatMode.ASK)) {
            return this.chatSessionContext.getConversation();
        }
        if (chatMode.equals((Object)ChatMode.AGENT)) {
            return this.agentSessionContext.getConversation();
        }
        return null;
    }

    private String getConversationIdByChatMode(ChatMode chatMode) {
        if (chatMode.equals((Object)ChatMode.ASK)) {
            return this.chatSessionContext.getConversation().getConversationId();
        }
        if (chatMode.equals((Object)ChatMode.AGENT)) {
            return this.agentSessionContext.getConversation().getConversationId();
        }
        return null;
    }

    private void trackStudioAssistAction(String action) {
        this.trackStudioAssistAction(action, null);
    }

    private void trackStudioAssistAction(String action, String messageId) {
        ChatMode chatMode = this.conversationSessionContext.getCurrentSession().getChatMode();
        ChatActionTrackingEvent.Builder trackingData = ChatActionTrackingEvent.builder().action(action).conversationId(this.getConversationIdByChatMode(chatMode)).chatMode(chatMode.getName());
        if (messageId != null) {
            trackingData.questionId(messageId);
        }
        if (chatMode.equals((Object)ChatMode.AGENT)) {
            trackingData.agentSessionContext(this.agentSessionContext);
        }
        this.eventBroker.post("STUDIOASSIST_TRACK_CHAT_ACTION", (Object)trackingData.build());
    }

    @Inject
    @Optional
    private void onAddMcpServer(@UIEventTopic(value="ON_STUDIO_ASSIST_ADD_MCP_SERVER") StudioAssistSettingRequest request) {
        try {
            this.trackStudioAssistAgentSettingAction(StudioAssistTrackingValueEnum.ADD_MCP_SERVER.getValue());
            BundleContext bundleContext = FrameworkUtil.getBundle(McpServerAddingDialog.class).getBundleContext();
            IEclipseContext context = EclipseContextFactory.getServiceContext((BundleContext)bundleContext);
            McpServerAddingDialog dialog = new McpServerAddingDialog(Display.getCurrent().getActiveShell());
            ContextInjectionFactory.inject((Object)dialog, (IEclipseContext)context);
            int result = dialog.open();
            if (result == 0) {
                McpServerDefinition server = dialog.getServer();
                this.agentSessionContext.addServer(server);
            }
        }
        catch (Exception e) {
            logger.error("Exception while handle ON_STUDIO_ASSIST_ADD_MCP_SERVER event", (Throwable)e);
        }
    }

    @Inject
    @Optional
    private void openMcpSetting(@UIEventTopic(value="ON_STUDIO_ASSIST_OPEN_MCP_SETTING") StudioAssistSettingRequest request) {
        try {
            this.trackStudioAssistAgentSettingAction(StudioAssistTrackingValueEnum.CLICK_TOOL_SETTING.getValue());
            URIBuilder uriBuilder = WebViewController.getInstance().buildURIBuilder("StudioAssistSetting.html");
            String url = uriBuilder.toString();
            this.mainBrowser.get().setUrl(url);
        }
        catch (Exception e) {
            logger.error("Exception while handle ON_STUDIO_ASSIST_OPEN_MCP_SETTING event", (Throwable)e);
        }
    }

    @Inject
    @Optional
    private void updateMcpClients(@UIEventTopic(value="ON_STUDIO_ASSIST_SETTING_OPENED") StudioAssistSettingRequest request) {
        this.updateMcpClients();
    }

    @Inject
    @Optional
    private void toolSelected(@UIEventTopic(value="ON_STUDIO_ASSIST_SELECT_TOOL") StudioAssistSettingRequest request) {
        try {
            String serverName = request.getServerName();
            String toolId = request.getToolName();
            this.agentSessionContext.selectTool(serverName, toolId);
        }
        catch (Exception e) {
            logger.error("Exception while handle ON_STUDIO_ASSIST_SELECT_TOOL event", (Throwable)e);
        }
    }

    @Inject
    @Optional
    private void toolDeselected(@UIEventTopic(value="ON_STUDIO_ASSIST_DESELECT_TOOL") StudioAssistSettingRequest request) {
        try {
            String serverName = request.getServerName();
            String toolId = request.getToolName();
            this.agentSessionContext.deselectTool(serverName, toolId);
        }
        catch (Exception e) {
            logger.error("Exception while handle ON_STUDIO_ASSIST_DESELECT_TOOL event", (Throwable)e);
        }
    }

    @Inject
    @Optional
    private void allToolsSelected(@UIEventTopic(value="ON_STUDIO_ASSIST_SELECT_ALL_TOOLS") StudioAssistSettingRequest request) {
        try {
            String serverName = request.getServerName();
            this.agentSessionContext.selectAllTools(serverName);
        }
        catch (Exception e) {
            logger.error("Exception while handle ON_STUDIO_ASSIST_SELECT_ALL_TOOLS event", (Throwable)e);
        }
    }

    @Inject
    @Optional
    private void allToolsDeselected(@UIEventTopic(value="ON_STUDIO_ASSIST_DESELECT_ALL_TOOLS") StudioAssistSettingRequest request) {
        try {
            String serverName = request.getServerName();
            this.agentSessionContext.deselectAllTools(serverName);
        }
        catch (Exception e) {
            logger.error("Exception while handle ON_STUDIO_ASSIST_DESELECT_ALL_TOOLS event", (Throwable)e);
        }
    }

    @Inject
    @Optional
    private void maxToolCallRequested(@UIEventTopic(value="ON_STUDIO_ASSIST_MAX_TOOL_CALL") StudioAssistSettingRequest request) {
        try {
            String value = request.getValue();
            AgentSetting agentSetting = this.agentPreferences.loadAgentSetting();
            agentSetting.setMaxToolCalls(Integer.parseInt(value));
            this.agentPreferences.saveAgentSetting(agentSetting);
        }
        catch (Exception e) {
            logger.error("Exception while handle ON_STUDIO_ASSIST_MAX_TOOL_CALL event", (Throwable)e);
        }
    }

    @Inject
    @Optional
    private void autoToolApprovalRequested(@UIEventTopic(value="ON_STUDIO_ASSIST_AUTO_TOOL_APPROVAL") StudioAssistSettingRequest request) {
        try {
            String value = request.getValue();
            AgentSetting agentSetting = this.agentPreferences.loadAgentSetting();
            agentSetting.setAutoToolApproval(Boolean.parseBoolean(value));
            this.agentPreferences.saveAgentSetting(agentSetting);
        }
        catch (Exception e) {
            logger.error("Exception while handle ON_STUDIO_ASSIST_AUTO_TOOL_APPROVAL event", (Throwable)e);
        }
    }

    @Inject
    @Optional
    private void openMcpToolApprovalReset(@UIEventTopic(value="ON_STUDIO_ASSIST_RESET_TOOL_APPROVAL") StudioAssistSettingRequest request) {
        try {
            this.trackStudioAssistAgentSettingAction(StudioAssistTrackingValueEnum.RESET_TOOL_APPROVAL.getValue());
            BundleContext bundleContext = FrameworkUtil.getBundle(McpToolApprovalResetDialog.class).getBundleContext();
            IEclipseContext context = EclipseContextFactory.getServiceContext((BundleContext)bundleContext);
            McpSetting mcpSetting = this.agentSessionContext.getMcpSetting();
            McpToolApprovalResetDialog dialog = new McpToolApprovalResetDialog(Display.getCurrent().getActiveShell(), mcpSetting);
            ContextInjectionFactory.inject((Object)dialog, (IEclipseContext)context);
            int result = dialog.open();
            if (result == 0) {
                AgentSetting agentSetting = dialog.getAgentSetting();
                List mcpServerSettings = agentSetting.getMcpServerSettings();
                this.agentSessionContext.resetApprovedTools(mcpServerSettings);
                this.updateMcpClients();
                this.trackMcpToolApprovalReset(dialog.getNoOfResetTools());
            }
        }
        catch (Exception e) {
            logger.error("Exception while handle ON_STUDIO_ASSIST_RESET_TOOL_APPROVAL event", (Throwable)e);
            this.showErrorDialog(GlobalStringConstants.ERROR, ComposerStudioAssistConstants.DIALOG_MCP_RESET_APPROVED_TOOL_FAILED_TO_OPEN_THE_DIALOG);
        }
    }

    private void trackMcpToolApprovalReset(int noOfResetTools) {
        HashMap<String, Object> trackingData = new HashMap<String, Object>();
        trackingData.put(StudioAssistTrackingKeyEnum.NUMBER_OF_SUCCESSFUL_TOOL_RESET.getValue(), noOfResetTools);
        this.trackStudioAssistAgentSetting(trackingData);
    }

    @Inject
    @Optional
    private void onMcpClientAdded(@UIEventTopic(value="ON_MCP_CLIENT_ADDED") McpServerDefinition server) {
        this.updateMcpClients();
    }

    @Inject
    @Optional
    private void onMcpClientStatusChanged(@UIEventTopic(value="STUDIOASSIST_MCP_CLIENT_UPDATED") McpClientUpdatedEvent event) {
        String mcpClientJson = this.mcpClientToJson(event.getClient());
        try {
            this.mainBrowser.get().evaluate(this.prepareEvaluationUpdateMcpClientScript(mcpClientJson));
        }
        catch (SWTException sWTException) {}
    }

    @Inject
    @Optional
    private void onServerRefreshed(@UIEventTopic(value="ON_STUDIO_ASSIST_AUTO_REFRESH_SERVER") StudioAssistSettingRequest request) {
        this.trackStudioAssistAgentSettingAction(StudioAssistTrackingValueEnum.RELOAD_MCP_SERVER.getValue());
        String serverName = request.getServerName();
        this.agentSessionContext.refreshClient(serverName);
    }

    @Inject
    @Optional
    private void onServerDeleted(@UIEventTopic(value="ON_STUDIO_ASSIST_AUTO_DELETE_SERVER") StudioAssistSettingRequest request) {
        this.trackStudioAssistAgentSettingAction(StudioAssistTrackingValueEnum.DELETE_MCP_SERVER.getValue());
        String serverName = request.getServerName();
        McpSetting mcpSetting = this.agentPreferences.loadMcpSetting();
        McpServerDefinition serverDefinition = mcpSetting.getServers().stream().filter(server -> serverName.equals(server.getName())).findFirst().orElse(null);
        String serverTitle = serverDefinition != null ? serverDefinition.getTitle() : "";
        String serverUrl = "";
        if (serverDefinition instanceof McpHttpServerDefinition) {
            McpHttpServerDefinition httpServer = (McpHttpServerDefinition)serverDefinition;
            serverUrl = httpServer.getUrl();
        } else if (serverDefinition instanceof McpSseServerDefinition) {
            McpSseServerDefinition sseServer = (McpSseServerDefinition)serverDefinition;
            serverUrl = sseServer.getUrl();
        }
        boolean hasTitle = StringUtils.isNotBlank((CharSequence)serverTitle);
        String detailedMessage = MessageFormat.format(ComposerStudioAssistConstants.DIALOG_MCP_SERVER_DELETE_MESSAGE, hasTitle ? serverTitle : serverName);
        String serverDisplayName = hasTitle ? String.format("%s: %s (%s)", serverName, serverTitle, serverUrl) : String.format("%s (%s)", serverName, serverUrl);
        String warningQuestion = MessageFormat.format(ComposerStudioAssistConstants.DIALOG_MCP_SERVER_DELETE_WARNING, serverDisplayName);
        String fullMessage = detailedMessage + "\n" + warningQuestion;
        MessageDialog dialog = new MessageDialog(Display.getCurrent().getActiveShell(), ComposerStudioAssistConstants.DIALOG_MCP_SERVER_DELETE_TITLE, null, fullMessage, 3, new String[]{ComposerStudioAssistConstants.DIALOG_MCP_SERVER_CANCEL_BUTTON_LABEL, ComposerStudioAssistConstants.DIALOG_MCP_SERVER_REMOVE_BUTTON_LABEL}, 1){

            protected void createButtonsForButtonBar(Composite parent) {
                super.createButtonsForButtonBar(parent);
                Button removeButton = this.getButton(1);
                if (removeButton != null) {
                    removeButton.setBackground(ColorUtil.REMOVE_BUTTON_COLOR);
                    removeButton.setForeground(ColorUtil.WHITE_COLOR);
                }
            }
        };
        if (dialog.open() == 1) {
            this.agentSessionContext.removeServer(serverName);
            this.updateMcpClients();
        }
    }

    @Inject
    @Optional
    private void onServerEnabled(@UIEventTopic(value="ON_STUDIO_ASSIST_ENABLE_SERVER") StudioAssistSettingRequest request) {
        try {
            String serverName = request.getServerName();
            this.agentSessionContext.enableServer(serverName);
            this.updateMcpClients();
        }
        catch (Exception e) {
            logger.error("Exception while handle ON_STUDIO_ASSIST_ENABLE_SERVER event", (Throwable)e);
        }
    }

    @Inject
    @Optional
    private void onServerDisabled(@UIEventTopic(value="ON_STUDIO_ASSIST_DISABLE_SERVER") StudioAssistSettingRequest request) {
        try {
            String serverName = request.getServerName();
            this.agentSessionContext.disableServer(serverName);
            this.updateMcpClients();
        }
        catch (Exception e) {
            logger.error("Exception while handle ON_STUDIO_ASSIST_DISABLE_SERVER event", (Throwable)e);
        }
    }

    @Inject
    @Optional
    private void onServerAuthorizationRequested(@UIEventTopic(value="ON_STUDIO_ASSIST_AUTHORIZE_SERVER") StudioAssistSettingRequest request) {
        try {
            String serverName = request.getServerName();
            AuthorizationRequest authRequest = this.agentSessionContext.requestServerAuthorization(serverName);
            if (authRequest != null) {
                Program.launch((String)authRequest.getUri().toString());
            }
        }
        catch (Exception e) {
            logger.error("Exception while handle ON_STUDIO_ASSIST_AUTHORIZE_SERVER event", (Throwable)e);
        }
    }

    @Inject
    @Optional
    private void onServerAuthorized(@UIEventTopic(value="STUDIOASSIST_MCP_CLIENT_AUTHORIZED") McpClientAuthorizedEvent event) {
        try {
            this.agentSessionContext.authorizeClient(event.getState(), event.getAuthorizationCode());
        }
        catch (Exception e) {
            logger.error("Exception while handle ON_STUDIO_ASSIST_AUTHORIZE_SERVER event", (Throwable)e);
        }
    }

    private void updateMcpClients() {
        List mcpClients = this.agentSessionContext.getMcpClients();
        McpSetting mcpSetting = this.agentSessionContext.getMcpSetting();
        AgentSetting agentSetting = this.agentPreferences.loadAgentSetting();
        String mcpClientsJson = this.mcpClientstoJson(mcpClients);
        String mcpSettingJson = mcpSetting.toJson();
        String agentSettingJson = agentSetting.toJson();
        this.mainBrowser.get().evaluate(this.prepareEvaluationUpdateMcpClientsScript(mcpClientsJson, mcpSettingJson, agentSettingJson));
    }

    @Inject
    @Optional
    private void approveToolCall(@UIEventTopic(value="ON_STUDIO_ASSIST_APPROVE_TOOL_CALL") StudioAssistToolCallRequest request) {
        try {
            AgentMessage agentMessage = this.agentSessionContext.findAgentMessageById(request.getMessageId());
            if (agentMessage == null) {
                logger.error("AgentMessage not found for messageId: " + request.getMessageId());
                return;
            }
            this.agentSessionContext.approveToolCall(agentMessage, request.getApproval());
        }
        catch (Exception e) {
            logger.error("Exception while handle ON_STUDIO_ASSIST_APPROVE_TOOL_CALL event", (Throwable)e);
        }
    }

    @Inject
    @Optional
    private void denyToolCall(@UIEventTopic(value="ON_STUDIO_ASSIST_DENY_TOOL_CALL") StudioAssistToolCallRequest request) {
        try {
            AgentMessage agentMessage = this.agentSessionContext.findAgentMessageById(request.getMessageId());
            if (agentMessage == null) {
                logger.error("AgentMessage not found for messageId: " + request.getMessageId());
                return;
            }
            this.agentSessionContext.denyToolCall(agentMessage);
        }
        catch (Exception e) {
            logger.error("Exception while handle ON_STUDIO_ASSIST_DENY_TOOL_CALL event", (Throwable)e);
        }
    }

    @Inject
    @Optional
    private void acknowledgeMaxedToolCall(@UIEventTopic(value="ON_STUDIO_ASSIST_ACKNOWLEDGE_MAXED_TOOL_CALL") StudioAssistToolCallRequest request) {
        try {
            AgentMessage agentMessage = this.agentSessionContext.findAgentMessageById(request.getMessageId());
            if (agentMessage == null) {
                logger.error("AgentMessage not found for messageId: " + request.getMessageId());
                return;
            }
            this.agentSessionContext.acknowledgeMaxedToolCall(agentMessage);
        }
        catch (Exception e) {
            logger.error("Exception while handle ON_STUDIO_ASSIST_ACKNOWLEDGE_MAXED_TOOL_CALL event", (Throwable)e);
        }
    }

    @Inject
    @Optional
    private void rejectMaxedToolCall(@UIEventTopic(value="ON_STUDIO_ASSIST_REJECT_MAXED_TOOL_CALL") StudioAssistToolCallRequest request) {
        try {
            AgentMessage agentMessage = this.agentSessionContext.findAgentMessageById(request.getMessageId());
            if (agentMessage == null) {
                logger.error("AgentMessage not found for messageId: " + request.getMessageId());
                return;
            }
            this.agentSessionContext.rejectMaxedToolCall(agentMessage);
        }
        catch (Exception e) {
            logger.error("Exception while handle ON_STUDIO_ASSIST_REJECT_MAXED_TOOL_CALL event", (Throwable)e);
        }
    }

    @Inject
    @Optional
    private void handleTrackAgentSetting(@UIEventTopic(value="ON_STUDIO_ASSIST_AGENT_SETTING_TRACKING") StudioAssistAgentSettingTrackingRequest request) {
        try {
            if (Objects.isNull(request) || Objects.isNull(request.getTrackingData())) {
                return;
            }
            this.trackStudioAssistAgentSetting(request.getTrackingData());
        }
        catch (Exception e) {
            logger.error("Failed to process tracking agent setting", (Throwable)e);
        }
    }

    @Inject
    @Optional
    private void onStudioAssistTracking(@UIEventTopic(value="ON_STUDIO_ASSIST_TRACKING") List<Object> trackingData) {
        if (this.isAgentModeTracking(trackingData)) {
            this.studioAssistChatController.addAgentModeTrackingData(trackingData, this.agentSessionContext);
        }
        trackingData.add(StudioAssistTrackingKeyEnum.CHAT_MODE.getValue());
        trackingData.add(this.conversationSessionContext.getCurrentSession().getChatMode().name());
        this.studioAssistChatController.trackStudioAssistChat(trackingData);
    }

    private void onTrackingOpenChatWindow(Event event) {
        Object data = event.getProperty("org.eclipse.e4.data");
        if (data instanceof StudioAssistChatOpenOperationEnum) {
            StudioAssistChatOpenOperationEnum operation = (StudioAssistChatOpenOperationEnum)data;
            StudioAssistChatStatus validateFunctionAvailability = this.studioAssistChatController.validateFunctionAvailability();
            String operationStr = operation.toString();
            String availabilityStr = validateFunctionAvailability.toString();
            String chatMode = null;
            chatMode = this.conversationSessionContext.getUserPreference().getCurrentChatMode() != null ? this.conversationSessionContext.getUserPreference().getCurrentChatMode().getName().toLowerCase() : ChatMode.ASK.getName().toLowerCase();
            this.eventBroker.post("STUDIOASSIST_TRACK_CHAT_OPEN", (Object)new ChatOpenTrackingEvent(operationStr, availabilityStr, chatMode));
        }
    }

    private boolean isAgentModeTracking(List<Object> trackingData) {
        int index = trackingData.indexOf(StudioAssistTrackingKeyEnum.CHAT_MODE.getValue());
        if (index < 0) {
            return false;
        }
        if (index + 1 < trackingData.size()) {
            Object chatMode = trackingData.get(index + 1);
            return chatMode != null && chatMode instanceof String && String.valueOf(chatMode).equalsIgnoreCase(ChatMode.AGENT.name());
        }
        return false;
    }

    private void trackStudioAssistAgentSettingAction(Object data) {
        HashMap<String, Object> trackingData = new HashMap<String, Object>();
        trackingData.put(StudioAssistTrackingKeyEnum.STUDIOASSIST_MCP_SETTING_ACTION.getValue(), data);
        this.trackStudioAssistAgentSetting(trackingData);
    }

    private void trackStudioAssistAgentSetting(Map<String, Object> trackingData) {
        this.studioAssistChatController.trackStudioAssistAgentSetting(trackingData);
    }

    private void showErrorDialog(String title, String message) {
        UISynchronizeService.asyncExec(() -> MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)title, (String)message));
    }

    private String mcpClientToJson(McpClient mcpClient) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            return mapper.writeValueAsString((Object)mcpClient);
        }
        catch (Exception exception) {
            return "{}";
        }
    }

    private String prepareEvaluationUpdateMcpClientScript(String mcpClientJson) {
        String script = "updateMcpClient('%s');".formatted(StringEscapeUtils.escapeEcmaScript((String)mcpClientJson));
        return script;
    }

    private String mcpClientstoJson(List<McpClient> mcpClients) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            return mapper.writeValueAsString(mcpClients);
        }
        catch (Exception exception) {
            return "[]";
        }
    }

    private String prepareEvaluationUpdateMcpClientsScript(String mcpClientsJson, String mcpSettingJson, String agentSettingJson) {
        String script = "updateMcpClients('%s', '%s', '%s');".formatted(StringEscapeUtils.escapeEcmaScript((String)mcpClientsJson), StringEscapeUtils.escapeEcmaScript((String)mcpSettingJson), StringEscapeUtils.escapeEcmaScript((String)agentSettingJson));
        logger.trace("prepareEvaluationUpdateMcpClientsScript -> " + script);
        return script;
    }
}

