/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.repository;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.kms.katalon.ai.core.model.preference.StudioAssistUserPreference;
import com.kms.katalon.ai.core.repository.IStudioAssistUserPreferenceRepository;
import com.kms.katalon.application.utils.ApplicationContext;
import com.kms.katalon.constants.GlobalStringConstants;
import java.io.File;
import java.util.Objects;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Creatable
public class StudioAssistUserPreferenceRepository
implements IStudioAssistUserPreferenceRepository {
    private static final Logger logger = LoggerFactory.getLogger(StudioAssistUserPreferenceRepository.class);
    private static final String USER_PREFERENCE_FILE = GlobalStringConstants.STUDIO_ASSIST_FOLDER_PATH + File.separator + "userPreference.json";
    private StudioAssistUserPreference currentUserPreferences;

    public StudioAssistUserPreferenceRepository() {
        this.loadPreferences();
    }

    public StudioAssistUserPreference getUserPreference() {
        String currentUserEmail = ApplicationContext.getInstance().getUserId();
        if (currentUserEmail == null || currentUserEmail.isEmpty()) {
            return this.createDefaultPreferences();
        }
        this.loadPreferences();
        return Objects.requireNonNullElseGet(this.currentUserPreferences, this::createDefaultPreferences);
    }

    public void saveUserPreference(StudioAssistUserPreference preferences) {
        if (preferences == null) {
            return;
        }
        this.currentUserPreferences = preferences;
        this.savePreferencesToFile();
    }

    private void loadPreferences() {
        try {
            StudioAssistUserPreference preferences;
            JsonNode preferencesNode;
            String currentUserEmail;
            File preferencesFile = new File(USER_PREFERENCE_FILE);
            this.currentUserPreferences = this.createDefaultPreferences();
            if (!preferencesFile.exists()) {
                return;
            }
            ObjectMapper mapper = this.createObjectMapper();
            JsonNode rootNode = mapper.readTree(preferencesFile);
            if (rootNode.has(currentUserEmail = ApplicationContext.getInstance().getUserId()) && (preferencesNode = rootNode.get(currentUserEmail)).isObject() && (preferences = (StudioAssistUserPreference)mapper.readValue(preferencesNode.toString(), StudioAssistUserPreference.class)) != null) {
                this.currentUserPreferences = preferences;
            }
        }
        catch (Exception e) {
            this.currentUserPreferences = this.createDefaultPreferences();
            logger.error("Error loading Studio Assist user preferences: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void savePreferencesToFile() {
        try {
            JsonNode existingNode;
            if (this.currentUserPreferences == null) {
                return;
            }
            File preferencesFile = new File(USER_PREFERENCE_FILE);
            File parentDir = preferencesFile.getParentFile();
            if (parentDir != null && !parentDir.exists()) {
                parentDir.mkdirs();
            }
            ObjectMapper mapper = this.createObjectMapper();
            ObjectNode rootNode = mapper.createObjectNode();
            if (preferencesFile.exists() && (existingNode = mapper.readTree(preferencesFile)).isObject()) {
                rootNode = (ObjectNode)existingNode;
            }
            String currentUserEmail = ApplicationContext.getInstance().getUserId();
            ObjectNode preferencesNode = (ObjectNode)mapper.valueToTree((Object)this.currentUserPreferences);
            rootNode.set(currentUserEmail, (JsonNode)preferencesNode);
            mapper.writerWithDefaultPrettyPrinter().writeValue(preferencesFile, (Object)rootNode);
        }
        catch (Exception e) {
            logger.error("Error saving Studio Assist user preferences: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private ObjectMapper createObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, true);
        return mapper;
    }

    private StudioAssistUserPreference createDefaultPreferences() {
        return new StudioAssistUserPreference();
    }
}

