/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.services;

import com.kms.katalon.ai.core.constant.StudioAssistAttachmentSource;
import com.kms.katalon.ai.core.constant.StudioAssistAttachmentStatus;
import com.kms.katalon.ai.core.constant.StudioAssistFileType;
import com.kms.katalon.ai.core.model.chat.ExternalFileAttachment;
import com.kms.katalon.ai.core.model.chat.FocusingFileAttachment;
import com.kms.katalon.ai.core.model.chat.ProjectFileAttachment;
import com.kms.katalon.ai.core.model.chat.StudioAssistChatAttachment;
import com.kms.katalon.ai.core.services.IAttachmentManager;
import com.kms.katalon.ai.util.ImageAttachmentUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.ImageTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Creatable
public class AttachmentManager
implements IAttachmentManager {
    private static final String TEMP_IMAGE_PREFIX = "clipboard_image_";
    private static final String TEMP_IMAGE_SUFFIX = ".png";
    private static final String TEMP_DIR = System.getProperty("java.io.tmpdir");
    private static final Logger logger = LoggerFactory.getLogger(AttachmentManager.class);

    public FocusingFileAttachment createFocusingFileAttachment(String filePath, StudioAssistFileType fileType) {
        if (StringUtils.isBlank((CharSequence)filePath)) {
            return null;
        }
        FocusingFileAttachment attachment = new FocusingFileAttachment();
        attachment.setFileType(fileType);
        attachment.setFilePath(filePath);
        attachment.setStatus(StudioAssistAttachmentStatus.VALID);
        return attachment;
    }

    public StudioAssistChatAttachment createProjectFileAttachment(String filePath, StudioAssistFileType fileType, IAttachmentManager.AttachmentValidator attachmentValidator) {
        ProjectFileAttachment attachment = new ProjectFileAttachment();
        attachment.setFileType(fileType);
        attachment.setFilePath(filePath);
        attachment.setFileSource(StudioAssistAttachmentSource.ATTACHMENT);
        try {
            attachment.setStatus(attachmentValidator.validate(filePath, fileType));
        }
        catch (Exception exception) {
            attachment.setStatus(StudioAssistAttachmentStatus.UNSUPPORTED);
        }
        return attachment;
    }

    public List<StudioAssistChatAttachment> createExternalFileAttachments(List<String> filePaths, IAttachmentManager.AttachmentStatusChecker attachmentStatusChecker) {
        if (filePaths == null || filePaths.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<StudioAssistChatAttachment> attachments = new ArrayList<StudioAssistChatAttachment>();
        for (String filePath : filePaths) {
            if (StringUtils.isBlank((CharSequence)filePath)) continue;
            StudioAssistFileType fileType = ImageAttachmentUtil.isImageFile(filePath) ? StudioAssistFileType.IMAGE : StudioAssistFileType.OTHER;
            ExternalFileAttachment attachment = new ExternalFileAttachment();
            attachment.setFileType(fileType);
            attachment.setFilePath(filePath);
            attachment.setFileSource(StudioAssistAttachmentSource.ATTACHMENT);
            attachment.setStatus(attachmentStatusChecker.checkStatus(filePath, fileType));
            attachments.add((StudioAssistChatAttachment)attachment);
        }
        return attachments;
    }

    public List<StudioAssistChatAttachment> createImageAttachmentsFromClipboard(IAttachmentManager.AttachmentStatusChecker statusChecker) {
        Clipboard clipboard = new Clipboard(Display.getCurrent());
        ArrayList<StudioAssistChatAttachment> attachments = new ArrayList<StudioAssistChatAttachment>();
        try {
            String tempImagePath;
            String[] filePaths = (String[])clipboard.getContents((Transfer)FileTransfer.getInstance());
            if (filePaths != null && filePaths.length > 0) {
                String[] stringArray = filePaths;
                int n = filePaths.length;
                int n2 = 0;
                while (n2 < n) {
                    String filePath = stringArray[n2];
                    if (ImageAttachmentUtil.isImageFile(filePath)) {
                        ExternalFileAttachment attachment = new ExternalFileAttachment();
                        attachment.setFileType(StudioAssistFileType.IMAGE);
                        attachment.setFilePath(filePath);
                        attachment.setFileSource(StudioAssistAttachmentSource.ATTACHMENT);
                        attachment.setStatus(statusChecker.checkStatus(filePath, StudioAssistFileType.IMAGE));
                        attachments.add((StudioAssistChatAttachment)attachment);
                    }
                    ++n2;
                }
                ArrayList<StudioAssistChatAttachment> arrayList = attachments;
                return arrayList;
            }
            ImageData imageData = null;
            if (clipboard.getContents((Transfer)ImageTransfer.getInstance()) != null) {
                imageData = (ImageData)clipboard.getContents((Transfer)ImageTransfer.getInstance());
            }
            if ((tempImagePath = this.saveImageDataToTempFile(imageData)) == null) {
                ArrayList<StudioAssistChatAttachment> arrayList = attachments;
                return arrayList;
            }
            ExternalFileAttachment attachment = new ExternalFileAttachment();
            attachment.setFileType(StudioAssistFileType.IMAGE);
            attachment.setFilePath(tempImagePath);
            attachment.setFileSource(StudioAssistAttachmentSource.ATTACHMENT);
            attachment.setStatus(statusChecker.checkStatus(tempImagePath, StudioAssistFileType.IMAGE));
            attachments.add((StudioAssistChatAttachment)attachment);
        }
        finally {
            clipboard.dispose();
        }
        return attachments;
    }

    private String saveImageDataToTempFile(ImageData imageData) {
        if (imageData == null) {
            return null;
        }
        FileOutputStream fos = null;
        try {
            String tempFilePath = File.createTempFile(TEMP_IMAGE_PREFIX, TEMP_IMAGE_SUFFIX, new File(TEMP_DIR)).getAbsolutePath();
            ImageLoader imageLoader = new ImageLoader();
            imageLoader.data = new ImageData[]{imageData};
            File tempFile = new File(tempFilePath);
            fos = new FileOutputStream(tempFile);
            imageLoader.save((OutputStream)fos, 5);
            String string = tempFilePath;
            return string;
        }
        catch (Exception e) {
            logger.error("Failed to save image data to temporary file", (Throwable)e);
            return null;
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    logger.error("Failed to close file output stream", (Throwable)e);
                }
            }
        }
    }
}

