/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.services;

import com.kms.katalon.ai.core.controller.IStudioAssistReferenceContextController;
import com.kms.katalon.ai.core.event.tracking.ChatErrorTrackingEvent;
import com.kms.katalon.ai.core.model.chat.ChatMode;
import com.kms.katalon.ai.core.model.chat.ChatQuestionMessage;
import com.kms.katalon.ai.core.model.chat.ChatResponseMessage;
import com.kms.katalon.ai.core.model.chat.ChatSession;
import com.kms.katalon.ai.core.model.chat.FollowUpQuestion;
import com.kms.katalon.ai.core.model.chat.ResponseMessage;
import com.kms.katalon.ai.core.model.chat.ResponseMessageStatus;
import com.kms.katalon.ai.core.model.chat.StudioAssistChatAnswerMessage;
import com.kms.katalon.ai.core.model.chat.StudioAssistChatPair;
import com.kms.katalon.ai.core.model.prompt.PromptType;
import com.kms.katalon.ai.core.retry.StudioAssistRetryPolicy;
import com.kms.katalon.ai.core.services.IChatManager;
import com.kms.katalon.ai.core.services.IStudioAssistService;
import dev.failsafe.Failsafe;
import dev.failsafe.Policy;
import dev.failsafe.RetryPolicy;
import jakarta.inject.Inject;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.stream.Collectors;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Creatable
public class ChatManager
implements IChatManager {
    private static final Logger logger = LoggerFactory.getLogger(ChatManager.class);
    @Inject
    private IStudioAssistService studioAssistService;
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private IStudioAssistReferenceContextController referenceContextController;

    public CompletableFuture<ResponseMessage> sendMessage(ChatSession session, ChatQuestionMessage question) {
        StudioAssistChatPair chatPair = session.appendChatItem(question, true);
        if (chatPair == null) {
            return CompletableFuture.completedFuture(null);
        }
        this.handleReferenceContexts(session, session.getConversation().getConversationId(), question.getMessageId());
        return this.generateAnswer(session, question).thenApply(response -> {
            chatPair.setResponse(response);
            return response;
        });
    }

    public CompletableFuture<ResponseMessage> retryMessage(ChatSession session, ChatQuestionMessage question) {
        StudioAssistChatPair chatPair = session.getConversation().getValidChatItems().stream().filter(item -> item instanceof StudioAssistChatPair).map(item -> (StudioAssistChatPair)item).filter(item -> question.getMessageId().equals(item.getRequest().getMessageId())).findFirst().orElse(null);
        if (chatPair == null) {
            return CompletableFuture.completedFuture(null);
        }
        ChatResponseMessage newResponse = new ChatResponseMessage(question.getMessageId());
        chatPair.setResponse((ResponseMessage)newResponse);
        chatPair.setReferenceContexts(null);
        chatPair.setFollowUpItems(List.of());
        this.handleReferenceContexts(session, session.getConversation().getConversationId(), question.getMessageId());
        return this.generateAnswer(session, question).thenApply(response -> {
            chatPair.setResponse(response);
            return response;
        });
    }

    public CompletableFuture<ResponseMessage> processChatResponseMessage(ChatSession session, ResponseMessage response) {
        return CompletableFuture.completedFuture(null);
    }

    public void stopGeneration(ChatSession session, ChatResponseMessage answerMessage) {
        this.studioAssistService.cancelCurrentChatService();
        ChatResponseMessage chatResponse = new ChatResponseMessage(answerMessage.getMessageId());
        chatResponse.setStatus(ResponseMessageStatus.CANCELLED);
        chatResponse.setContent("");
        StudioAssistChatPair chatPair = session.getConversation().getValidChatItems().stream().filter(item -> item instanceof StudioAssistChatPair).map(item -> (StudioAssistChatPair)item).filter(item -> answerMessage.getMessageId().equals(item.getResponse() != null ? item.getResponse().getMessageId() : null)).findFirst().orElse(null);
        if (chatPair != null) {
            answerMessage.setMessageId(chatPair.getRequest().getMessageId());
            chatPair.setResponse((ResponseMessage)chatResponse);
        }
        this.onChatAnswerUpdated((ResponseMessage)chatResponse);
    }

    public void clearConversation(ChatSession session) {
        session.resetConversation();
    }

    public CompletableFuture<ResponseMessage> getFollowUpQuestions(ChatSession session, String conversationId, String questionMessageId) {
        try {
            List validConversation = session.getConversation().getValidChatItems();
            String followUpQuestionRequest = "Based on your last answer, list out 2 follow up questions relating to Katalon to deep dive into it. Output them in the \"suggestedQuestions\" field without explaining into \"finalAnswer\".";
            if (validConversation.isEmpty()) {
                followUpQuestionRequest = "As an automation tester using Katalon Studio, suggest 2 questions. Output them in the \"suggestedQuestions\" field without explaining into \"finalAnswer\".";
            }
            ChatQuestionMessage question = new ChatQuestionMessage(followUpQuestionRequest);
            return ((CompletableFuture)this.studioAssistService.sendMessage(PromptType.CHATBOT, validConversation, question, Map.of()).thenApply(response -> {
                if (response instanceof StudioAssistChatAnswerMessage) {
                    StudioAssistChatAnswerMessage answerMessage = (StudioAssistChatAnswerMessage)response;
                    StudioAssistChatPair chatPair = this.findChatPairByQuestionId(session, questionMessageId);
                    if (chatPair != null && answerMessage.getSuggestedQuestions() != null) {
                        List followUpItems = answerMessage.getSuggestedQuestions().stream().map(q -> new FollowUpQuestion(q)).collect(Collectors.toList());
                        chatPair.setFollowUpItems(followUpItems);
                        this.onChatAnswerUpdated((ResponseMessage)answerMessage);
                    }
                }
                return response;
            })).exceptionally(throwable -> {
                logger.error("Error generating follow-up questions for message {}: {}", new Object[]{questionMessageId, throwable.getMessage(), throwable});
                return null;
            });
        }
        catch (Exception e) {
            logger.error("Failed to generate follow-up questions", (Throwable)e);
            return CompletableFuture.completedFuture(null);
        }
    }

    private void handleReferenceContexts(ChatSession session, String conversationId, String messageId) {
        try {
            if (!session.getProjectContexts().isEmpty()) {
                this.referenceContextController.loadAndAddReferenceContexts(session.getConversation(), session.getConversation().getConversationId(), messageId, PromptType.CHATBOT, ChatMode.ASK);
            }
        }
        catch (Exception e) {
            logger.error("Failed to load reference contexts for message {}", (Object)messageId, (Object)e);
        }
    }

    private StudioAssistChatPair findChatPairByQuestionId(ChatSession session, String questionMessageId) {
        return session.getConversation().getValidChatItems().stream().filter(item -> item instanceof StudioAssistChatPair).map(item -> (StudioAssistChatPair)item).filter(pair -> pair.getRequest() != null && questionMessageId.equals(pair.getRequest().getMessageId())).findFirst().orElse(null);
    }

    private CompletableFuture<ResponseMessage> generateAnswer(ChatSession session, ChatQuestionMessage question) {
        String messageId = question.getMessageId();
        String conversationId = session.getConversation().getConversationId();
        RetryPolicy retryPolicy = StudioAssistRetryPolicy.createAskModeRetryPolicy();
        CompletableFuture<ResponseMessage> completableFuture = new CompletableFuture<ResponseMessage>();
        CompletableFuture retryableFuture = Failsafe.with((Policy)retryPolicy, (Policy[])new RetryPolicy[0]).getStageAsync(() -> {
            List conversation = session.getConversation().getValidChatItems();
            return this.studioAssistService.sendMessage(PromptType.CHATBOT, conversation, null, Map.of());
        });
        retryableFuture.whenComplete((result, throwable) -> {
            if (throwable != null) {
                Throwable actualException = throwable;
                if (throwable instanceof CompletionException && throwable.getCause() != null) {
                    actualException = throwable.getCause();
                }
                ChatResponseMessage errorMessage = new ChatResponseMessage(messageId);
                errorMessage.setStatus(ResponseMessageStatus.FAILED);
                errorMessage.setContent(actualException.getMessage());
                String errorCode = ChatErrorTrackingEvent.getErrorCodeFromException((Throwable)actualException);
                this.eventBroker.post("STUDIOASSIST_TRACK_CHAT_ERROR", (Object)ChatErrorTrackingEvent.builder().errorCode(errorCode).conversationId(conversationId).questionId(messageId).chatMode(ChatMode.ASK.getName().toLowerCase()).build());
                logger.error("Error generating answer for message {}: {}", new Object[]{messageId, actualException.getMessage(), actualException});
                this.onChatAnswerUpdated((ResponseMessage)errorMessage);
                completableFuture.complete((ResponseMessage)errorMessage);
            } else if (result instanceof StudioAssistChatAnswerMessage) {
                StudioAssistChatAnswerMessage answerMessage = (StudioAssistChatAnswerMessage)result;
                ChatResponseMessage chatMessage = new ChatResponseMessage(messageId);
                chatMessage.setContent(answerMessage.getFinalAnswer());
                if (answerMessage.getWarning() != null) {
                    chatMessage.setStatus(ResponseMessageStatus.FAILED);
                } else {
                    chatMessage.setStatus(ResponseMessageStatus.COMPLETED);
                }
                this.onChatAnswerUpdated((ResponseMessage)chatMessage);
                completableFuture.complete((ResponseMessage)chatMessage);
            } else {
                completableFuture.complete((ResponseMessage)result);
            }
        });
        return completableFuture;
    }

    private void onChatAnswerUpdated(ResponseMessage answerMessage) {
        this.eventBroker.post("ON_CHAT_MESSAGE_UPDATED", (Object)answerMessage);
    }
}

