/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.services;

import com.azure.ai.openai.models.ChatCompletionsOptions;
import com.kms.katalon.ai.core.model.config.OpenAIConfig;
import com.kms.katalon.ai.services.BaseOpenAiService;
import com.kms.katalon.network.core.model.Authentication;
import com.kms.katalon.network.core.model.BearerAuthentication;
import com.kms.katalon.network.core.model.HttpOptions;
import com.kms.katalon.network.core.model.HttpResponse;
import com.kms.katalon.network.core.model.config.ProxyConfig;
import com.kms.katalon.network.core.model.config.ProxyType;
import com.kms.katalon.network.core.model.exception.HttpException;
import com.kms.katalon.network.core.model.exception.InvalidRequestException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;

public class OpenAiService
extends BaseOpenAiService {
    private static final String API_URL = "https://api.openai.com";
    private OpenAIConfig config;

    public OpenAiService(OpenAIConfig config) {
        this.config = config;
        this.model = config.getModelName();
        this.maxCompletionTokens = config.getMaxToken();
    }

    @Override
    protected BaseOpenAiService.ChatCompletionsData sendRequest(ChatCompletionsOptions completionsOptions) throws URISyntaxException, HttpException {
        URI baseUri = new URI(API_URL);
        URI uri = new URIBuilder().setScheme(baseUri.getScheme()).setHost(baseUri.getHost()).setPort(baseUri.getPort()).setPath("/v1/chat/completions").build();
        HashMap<String, String> headers = new HashMap<String, String>();
        String organizationId = this.config.getOrganizationId();
        if (StringUtils.isNotBlank((CharSequence)organizationId)) {
            headers.put("OpenAI-Organization", organizationId);
        }
        BearerAuthentication authentication = new BearerAuthentication(this.config.getSecretKey());
        ProxyConfig proxyConfig = this.networkPreferences.getProxyConfig(ProxyType.AUTHENTICATION);
        HttpOptions httpOptions = new HttpOptions.Builder().headers(headers).authentication((Authentication)authentication).proxy(proxyConfig).build();
        try {
            StringEntity entity = new StringEntity(completionsOptions.toJsonString(), StandardCharsets.UTF_8);
            HttpResponse response = this.httpClient.post(uri, (HttpEntity)entity, httpOptions);
            return new BaseOpenAiService.ChatCompletionsData(uri, httpOptions, response);
        }
        catch (IOException e) {
            throw new InvalidRequestException((Throwable)e);
        }
    }
}

