/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.services;

import com.kms.katalon.ai.core.constant.StudioAssistAttachmentSource;
import com.kms.katalon.ai.core.constant.StudioAssistTrackingContextTypeEnum;
import com.kms.katalon.ai.core.constant.StudioAssistTrackingKeyEnum;
import com.kms.katalon.ai.core.constant.StudioAssistTrackingValueEnum;
import com.kms.katalon.ai.core.context.IAgentSessionContext;
import com.kms.katalon.ai.core.event.tracking.AttachmentUsageTrackingEvent;
import com.kms.katalon.ai.core.event.tracking.ChatActionTrackingEvent;
import com.kms.katalon.ai.core.event.tracking.ChatAnswerTrackingEvent;
import com.kms.katalon.ai.core.event.tracking.ChatCloseTrackingEvent;
import com.kms.katalon.ai.core.event.tracking.ChatErrorTrackingEvent;
import com.kms.katalon.ai.core.event.tracking.ChatFileAttachmentTrackingEvent;
import com.kms.katalon.ai.core.event.tracking.ChatOpenTrackingEvent;
import com.kms.katalon.ai.core.event.tracking.ConversationRatingTrackingEvent;
import com.kms.katalon.ai.core.event.tracking.McpSettingActionTrackingEvent;
import com.kms.katalon.ai.core.model.agent.AgentConversation;
import com.kms.katalon.ai.core.model.agent.AgentMessage;
import com.kms.katalon.ai.core.model.agent.AgentMessageStatus;
import com.kms.katalon.ai.core.model.agent.AgentSetting;
import com.kms.katalon.ai.core.model.agent.ToolCallMessage;
import com.kms.katalon.ai.core.model.agent.ToolCallStatus;
import com.kms.katalon.ai.core.model.agent.config.McpHttpServerDefinition;
import com.kms.katalon.ai.core.model.agent.config.McpServerDefinition;
import com.kms.katalon.ai.core.model.agent.config.McpSseServerDefinition;
import com.kms.katalon.ai.core.model.chat.AttachmentSource;
import com.kms.katalon.ai.core.model.chat.ChatMode;
import com.kms.katalon.ai.core.model.chat.ChatResponseMessage;
import com.kms.katalon.ai.core.model.chat.ResponseMessage;
import com.kms.katalon.ai.core.model.chat.ResponseMessageStatus;
import com.kms.katalon.ai.core.model.chat.StudioAssistChatAttachment;
import com.kms.katalon.ai.core.model.chat.StudioAssistChatItem;
import com.kms.katalon.ai.core.model.chat.StudioAssistChatPair;
import com.kms.katalon.ai.core.model.chat.StudioAssistConversation;
import com.kms.katalon.ai.core.model.config.LlmConfigType;
import com.kms.katalon.ai.core.model.config.StudioAssistConfig;
import com.kms.katalon.ai.core.model.exception.StudioAssistLoadingConfigException;
import com.kms.katalon.ai.core.model.prompt.PromptType;
import com.kms.katalon.ai.core.preferences.IStudioAssistPreferences;
import com.kms.katalon.ai.core.services.IStudioAssistController;
import com.kms.katalon.ai.core.services.IStudioAssistService;
import com.kms.katalon.ai.core.services.IStudioAssistTrackingService;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.setting.IStudioAssistAiAutoTagSetting;
import com.kms.katalon.core.setting.StudioAssistSetting;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.session.core.model.AiAutoTagPolicyType;
import com.kms.katalon.session.core.services.ISessionController;
import com.kms.katalon.tracking.service.Trackings;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Creatable
@Singleton
public class StudioAssistTrackingService
implements IStudioAssistTrackingService {
    @Inject
    private IStudioAssistPreferences preferences;
    @Inject
    private IStudioAssistController controller;
    @Inject
    private ISessionController sessionController;
    @Inject
    private IStudioAssistService studioAssistService;
    private final Logger logger = LoggerFactory.getLogger(StudioAssistTrackingService.class);

    private String getTrackingConfigType() {
        StudioAssistConfig config;
        block11: {
            try {
                config = this.preferences.getConfig();
                if (config != null) break block11;
                return "";
            }
            catch (StudioAssistLoadingConfigException e) {
                this.logger.error("Error when getting StudioAssist config", (Throwable)e);
                return "";
            }
        }
        LlmConfigType configType = config.getType();
        switch (configType) {
            case OPENAI: {
                return "openai";
            }
            case AZURE_OPENAI: {
                return "azure_openai";
            }
            case GEN_AI: {
                return "katalon_genai";
            }
            case GEMINI: {
                return "gemini";
            }
            case OPENAI_COMPATIBLE: {
                return "openai_compatible";
            }
            case AWS_BEDROCK: {
                return "aws_bedrock";
            }
        }
        return "";
    }

    public void trackStudioAssistChat(List<Object> trackingData) {
        trackingData.add(StudioAssistTrackingKeyEnum.SA_CONFIG.getValue());
        trackingData.add(this.getTrackingConfigType());
        Trackings.trackStudioAssistChat(trackingData);
    }

    public void trackOpenStudioAssistChat(String triggerMethod, String pageState, String chatMode) {
        Trackings.trackOpenStudioAssistChat((String)triggerMethod, (String)pageState, (String)this.getTrackingConfigType(), (String)chatMode);
    }

    public void trackCloseStudioAssistChat(StudioAssistConversation conversation, String chatMode) {
        HashMap<String, Object> trackingData = new HashMap<String, Object>();
        trackingData.put(StudioAssistTrackingKeyEnum.STUDIOASSIST_CHAT_ACTION.getValue(), StudioAssistTrackingValueEnum.CLOSE_CHAT.getValue());
        trackingData.put(StudioAssistTrackingKeyEnum.CONVERSATION_ID.getValue(), conversation.getConversationId());
        trackingData.put(StudioAssistTrackingKeyEnum.SA_CONFIG.getValue(), this.getTrackingConfigType());
        trackingData.put(StudioAssistTrackingKeyEnum.CHAT_MODE.getValue(), chatMode.toLowerCase());
        if (conversation instanceof AgentConversation) {
            AgentConversation agentConversation = (AgentConversation)conversation;
            this.processAgentConversationDetails(agentConversation, trackingData);
        }
        ArrayBlockingQueue chatHistory = conversation.getMessages();
        trackingData.put(StudioAssistTrackingKeyEnum.NUMBER_OF_QUESTION.getValue(), chatHistory.size());
        long numberOfSuccessAnswer = chatHistory.stream().filter(this::isSuccessfulAnswer).count();
        trackingData.put(StudioAssistTrackingKeyEnum.NUMBER_OF_SUCCESS_ANSWER.getValue(), (int)numberOfSuccessAnswer);
        Trackings.trackCloseStudioAssistChat(this.convertToTrackingData(trackingData));
    }

    private void processAgentConversationDetails(AgentConversation conversation, Map<String, Object> trackingData) {
        if (conversation == null || conversation.getMessages() == null) {
            return;
        }
        int totalToolCalls = 0;
        int successfulToolCalls = 0;
        HashMap<String, Integer> toolUsageCounts = new HashMap<String, Integer>();
        for (StudioAssistChatItem item : conversation.getMessages()) {
            AgentMessage agentMessage;
            List toolCalls;
            StudioAssistChatPair chatPair;
            ResponseMessage responseMessage;
            if (!(item instanceof StudioAssistChatPair) || !((responseMessage = (chatPair = (StudioAssistChatPair)item).getResponse()) instanceof AgentMessage) || (toolCalls = (agentMessage = (AgentMessage)responseMessage).getToolCalls()).isEmpty()) continue;
            totalToolCalls += toolCalls.size();
            for (ToolCallMessage toolCall : toolCalls) {
                toolUsageCounts.merge(toolCall.getName(), 1, Integer::sum);
                if (toolCall.getStatus() != ToolCallStatus.SUCCESS) continue;
                ++successfulToolCalls;
            }
        }
        trackingData.put(StudioAssistTrackingKeyEnum.TOTAL_NUMBER_OF_TOOL_CALLED.getValue(), totalToolCalls);
        trackingData.put(StudioAssistTrackingKeyEnum.NUMBER_OF_SUCCESS_TOOL_CALL.getValue(), successfulToolCalls);
        trackingData.put(StudioAssistTrackingKeyEnum.KS_MCP_USAGE.getValue(), this.formatToolUsage(toolUsageCounts));
    }

    private boolean isSuccessfulAnswer(StudioAssistChatItem item) {
        if (item instanceof StudioAssistChatPair) {
            StudioAssistChatPair pair = (StudioAssistChatPair)item;
            return Boolean.TRUE.equals(pair.getGoodQuestion());
        }
        return true;
    }

    private String formatToolUsage(Map<String, Integer> toolUsageMap) {
        if (toolUsageMap == null || toolUsageMap.isEmpty()) {
            return "";
        }
        return toolUsageMap.entrySet().stream().map(entry -> (String)entry.getKey() + ": " + String.valueOf(entry.getValue())).collect(Collectors.joining(", "));
    }

    private List<Object> convertToTrackingData(Map<String, Object> map) {
        return map.entrySet().stream().flatMap(entry -> List.of(entry.getKey(), entry.getValue()).stream()).toList();
    }

    public void trackConfigureStudioAssist() {
        String configType = this.getTrackingConfigType();
        boolean projectContextObjectRepositoriesEnabled = StudioAssistSetting.isProjectContextObjectRepositoriesEnabled();
        boolean projectContextCustomKeywordsEnabled = StudioAssistSetting.isProjectContextCustomKeywordsEnabled();
        boolean followUpQuestionsEnabled = StudioAssistSetting.isFollowUpQuestionEnabled();
        IStudioAssistAiAutoTagSetting studioAssistSetting = this.controller.getStudioAssistAiAutoTagSetting();
        boolean apiTestCaseGenTagEnabled = studioAssistSetting.isApiTestCaseGeneration();
        boolean codeGenTagEnabled = studioAssistSetting.isCodeGeneration();
        AiAutoTagPolicyType aiAutoTaggingPolicyType = Optional.ofNullable(this.sessionController.getAdministrationManagedKsSetting().getAiAutoTagging()).map(setting -> setting.getType()).orElse(AiAutoTagPolicyType.USER_MANAGED_AI_AUTO_TAG);
        boolean isAdminManagedAiAutoTag = aiAutoTaggingPolicyType == AiAutoTagPolicyType.ADMIN_MANAGED_AI_AUTO_TAG;
        ArrayList<Object> trackingData = new ArrayList<Object>();
        trackingData.add(StudioAssistTrackingKeyEnum.SA_CONFIG.getValue());
        trackingData.add(configType);
        ArrayList<String> contextTypes = new ArrayList<String>();
        if (projectContextObjectRepositoriesEnabled) {
            contextTypes.add("object_repository");
        }
        if (projectContextCustomKeywordsEnabled) {
            contextTypes.add("custom_keyword");
        }
        if (!contextTypes.isEmpty()) {
            trackingData.add(StudioAssistTrackingKeyEnum.CONTEXT_TYPE.getValue());
            trackingData.add(StringUtils.join(contextTypes, (String)","));
        }
        trackingData.add(StudioAssistTrackingKeyEnum.FOLLOW_UP_QUESTION.getValue());
        trackingData.add(String.valueOf(followUpQuestionsEnabled));
        this.addTagTrackingData(trackingData, StudioAssistTrackingKeyEnum.APPEND_API_TEST_CASE_GEN_TAG_ENABLED, StudioAssistTrackingKeyEnum.API_TEST_CASE_GEN_TAG_NAME, apiTestCaseGenTagEnabled, isAdminManagedAiAutoTag, studioAssistSetting.isApiTestCaseDefaultTag(), studioAssistSetting.isApiTestCaseCustomTag());
        this.addTagTrackingData(trackingData, StudioAssistTrackingKeyEnum.APPEND_CODE_GENERATION_TAG_ENABLED, StudioAssistTrackingKeyEnum.CODE_GENERATION_TAG_NAME, codeGenTagEnabled, isAdminManagedAiAutoTag, studioAssistSetting.isCodeGenerationDefaultTag(), studioAssistSetting.isCodeGenerationCustomTag());
        Trackings.trackStudioAssistConfig(trackingData);
    }

    private void addTagTrackingData(List<Object> trackingData, StudioAssistTrackingKeyEnum enabledKey, StudioAssistTrackingKeyEnum tagNameKey, boolean tagEnabled, boolean isAdminManagedAiAutoTag, boolean isDefaultTag, boolean isCustomTag) {
        trackingData.add(enabledKey.getValue());
        trackingData.add(String.valueOf(tagEnabled));
        if (tagEnabled) {
            trackingData.add(tagNameKey.getValue());
            trackingData.add(this.determineTagNamePolicy(isAdminManagedAiAutoTag, isDefaultTag, isCustomTag));
        }
    }

    private String determineTagNamePolicy(boolean isAdminManagedAiAutoTag, boolean isDefaultTag, boolean isCustomTag) {
        if (isAdminManagedAiAutoTag) {
            return "admin_config";
        }
        if (isDefaultTag) {
            return "default";
        }
        if (isCustomTag) {
            return "custom";
        }
        return "";
    }

    public void trackCustomizedPromptEvents(List<PromptType> customizedPrompts, List<PromptType> restoredPrompts) {
        ArrayList<String> trackingData = new ArrayList<String>();
        if (customizedPrompts != null && !customizedPrompts.isEmpty()) {
            ArrayList<String> customizedPromptNames = new ArrayList<String>();
            for (PromptType promptType : customizedPrompts) {
                customizedPromptNames.add(promptType.name().toLowerCase());
            }
            trackingData.add(StudioAssistTrackingKeyEnum.CUSTOMIZED_PROMPT_FEATURE.getValue());
            trackingData.add(StringUtils.join(customizedPromptNames, (String)","));
        }
        if (restoredPrompts != null && !restoredPrompts.isEmpty()) {
            ArrayList<String> restoredPromptNames = new ArrayList<String>();
            for (PromptType promptType : restoredPrompts) {
                restoredPromptNames.add(promptType.name().toLowerCase());
            }
            trackingData.add(StudioAssistTrackingKeyEnum.RESTORE_CUSTOMIZED_PROMPT_FEATURE.getValue());
            trackingData.add(StringUtils.join(restoredPromptNames, (String)","));
        }
        if (trackingData.isEmpty()) {
            return;
        }
        Trackings.trackStudioAssistPromptLibraryConfig(trackingData);
    }

    @Inject
    @org.eclipse.e4.core.di.annotations.Optional
    private void onSaSettingChange(@UIEventTopic(value="ON_SA_SETTING_CHANGE") Object object) {
        try {
            this.trackConfigureStudioAssist();
        }
        catch (Exception e) {
            this.logger.error("Exception while handle ON_SA_SETTING_CHANGE event", (Throwable)e);
            LogUtil.logError((Throwable)e, (String)"Exception while handle event studio assist setting change");
        }
    }

    @Inject
    @org.eclipse.e4.core.di.annotations.Optional
    private void onTrackAttachmentUsage(@UIEventTopic(value="STUDIOASSIST_TRACK_ATTACHMENT_USAGE") AttachmentUsageTrackingEvent event) {
        try {
            if (event.getAttachments() == null || event.getAttachments().isEmpty()) {
                return;
            }
            for (StudioAssistChatAttachment attachment : event.getAttachments()) {
                ArrayList<Object> trackingData = new ArrayList<Object>();
                trackingData.add(StudioAssistTrackingKeyEnum.CONVERSATION_ID.getValue());
                trackingData.add(event.getConversationId());
                trackingData.add(StudioAssistTrackingKeyEnum.QUESTION_ID.getValue());
                trackingData.add(event.getQuestionId());
                trackingData.add(StudioAssistTrackingKeyEnum.CONTEXT_ID.getValue());
                trackingData.add(attachment.getFileClientId());
                if (StudioAssistAttachmentSource.FOCUSING_FILE.equals((Object)attachment.getFileSource())) {
                    trackingData.add(StudioAssistTrackingKeyEnum.CONTEXT_TYPE.getValue());
                    trackingData.add(StudioAssistTrackingContextTypeEnum.CURRENT_FILE.getValue());
                } else {
                    ProjectEntity currentProject = ProjectController.getInstance().getCurrentProject();
                    String projectLocation = currentProject == null ? null : currentProject.getFolderLocation();
                    String attachmentPath = attachment.getFilePath();
                    if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{projectLocation}) && StringUtils.startsWith((CharSequence)attachmentPath, (CharSequence)projectLocation)) {
                        trackingData.add(StudioAssistTrackingKeyEnum.CONTEXT_TYPE.getValue());
                        trackingData.add(StudioAssistTrackingContextTypeEnum.PROJECT_FILE_ATTACHMENT.getValue());
                    } else {
                        trackingData.add(StudioAssistTrackingKeyEnum.CONTEXT_TYPE.getValue());
                        trackingData.add(StudioAssistTrackingContextTypeEnum.EXTERNAL_FILE_ATTACHMENT.getValue());
                    }
                }
                trackingData.add(StudioAssistTrackingKeyEnum.CHAT_MODE.getValue());
                trackingData.add(event.getChatMode().toLowerCase());
                this.trackStudioAssistChat(trackingData);
            }
        }
        catch (Exception e) {
            this.logger.error("Error tracking attachment usage", (Throwable)e);
        }
    }

    @Inject
    @org.eclipse.e4.core.di.annotations.Optional
    private void onTrackConversationRating(@UIEventTopic(value="STUDIOASSIST_TRACK_CONVERSATION_RATING") ConversationRatingTrackingEvent event) {
        try {
            List trackingData = this.studioAssistService.buildRatingTrackingData(event.getRequest(), event.getConversation(), event.getChatMode());
            this.trackStudioAssistChat(trackingData);
        }
        catch (Exception e) {
            this.logger.error("Error tracking conversation rating", (Throwable)e);
        }
    }

    @Inject
    @org.eclipse.e4.core.di.annotations.Optional
    private void onTrackChatOpen(@UIEventTopic(value="STUDIOASSIST_TRACK_CHAT_OPEN") ChatOpenTrackingEvent event) {
        try {
            Trackings.trackOpenStudioAssistChat((String)event.getTriggerMethod(), (String)event.getPageState(), (String)this.getTrackingConfigType(), (String)event.getChatMode());
        }
        catch (Exception e) {
            this.logger.error("Error tracking chat open", (Throwable)e);
        }
    }

    @Inject
    @org.eclipse.e4.core.di.annotations.Optional
    private void onTrackChatClose(@UIEventTopic(value="STUDIOASSIST_TRACK_CHAT_CLOSE") ChatCloseTrackingEvent event) {
        try {
            this.trackCloseStudioAssistChat(event.getConversation(), event.getChatMode());
        }
        catch (Exception e) {
            this.logger.error("Error tracking chat close", (Throwable)e);
        }
    }

    public void trackStudioAssistAgentSetting(Map<String, Object> trackingData) {
        ArrayList data = new ArrayList();
        trackingData.forEach((key, value) -> {
            data.add(key);
            data.add(value);
        });
        Trackings.trackStudioAssistAgentSetting(data);
    }

    public void addAgentModeTrackingData(List<Object> trackingData, IAgentSessionContext sessionContext) {
        trackingData.add(StudioAssistTrackingKeyEnum.NUMBER_OF_AVAILABLE_TOOL.getValue());
        trackingData.add(String.valueOf(this.getNumberOfAvailableTools(sessionContext)));
        List<McpServerDefinition> enabledMcpServers = this.getEnabledMcpServers(sessionContext);
        long enabledHttpMcpServers = enabledMcpServers.stream().filter(server -> server instanceof McpHttpServerDefinition).count();
        long enabledSseMcpServers = enabledMcpServers.stream().filter(server -> server instanceof McpSseServerDefinition).count();
        trackingData.add(StudioAssistTrackingKeyEnum.NUMBER_OF_ENABLED_HTTP_MCP_SERVER.getValue());
        trackingData.add(String.valueOf(enabledHttpMcpServers));
        trackingData.add(StudioAssistTrackingKeyEnum.NUMBER_OF_ENABLED_SSE_MCP_SERVER.getValue());
        trackingData.add(String.valueOf(enabledSseMcpServers));
        AgentSetting agentSetting = sessionContext.getAgentSetting();
        if (agentSetting != null) {
            trackingData.add(StudioAssistTrackingKeyEnum.MAX_TOOL_CALL.getValue());
            trackingData.add(String.valueOf(agentSetting.getMaxToolCalls()));
            trackingData.add(StudioAssistTrackingKeyEnum.AUTO_APPROVE_ALL_USAGE.getValue());
            trackingData.add(String.valueOf(agentSetting.isAutoToolApproval()));
        }
    }

    private List<McpServerDefinition> getEnabledMcpServers(IAgentSessionContext sessionContext) {
        List disabledServers = Optional.ofNullable(sessionContext.getAgentSetting()).map(AgentSetting::getDisabledServers).orElse(List.of());
        return sessionContext.getMcpSetting().getServers().stream().filter(server -> !disabledServers.contains(server.getName())).toList();
    }

    private int getNumberOfAvailableTools(IAgentSessionContext sessionContext) {
        return sessionContext.getAvailableTools().size();
    }

    @Inject
    @org.eclipse.e4.core.di.annotations.Optional
    private void onTrackChatAction(@UIEventTopic(value="STUDIOASSIST_TRACK_CHAT_ACTION") ChatActionTrackingEvent event) {
        try {
            ArrayList<Object> trackingData = new ArrayList<Object>();
            trackingData.add(StudioAssistTrackingKeyEnum.STUDIOASSIST_CHAT_ACTION.getValue());
            trackingData.add(event.getAction());
            if (event.getConversationId() != null) {
                trackingData.add(StudioAssistTrackingKeyEnum.CONVERSATION_ID.getValue());
                trackingData.add(event.getConversationId());
            }
            if (event.getQuestionId() != null) {
                trackingData.add(StudioAssistTrackingKeyEnum.QUESTION_ID.getValue());
                trackingData.add(event.getQuestionId());
            }
            if (event.getChatMode() != null) {
                trackingData.add(StudioAssistTrackingKeyEnum.CHAT_MODE.getValue());
                trackingData.add(event.getChatMode().toLowerCase());
                if (event.getChatMode().equalsIgnoreCase(ChatMode.AGENT.getName()) && event.getAgentSessionContext() != null) {
                    this.addAgentModeTrackingData(trackingData, event.getAgentSessionContext());
                }
            }
            this.trackStudioAssistChat(trackingData);
        }
        catch (Exception e) {
            this.logger.error("Error tracking chat action", (Throwable)e);
        }
    }

    @Inject
    @org.eclipse.e4.core.di.annotations.Optional
    private void onTrackChatAnswer(@UIEventTopic(value="STUDIOASSIST_TRACK_CHAT_ANSWER") ChatAnswerTrackingEvent event) {
        try {
            AgentMessage agentMessage;
            ArrayList<Object> trackingData = new ArrayList<Object>();
            trackingData.add(StudioAssistTrackingKeyEnum.STUDIOASSIST_ANSWER_SUCCESS.getValue());
            ResponseMessage responseMessage = event.getResponseMessage();
            if (responseMessage instanceof ChatResponseMessage) {
                ChatResponseMessage chatMessage = (ChatResponseMessage)responseMessage;
                trackingData.add(chatMessage.getStatus().equals((Object)ResponseMessageStatus.COMPLETED));
                trackingData.add(StudioAssistTrackingKeyEnum.QUESTION_ID.getValue());
                trackingData.add(responseMessage.getMessageId());
                trackingData.add(StudioAssistTrackingKeyEnum.CHAT_MODE.getValue());
                trackingData.add(ChatMode.ASK.getName().toLowerCase());
            } else if (responseMessage instanceof AgentMessage && (agentMessage = (AgentMessage)responseMessage).isFinished()) {
                trackingData.add(agentMessage.getStatus().equals((Object)AgentMessageStatus.FINISHED));
                if (agentMessage.getStatus().equals((Object)AgentMessageStatus.FINISHED)) {
                    trackingData.add(StudioAssistTrackingKeyEnum.TOTAL_NUMBER_OF_TOOL_CALLED.getValue());
                    List toolCalls = agentMessage.getToolCalls();
                    trackingData.add(toolCalls.size());
                    long successfulToolCalls = toolCalls.stream().filter(toolCall -> toolCall.getStatus() == ToolCallStatus.SUCCESS).count();
                    trackingData.add(StudioAssistTrackingKeyEnum.NUMBER_OF_SUCCESS_TOOL_CALL.getValue());
                    trackingData.add((int)successfulToolCalls);
                }
                trackingData.add(StudioAssistTrackingKeyEnum.QUESTION_ID.getValue());
                trackingData.add(agentMessage.getMessageId());
                trackingData.add(StudioAssistTrackingKeyEnum.CHAT_MODE.getValue());
                trackingData.add(ChatMode.AGENT.getName().toLowerCase());
            }
            if (event.getConversationId() != null) {
                trackingData.add(StudioAssistTrackingKeyEnum.CONVERSATION_ID.getValue());
                trackingData.add(event.getConversationId());
            }
            this.trackStudioAssistChat(trackingData);
        }
        catch (Exception e) {
            this.logger.error("Error tracking chat action", (Throwable)e);
        }
    }

    @Inject
    @org.eclipse.e4.core.di.annotations.Optional
    private void onTrackChatError(@UIEventTopic(value="STUDIOASSIST_TRACK_CHAT_ERROR") ChatErrorTrackingEvent event) {
        try {
            ArrayList<Object> trackingData = new ArrayList<Object>();
            trackingData.add(StudioAssistTrackingKeyEnum.STUDIOASSIST_ERROR.getValue());
            trackingData.add(event.getErrorType().getValue());
            if (event.getConversationId() != null) {
                trackingData.add(StudioAssistTrackingKeyEnum.CONVERSATION_ID.getValue());
                trackingData.add(event.getConversationId());
            }
            if (event.getQuestionId() != null) {
                trackingData.add(StudioAssistTrackingKeyEnum.QUESTION_ID.getValue());
                trackingData.add(event.getQuestionId());
            }
            if (event.getChatMode() != null) {
                trackingData.add(StudioAssistTrackingKeyEnum.CHAT_MODE.getValue());
                trackingData.add(event.getChatMode().toLowerCase());
            }
            this.trackStudioAssistChat(trackingData);
        }
        catch (Exception e) {
            this.logger.error("Error tracking chat error", (Throwable)e);
        }
    }

    @Inject
    @org.eclipse.e4.core.di.annotations.Optional
    private void onTrackMcpSettingAction(@UIEventTopic(value="STUDIOASSIST_TRACK_MCP_SETTING_ACTION") McpSettingActionTrackingEvent event) {
        try {
            ArrayList<Object> trackingData = new ArrayList<Object>();
            trackingData.add(StudioAssistTrackingKeyEnum.STUDIOASSIST_MCP_SETTING_ACTION.getValue());
            trackingData.add(event.getAction().getValue());
            if (event.getChatMode() != null) {
                trackingData.add(StudioAssistTrackingKeyEnum.CHAT_MODE.getValue());
                trackingData.add(event.getChatMode().toLowerCase());
            }
            this.trackStudioAssistChat(trackingData);
        }
        catch (Exception e) {
            this.logger.error("Error tracking MCP setting action", (Throwable)e);
        }
    }

    @Inject
    @org.eclipse.e4.core.di.annotations.Optional
    private void onTrackFileAttach(@UIEventTopic(value="STUDIOASSIST_FILE_ATTACHMENT") ChatFileAttachmentTrackingEvent event) {
        try {
            ArrayList<Object> trackingData = new ArrayList<Object>();
            trackingData.add(StudioAssistTrackingKeyEnum.STUDIOASSIST_CHAT_ACTION.getValue());
            trackingData.add(StudioAssistTrackingValueEnum.FILE_ATTACHMENT.getValue());
            if (event.getChatMode() != null) {
                trackingData.add(StudioAssistTrackingKeyEnum.CHAT_MODE.getValue());
                trackingData.add(event.getChatMode().getName().toLowerCase());
            }
            if (event.getAttachmentSource() != null) {
                trackingData.add(StudioAssistTrackingKeyEnum.ATTACH_FROM.getValue());
                if (event.getAttachmentSource() == AttachmentSource.PROJECT) {
                    trackingData.add(StudioAssistTrackingValueEnum.ATTACH_FILE_FROM_PROJECT.getValue());
                } else if (event.getAttachmentSource() == AttachmentSource.EXTERNAL) {
                    trackingData.add(StudioAssistTrackingValueEnum.ATTACH_FILE_FROM_EXTERNAL.getValue());
                }
            }
            this.trackStudioAssistChat(trackingData);
        }
        catch (Exception e) {
            this.logger.error("Error tracking file attachment", (Throwable)e);
        }
    }
}

