/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.services.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.kms.katalon.ai.constants.GenAiChatJobStatus;
import com.kms.katalon.ai.core.model.agent.AgentMessage;
import com.kms.katalon.ai.core.model.agent.ToolCallMessage;
import com.kms.katalon.ai.core.model.agent.ToolCallStatus;
import com.kms.katalon.ai.core.model.chat.ChatMode;
import com.kms.katalon.ai.core.model.chat.ChatQuestionMessage;
import com.kms.katalon.ai.core.model.chat.ChatResponseMessage;
import com.kms.katalon.ai.core.model.chat.ImageChatAttachment;
import com.kms.katalon.ai.core.model.chat.ResponseMessage;
import com.kms.katalon.ai.core.model.chat.StudioAssistChatAnswerMessage;
import com.kms.katalon.ai.core.model.chat.StudioAssistChatAttachment;
import com.kms.katalon.ai.core.model.chat.StudioAssistChatItem;
import com.kms.katalon.ai.core.model.chat.StudioAssistChatPair;
import com.kms.katalon.ai.core.model.chat.StudioAssistChatReferenceContextMessage;
import com.kms.katalon.ai.core.model.chat.StudioAssistUploadedFileHistory;
import com.kms.katalon.ai.core.model.exception.StudioAssistLlmApiAiSettingDisabledException;
import com.kms.katalon.ai.core.model.exception.StudioAssistLlmApiAuthenticationException;
import com.kms.katalon.ai.core.model.exception.StudioAssistLlmApiClientException;
import com.kms.katalon.ai.core.model.exception.StudioAssistLlmApiNoInternetException;
import com.kms.katalon.ai.core.model.exception.StudioAssistLlmApiResourceExhaustedException;
import com.kms.katalon.ai.core.model.exception.StudioAssistLlmApiRuntimeException;
import com.kms.katalon.ai.core.model.exception.StudioAssistLlmApiServerContentViolatedException;
import com.kms.katalon.ai.core.model.exception.StudioAssistLlmApiServerNoAnswerException;
import com.kms.katalon.ai.core.model.exception.StudioAssistLlmApiServerTimeoutException;
import com.kms.katalon.ai.core.model.exception.StudioAssistLlmApiServerTokenExceededException;
import com.kms.katalon.ai.core.model.llm.InlineImageInput;
import com.kms.katalon.ai.core.model.llm.ToolCall;
import com.kms.katalon.ai.core.services.internal.IChatAnswerLlmService;
import com.kms.katalon.ai.core.util.ToolUtil;
import com.kms.katalon.ai.internal.IGenAiClient;
import com.kms.katalon.ai.internal.IGenAiClientFactory;
import com.kms.katalon.ai.internal.model.AskForUploadFileRequest;
import com.kms.katalon.ai.internal.model.AskForUploadFileResponse;
import com.kms.katalon.ai.internal.model.GenAiGetAnswerError;
import com.kms.katalon.ai.internal.model.GenAiGetAnswerRequest;
import com.kms.katalon.ai.internal.model.GenAiGetAnswerResponse;
import com.kms.katalon.ai.internal.model.GenAiSubmitQuestionRequest;
import com.kms.katalon.ai.internal.model.GenAiSubmitQuestionResponse;
import com.kms.katalon.ai.internal.model.UploadFileRequest;
import com.kms.katalon.ai.internal.model.UploadFileResponse;
import com.kms.katalon.ai.services.genai.dto.GenAiChatAttachment;
import com.kms.katalon.ai.services.genai.dto.GenAiChatMessage;
import com.kms.katalon.ai.services.genai.dto.GenAiChatMessageRequest;
import com.kms.katalon.ai.services.genai.dto.GenAiChatTool;
import com.kms.katalon.ai.services.internal.UploadAttachmentCallable;
import com.kms.katalon.network.core.model.exception.HttpException;
import com.kms.katalon.network.core.services.IHttpClient;
import com.kms.katalon.network.core.services.INetworkPreferences;
import com.kms.katalon.session.core.model.Account;
import com.kms.katalon.session.core.model.Organization;
import com.kms.katalon.session.core.model.User;
import com.kms.katalon.session.core.services.ISessionManager;
import io.modelcontextprotocol.spec.McpSchema;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StudioAssistChatAnswerGenAIService
implements IChatAnswerLlmService {
    private static final Logger logger = LoggerFactory.getLogger(StudioAssistChatAnswerGenAIService.class);
    private static final int DEFAULT_INTERVAL_FETCH_MS = 1000;
    private static final int DEFAULT_MAX_FETCHING_TIMES = 120;
    private static final int DEFAULT_TIMEOUT_SECONDS = 120;
    private static final int UPLOAD_THREAD_POOL_SIZE = 4;
    private final ChatMode chatMode;
    private final List<StudioAssistChatItem> conversation;
    private final ChatQuestionMessage question;
    private final Map<String, List<McpSchema.Tool>> availableTools;
    private final int intervalFetchInMs;
    private final int maxFetchingTimes;
    private volatile boolean cancelled = false;
    private volatile CompletableFuture<ResponseMessage> currentFuture;
    @Inject
    private IGenAiClientFactory clientFactory;
    @Inject
    private ISessionManager sessionManager;
    @Inject
    private IHttpClient httpClient;
    @Inject
    private INetworkPreferences networkPreferences;
    private List<GenAiChatAttachment> genAiAttachments;

    public StudioAssistChatAnswerGenAIService(ChatMode chatMode, List<StudioAssistChatItem> conversation, ChatQuestionMessage question, Map<String, List<McpSchema.Tool>> availableTools, int intervalFetchInMs, int maxFetchingTimes) {
        this.chatMode = chatMode;
        this.conversation = conversation;
        this.question = question;
        this.availableTools = Objects.requireNonNullElseGet(availableTools, Map::of);
        this.intervalFetchInMs = intervalFetchInMs > 0 ? intervalFetchInMs : 1000;
        this.maxFetchingTimes = maxFetchingTimes > 0 ? maxFetchingTimes : 120;
    }

    public CompletableFuture<ResponseMessage> executeAsync() {
        this.currentFuture = CompletableFuture.supplyAsync(() -> {
            long startTime = System.currentTimeMillis();
            try {
                IGenAiClient client = this.clientFactory.createGenAiClient();
                Long accountId = Optional.ofNullable(this.sessionManager.getAccount()).map(Account::getId).orElse(null);
                Long orgId = Optional.ofNullable(this.sessionManager.getOrganization()).map(Organization::getId).orElse(null);
                Long userId = Optional.ofNullable(this.sessionManager.getUser()).map(User::getId).orElse(null);
                this.validate(orgId, accountId, userId);
                GenAiSubmitQuestionResponse questionResponse = this.submitQuestion(client, orgId, accountId, userId);
                String chatJobId = Optional.ofNullable(questionResponse).map(GenAiSubmitQuestionResponse::getChatJobId).orElse(null);
                if (chatJobId == null) {
                    logger.error("Received null as chat job id when submit question");
                    throw new StudioAssistLlmApiRuntimeException("Received null as chat job id when submit question");
                }
                GenAiGetAnswerRequest getAnswerRequest = new GenAiGetAnswerRequest(orgId, accountId, userId, chatJobId);
                GenAiGetAnswerResponse answerResponse = this.pollForAnswer(client, getAnswerRequest);
                ResponseMessage responseMessage = this.handleCompletedResponse(answerResponse);
                return responseMessage;
            }
            catch (CancellationException e) {
                logger.info("Execution was cancelled during operation | messageId: {}", (Object)this.getMessageId());
                throw e;
            }
            catch (ExecutionException | TimeoutException ex) {
                logger.error("Known exception while processing GenAI chat question", (Throwable)ex);
                throw new StudioAssistLlmApiClientException((Throwable)ex);
            }
            catch (StudioAssistLlmApiNoInternetException e) {
                logger.error("Internet disconnected while processing GenAI chat question", (Throwable)e);
                throw e;
            }
            catch (StudioAssistLlmApiResourceExhaustedException e) {
                logger.error("Resource exhausted while processing GenAI chat question", (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                logger.error("Exception while processing GenAI chat question", (Throwable)e);
                throw new StudioAssistLlmApiClientException((Throwable)e);
            }
            finally {
                logger.debug("Fetching chat answer from GenAI completed | processingTime = {} ms", (Object)(System.currentTimeMillis() - startTime));
            }
        }).orTimeout(120L, TimeUnit.SECONDS);
        return this.currentFuture;
    }

    public void cancel() {
        logger.info("Cancelling GenAI execution | messageId: {}", (Object)this.getMessageId());
        this.cancelled = true;
        if (this.currentFuture != null && !this.currentFuture.isDone()) {
            this.currentFuture.cancel(true);
        }
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    private StudioAssistChatAnswerMessage createCancelledMessage() {
        StudioAssistChatAnswerMessage cancelledMessage = new StudioAssistChatAnswerMessage();
        cancelledMessage.setMessageId(this.getMessageId());
        cancelledMessage.setFinalAnswer("");
        return cancelledMessage;
    }

    private GenAiSubmitQuestionResponse submitQuestion(Object client, Long orgId, Long accountId, Long userId) throws InterruptedException, ExecutionException, TimeoutException, HttpException {
        List<GenAiChatMessage> messages = this.buildChatMessage(accountId, orgId, userId);
        List<GenAiChatTool> availableTools = this.getLlmTools().stream().map(tool -> {
            GenAiChatTool chatTool = new GenAiChatTool();
            chatTool.setName(tool.name());
            chatTool.setDescription(tool.description());
            ObjectMapper objectMapper = new ObjectMapper();
            try {
                String json = objectMapper.writeValueAsString((Object)tool.inputSchema());
                Map toolSchema = (Map)objectMapper.readValue(json, (TypeReference)new TypeReference<Map<String, Object>>(){});
                chatTool.setParameters(toolSchema);
            }
            catch (JsonProcessingException jsonProcessingException) {
                return null;
            }
            return chatTool;
        }).filter(Objects::nonNull).toList();
        GenAiSubmitQuestionRequest submitRequest = new GenAiSubmitQuestionRequest(orgId, accountId, userId, messages);
        submitRequest.setChatMode(this.chatMode.name());
        submitRequest.setAvailableTools(availableTools);
        logger.info("=== Submitting question to GenAI, messages count: {}", (Object)messages.size());
        return this.clientFactory.createGenAiClient().submitQuestion(submitRequest);
    }

    private GenAiGetAnswerResponse pollForAnswer(Object client, GenAiGetAnswerRequest getAnswerRequest) throws InterruptedException, HttpException {
        int fetchingTimes = 1;
        while (fetchingTimes <= this.maxFetchingTimes && !this.cancelled) {
            logger.debug("Fetching {} times | chatJobId = {}", (Object)fetchingTimes, (Object)getAnswerRequest.getChatJobId());
            if (this.cancelled) {
                logger.info("Polling cancelled by user | chatJobId = {}", (Object)getAnswerRequest.getChatJobId());
                throw new InterruptedException("Polling cancelled by user");
            }
            GenAiGetAnswerResponse answerResponse = this.clientFactory.createGenAiClient().getAnswer(getAnswerRequest);
            if (answerResponse == null) {
                logger.debug("answerResponse is null, jump to next fetch");
                ++fetchingTimes;
                Thread.sleep(this.intervalFetchInMs);
                continue;
            }
            GenAiChatJobStatus jobStatus = answerResponse.getStatus();
            if (GenAiChatJobStatus.CANCELLED.equals((Object)jobStatus)) {
                logger.debug("Chat job has been cancelled | chatJobId = {}", (Object)getAnswerRequest.getChatJobId());
                break;
            }
            if (GenAiChatJobStatus.COMPLETED.equals((Object)jobStatus)) {
                return answerResponse;
            }
            if (this.isTheAnswerNull(answerResponse)) {
                logger.debug("GenAI answer is null for in-progress job, continue polling... (attempt {}/{})", (Object)fetchingTimes, (Object)this.maxFetchingTimes);
                ++fetchingTimes;
                Thread.sleep(this.intervalFetchInMs);
                continue;
            }
            ++fetchingTimes;
            Thread.sleep(this.intervalFetchInMs);
        }
        if (this.cancelled) {
            logger.info("Polling stopped due to user cancellation | chatJobId = {}", (Object)getAnswerRequest.getChatJobId());
            throw new InterruptedException("Polling cancelled by user");
        }
        if (this.maxFetchingTimes < fetchingTimes) {
            logger.debug("Exceeded max fetching time, stop the fetching | chatJobId = {}", (Object)getAnswerRequest.getChatJobId());
            throw new StudioAssistLlmApiServerTimeoutException("LLM takes too long to provide the answer");
        }
        throw new StudioAssistLlmApiServerTimeoutException("LLM takes too long to provide the answer");
    }

    private ResponseMessage handleCompletedResponse(GenAiGetAnswerResponse answerResponse) {
        GenAiGetAnswerError finishError = answerResponse.getFinishError();
        if (finishError != null) {
            int errorCode = finishError.getCode();
            String errorMessage = finishError.getMessage();
            switch (errorCode) {
                case 3: {
                    if (errorMessage.contains("Content violated filtered")) {
                        throw new StudioAssistLlmApiServerContentViolatedException(errorMessage);
                    }
                    throw new StudioAssistLlmApiClientException(errorMessage);
                }
                case 7: {
                    throw new StudioAssistLlmApiAiSettingDisabledException(errorMessage);
                }
                case 16: {
                    throw new StudioAssistLlmApiAuthenticationException(errorMessage);
                }
                case 11: {
                    if (errorMessage.contains("Token limit reached")) {
                        throw new StudioAssistLlmApiServerTokenExceededException(errorMessage);
                    }
                    throw new StudioAssistLlmApiRuntimeException(errorMessage);
                }
                case 8: {
                    throw new StudioAssistLlmApiResourceExhaustedException();
                }
            }
            throw new StudioAssistLlmApiRuntimeException(errorMessage);
        }
        if (this.isTheAnswerNull(answerResponse) || this.isEmptyAnswer(answerResponse)) {
            throw new StudioAssistLlmApiServerNoAnswerException("Empty answer from Katalon AI LLM");
        }
        if (answerResponse.getAnswer() != null && answerResponse.getAnswer().getWarning() != null) {
            StudioAssistChatAnswerMessage chatAnswerMsg = answerResponse.getAnswer();
            chatAnswerMsg.setMessageId(this.getMessageId());
            chatAnswerMsg.setFinalAnswer(answerResponse.getAnswer().getWarning().getExplanation());
            chatAnswerMsg.setWarning(answerResponse.getAnswer().getWarning());
            return chatAnswerMsg;
        }
        if (CollectionUtils.isEmpty((Collection)answerResponse.getAnswer().getToolCalls())) {
            StudioAssistChatAnswerMessage chatAnswerMsg = answerResponse.getAnswer();
            chatAnswerMsg.setMessageId(this.getMessageId());
            chatAnswerMsg.setUploadedFileMap(Optional.ofNullable(this.genAiAttachments).orElse(Collections.emptyList()).stream().collect(Collectors.toMap(GenAiChatAttachment::getFileClientId, item -> new StudioAssistUploadedFileHistory(item.getFileClientId(), item.getFileId()))));
            return chatAnswerMsg;
        }
        List<ResponseMessage> toolCalls = answerResponse.getAnswer().getToolCalls().stream().map(item -> {
            String toolName;
            String server = ToolUtil.parseServerNameFromToolCall((String)item.getName());
            McpSchema.Tool foundTool = this.getToolFromServerNameAndToolName(server, toolName = ToolUtil.parseToolNameFromToolCall((String)item.getName()));
            if (foundTool == null) {
                logger.debug("Tool not found for tool call name: {}", (Object)item.getName());
                return null;
            }
            ToolCallMessage tool = new ToolCallMessage(foundTool);
            tool.setCallId(item.getCallId());
            tool.setServer(server);
            tool.setStatus(ToolCallStatus.REQUESTED);
            tool.setInput(item.getInput());
            return tool;
        }).filter(Objects::nonNull).toList();
        AgentMessage agentMessage = new AgentMessage(this.getMessageId());
        agentMessage.setChildren(toolCalls);
        return agentMessage;
    }

    private List<GenAiChatMessage> buildChatMessage(Long accountId, Long orgId, Long userId) throws InterruptedException, ExecutionException, TimeoutException {
        ChatQuestionMessage question = this.question;
        ArrayList chatItems = this.conversation.stream().filter(item -> item instanceof StudioAssistChatPair).map(item -> (StudioAssistChatPair)item).collect(Collectors.toCollection(ArrayList::new));
        if (question == null && !chatItems.isEmpty()) {
            StudioAssistChatPair lastChatPair = (StudioAssistChatPair)chatItems.remove(chatItems.size() - 1);
            question = lastChatPair.getRequest();
        }
        if (question != null && StringUtils.isNotEmpty((CharSequence)question.getContent())) {
            Map uploadedAttachments = chatItems.stream().flatMap(item -> item.getRequest().getAttachments().stream()).filter(attachment -> StringUtils.isNotBlank((CharSequence)attachment.getFileId())).collect(Collectors.toMap(attachment -> {
                Date dateModified = attachment.getDateModified();
                return dateModified == null ? null : attachment.getFilePath() + "@" + dateModified.toInstant().toEpochMilli();
            }, Function.identity(), (existing, replacement) -> existing));
            List<StudioAssistChatAttachment> newAttachments = question.getAttachments().stream().filter(newAttachment -> {
                String key;
                if (StringUtils.isNotEmpty((CharSequence)newAttachment.getFileId())) {
                    return false;
                }
                Date dateModified = newAttachment.getDateModified();
                String string = key = dateModified == null ? null : newAttachment.getFilePath() + "@" + dateModified.toInstant().toEpochMilli();
                return key == null || !uploadedAttachments.containsKey(key);
            }).toList();
            this.genAiAttachments = this.handleUploadAttachments(accountId, orgId, userId, newAttachments);
        }
        ArrayList messages = this.conversation.stream().map(this::mapObjectToGenAiChatMessages).flatMap(Collection::stream).collect(Collectors.toCollection(ArrayList::new));
        if (this.question != null) {
            if (this.chatMode == ChatMode.ASK && this.genAiAttachments.isEmpty()) {
                this.genAiAttachments = question.getAttachments().stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getFileClientId()) && StringUtils.isNotBlank((CharSequence)item.getFileId())).map(item -> new GenAiChatAttachment(item.getFileClientId(), item.getFileId())).toList();
            }
            messages.add(new GenAiChatMessage(new GenAiChatMessageRequest(question.getContent(), this.genAiAttachments), null));
        }
        return messages;
    }

    private List<GenAiChatAttachment> handleUploadAttachments(Long accountId, Long orgId, Long userId, List<StudioAssistChatAttachment> attachments) throws InterruptedException, ExecutionException, TimeoutException {
        if (attachments.isEmpty()) {
            return Collections.emptyList();
        }
        Map uploadFileRequestMap = attachments.stream().map(item -> new UploadFileRequest(item.getFileClientId(), item.buildMetadata(), this.getMimeType((StudioAssistChatAttachment)item))).collect(Collectors.toMap(UploadFileRequest::getFileClientId, Function.identity()));
        IGenAiClient client = this.clientFactory.createGenAiClient();
        AskForUploadFileResponse response = client.askForUploadFiles(new AskForUploadFileRequest(orgId, accountId, userId, new ArrayList<UploadFileRequest>(uploadFileRequestMap.values())));
        List<UploadFileResponse> objects = response.getObjects();
        if (objects == null || objects.isEmpty()) {
            return Collections.emptyList();
        }
        Map attachmentsMap = attachments.stream().collect(Collectors.toMap(StudioAssistChatAttachment::getFileClientId, Function.identity()));
        ExecutorService uploadExecutor = Executors.newFixedThreadPool(4);
        try {
            List<UploadAttachmentCallable> callables = objects.stream().map(item -> new UploadAttachmentCallable((StudioAssistChatAttachment)attachmentsMap.get(item.getFileClientId()), (UploadFileRequest)uploadFileRequestMap.get(item.getFileClientId()), (UploadFileResponse)item, this.httpClient, this.networkPreferences)).toList();
            List futures = uploadExecutor.invokeAll(callables);
            HashMap<String, UploadFileResponse> uploadFileResponseMap = new HashMap<String, UploadFileResponse>(attachments.size());
            for (Future future : futures) {
                uploadFileResponseMap.put(((UploadFileResponse)future.get()).getFileClientId(), (UploadFileResponse)future.get());
            }
            attachments.forEach(item -> {
                UploadFileResponse uploadFileResponse = (UploadFileResponse)uploadFileResponseMap.get(item.getFileClientId());
                if (uploadFileResponse != null) {
                    item.setFileId(uploadFileResponse.getFileId());
                }
            });
            List<GenAiChatAttachment> list = attachments.stream().map(item -> new GenAiChatAttachment(item.getFileClientId(), item.getFileId())).toList();
            return list;
        }
        finally {
            uploadExecutor.shutdown();
        }
    }

    private String getMimeType(StudioAssistChatAttachment attachment) {
        if (attachment instanceof ImageChatAttachment) {
            ImageChatAttachment imageAttachment = (ImageChatAttachment)attachment;
            InlineImageInput inlineImageInput = imageAttachment.getImageInput();
            if (inlineImageInput != null && inlineImageInput.getFormat() != null) {
                return inlineImageInput.getFormat().getMimeType();
            }
            logger.warn("Failed to get image input from attachment {}, will use default PNG mime type", (Object)attachment.getFileClientId());
            return ContentType.IMAGE_PNG.getMimeType();
        }
        return ContentType.TEXT_PLAIN.getMimeType();
    }

    private List<GenAiChatMessage> mapObjectToGenAiChatMessages(Object message) {
        if (message instanceof StudioAssistChatPair) {
            StudioAssistChatPair chatPair = (StudioAssistChatPair)message;
            return this.mapToGenAiChatMessages(chatPair);
        }
        return Collections.emptyList();
    }

    private List<GenAiChatMessage> mapToGenAiChatMessages(StudioAssistChatPair chatPair) {
        ArrayList<GenAiChatMessage> messages = new ArrayList<GenAiChatMessage>();
        if (chatPair.getReferenceContexts() != null && !chatPair.getReferenceContexts().isEmpty()) {
            for (StudioAssistChatReferenceContextMessage ctxMessage : chatPair.getReferenceContexts()) {
                messages.add(new GenAiChatMessage(new GenAiChatMessageRequest(ctxMessage.getContent()), null));
            }
        }
        List<GenAiChatAttachment> chatAttachments = chatPair.getRequest().getAttachments().stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getFileClientId()) && StringUtils.isNotBlank((CharSequence)item.getFileId())).map(item -> new GenAiChatAttachment(item.getFileClientId(), item.getFileId())).toList();
        GenAiChatMessage chatRequest = GenAiChatMessage.request(chatPair.getRequest().getContent(), chatAttachments);
        GenAiChatMessage chatResponse = null;
        ResponseMessage responseMessage = chatPair.getResponse();
        if (responseMessage instanceof StudioAssistChatAnswerMessage) {
            StudioAssistChatAnswerMessage finalAnswer = (StudioAssistChatAnswerMessage)responseMessage;
            chatResponse = GenAiChatMessage.response(finalAnswer.getFinalAnswer());
        } else {
            ResponseMessage responseMessage2 = chatPair.getResponse();
            if (responseMessage2 instanceof AgentMessage) {
                AgentMessage agentMessage = (AgentMessage)responseMessage2;
                String finalAnswer = agentMessage.getChildren().stream().filter(child -> child instanceof StudioAssistChatAnswerMessage).findFirst().map(child -> (StudioAssistChatAnswerMessage)child).map(StudioAssistChatAnswerMessage::getFinalAnswer).orElse("");
                List<ToolCall> toolCalls = agentMessage.getChildren().stream().filter(child -> child instanceof ToolCallMessage).map(child -> (ToolCallMessage)child).map(toolCall -> {
                    ToolCall call = new ToolCall();
                    call.setCallId(toolCall.getCallId());
                    call.setName(toolCall.getName());
                    call.setInput(toolCall.getInput());
                    call.setOutput(toolCall.getOutput());
                    return call;
                }).toList();
                if (StringUtils.isNotEmpty((CharSequence)finalAnswer) || !toolCalls.isEmpty()) {
                    chatResponse = GenAiChatMessage.response(finalAnswer, toolCalls);
                }
            } else {
                ResponseMessage responseMessage3 = chatPair.getResponse();
                if (responseMessage3 instanceof ChatResponseMessage) {
                    ChatResponseMessage chatMessage = (ChatResponseMessage)responseMessage3;
                    chatResponse = GenAiChatMessage.response(chatMessage.getContent());
                }
            }
        }
        messages.add(chatRequest);
        if (chatResponse != null) {
            messages.add(chatResponse);
        }
        return messages;
    }

    private List<McpSchema.Tool> getLlmTools() {
        return this.availableTools.entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream().filter(tool -> ToolUtil.formatLlmToolName((String)((String)entry.getKey()), (String)tool.name()).length() <= 64).map(tool -> McpSchema.Tool.builder().name(ToolUtil.formatLlmToolName((String)((String)entry.getKey()), (String)tool.name())).description(tool.description()).inputSchema(tool.inputSchema()).outputSchema(tool.outputSchema()).build())).toList();
    }

    private McpSchema.Tool getToolFromServerNameAndToolName(String mcpServerName, String toolName) {
        return this.availableTools.entrySet().stream().filter(entry -> ((String)entry.getKey()).equals(mcpServerName)).flatMap(entry -> ((List)entry.getValue()).stream()).filter(tool -> toolName.equals(tool.name())).findFirst().orElse(null);
    }

    private void validate(Long orgId, Long accountId, Long userId) {
        if (orgId == null) {
            throw new StudioAssistLlmApiRuntimeException("Cannot get Organization Id");
        }
        if (accountId == null) {
            throw new StudioAssistLlmApiRuntimeException("Cannot get Account Id");
        }
        if (userId == null) {
            throw new StudioAssistLlmApiRuntimeException("Cannot get User Id");
        }
    }

    private boolean isEmptyAnswer(GenAiGetAnswerResponse answerResponse) {
        return StringUtils.isBlank((CharSequence)answerResponse.getAnswer().getFinalAnswer()) && answerResponse.getAnswer().getWarning() == null && answerResponse.getAnswer().getSuggestedQuestions() == null && CollectionUtils.isEmpty((Collection)answerResponse.getAnswer().getToolCalls());
    }

    private boolean isTheAnswerNull(GenAiGetAnswerResponse answerResponse) {
        return answerResponse.getAnswer() == null;
    }

    public String getMessageId() {
        return this.question == null ? "" : this.question.getMessageId();
    }
}

