/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.services.internal;

import com.google.common.net.UrlEscapers;
import com.kms.katalon.ai.core.constant.StudioAssistFileType;
import com.kms.katalon.ai.core.model.chat.ImageChatAttachment;
import com.kms.katalon.ai.core.model.chat.StudioAssistChatAttachment;
import com.kms.katalon.ai.core.model.exception.StudioAssistLlmApiClientException;
import com.kms.katalon.ai.core.model.llm.ImageFormat;
import com.kms.katalon.ai.core.model.llm.InlineImageInput;
import com.kms.katalon.ai.internal.model.UploadFileRequest;
import com.kms.katalon.ai.internal.model.UploadFileResponse;
import com.kms.katalon.network.core.model.HttpOptions;
import com.kms.katalon.network.core.model.HttpResponse;
import com.kms.katalon.network.core.model.config.ProxyConfig;
import com.kms.katalon.network.core.model.config.ProxyType;
import com.kms.katalon.network.core.services.IHttpClient;
import com.kms.katalon.network.core.services.INetworkPreferences;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploadAttachmentCallable
implements Callable<UploadFileResponse> {
    private static final Integer MAX_TRY = 3;
    private static final String METADATA_FORMAT = "x-amz-meta-%s";
    private static final long MAX_IMAGE_SIZE_BYTES = 0xA00000L;
    private final Logger logger = LoggerFactory.getLogger(UploadAttachmentCallable.class);
    private StudioAssistChatAttachment attachment;
    private UploadFileRequest uploadFileRequest;
    private UploadFileResponse uploadFileResponse;
    private IHttpClient httpClient;
    private INetworkPreferences networkPreferences;

    public UploadAttachmentCallable(StudioAssistChatAttachment attachment, UploadFileRequest uploadFileRequest, UploadFileResponse uploadFileResponse, IHttpClient httpClient, INetworkPreferences networkPreferences) {
        this.attachment = attachment;
        this.uploadFileRequest = uploadFileRequest;
        this.uploadFileResponse = uploadFileResponse;
        this.httpClient = httpClient;
        this.networkPreferences = networkPreferences;
    }

    @Override
    public UploadFileResponse call() throws Exception {
        if (this.uploadFileResponse == null || StringUtils.isBlank((CharSequence)this.uploadFileResponse.getUploadSpec().getUrl())) {
            this.logger.error("There is no information from upload specification");
            throw new StudioAssistLlmApiClientException("There is no information from upload specification");
        }
        String url = this.uploadFileResponse.getUploadSpec().getUrl();
        HashMap<String, String> headers = new HashMap<String, String>();
        Optional.ofNullable(this.uploadFileRequest.getMetadata()).map(Map::entrySet).orElse(Collections.emptySet()).stream().forEach(entry -> {
            String key = String.format(METADATA_FORMAT, UrlEscapers.urlFragmentEscaper().escape((String)entry.getKey()));
            String value = (String)entry.getValue();
            headers.put(key, value);
        });
        HttpEntity entity = this.prepareHttpEntity();
        String contentType = this.getContentType();
        if (StringUtils.isNotBlank((CharSequence)contentType)) {
            headers.put("Content-Type", contentType);
        }
        int count = 0;
        while (count < MAX_TRY) {
            try {
                HttpResponse response = this.httpClient.put(URI.create(url), entity, this.buildHttpOptions(headers));
                if (200 == response.getStatusCode() || 201 == response.getStatusCode()) break;
                this.logger.warn("Upload attachment {} not success: {}", (Object)this.attachment.getFileId(), (Object)response.getBody());
                break;
            }
            catch (Exception e) {
                this.logger.warn("Exception while upload file to S3 (attempt {}/{})", new Object[]{count + 1, MAX_TRY, e});
                if (++count != MAX_TRY) continue;
                throw e;
            }
        }
        return this.uploadFileResponse;
    }

    private HttpEntity prepareHttpEntity() throws IOException {
        if (this.attachment.getFileType() == StudioAssistFileType.IMAGE) {
            byte[] imageBytes = this.extractImageBytes();
            this.logger.debug("Prepared binary entity for image upload: {} bytes", (Object)imageBytes.length);
            return new ByteArrayEntity(imageBytes);
        }
        String fileContent = this.attachment.getFileContent() == null ? "" : this.attachment.getFileContent();
        this.logger.debug("Prepared text entity for file upload: {} chars", (Object)fileContent.length());
        return new StringEntity(fileContent);
    }

    private byte[] extractImageBytes() throws IOException {
        if (StringUtils.isNotBlank((CharSequence)this.attachment.getFileContent())) {
            try {
                return this.extractBase64FromInlineImageInput(this.attachment.getFileContent());
            }
            catch (Exception e) {
                this.logger.warn("Failed to extract base64 from fileContent, trying filePath", (Throwable)e);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)this.attachment.getFilePath())) {
            return this.readImageFile(this.attachment.getFilePath());
        }
        throw new StudioAssistLlmApiClientException("No image data available for attachment: " + this.attachment.getFileClientId());
    }

    private byte[] extractBase64FromInlineImageInput(String fileContent) throws IOException {
        StudioAssistChatAttachment studioAssistChatAttachment = this.attachment;
        if (studioAssistChatAttachment instanceof ImageChatAttachment) {
            ImageChatAttachment imageAttachment = (ImageChatAttachment)studioAssistChatAttachment;
            InlineImageInput imageInput = imageAttachment.getImageInput();
            if (StringUtils.isBlank((CharSequence)imageInput.getData())) {
                throw new StudioAssistLlmApiClientException("InlineImageInput contains no data: " + this.attachment.getFileClientId());
            }
            this.logger.debug("Extracting base64 image data for format: {}", (Object)imageInput.getFormat());
            return Base64.getDecoder().decode(imageInput.getData());
        }
        throw new StudioAssistLlmApiClientException("No image data available for attachment: " + this.attachment.getFileClientId());
    }

    private byte[] readImageFile(String filePath) throws IOException {
        Path path = Paths.get(filePath, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            throw new StudioAssistLlmApiClientException("Image file not found: " + filePath);
        }
        long fileSize = Files.size(path);
        if (fileSize > 0xA00000L) {
            throw new StudioAssistLlmApiClientException(String.format("Image file too large: %d bytes (max %d bytes)", fileSize, 0xA00000L));
        }
        this.logger.debug("Reading image file: {} ({} bytes)", (Object)filePath, (Object)fileSize);
        return Files.readAllBytes(path);
    }

    private String getContentType() {
        if (this.attachment.getFileType() == StudioAssistFileType.IMAGE) {
            String mimeType = this.uploadFileRequest.getMimeContentType();
            if (StringUtils.isNotBlank((CharSequence)mimeType)) {
                return mimeType;
            }
            return ImageFormat.PNG.getMimeType();
        }
        return ContentType.TEXT_PLAIN.getMimeType();
    }

    private HttpOptions buildHttpOptions(Map<String, String> headers) {
        if (headers == null) {
            headers = new HashMap<String, String>();
        }
        ProxyConfig proxyConfig = this.networkPreferences.getProxyConfig(ProxyType.AUTHENTICATION);
        HttpOptions httpOptions = new HttpOptions.Builder().headers(headers).proxy(proxyConfig).build();
        return httpOptions;
    }
}

