/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.util;

import com.kms.katalon.ai.core.constant.StudioAssistFileType;
import com.kms.katalon.ai.util.ImageAttachmentUtil;

public class TreeEntityFileTypeResolver {
    public static StudioAssistFileType resolveFileType(String entityClassName, String filePath) {
        if (entityClassName == null) {
            return StudioAssistFileType.OTHER;
        }
        return switch (entityClassName) {
            case "TestCaseTreeEntity" -> StudioAssistFileType.TEST_CASE;
            case "TestSuiteTreeEntity" -> StudioAssistFileType.TEST_SUITE;
            case "ProfileTreeEntity" -> StudioAssistFileType.PROFILE;
            case "WebElementTreeEntity" -> StudioAssistFileType.WEB_SERVICE_OBJECT;
            case "TestListenerTreeEntity" -> StudioAssistFileType.LISTENER;
            case "KeywordTreeEntity" -> TreeEntityFileTypeResolver.resolveKeywordFileType(filePath);
            case "SystemFileTreeEntity" -> TreeEntityFileTypeResolver.resolveSystemFileType(filePath);
            case "UserFileTreeEntity" -> TreeEntityFileTypeResolver.resolveUserFileType(filePath);
            default -> StudioAssistFileType.OTHER;
        };
    }

    private static StudioAssistFileType resolveKeywordFileType(String filePath) {
        if (filePath != null && filePath.toLowerCase().endsWith(".java")) {
            return StudioAssistFileType.JAVA;
        }
        return StudioAssistFileType.GROOVY;
    }

    private static StudioAssistFileType resolveSystemFileType(String filePath) {
        if (filePath != null && filePath.toLowerCase().endsWith(".feature")) {
            return StudioAssistFileType.FEATURE_FILE;
        }
        return StudioAssistFileType.OTHER;
    }

    private static StudioAssistFileType resolveUserFileType(String filePath) {
        if (ImageAttachmentUtil.isImageFile(filePath)) {
            return StudioAssistFileType.IMAGE;
        }
        return StudioAssistFileType.OTHER;
    }
}

