/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.console.strategy;

import com.kms.katalon.console.constants.ConsoleMessageConstants;
import com.kms.katalon.console.entity.ConsoleLauncherEntity;
import com.kms.katalon.console.handlers.ActivationHandler;
import com.kms.katalon.console.handlers.ArgumentOptionsHandler;
import com.kms.katalon.console.handlers.ProjectHandler;
import com.kms.katalon.console.handlers.ProxyHandler;
import com.kms.katalon.console.strategy.ConsoleModeStrategy;
import com.kms.katalon.console.util.LocalInformationUtil;
import com.kms.katalon.constants.GlobalMessageConstants;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.execution.constants.ExecutionMessageConstants;
import com.kms.katalon.execution.util.ApiKey;
import com.kms.katalon.license.ConsoleLicenseService;
import com.kms.katalon.license.models.ConsoleLicenseType;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.session.core.model.Organization;
import com.kms.katalon.session.core.services.ISessionController;
import com.kms.katalon.testcloud.core.service.ITestCloudController;
import com.kms.katalon.testops.core.model.TestOpsLoadOptions;
import com.kms.katalon.testops.core.services.ITestOpsController;
import jakarta.inject.Inject;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import joptsimple.OptionSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.osgi.framework.Bundle;

@Creatable
public abstract class AbstractConsoleModeStrategy
implements ConsoleModeStrategy {
    @Inject
    protected ActivationHandler activator;
    @Inject
    protected ITestOpsController testOpsController;
    @Inject
    protected ITestCloudController testCloudController;
    @Inject
    protected ISessionController sessionController;
    @Inject
    protected IEclipseContext context;

    protected ProjectEntity performProjectInitialization(ConsoleLauncherEntity consoleLauncherEntity) throws Exception {
        ProjectEntity project = ProjectHandler.findProject(consoleLauncherEntity.getOptions());
        ProjectHandler.setDefaultExecutionPropertiesOfProject(project, consoleLauncherEntity.getConsoleOptionValueMap());
        this.loadProjectTestOpsSettings();
        this.activator.printLicenseInfo();
        return project;
    }

    protected void registerTestOpsCommand(ConsoleLauncherEntity consoleLauncherEntity) {
        try {
            List<String> arguments = Arrays.asList(consoleLauncherEntity.getArguments());
            Bundle katalonBundle = Platform.getBundle((String)"com.kms.katalon.integration.analytics");
            Class analyticsCommandFactory = katalonBundle.loadClass("com.kms.katalon.integration.analytics.AnalyticsCommandFactory");
            Object factory = analyticsCommandFactory.newInstance();
            Method registerTestopsMethod = Arrays.asList(analyticsCommandFactory.getMethods()).stream().filter(method -> method.getName().equals("registerTestopsCommand")).findAny().orElse(null);
            if (registerTestopsMethod != null) {
                registerTestopsMethod.invoke(factory, arguments);
            }
        }
        catch (Exception exception) {}
    }

    protected void prepareApplicationConfiguration(ConsoleLauncherEntity consoleLauncherEntity) throws Exception {
        ArgumentOptionsHandler.getInstance().prepareApplicationConfiguration(consoleLauncherEntity.getApplicationConfigOptions());
    }

    protected int checkAndConfigureProxy(ConsoleLauncherEntity consoleLauncherEntity) {
        int code = ProxyHandler.checkingProxyInfo(consoleLauncherEntity.getOptions());
        if (code == 200) {
            ProxyHandler.printProxyInfo();
        }
        return code;
    }

    protected void validateOptionsAndApiKey() {
        ArgumentOptionsHandler.getInstance().validateOption();
        ArgumentOptionsHandler.getInstance().getApiKeyOnpremiseValue();
    }

    protected void activateAndPrintSystemInfo() throws Throwable {
        LogUtil.logInfo((String)ExecutionMessageConstants.ACTIVATE_IN_ACTIVATING);
        this.activator.activate();
        LocalInformationUtil.printSystemInformation();
    }

    protected int validateOptionsAndApiKeyWithResult() {
        try {
            ArgumentOptionsHandler.getInstance().validateOption();
            ArgumentOptionsHandler.getInstance().getApiKeyOnpremiseValue();
            return 200;
        }
        catch (Exception e) {
            LogUtil.printErrorLine((String)MessageFormat.format(ConsoleMessageConstants.ERROR_VALIDATION_FAILED, e.getMessage()));
            return 2;
        }
    }

    protected int activateAndPrintSystemInfoWithResult(OptionSet options) {
        try {
            LogUtil.logInfo((String)ExecutionMessageConstants.ACTIVATE_IN_ACTIVATING);
            this.activator.activate();
            LocalInformationUtil.printSystemInformation();
            return 200;
        }
        catch (Throwable e) {
            LogUtil.printErrorLine((String)MessageFormat.format(ConsoleMessageConstants.ERROR_ACTIVATION_FAILED, e.getMessage()));
            return 2;
        }
    }

    protected void loadProjectTestOpsSettings() {
        if (StringUtils.isBlank((CharSequence)ApiKey.get())) {
            return;
        }
        Organization org = this.sessionController.getSession().getOrganization();
        Boolean overrideAuthentication = null;
        if (org != null && org.isSamlSSO()) {
            overrideAuthentication = false;
        }
        Boolean testOpsEnabled = ArgumentOptionsHandler.getInstance().getTestOpsEnabled();
        Long projectId = ArgumentOptionsHandler.getInstance().getTestOpsProjectId();
        String testOpsUrl = ArgumentOptionsHandler.getInstance().getTestOpsServerUrl();
        TestOpsLoadOptions loadOptions = TestOpsLoadOptions.builder().overrideTestOpsEnabled(testOpsEnabled).overrideAuthentication(overrideAuthentication).serverUrl(testOpsUrl).projectId(projectId).build();
        try {
            this.testOpsController.reload(loadOptions);
        }
        catch (Exception e) {
            if (StringUtils.isNotBlank((CharSequence)e.getMessage())) {
                LogUtil.printErrorLine((String)e.getMessage());
            }
            LogUtil.printErrorLine((String)e.toString());
        }
        this.configureTestCloudLicense();
    }

    protected void configureTestCloudLicense() {
        boolean testCloudActivated = false;
        try {
            testCloudActivated = this.testCloudController.checkTestCloudLicense();
        }
        catch (Exception e) {
            LogUtil.logInfo((String)MessageFormat.format(ConsoleMessageConstants.ACTIVATE_FAILED, GlobalMessageConstants.TESTCLOUD_NAME, e.getMessage()));
        }
        if (testCloudActivated) {
            ConsoleLicenseType licenseType = ConsoleLicenseService.getInstance().getLicenseType();
            if (licenseType == null) {
                licenseType = ConsoleLicenseType.TESTCLOUD_LICENSE;
            } else if (licenseType.equals((Object)ConsoleLicenseType.KRE_LICENSE)) {
                licenseType = ConsoleLicenseType.ALL;
            }
            ConsoleLicenseService.getInstance().setLicenseType(licenseType);
        }
    }

    protected int performInitializationTasks(ConsoleLauncherEntity consoleLauncherEntity) {
        try {
            this.registerTestOpsCommand(consoleLauncherEntity);
            int validationResult = this.validateOptionsAndApiKeyWithResult();
            if (validationResult != 200) {
                return validationResult;
            }
            int activationResult = this.activateAndPrintSystemInfoWithResult(consoleLauncherEntity.getOptions());
            if (activationResult != 200) {
                return activationResult;
            }
            this.loadProjectTestOpsSettings();
            return 200;
        }
        catch (Exception e) {
            LogUtil.printErrorLine((String)MessageFormat.format(ConsoleMessageConstants.ERROR_INITIALIZATION_SETUP_FAILED, e.getMessage()));
            LogUtil.logError((String)ExceptionUtils.getStackTrace((Throwable)e));
            return 2;
        }
    }
}

