/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.codeassist.completions;

import org.codehaus.groovy.eclipse.codeassist.GroovyContentAssist;
import org.codehaus.groovy.eclipse.codeassist.ProposalUtils;
import org.codehaus.groovy.eclipse.codeassist.completions.ParameterGuesserDelegate;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.EditorHighlightingSynchronizer;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.text.java.JavaCompletionProposal;
import org.eclipse.jdt.internal.ui.text.template.contentassist.PositionBasedCompletionProposal;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.link.ILinkedModeListener;
import org.eclipse.jface.text.link.InclusivePositionUpdater;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.text.link.ProposalPosition;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;

public class NamedParameterProposal
extends JavaCompletionProposal {
    private ICompletionProposal[] choices;
    private IPositionUpdater updater;
    private IRegion selectedRegion;
    private final String paramName;
    private final String paramSignature;

    public NamedParameterProposal(String paramName, String paramSignature, int replacementOffset, int replacementLength, Image image, StyledString displayString, int relevance, boolean inJavadoc, JavaContentAssistInvocationContext javaContext) {
        super(NamedParameterProposal.computeReplacementString(paramName), replacementOffset, replacementLength, image, displayString, relevance, inJavadoc, javaContext);
        this.paramName = paramName;
        this.paramSignature = paramSignature;
        this.setTriggerCharacters(ProposalUtils.VAR_TRIGGER);
    }

    private static String computeReplacementString(String name) {
        return name + ": __";
    }

    private IRegion calculateArgumentRegion() {
        String repl = this.getReplacementString();
        int replOffset = this.getReplacementOffset();
        int start = replOffset + repl.indexOf(": ") + 2;
        int end = replOffset + repl.lastIndexOf("_") + 1;
        if (start > 0 && end > 0) {
            return new Region(start, end - start);
        }
        return null;
    }

    private boolean shouldDoGuessing() {
        if (this.fInvocationContext.getCoreContext().isExtended()) {
            IPreferenceStore prefs = JavaPlugin.getDefault().getPreferenceStore();
            return prefs.getBoolean("content_assist_fill_method_arguments") && prefs.getBoolean("content_assist_guess_method_arguments");
        }
        return false;
    }

    private ICompletionProposal[] doGuessing(Position position) {
        if (this.paramName == null || this.paramSignature == null) {
            return ProposalUtils.NO_COMPLETIONS;
        }
        IJavaElement[] visibleElements = this.fInvocationContext.getCoreContext().getVisibleElements(this.paramSignature);
        ParameterGuesserDelegate guesser = new ParameterGuesserDelegate(this.fInvocationContext.getCoreContext().getEnclosingElement(), this.fInvocationContext);
        ICompletionProposal[] guesses = guesser.parameterProposals(Signature.toString((String)this.paramSignature), this.paramName, position, visibleElements, true);
        if (guesses != null && guesses.length > 0) {
            int i = 0;
            while (i < guesses.length) {
                guesses[i] = new PositionBasedCompletionProposal(guesses[i].getDisplayString(), position, guesses[i].getSelection(null).x - position.getOffset(), guesses[i].getImage(), guesses[i].getDisplayString(), guesses[i].getContextInformation(), null, ((PositionBasedCompletionProposal)guesses[i]).getTriggerCharacters()){

                    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
                        super.apply(viewer, trigger, stateMask, offset);
                        if (trigger > '\u0000') {
                            try {
                                viewer.getDocument().replace(offset += this.getDisplayString().length(), 0, String.valueOf(trigger));
                            }
                            catch (BadLocationException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                };
                ++i;
            }
        } else {
            guesses = new ICompletionProposal[]{new JavaCompletionProposal(this.paramName, 0, this.paramName.length(), null, this.paramName, 0)};
        }
        return guesses;
    }

    public void apply(IDocument document, char trigger, int offset) {
        super.apply(document, trigger, offset);
        if (this.selectedRegion == null) {
            this.selectedRegion = this.calculateArgumentRegion();
        }
        this.setUpLinkedMode(document, ',');
    }

    protected void setUpLinkedMode(IDocument document, char closingCharacter) {
        ITextViewer textViewer = this.getTextViewer();
        if (textViewer != null) {
            try {
                LinkedModeModel model = new LinkedModeModel();
                LinkedPositionGroup group = new LinkedPositionGroup();
                if (this.shouldDoGuessing()) {
                    Position position = new Position(this.selectedRegion.getOffset(), this.selectedRegion.getLength());
                    this.ensurePositionCategoryInstalled(document, model);
                    document.addPosition(this.getCategory(), position);
                    this.choices = this.doGuessing(position);
                    group.addPosition((LinkedPosition)new ProposalPosition(document, position.getOffset(), position.getLength(), -1, this.choices));
                } else {
                    IRegion argRegion = this.calculateArgumentRegion();
                    group.addPosition(new LinkedPosition(document, argRegion.getOffset(), argRegion.getLength(), -1));
                }
                model.addGroup(group);
                JavaEditor editor = this.getJavaEditor();
                if (editor != null) {
                    model.addLinkingListener((ILinkedModeListener)new EditorHighlightingSynchronizer(editor));
                }
                model.forceInstall();
                EditorLinkedModeUI ui = new EditorLinkedModeUI(model, textViewer);
                ui.setCyclingMode(LinkedModeUI.CYCLE_WHEN_NO_PARENT);
                ui.setDoContextInfo(true);
                ui.setExitPolicy((m, e, off, len) -> {
                    if (e.character == closingCharacter) {
                        return new LinkedModeUI.ExitFlags(2, true);
                    }
                    if (e.character == ';' || e.character == '\r') {
                        return new LinkedModeUI.ExitFlags(1, true);
                    }
                    return null;
                });
                ui.setExitPosition(textViewer, this.getReplacementOffset() + this.getReplacementString().length(), 0, Integer.MAX_VALUE);
                ui.setSimpleMode(true);
                ui.enter();
                this.selectedRegion = ui.getSelectedRegion();
            }
            catch (Exception e2) {
                this.ensurePositionCategoryRemoved(document);
                GroovyContentAssist.logError(e2);
                this.openErrorDialog(e2);
                this.choices = null;
            }
        }
    }

    public Point getSelection(IDocument document) {
        if (this.selectedRegion == null) {
            return new Point(this.getReplacementOffset(), 0);
        }
        return new Point(this.selectedRegion.getOffset(), this.selectedRegion.getLength());
    }

    private JavaEditor getJavaEditor() {
        IEditorPart part = JavaPlugin.getActivePage().getActiveEditor();
        if (part instanceof JavaEditor) {
            return (JavaEditor)part;
        }
        return null;
    }

    private void openErrorDialog(Exception e) {
        Shell shell = this.getTextViewer().getTextWidget().getShell();
        MessageDialog.openError((Shell)shell, (String)"Error inserting parameters", (String)e.getMessage());
    }

    private void ensurePositionCategoryInstalled(final IDocument document, LinkedModeModel model) {
        if (!document.containsPositionCategory(this.getCategory())) {
            document.addPositionCategory(this.getCategory());
            this.updater = new InclusivePositionUpdater(this.getCategory());
            document.addPositionUpdater(this.updater);
            model.addLinkingListener(new ILinkedModeListener(){

                public void left(LinkedModeModel environment, int flags) {
                    NamedParameterProposal.this.ensurePositionCategoryRemoved(document);
                }

                public void suspend(LinkedModeModel environment) {
                }

                public void resume(LinkedModeModel environment, int flags) {
                }
            });
        }
    }

    private void ensurePositionCategoryRemoved(IDocument document) {
        if (document.containsPositionCategory(this.getCategory())) {
            try {
                document.removePositionCategory(this.getCategory());
            }
            catch (BadPositionCategoryException badPositionCategoryException) {
                // empty catch block
            }
            document.removePositionUpdater(this.updater);
            this.updater = null;
        }
    }

    private String getCategory() {
        return "ParameterGuessingProposal_" + this.toString();
    }

    public ICompletionProposal[] getChoices() throws JavaModelException {
        this.selectedRegion = this.calculateArgumentRegion();
        return this.doGuessing(new Position(this.selectedRegion.getOffset(), this.selectedRegion.getLength()));
    }
}

