/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.codeassist.creators;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.eclipse.codeassist.ProposalUtils;
import org.codehaus.groovy.eclipse.codeassist.creators.AbstractProposalCreator;
import org.codehaus.groovy.eclipse.codeassist.preferences.DGMProposalFilter;
import org.codehaus.groovy.eclipse.codeassist.proposals.AbstractGroovyProposal;
import org.codehaus.groovy.eclipse.codeassist.proposals.GroovyFieldProposal;
import org.codehaus.groovy.eclipse.codeassist.proposals.GroovyMethodProposal;
import org.codehaus.groovy.eclipse.codeassist.proposals.IGroovyProposal;
import org.codehaus.groovy.eclipse.codeassist.requestor.ContentAssistContext;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.groovy.core.util.ArrayUtils;
import org.eclipse.jdt.groovy.core.util.GroovyUtils;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.groovy.search.VariableScope;
import org.eclipse.jdt.internal.codeassist.CompletionEngine;
import org.eclipse.jdt.internal.ui.text.java.LazyJavaCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.MemberProposalInfo;
import org.eclipse.jdt.internal.ui.text.java.MethodProposalInfo;
import org.eclipse.jdt.internal.ui.text.java.ProposalInfo;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.viewers.StyledString;

public class CategoryProposalCreator
extends AbstractProposalCreator {
    protected static final String GROOVY_METHOD_CONTRIBUTOR = "Groovy";

    @Override
    public List<IGroovyProposal> findAllProposals(ClassNode selfType, Set<ClassNode> categories, String prefix, boolean isStatic, boolean isPrimary) {
        if (categories == null || categories.isEmpty()) {
            return Collections.emptyList();
        }
        DGMProposalFilter filter = new DGMProposalFilter();
        ArrayList<IGroovyProposal> proposals = new ArrayList<IGroovyProposal>();
        for (ClassNode category : categories) {
            boolean isDefaultCategory = this.isDefaultCategory(category);
            for (MethodNode method : category.getMethods()) {
                AbstractGroovyProposal proposal;
                if (isDefaultCategory && (GroovyUtils.isDeprecated((ASTNode)method) || filter.isFiltered(method))) continue;
                String methodName = method.getName();
                if (!method.isStatic() || !method.isPublic()) continue;
                Parameter[] params = method.getParameters();
                if (params.length > 0 && this.matcher.test(prefix, methodName) && GroovyUtils.isAssignable((ClassNode)selfType, (ClassNode)params[0].getType())) {
                    proposal = new CategoryMethodProposal(method);
                    proposal.setRelevanceMultiplier(this.tweakRelevance(method, selfType));
                    proposals.add(proposal);
                }
                if (params.length != 1 || !this.findLooselyMatchedAccessorKind(prefix, methodName, true).isAccessorKind(method, true) || !CategoryProposalCreator.hasNoField(selfType, methodName) || !GroovyUtils.isAssignable((ClassNode)selfType, (ClassNode)params[0].getType()) || !isStatic && GeneralUtils.isOrImplements((ClassNode)selfType, (ClassNode)VariableScope.MAP_CLASS_NODE) || !isDefaultCategory && methodName.startsWith("is") && GroovyUtils.getGroovyVersion().getMajor() <= 3) continue;
                proposal = new CategoryPropertyProposal(method);
                proposal.setRelevanceMultiplier(this.tweakRelevance(method, selfType));
                proposals.add(proposal);
            }
        }
        return proposals;
    }

    protected boolean isDefaultCategory(ClassNode category) {
        return VariableScope.DGM_CLASS_NODE.equals((Object)category) || this.currentScope != null && this.currentScope.isDefaultCategory(category);
    }

    protected boolean isDefaultStaticCategory(ClassNode category) {
        return VariableScope.DGSM_CLASS_NODE.equals((Object)category) || this.currentScope != null && this.currentScope.isDefaultStaticCategory(category);
    }

    protected static boolean isObjectOrPrimitiveArray(ClassNode type) {
        return VariableScope.OBJECT_CLASS_NODE.equals((Object)type.getComponentType()) || ClassHelper.isPrimitiveType((ClassNode)type.getComponentType());
    }

    protected float tweakRelevance(MethodNode method, ClassNode selfType) {
        float relevanceMultiplier = this.isDefaultCategory(method.getDeclaringClass()) ? 0.1f : 5.0f;
        ClassNode firstParamType = method.getParameters()[0].getType();
        if (!selfType.equals((Object)firstParamType)) {
            int distance = 0;
            if (!firstParamType.isInterface()) {
                ClassNode next = selfType;
                do {
                    ++distance;
                    ClassNode classNode = next = next.isArray() && !CategoryProposalCreator.isObjectOrPrimitiveArray(next) ? VariableScope.OBJECT_CLASS_NODE.makeArray() : next.getSuperClass();
                } while (next != null && !next.equals((Object)firstParamType));
                if (next == null) {
                    distance = 5;
                }
            } else if (firstParamType.equals((Object)VariableScope.GROOVY_OBJECT_CLASS_NODE)) {
                distance = 5;
            } else {
                LinkedList<ClassDepth> todo = new LinkedList<ClassDepth>();
                HashSet<ClassNode> visited = new HashSet<ClassNode>();
                todo.add(new ClassDepth(selfType, 0));
                block1: while (!todo.isEmpty()) {
                    ClassDepth next = (ClassDepth)todo.remove();
                    visited.add(next.clazz.redirect());
                    ClassNode[] classNodeArray = next.clazz.getInterfaces();
                    int n = classNodeArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ClassNode face = classNodeArray[n2];
                        if (firstParamType.equals((Object)face)) {
                            distance = next.depth + 1;
                            break block1;
                        }
                        if (!visited.contains(face.redirect())) {
                            todo.add(new ClassDepth(face, next.depth + 1));
                        }
                        ++n2;
                    }
                    Optional.ofNullable(next.clazz.getSuperClass()).filter(sc -> !sc.equals((Object)VariableScope.OBJECT_CLASS_NODE)).map(sc -> new ClassDepth((ClassNode)sc, classDepth.depth + 1)).ifPresent(todo::add);
                }
            }
            while (distance-- > 0) {
                relevanceMultiplier *= 0.88f;
            }
        }
        return relevanceMultiplier;
    }

    protected class CategoryMethodProposal
    extends GroovyMethodProposal {
        protected CategoryMethodProposal(MethodNode method) {
            super(method, CategoryProposalCreator.GROOVY_METHOD_CONTRIBUTOR);
        }

        @Override
        protected int getModifiers() {
            int modifiers = super.getModifiers();
            if (!CategoryProposalCreator.this.isDefaultStaticCategory(this.getMethod().getDeclaringClass())) {
                modifiers &= 0xFFFFFFF7;
            }
            return modifiers;
        }

        @Override
        protected char[] createMethodSignature() {
            return ProposalUtils.createMethodSignature(this.getMethod(), 1);
        }

        @Override
        protected char[][] getParameterNames(Parameter[] parameters) {
            return (char[][])ArrayUtils.remove((Object[])super.getParameterNames(parameters), (int)0);
        }

        @Override
        protected char[][] getParameterTypeNames(Parameter[] parameters) {
            return (char[][])ArrayUtils.remove((Object[])super.getParameterTypeNames(parameters), (int)0);
        }

        @Override
        public IJavaCompletionProposal createJavaProposal(CompletionEngine engine, ContentAssistContext context, JavaContentAssistInvocationContext javaContext) {
            IJavaCompletionProposal javaProposal = super.createJavaProposal(engine, context, javaContext);
            if (javaProposal instanceof LazyJavaCompletionProposal) {
                ProposalInfo proposalInfo = (ProposalInfo)ReflectionUtils.executePrivateMethod(LazyJavaCompletionProposal.class, (String)"getProposalInfo", (Object)javaProposal);
                CompletionProposal proposal = (CompletionProposal)ReflectionUtils.executePrivateMethod(LazyJavaCompletionProposal.class, (String)"getProposal", (Object)javaProposal);
                final MethodProposalInfo methodProposalInfo = proposalInfo instanceof MethodProposalInfo ? (MethodProposalInfo)proposalInfo : new MethodProposalInfo(javaContext.getProject(), proposal);
                ((LazyJavaCompletionProposal)javaProposal).setProposalInfo((ProposalInfo)new MemberProposalInfo(javaContext.getProject(), proposal){

                    protected IMember resolveMember() throws JavaModelException {
                        IType type = this.fJavaProject.findType(CategoryMethodProposal.this.getMethod().getDeclaringClass().getName());
                        if (type != null) {
                            try {
                                String methName = CategoryMethodProposal.this.getMethod().getName();
                                String[] paramTypes = GroovyUtils.getParameterTypeSignatures((MethodNode)CategoryMethodProposal.this.getMethod(), (boolean)false);
                                Map typeVariables = (Map)ReflectionUtils.throwableExecutePrivateMethod(MethodProposalInfo.class, (String)"computeTypeVariables", (Class[])new Class[]{IType.class}, (Object)methodProposalInfo, (Object[])new Object[]{type});
                                IMethod[] methods = type.getMethods();
                                int i = methods.length - 1;
                                while (i >= 0) {
                                    if (methName.equals(methods[i].getElementName())) {
                                        Boolean match = (Boolean)ReflectionUtils.throwableExecutePrivateMethod(MethodProposalInfo.class, (String)"isSameMethodSignature", (Class[])new Class[]{String.class, String[].class, Boolean.TYPE, IMethod.class, Map.class, IType.class}, (Object)methodProposalInfo, (Object[])new Object[]{methName, paramTypes, Boolean.FALSE, methods[i], typeVariables, type});
                                        if (Boolean.TRUE.equals(match)) {
                                            return methods[i];
                                        }
                                    }
                                    --i;
                                }
                            }
                            catch (JavaModelException e) {
                                throw e;
                            }
                            catch (InvocationTargetException e) {
                                if (e.getCause() instanceof JavaModelException) {
                                    throw (JavaModelException)e.getCause();
                                }
                                throw new RuntimeException(e.getCause());
                            }
                            catch (Exception e) {
                                if (e instanceof RuntimeException) {
                                    throw (RuntimeException)e;
                                }
                                throw new RuntimeException(e);
                            }
                        }
                        return null;
                    }
                });
            }
            return javaProposal;
        }
    }

    protected class CategoryPropertyProposal
    extends GroovyFieldProposal {
        protected CategoryPropertyProposal(MethodNode method) {
            super(CategoryProposalCreator.createMockField(method));
            if (!CategoryProposalCreator.this.isDefaultStaticCategory(method.getDeclaringClass())) {
                this.getField().setModifiers(this.getField().getModifiers() & 0xFFFFFFF7);
            }
        }

        @Override
        protected StyledString createDisplayString(FieldNode field) {
            return super.createDisplayString(field).append(new StyledString(" (Groovy)", StyledString.DECORATIONS_STYLER));
        }
    }

    private static class ClassDepth {
        final ClassNode clazz;
        final int depth;

        ClassDepth(ClassNode t, int n) {
            this.clazz = t;
            this.depth = n;
        }
    }
}

