/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.codeassist.creators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.eclipse.GroovyLogManager;
import org.codehaus.groovy.eclipse.TraceCategory;
import org.codehaus.groovy.eclipse.codeassist.creators.AbstractProposalCreator;
import org.codehaus.groovy.eclipse.codeassist.proposals.GroovyFieldProposal;
import org.codehaus.groovy.eclipse.codeassist.proposals.GroovyMethodProposal;
import org.codehaus.groovy.eclipse.codeassist.proposals.IGroovyProposal;
import org.eclipse.jdt.groovy.core.util.GroovyUtils;
import org.eclipse.jdt.groovy.search.VariableScope;

public class FieldProposalCreator
extends AbstractProposalCreator {
    private final Set<ClassNode> alreadySeen = new HashSet<ClassNode>();

    @Override
    public List<IGroovyProposal> findAllProposals(ClassNode type, Set<ClassNode> categories, String prefix, boolean isStatic, boolean isPrimary) {
        ClassNode enclosingTypeDeclaration;
        ArrayList<IGroovyProposal> proposals = new ArrayList<IGroovyProposal>();
        boolean firstTime = this.alreadySeen.isEmpty();
        Collection<FieldNode> allFields = this.getAllFields(type, this.alreadySeen);
        for (FieldNode field : allFields) {
            if (isStatic && !field.isStatic() || !this.matcher.test(prefix, field.getName())) continue;
            GroovyFieldProposal proposal = new GroovyFieldProposal(field);
            proposal.setRelevanceMultiplier(field.isEnum() ? 5 : 1);
            proposals.add(proposal);
            if (!(field.getInitialExpression() instanceof ClosureExpression)) continue;
            proposals.add(new GroovyMethodProposal(FieldProposalCreator.convertToMethodProposal(field)));
        }
        if (!isPrimary && "class".startsWith(prefix) && VariableScope.CLASS_CLASS_NODE.equals((Object)type)) {
            FieldNode field;
            field = new FieldNode("class", 25, VariableScope.CLASS_CLASS_NODE, VariableScope.OBJECT_CLASS_NODE, null);
            field.setDeclaringClass(VariableScope.OBJECT_CLASS_NODE);
            proposals.add(new GroovyFieldProposal(field));
        }
        if (this.currentScope != null && (enclosingTypeDeclaration = this.currentScope.getEnclosingTypeDeclaration()) != null && firstTime && isPrimary && type.getModule() != null) {
            this.findStaticImportProposals(proposals, prefix, type.getModule());
            this.findStaticFavoriteProposals(proposals, prefix, type.getModule());
            FieldProposalCreator.demoteLowVisibilityProposals(proposals, type);
        }
        Iterator it = proposals.iterator();
        while (it.hasNext()) {
            IGroovyProposal proposal = (IGroovyProposal)it.next();
            if (proposal instanceof GroovyFieldProposal) {
                if (!GroovyUtils.isSynthetic((FieldNode)((GroovyFieldProposal)proposal).getField())) continue;
                it.remove();
                continue;
            }
            if (!(proposal instanceof GroovyMethodProposal) || !GroovyUtils.isSynthetic((MethodNode)((GroovyMethodProposal)proposal).getMethod())) continue;
            it.remove();
        }
        return proposals;
    }

    private void findStaticImportProposals(List<IGroovyProposal> proposals, String prefix, ModuleNode module) {
        for (Map.Entry entry : module.getStaticStarImports().entrySet()) {
            ClassNode typeNode = ((ImportNode)entry.getValue()).getType();
            if (typeNode == null) continue;
            for (FieldNode field : this.getAllFields(typeNode, this.alreadySeen)) {
                if (!field.isStatic() || !this.matcher.test(prefix, field.getName())) continue;
                GroovyFieldProposal proposal = new GroovyFieldProposal(field);
                proposal.setRelevanceMultiplier(0.95f);
                proposals.add(proposal);
            }
        }
        for (Map.Entry entry : module.getStaticImports().entrySet()) {
            String fieldName = ((ImportNode)entry.getValue()).getFieldName();
            if (fieldName == null || !this.matcher.test(prefix, fieldName)) continue;
            ClassNode typeNode = ((ImportNode)entry.getValue()).getType();
            for (FieldNode field : this.getAllFields(typeNode, new HashSet<ClassNode>(this.alreadySeen))) {
                if (!field.isStatic() || !field.getName().equals(fieldName)) continue;
                GroovyFieldProposal proposal = new GroovyFieldProposal(field);
                proposal.setRelevanceMultiplier(0.95f);
                proposals.add(proposal);
            }
        }
    }

    private void findStaticFavoriteProposals(List<IGroovyProposal> proposals, String prefix, ModuleNode module) {
        for (String favoriteStaticMember : this.favoriteStaticMembers) {
            GroovyFieldProposal proposal;
            int pos = favoriteStaticMember.lastIndexOf(46);
            String typeName = favoriteStaticMember.substring(0, pos);
            String fieldName = favoriteStaticMember.substring(pos + 1);
            ClassNode typeNode = FieldProposalCreator.tryResolveClassNode(typeName, module);
            if (typeNode == null) {
                if (!GroovyLogManager.manager.hasLoggers()) continue;
                GroovyLogManager.manager.log(TraceCategory.CONTENT_ASSIST, "FieldProposalCreator: Cannot resolve favorite type " + typeName);
                continue;
            }
            if ("*".equals(fieldName)) {
                for (FieldNode field : this.getAllFields(typeNode, this.alreadySeen)) {
                    if (!field.isStatic() || !this.matcher.test(prefix, field.getName())) continue;
                    proposal = new GroovyFieldProposal(field);
                    proposal.setRequiredStaticImport(typeName + "." + field.getName());
                    proposal.setRelevanceMultiplier(0.95f);
                    proposals.add(proposal);
                }
                continue;
            }
            if (!this.matcher.test(prefix, fieldName)) continue;
            for (FieldNode field : this.getAllFields(typeNode, new HashSet<ClassNode>(this.alreadySeen))) {
                if (!field.isStatic() || !field.getName().equals(fieldName)) continue;
                proposal = new GroovyFieldProposal(field);
                proposal.setRequiredStaticImport(favoriteStaticMember);
                proposal.setRelevanceMultiplier(0.95f);
                proposals.add(proposal);
            }
        }
    }

    private static MethodNode convertToMethodProposal(FieldNode field) {
        MethodNode method = new MethodNode(field.getName(), field.getModifiers(), field.getType(), FieldProposalCreator.extractParameters(field.getInitialExpression()), ClassNode.EMPTY_ARRAY, (Statement)new BlockStatement());
        method.setDeclaringClass(field.getDeclaringClass());
        return method;
    }

    private static Parameter[] extractParameters(Expression expr) {
        if (expr instanceof ClosureExpression && ((ClosureExpression)expr).isParameterSpecified()) {
            return ((ClosureExpression)expr).getParameters();
        }
        return Parameter.EMPTY_ARRAY;
    }
}

