/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.codeassist.processors;

import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.eclipse.codeassist.processors.AbstractGroovyCompletionProcessor;
import org.codehaus.groovy.eclipse.codeassist.processors.GroovyProposalTypeSearchRequestor;
import org.codehaus.groovy.eclipse.codeassist.requestor.ContentAssistContext;
import org.codehaus.groovy.eclipse.codeassist.requestor.ContentAssistLocation;
import org.codehaus.jdt.groovy.internal.compiler.ast.JDTResolver;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.groovy.search.ITypeResolver;
import org.eclipse.jdt.internal.codeassist.ISearchRequestor;
import org.eclipse.jdt.internal.core.SearchableEnvironment;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.contentassist.ICompletionProposal;

public class PackageCompletionProcessor
extends AbstractGroovyCompletionProcessor
implements ITypeResolver {
    protected ModuleNode module;
    protected JDTResolver resolver;
    protected static final Pattern ILLEGAL_CHARS = Pattern.compile("[^\\p{javaJavaIdentifierPart}\\s\\.]");

    public PackageCompletionProcessor(ContentAssistContext context, JavaContentAssistInvocationContext javaContext, SearchableEnvironment nameEnvironment) {
        super(context, javaContext, nameEnvironment);
    }

    public void setResolverInformation(ModuleNode module, JDTResolver resolver) {
        this.module = module;
        this.resolver = resolver;
    }

    @Override
    public List<ICompletionProposal> generateProposals(IProgressMonitor monitor) {
        String expression;
        ContentAssistContext context = this.getContext();
        if (!this.doPackageCompletion(context, expression = context.getQualifiedCompletionExpression())) {
            return Collections.emptyList();
        }
        int replacementStart = this.getReplacementStartOffset();
        SearchableEnvironment environment = this.getNameEnvironment();
        GroovyProposalTypeSearchRequestor requestor = new GroovyProposalTypeSearchRequestor(context, this.getJavaContext(), replacementStart, -1, environment.nameLookup, monitor);
        environment.findPackages(expression.toCharArray(), (ISearchRequestor)requestor);
        return requestor.processAcceptedPackages();
    }

    protected boolean doPackageCompletion(ContentAssistContext context, String expression) {
        AnnotatedNode completionNode;
        if (expression.isEmpty() || ILLEGAL_CHARS.matcher(expression).find()) {
            return false;
        }
        if (context.location == ContentAssistLocation.GENERICS && context.completionNode instanceof GenericsType) {
            return false;
        }
        return context.location != ContentAssistLocation.PARAMETER || !(context.completionNode instanceof AnnotatedNode) || (completionNode = (AnnotatedNode)context.completionNode).getStart() >= completionNode.getNameStart() || context.completionLocation < completionNode.getNameStart();
    }
}

